/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.catalog.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.core.catalog.internal.CatalogClasspathDo;
import org.apache.brooklyn.core.catalog.internal.CatalogClasspathDto;
import org.apache.brooklyn.core.catalog.internal.CatalogDo;
import org.apache.brooklyn.core.catalog.internal.CatalogItemDtoAbstract;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class CatalogDto {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogDto.class);
    String id;
    String contentsDescription;
    String name;
    String description;
    CatalogClasspathDto classpath;
    private List<CatalogItemDtoAbstract<?, ?>> entries = null;
    List<CatalogDto> catalogs = null;

    public static CatalogDto newDefaultLocalScanningDto(CatalogClasspathDo.CatalogScanningModes scanMode) {
        CatalogDo result = new CatalogDo(CatalogDto.newNamedInstance("Local Scanned Catalog", "All annotated Brooklyn entities detected in the default classpath", "scanning-local-classpath"));
        result.setClasspathScanForEntities(scanMode);
        return result.dto;
    }

    public static CatalogDto newNamedInstance(String name, String description, String optionalContentsDescription) {
        CatalogDto result = new CatalogDto();
        result.name = name;
        result.description = description;
        if (optionalContentsDescription != null) {
            result.contentsDescription = optionalContentsDescription;
        }
        return result;
    }

    public static CatalogDto newEmptyInstance(String optionalContentsDescription) {
        CatalogDto result = new CatalogDto();
        if (optionalContentsDescription != null) {
            result.contentsDescription = optionalContentsDescription;
        }
        return result;
    }

    @Deprecated
    public static CatalogDto newDtoFromCatalogItems(Collection<CatalogItem<?, ?>> entries) {
        return CatalogDto.newDtoFromCatalogItems(entries, null);
    }

    public static CatalogDto newDtoFromCatalogItems(Collection<CatalogItem<?, ?>> entries, String description) {
        CatalogDto result = new CatalogDto();
        result.contentsDescription = description;
        result.entries = (List)FluentIterable.from(entries).filter(CatalogItemDtoAbstract.class).copyInto((Collection)Lists.newArrayListWithExpectedSize((int)entries.size()));
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("id", (Object)this.id).add("contentsDescription", (Object)this.contentsDescription).toString();
    }

    Iterable<CatalogItemDtoAbstract<?, ?>> getUniqueEntries() {
        if (this.entries == null) {
            return null;
        }
        Map<String, CatalogItemDtoAbstract<?, ?>> result = this.getEntriesMap();
        return result.values();
    }

    private Map<String, CatalogItemDtoAbstract<?, ?>> getEntriesMap() {
        if (this.entries == null) {
            return null;
        }
        MutableMap result = MutableMap.of();
        for (CatalogItemDtoAbstract<?, ?> entry : this.entries) {
            result.put(entry.getId(), entry);
        }
        return result;
    }

    void removeEntry(CatalogItemDtoAbstract<?, ?> entry) {
        if (this.entries != null) {
            this.entries.remove(entry);
        }
    }

    void addEntry(CatalogItemDtoAbstract<?, ?> entry) {
        if (this.entries == null) {
            this.entries = MutableList.of();
        }
        CatalogItemDtoAbstract<?, ?> oldEntry = this.getEntriesMap().get(entry.getId());
        this.entries.add(entry);
        if (oldEntry != null) {
            this.removeEntry(oldEntry);
        }
    }
}

