/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.group;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.core.BrooklynLogging;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.apache.brooklyn.core.mgmt.internal.CollectionChangeListener;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.entity.group.AbstractGroupImpl;
import org.apache.brooklyn.entity.group.DynamicGroup;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicGroupImpl
extends AbstractGroupImpl
implements DynamicGroup {
    private static final Logger log = LoggerFactory.getLogger(DynamicGroupImpl.class);
    protected final Object memberChangeMutex = new Object();
    private volatile MyEntitySetChangeListener setChangeListener = null;

    @Override
    public void init() {
        super.init();
        this.sensors().set(RUNNING, true);
    }

    @Override
    public void setEntityFilter(Predicate<? super Entity> filter) {
        this.setConfigEvenIfOwned(ENTITY_FILTER, filter);
        this.rescanEntities();
    }

    @Override
    public Predicate<? super Entity> entityFilter() {
        return this.getEntityFilter();
    }

    protected Predicate<? super Entity> getEntityFilter() {
        Entity ancestor;
        Predicate entityFilter = (Predicate)this.getConfig(ENTITY_FILTER);
        if (entityFilter == null) {
            entityFilter = Predicates.alwaysFalse();
        }
        Predicate<Entity> ancestorFilter = (ancestor = this.getAncestorToScan()) == null ? EntityPredicates.applicationIdEqualTo(this.getApplicationId()) : (ancestor.getParent() == null ? EntityPredicates.applicationIdEqualTo(ancestor.getId()) : EntityPredicates.isDescendantOf(ancestor));
        return Predicates.and(ancestorFilter, (Predicate)entityFilter);
    }

    protected Entity getAncestorToScan() {
        Entity ancestor = (Entity)this.getConfig(ANCESTOR);
        if (ancestor == null) {
            return this.getApplication();
        }
        return ancestor;
    }

    private boolean isRunning() {
        return Boolean.TRUE.equals(this.getAttribute(RUNNING));
    }

    @Override
    public void stop() {
        this.sensors().set(RUNNING, false);
        if (this.setChangeListener != null) {
            ((ManagementContextInternal)this.getManagementContext()).removeEntitySetListener(this.setChangeListener);
        }
    }

    @Override
    public <T> void addSubscription(Entity producer, Sensor<T> sensor, final Predicate<? super SensorEvent<? super T>> filter) {
        SensorEventListener listener = new SensorEventListener<T>(){

            public void onEvent(SensorEvent<T> event) {
                if (filter.apply(event)) {
                    DynamicGroupImpl.this.onEntityChanged(event.getSource());
                }
            }
        };
        this.subscriptions().subscribe(producer, sensor, listener);
    }

    @Override
    public <T> void addSubscription(Entity producer, Sensor<T> sensor) {
        this.addSubscription(producer, sensor, Predicates.alwaysTrue());
    }

    protected boolean acceptsEntity(Entity e) {
        return this.entityFilter().apply((Object)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEntityAdded(Entity item) {
        Object object = this.memberChangeMutex;
        synchronized (object) {
            if (this.acceptsEntity(item)) {
                if (log.isDebugEnabled()) {
                    log.debug("{} detected item add {}", (Object)this, (Object)item);
                }
                this.addMember(item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEntityRemoved(Entity item) {
        Object object = this.memberChangeMutex;
        synchronized (object) {
            if (this.removeMember(item) && log.isDebugEnabled()) {
                log.debug("{} detected item removal {}", (Object)this, (Object)item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEntityChanged(Entity item) {
        Object object = this.memberChangeMutex;
        synchronized (object) {
            boolean accepts = this.acceptsEntity(item);
            boolean has = this.hasMember(item);
            if (has && !accepts) {
                this.removeMember(item);
                if (log.isDebugEnabled()) {
                    log.debug("{} detected item removal on change of {}", (Object)this, (Object)item);
                }
            } else if (!has && accepts) {
                if (log.isDebugEnabled()) {
                    log.debug("{} detected item add on change of {}", (Object)this, (Object)item);
                }
                this.addMember(item);
            }
        }
    }

    @Override
    public void onManagementBecomingMaster() {
        if (this.setChangeListener != null) {
            log.warn("{} becoming master twice", (Object)this);
            return;
        }
        this.setChangeListener = new MyEntitySetChangeListener();
        ((ManagementContextInternal)this.getManagementContext()).addEntitySetListener(this.setChangeListener);
        Task rescan = Tasks.builder().displayName("rescan entities").body(new Runnable(){

            @Override
            public void run() {
                try {
                    DynamicGroupImpl.this.rescanEntities();
                }
                catch (Exception e) {
                    log.warn("Error rescanning entities on management of " + DynamicGroupImpl.this + "; may be a group set against an unknown entity: " + e);
                    log.debug("Trace for rescan entities error", (Throwable)e);
                    Exceptions.propagateIfFatal((Throwable)e);
                }
            }
        }).build();
        this.getExecutionContext().submit(rescan);
    }

    @Override
    public void onManagementNoLongerMaster() {
        if (this.setChangeListener == null) {
            log.warn("{} no longer master twice", (Object)this);
            return;
        }
        ((ManagementContextInternal)this.getManagementContext()).removeEntitySetListener(this.setChangeListener);
        this.setChangeListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rescanEntities() {
        Object object = this.memberChangeMutex;
        synchronized (object) {
            if (!this.isRunning() || !this.getManagementSupport().isDeployed()) {
                if (log.isDebugEnabled()) {
                    log.debug("{} not scanning for children: stopped", (Object)this);
                }
                return;
            }
            if (this.getAncestorToScan() == null) {
                BrooklynLogging.log(log, BrooklynLogging.levelDependingIfReadOnly(this, BrooklynLogging.LoggingLevel.WARN, BrooklynLogging.LoggingLevel.TRACE, BrooklynLogging.LoggingLevel.TRACE), "{} not (yet) scanning for children: no application defined", this);
                return;
            }
            boolean changed = false;
            Collection<Entity> currentMembers = this.getMembers();
            LinkedHashSet toRemove = Sets.newLinkedHashSet(currentMembers);
            Iterable<Entity> unfiltered = Entities.descendantsAndSelf(this.getAncestorToScan());
            log.debug("{} filtering {} with {}", new Object[]{this, unfiltered, this.entityFilter()});
            for (Entity it : Iterables.filter(unfiltered, this.entityFilter())) {
                toRemove.remove(it);
                if (currentMembers.contains(it)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("{} rescan detected new item {}", (Object)this, (Object)it);
                }
                this.addMember(it);
                changed = true;
            }
            for (Entity it : toRemove) {
                if (log.isDebugEnabled()) {
                    log.debug("{} rescan detected vanished item {}", (Object)this, (Object)it);
                }
                this.removeMember(it);
                changed = true;
            }
            if (changed && log.isDebugEnabled()) {
                log.debug("{} rescan complete, members now {}", (Object)this, this.getMembers());
            }
        }
    }

    private class MyEntitySetChangeListener
    implements CollectionChangeListener.ListenerWithErrorHandler<Entity> {
        private MyEntitySetChangeListener() {
        }

        @Override
        public void onItemAdded(Entity item) {
            DynamicGroupImpl.this.onEntityAdded(item);
        }

        @Override
        public void onItemRemoved(Entity item) {
            DynamicGroupImpl.this.onEntityRemoved(item);
        }

        @Override
        public void onError(String msg, Throwable trace) {
            BrooklynLogging.log(log, Entities.isManagedActive(DynamicGroupImpl.this) ? BrooklynLogging.LoggingLevel.WARN : BrooklynLogging.LoggingLevel.DEBUG, msg, trace);
            throw Exceptions.propagate((Throwable)trace);
        }
    }
}

