/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.units;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.List;
import org.apache.brooklyn.core.resolve.jackson.JsonSymbolDependentDeserializer;
import org.apache.brooklyn.util.collections.MutableList;

@JsonDeserialize(using=RangeDeserializer.class)
public class Range
extends MutableList<Object> {
    public Range() {
    }

    public Range(List<Object> l) {
        this.setValue(l);
    }

    public boolean add(Object o) {
        if (this.size() >= 2) {
            throw new IllegalStateException("Range must be of size 2; cannot add '" + o + "' when currently " + (Object)((Object)this));
        }
        if (o instanceof String && "unbounded".equalsIgnoreCase((String)o)) {
            o = this.isEmpty() ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        }
        if (!(o instanceof Integer)) {
            throw new IllegalStateException("Invalid value for range; must be an integer or 'UNBOUNDED'");
        }
        return super.add((Object)((Integer)o));
    }

    public int min() {
        return (Integer)this.get(0);
    }

    public int max() {
        return (Integer)this.get(1);
    }

    private void setValue(List<Object> l) {
        if (l.size() != 2) {
            throw new IllegalStateException("Range must be of size 2; cannot create from " + l);
        }
        l.forEach(this::add);
    }

    public static class RangeDeserializer
    extends JsonSymbolDependentDeserializer {
        @Override
        public JavaType getDefaultType() {
            return this.ctxt.constructType(Range.class);
        }

        @Override
        protected Object deserializeArray(JsonParser p) throws IOException {
            return new Range((List)super.deserializeArray(p));
        }

        @Override
        protected JsonDeserializer<?> getArrayDeserializer() throws IOException {
            return this.ctxt.getFactory().createCollectionDeserializer(this.ctxt, this.ctxt.getTypeFactory().constructCollectionType(List.class, Object.class), this.getBeanDescription());
        }
    }
}

