/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.joda.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import org.apache.cayenne.access.types.ExtendedType;
import org.joda.time.DateTime;

public class DateTimeType
implements ExtendedType<DateTime> {
    public String getClassName() {
        return DateTime.class.getName();
    }

    public void setJdbcObject(PreparedStatement statement, DateTime value, int pos, int type, int scale) throws Exception {
        if (value == null) {
            statement.setNull(pos, type);
        } else {
            Timestamp ts = new Timestamp(value.getMillis());
            statement.setTimestamp(pos, ts);
        }
    }

    public DateTime materializeObject(ResultSet rs, int index, int type) throws Exception {
        if (rs.getTimestamp(index) != null) {
            return new DateTime(rs.getTimestamp(index).getTime());
        }
        return null;
    }

    public DateTime materializeObject(CallableStatement rs, int index, int type) throws Exception {
        if (rs.getTimestamp(index) != null) {
            return new DateTime(rs.getTimestamp(index).getTime());
        }
        return null;
    }

    public String toString(DateTime value) {
        if (value == null) {
            return "NULL";
        }
        return '\'' + value.toString() + '\'';
    }
}

