/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.codegen;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.dialog.codegen.GeneratorController;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.validation.ValidationFailure;
import org.apache.cayenne.validation.ValidationResult;
import org.apache.commons.collections.Predicate;

public abstract class CodeGeneratorControllerBase
extends CayenneController {
    public static final String SELECTED_PROPERTY = "selected";
    protected Collection<DataMap> dataMaps;
    protected ValidationResult validation;
    protected List<Object> classes;
    private Set<String> selectedEntities;
    private Set<String> selectedEmbeddables;
    private Set<String> selectedDataMaps;
    protected transient Object currentClass;

    public CodeGeneratorControllerBase(CayenneController parent, Collection<DataMap> dataMaps) {
        super(parent);
        this.dataMaps = dataMaps;
        this.classes = new ArrayList<Object>();
        for (DataMap dataMap : dataMaps) {
            this.classes.addAll(dataMap.getObjEntities());
            this.classes.addAll(dataMap.getEmbeddables());
            this.classes.add(dataMap);
        }
        this.selectedEntities = new HashSet<String>();
        this.selectedEmbeddables = new HashSet<String>();
        this.selectedDataMaps = new HashSet<String>();
    }

    public List<Object> getClasses() {
        return this.classes;
    }

    @Override
    public abstract Component getView();

    public void validate(GeneratorController validator) {
        ValidationResult validationBuffer = new ValidationResult();
        if (validator != null) {
            for (Object classObj : this.classes) {
                if (classObj instanceof ObjEntity) {
                    validator.validateEntity(validationBuffer, (ObjEntity)classObj, false);
                    continue;
                }
                if (!(classObj instanceof Embeddable)) continue;
                validator.validateEmbeddable(validationBuffer, (Embeddable)classObj);
            }
        }
        this.validation = validationBuffer;
    }

    public boolean updateDataMapSelection(Predicate predicate, DataMap dataMap) {
        boolean modified = false;
        for (Object classObj : this.classes) {
            boolean select = predicate.evaluate(classObj);
            if (classObj instanceof ObjEntity) {
                if (!dataMap.getObjEntities().contains(classObj)) continue;
                if (select) {
                    if (!this.selectedEntities.add(((ObjEntity)classObj).getName())) continue;
                    modified = true;
                    continue;
                }
                if (!this.selectedEntities.remove(((ObjEntity)classObj).getName())) continue;
                modified = true;
                continue;
            }
            if (classObj instanceof Embeddable) {
                if (!dataMap.getEmbeddables().contains(classObj)) continue;
                if (select) {
                    if (!this.selectedEmbeddables.add(((Embeddable)classObj).getClassName())) continue;
                    modified = true;
                    continue;
                }
                if (!this.selectedEmbeddables.remove(((Embeddable)classObj).getClassName())) continue;
                modified = true;
                continue;
            }
            if (dataMap != classObj) continue;
            if (select) {
                if (!this.selectedDataMaps.add(((DataMap)classObj).getName())) continue;
                modified = true;
                continue;
            }
            if (!this.selectedDataMaps.remove(((DataMap)classObj).getName())) continue;
            modified = true;
        }
        if (modified) {
            this.firePropertyChange(SELECTED_PROPERTY, null, null);
        }
        return modified;
    }

    public boolean updateSelection(Predicate predicate) {
        boolean modified = false;
        for (Object classObj : this.classes) {
            boolean select = predicate.evaluate(classObj);
            if (classObj instanceof ObjEntity) {
                if (select) {
                    if (!this.selectedEntities.add(((ObjEntity)classObj).getName())) continue;
                    modified = true;
                    continue;
                }
                if (!this.selectedEntities.remove(((ObjEntity)classObj).getName())) continue;
                modified = true;
                continue;
            }
            if (classObj instanceof Embeddable) {
                if (select) {
                    if (!this.selectedEmbeddables.add(((Embeddable)classObj).getClassName())) continue;
                    modified = true;
                    continue;
                }
                if (!this.selectedEmbeddables.remove(((Embeddable)classObj).getClassName())) continue;
                modified = true;
                continue;
            }
            if (!(classObj instanceof DataMap)) continue;
            if (select) {
                if (!this.selectedDataMaps.add(((DataMap)classObj).getName())) continue;
                modified = true;
                continue;
            }
            if (!this.selectedDataMaps.remove(((DataMap)classObj).getName())) continue;
            modified = true;
        }
        if (modified) {
            this.firePropertyChange(SELECTED_PROPERTY, null, null);
        }
        return modified;
    }

    public List<Embeddable> getSelectedEmbeddables() {
        ArrayList<Embeddable> selected = new ArrayList<Embeddable>(this.selectedEmbeddables.size());
        for (Object classObj : this.classes) {
            if (!(classObj instanceof Embeddable) || !this.selectedEmbeddables.contains(((Embeddable)classObj).getClassName())) continue;
            selected.add((Embeddable)classObj);
        }
        return selected;
    }

    public List<ObjEntity> getSelectedEntities() {
        ArrayList<ObjEntity> selected = new ArrayList<ObjEntity>(this.selectedEntities.size());
        for (Object classObj : this.classes) {
            if (!(classObj instanceof ObjEntity) || !this.selectedEntities.contains(((ObjEntity)classObj).getName())) continue;
            selected.add((ObjEntity)classObj);
        }
        return selected;
    }

    public List<DataMap> getSelectedDataMaps() {
        ArrayList<DataMap> selected = new ArrayList<DataMap>(this.selectedDataMaps.size());
        for (Object classObj : this.classes) {
            if (!(classObj instanceof DataMap) || !this.selectedDataMaps.contains(((DataMap)classObj).getName())) continue;
            selected.add((DataMap)classObj);
        }
        return selected;
    }

    public int getSelectedEntitiesSize() {
        return this.selectedEntities.size();
    }

    public int getSelectedEmbeddablesSize() {
        return this.selectedEmbeddables.size();
    }

    public int getSelectedDataMapsSize() {
        return this.selectedDataMaps.size();
    }

    public String getProblem(Object obj) {
        String name = null;
        if (obj instanceof ObjEntity) {
            name = ((ObjEntity)obj).getName();
        } else if (obj instanceof Embeddable) {
            name = ((Embeddable)obj).getClassName();
        }
        if (this.validation == null) {
            return null;
        }
        List<ValidationFailure> failures = this.validation.getFailures(name);
        if (failures.isEmpty()) {
            return null;
        }
        return failures.get(0).getDescription();
    }

    public boolean isSelected() {
        if (this.currentClass instanceof ObjEntity) {
            return this.selectedEntities.contains(((ObjEntity)this.currentClass).getName());
        }
        if (this.currentClass instanceof Embeddable) {
            return this.selectedEmbeddables.contains(((Embeddable)this.currentClass).getClassName());
        }
        if (this.currentClass instanceof DataMap) {
            return this.selectedDataMaps.contains(((DataMap)this.currentClass).getName());
        }
        return false;
    }

    public void setSelected(boolean selectedFlag) {
        if (this.currentClass == null) {
            return;
        }
        if (this.currentClass instanceof ObjEntity) {
            if (selectedFlag) {
                if (this.selectedEntities.add(((ObjEntity)this.currentClass).getName())) {
                    this.firePropertyChange(SELECTED_PROPERTY, null, null);
                }
            } else if (this.selectedEntities.remove(((ObjEntity)this.currentClass).getName())) {
                this.firePropertyChange(SELECTED_PROPERTY, null, null);
            }
        }
        if (this.currentClass instanceof Embeddable) {
            if (selectedFlag) {
                if (this.selectedEmbeddables.add(((Embeddable)this.currentClass).getClassName())) {
                    this.firePropertyChange(SELECTED_PROPERTY, null, null);
                }
            } else if (this.selectedEmbeddables.remove(((Embeddable)this.currentClass).getClassName())) {
                this.firePropertyChange(SELECTED_PROPERTY, null, null);
            }
        }
        if (this.currentClass instanceof DataMap) {
            if (selectedFlag) {
                if (this.selectedDataMaps.add(((DataMap)this.currentClass).getName())) {
                    this.firePropertyChange(SELECTED_PROPERTY, null, null);
                }
            } else if (this.selectedDataMaps.remove(((DataMap)this.currentClass).getName())) {
                this.firePropertyChange(SELECTED_PROPERTY, null, null);
            }
        }
    }

    public Object getCurrentClass() {
        return this.currentClass;
    }

    public void setCurrentClass(Object currentClass) {
        this.currentClass = currentClass;
    }

    public Collection<DataMap> getDataMaps() {
        return this.dataMaps;
    }

    public JLabel getItemName(Object obj) {
        Icon icon;
        String className;
        if (obj instanceof Embeddable) {
            className = ((Embeddable)obj).getClassName();
            icon = CellRenderers.iconForObject(new Embeddable());
        } else if (obj instanceof ObjEntity) {
            className = ((ObjEntity)obj).getName();
            icon = CellRenderers.iconForObject(new ObjEntity());
        } else {
            className = ((DataMap)obj).getName();
            icon = CellRenderers.iconForObject(new DataMap());
        }
        JLabel labelIcon = new JLabel();
        labelIcon.setIcon(icon);
        labelIcon.setVisible(true);
        labelIcon.setText(className);
        return labelIcon;
    }
}

