/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.pref;

import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.pref.CayennePreference;

public class TableColumnPreferences
extends CayennePreference {
    private static final String SORT_COLUMN_KEY = "sort_column";
    private static final String SORT_ORDER_KEY = "sort_order";
    private static final String WIDTH_KEY = "width_";
    public static final String TABLE_COLUMN_PREF_KEY = "table_column";
    private static final String ORDER_KEY = "order_";
    private JTable table;
    private int columnCount;
    private int defaultSortColumn;
    private boolean defaultSortOrder;
    private int[] currentWidth;
    private TableColumnModelListener listener = new TableColumnModelListener(){

        @Override
        public void columnAdded(TableColumnModelEvent e) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
            for (int i = 0; i < TableColumnPreferences.this.columnCount; ++i) {
                TableColumn column = TableColumnPreferences.this.table.getColumnModel().getColumn(i);
                TableColumnPreferences.this.setWidth(column.getModelIndex(), column.getPreferredWidth());
            }
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            TableColumn column = null;
            for (int i = 0; i < TableColumnPreferences.this.columnCount; ++i) {
                column = TableColumnPreferences.this.table.getColumnModel().getColumn(i);
                TableColumnPreferences.this.setOrderIndex(column.getModelIndex(), i);
            }
            TableColumnPreferences.this.updateSort(TableColumnPreferences.this.defaultSortColumn, TableColumnPreferences.this.defaultSortOrder);
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    };

    public TableColumnPreferences(Class className, String path) {
        this.setCurrentNodeForPreference(className, path);
    }

    public Preferences getPreference() {
        if (this.getCurrentPreference() == null) {
            this.setCurrentNodeForPreference(this.getClass(), TABLE_COLUMN_PREF_KEY);
        }
        return this.getCurrentPreference();
    }

    public void bind(JTable table, Map<Integer, Integer> minSizes, Map<Integer, Integer> maxSizes, Map<Integer, Integer> defaultSizes, int defaultSortColumn, boolean defaultSortOrder) {
        this.bind(table, minSizes, maxSizes, defaultSizes);
        ((CayenneTable)table).setSortPreferenceSaver(this);
        this.defaultSortColumn = defaultSortColumn;
        this.defaultSortOrder = defaultSortOrder;
        this.updateSort(defaultSortColumn, defaultSortOrder);
    }

    public void bind(JTable table, Map<Integer, Integer> minSizes, Map<Integer, Integer> maxSizes, Map<Integer, Integer> defaultSizes) {
        this.table = table;
        this.columnCount = table.getColumnCount();
        this.currentWidth = new int[this.columnCount];
        table.getColumnModel().removeColumnModelListener(this.listener);
        this.updateTable(minSizes, maxSizes, defaultSizes);
        table.getColumnModel().addColumnModelListener(this.listener);
    }

    private void updateTable(Map<Integer, Integer> minSizes, Map<Integer, Integer> maxSizes, Map<Integer, Integer> defaultSizes) {
        this.updateWidths(minSizes, maxSizes, defaultSizes);
        this.updateOrder();
    }

    private void updateWidths(Map<Integer, Integer> minSizes, Map<Integer, Integer> maxSizes, Map<Integer, Integer> defaultSizes) {
        TableColumn column = null;
        TableColumnModel columnModel = this.table.getColumnModel();
        for (int i = 0; i < this.columnCount; ++i) {
            column = columnModel.getColumn(i);
            int modelIndex = column.getModelIndex();
            if (minSizes != null && minSizes.containsKey(modelIndex)) {
                column.setMinWidth(minSizes.get(modelIndex));
            }
            if (maxSizes != null && maxSizes.containsKey(modelIndex)) {
                column.setMaxWidth(maxSizes.get(modelIndex));
            }
            int defaultWidth = defaultSizes != null && defaultSizes.containsKey(modelIndex) ? defaultSizes.get(modelIndex).intValue() : column.getPreferredWidth();
            int width = this.getWidth(modelIndex, defaultWidth);
            if (column.getPreferredWidth() == width) continue;
            column.setPreferredWidth(width);
        }
    }

    private void updateOrder() {
        TableColumnModel columnModel = this.table.getColumnModel();
        TableModel model = this.table.getModel();
        String columnName = "";
        for (int i = 0; i < this.columnCount; ++i) {
            columnName = model.getColumnName(i);
            TableColumn column = this.table.getColumn(columnName);
            int modelIndex = column.getModelIndex();
            int orderIndex = this.getOrderIndex(modelIndex, modelIndex);
            if (i == orderIndex) continue;
            this.table.moveColumn(columnModel.getColumnIndex(columnName), orderIndex);
        }
    }

    private void updateSort(int defaultSortColumn, boolean defaultSortOrder) {
        ((CayenneTable)this.table).sort(this.getSortColumn(SORT_COLUMN_KEY, defaultSortColumn), this.getSortOrder(SORT_ORDER_KEY, defaultSortOrder));
    }

    private int getWidth(int index, int defaultWidth) {
        if (this.currentWidth[index] == 0) {
            this.currentWidth[index] = this.getPreference().getInt(WIDTH_KEY + Integer.toString(index), defaultWidth);
        }
        return this.currentWidth[index];
    }

    private void setWidth(int index, int width) {
        if (this.currentWidth[index] != width) {
            this.getPreference().putInt(WIDTH_KEY + Integer.toString(index), width);
            this.currentWidth[index] = width;
        }
    }

    private int getOrderIndex(int columnIndex, int defaultOrderIndex) {
        return this.getPreference().getInt(ORDER_KEY + Integer.toString(columnIndex), defaultOrderIndex);
    }

    private void setOrderIndex(int columnIndex, int defaultOrderIndex) {
        this.getPreference().putInt(ORDER_KEY + Integer.toString(columnIndex), defaultOrderIndex);
    }

    private boolean getSortOrder(String sortOrderKey, boolean defaultSortOrder) {
        return this.getPreference().getBoolean(SORT_ORDER_KEY, defaultSortOrder);
    }

    public void setSortOrder(boolean isAscent) {
        this.getPreference().putBoolean(SORT_ORDER_KEY, isAscent);
    }

    private int getSortColumn(String sortColumnKey, int defaultSortColumn) {
        return this.getPreference().getInt(SORT_COLUMN_KEY, defaultSortColumn);
    }

    public void setSortColumn(int sortCol) {
        this.getPreference().putInt(SORT_COLUMN_KEY, sortCol);
    }
}

