/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import java.io.Serializable;
import org.apache.commons.dbcp2.Utils;
import org.apache.commons.dbcp2.datasources.UserPassKey;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestUserPassKey {
    private UserPassKey userPassKey;
    private UserPassKey anotherUserPassKey;

    @BeforeEach
    public void setUp() {
        this.userPassKey = new UserPassKey("user", "pass");
        this.anotherUserPassKey = new UserPassKey((String)null, "");
    }

    @Test
    void testEquals() {
        Assertions.assertEquals((Object)new UserPassKey("user"), (Object)new UserPassKey("user", (char[])null));
        Assertions.assertEquals((Object)this.userPassKey, (Object)this.userPassKey);
        Assertions.assertNotEquals((Object)this.userPassKey, null);
        Assertions.assertNotEquals((Object)this.userPassKey, (Object)new Object());
        Assertions.assertNotEquals((Object)new UserPassKey(null), (Object)this.userPassKey);
        Assertions.assertEquals((Object)new UserPassKey(null), (Object)new UserPassKey(null));
        Assertions.assertNotEquals((Object)new UserPassKey("user", "pass"), (Object)new UserPassKey("foo", "pass"));
    }

    @Test
    void testGettersAndSetters() {
        Assertions.assertEquals((Object)"user", (Object)this.userPassKey.getUserName());
        Assertions.assertEquals((Object)"pass", (Object)this.userPassKey.getPassword());
        Assertions.assertArrayEquals((char[])Utils.toCharArray((String)"pass"), (char[])this.userPassKey.getPasswordCharArray());
    }

    @Test
    void testHashcode() {
        Assertions.assertEquals((int)this.userPassKey.hashCode(), (int)new UserPassKey("user", "pass").hashCode());
        Assertions.assertNotEquals((int)this.userPassKey.hashCode(), (int)this.anotherUserPassKey.hashCode());
    }

    @Test
    void testSerialization() {
        Assertions.assertEquals((Object)this.userPassKey, (Object)SerializationUtils.roundtrip((Serializable)this.userPassKey));
        Assertions.assertEquals((Object)this.anotherUserPassKey, (Object)SerializationUtils.roundtrip((Serializable)this.anotherUserPassKey));
    }

    @Test
    void testToString() {
        Assertions.assertEquals((Object)this.userPassKey.toString(), (Object)new UserPassKey("user", "pass").toString());
        Assertions.assertNotEquals((Object)this.userPassKey.toString(), (Object)this.anotherUserPassKey.toString());
    }
}

