/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.config.store.disk;

import org.ehcache.impl.internal.store.disk.OffHeapDiskStore;
import org.ehcache.spi.service.ServiceConfiguration;

public class OffHeapDiskStoreConfiguration
implements ServiceConfiguration<OffHeapDiskStore.Provider, OffHeapDiskStoreConfiguration> {
    public static final int DEFAULT_WRITER_CONCURRENCY = 1;
    public static final int DEFAULT_DISK_SEGMENTS = 16;
    private final String threadPoolAlias;
    private final int writerConcurrency;
    private final int diskSegments;

    public OffHeapDiskStoreConfiguration(int diskSegments) {
        this(null, 1, diskSegments);
    }

    public OffHeapDiskStoreConfiguration(String threadPoolAlias, int writerConcurrency) {
        this(threadPoolAlias, writerConcurrency, 16);
    }

    public OffHeapDiskStoreConfiguration(String threadPoolAlias, int writerConcurrency, int diskSegments) {
        this.threadPoolAlias = threadPoolAlias;
        this.writerConcurrency = writerConcurrency;
        this.diskSegments = diskSegments;
    }

    public String getThreadPoolAlias() {
        return this.threadPoolAlias;
    }

    public int getWriterConcurrency() {
        return this.writerConcurrency;
    }

    public int getDiskSegments() {
        return this.diskSegments;
    }

    @Override
    public Class<OffHeapDiskStore.Provider> getServiceType() {
        return OffHeapDiskStore.Provider.class;
    }

    @Override
    public OffHeapDiskStoreConfiguration derive() {
        return new OffHeapDiskStoreConfiguration(this.threadPoolAlias, this.writerConcurrency, this.diskSegments);
    }

    public OffHeapDiskStoreConfiguration build(OffHeapDiskStoreConfiguration config) {
        return config;
    }
}

