/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.eventing.backend.database;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.ws.eventing.backend.database.SubscriptionDatabase;
import org.apache.cxf.ws.eventing.backend.database.SubscriptionTicket;
import org.apache.cxf.ws.eventing.shared.faults.UnknownSubscription;

public class SubscriptionDatabaseImpl
implements SubscriptionDatabase {
    private static final Logger LOG = LogUtils.getLogger(SubscriptionDatabaseImpl.class);
    private final List<SubscriptionTicket> ticketList;

    public SubscriptionDatabaseImpl() {
        LOG.info("Instantiating SubscriptionDatabaseImpl");
        this.ticketList = new CopyOnWriteArrayList<SubscriptionTicket>();
    }

    @Override
    public void addTicket(SubscriptionTicket ticket) {
        this.ticketList.add(ticket);
        LOG.info("SubscriptionDatabaseImpl accepted ticket for subscription: " + String.valueOf(ticket.getUuid()));
    }

    @Override
    public List<SubscriptionTicket> getTickets() {
        return this.ticketList;
    }

    @Override
    public SubscriptionTicket findById(UUID id) {
        for (SubscriptionTicket ticket : this.ticketList) {
            if (!ticket.getUuid().equals(id)) continue;
            return ticket;
        }
        return null;
    }

    @Override
    public synchronized void removeTicketByUUID(UUID id) {
        boolean removed = false;
        for (SubscriptionTicket ticket : this.ticketList) {
            if (!ticket.getUuid().equals(id)) continue;
            this.ticketList.remove(ticket);
            removed = true;
            break;
        }
        if (!removed) {
            throw new UnknownSubscription();
        }
    }
}

