/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.GDateValue;
import net.sf.saxon.value.Whitespace;

public class GMonthValue
extends GDateValue {
    private static final Pattern regex = Pattern.compile("--([0-9][0-9])(Z|[+-][0-9][0-9]:[0-9][0-9])?");

    private GMonthValue(GDateValue.MutableGDateValue m) {
        super(m);
    }

    public static ConversionResult makeGMonthValue(UnicodeString value) {
        GDateValue.MutableGDateValue g = new GDateValue.MutableGDateValue();
        UnicodeString trimmed = Whitespace.trim(value);
        Matcher m = regex.matcher(trimmed.toString());
        if (!m.matches()) {
            return new ValidationFailure("Cannot convert '" + value + "' to a gMonth");
        }
        String base = m.group(1);
        String tz = m.group(2);
        String date = "2000-" + base + "-01" + (tz == null ? "" : tz);
        g.typeLabel = BuiltInAtomicType.G_MONTH;
        GMonthValue.setLexicalValue(g, BMPString.of(date), true);
        return g.error == null ? new GMonthValue(g) : g.error;
    }

    public GMonthValue(byte month, int tz) {
        this(month, tz, BuiltInAtomicType.G_MONTH);
    }

    public GMonthValue(byte month, int tz, AtomicType type) {
        this(new GDateValue.MutableGDateValue(2000, month, 1, false, tz, type));
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        GDateValue.MutableGDateValue m = this.makeMutableCopy();
        m.typeLabel = typeLabel;
        return new GMonthValue(m);
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.G_MONTH;
    }

    @Override
    public UnicodeString getPrimitiveStringValue() {
        UnicodeBuilder sb = new UnicodeBuilder(16);
        sb.appendLatin("--");
        GMonthValue.appendTwoDigits(sb, this.month);
        if (this.hasTimezone()) {
            this.appendTimezone(sb);
        }
        return sb.toUnicodeString();
    }

    @Override
    public CalendarValue add(DurationValue duration) throws XPathException {
        throw new XPathException("Cannot add a duration to an xs:gMonth", "XPTY0004").asTypeError();
    }

    @Override
    public CalendarValue adjustTimezone(int tz) {
        DateTimeValue dt = this.toDateTime().adjustTimezone(tz);
        return new GMonthValue(dt.getMonth(), dt.getTimezoneInMinutes());
    }
}

