/*
 * Decompiled with CFR 0.152.
 */
package os.shaded_org_apache_tools_zip;

import os.shaded_org_apache_tools_zip.ZipShort;

public final class GeneralPurposeBit
implements Cloneable {
    private static final int ENCRYPTION_FLAG = 1;
    private static final int DATA_DESCRIPTOR_FLAG = 8;
    private static final int STRONG_ENCRYPTION_FLAG = 64;
    public static final int UFT8_NAMES_FLAG = 2048;
    private boolean languageEncodingFlag = false;
    private boolean dataDescriptorFlag = false;
    private boolean encryptionFlag = false;
    private boolean strongEncryptionFlag = false;

    public boolean usesUTF8ForNames() {
        return this.languageEncodingFlag;
    }

    public void useUTF8ForNames(boolean bl) {
        this.languageEncodingFlag = bl;
    }

    public boolean usesDataDescriptor() {
        return this.dataDescriptorFlag;
    }

    public void useDataDescriptor(boolean bl) {
        this.dataDescriptorFlag = bl;
    }

    public boolean usesEncryption() {
        return this.encryptionFlag;
    }

    public void useEncryption(boolean bl) {
        this.encryptionFlag = bl;
    }

    public boolean usesStrongEncryption() {
        return this.encryptionFlag && this.strongEncryptionFlag;
    }

    public void useStrongEncryption(boolean bl) {
        this.strongEncryptionFlag = bl;
        if (bl) {
            this.useEncryption(true);
        }
    }

    public byte[] encode() {
        byte[] byArray = new byte[2];
        this.encode(byArray, 0);
        return byArray;
    }

    public void encode(byte[] byArray, int n) {
        ZipShort.putShort((this.dataDescriptorFlag ? 8 : 0) | (this.languageEncodingFlag ? 2048 : 0) | (this.encryptionFlag ? 1 : 0) | (this.strongEncryptionFlag ? 64 : 0), byArray, n);
    }

    public static GeneralPurposeBit parse(byte[] byArray, int n) {
        int n2 = ZipShort.getValue(byArray, n);
        GeneralPurposeBit generalPurposeBit = new GeneralPurposeBit();
        generalPurposeBit.useDataDescriptor((n2 & 8) != 0);
        generalPurposeBit.useUTF8ForNames((n2 & 0x800) != 0);
        generalPurposeBit.useStrongEncryption((n2 & 0x40) != 0);
        generalPurposeBit.useEncryption((n2 & 1) != 0);
        return generalPurposeBit;
    }

    public int hashCode() {
        return 3 * (7 * (13 * (17 * (this.encryptionFlag ? 1 : 0) + (this.strongEncryptionFlag ? 1 : 0)) + (this.languageEncodingFlag ? 1 : 0)) + (this.dataDescriptorFlag ? 1 : 0));
    }

    public boolean equals(Object object) {
        if (object instanceof GeneralPurposeBit) {
            GeneralPurposeBit generalPurposeBit = (GeneralPurposeBit)object;
            return generalPurposeBit.encryptionFlag == this.encryptionFlag && generalPurposeBit.strongEncryptionFlag == this.strongEncryptionFlag && generalPurposeBit.languageEncodingFlag == this.languageEncodingFlag && generalPurposeBit.dataDescriptorFlag == this.dataDescriptorFlag;
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("GeneralPurposeBit is not Cloneable?", cloneNotSupportedException);
        }
    }
}

