/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class PrecedenceTest
extends BaseJDBCTestCase {
    public PrecedenceTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(PrecedenceTest.class);
    }

    public void testPrecedence() throws SQLException {
        String sql = "create table t1(c11 int)";
        Statement st = this.createStatement();
        st.executeUpdate(sql);
        sql = "insert into t1 values(1)";
        PrecedenceTest.assertEquals((int)1, (int)st.executeUpdate(sql));
        sql = "select c11 from t1 where 1 in (1,2,3) = (1=1)";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "1");
        sql = "select c11 from t1 where 'acme widgets' like 'acme%' in ('1=1')";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "1");
        sql = "select c11 from t1 where 1 between -100 and 100 is not null";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "1");
        sql = "select c11 from t1 where exists(select * from (values 1) as t) not in ('1=2')";
        JDBC.assertEmpty(st.executeQuery(sql));
        st.close();
    }
}

