/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.vti.StringColumnVTI;

public class RSMDWrapper
extends StringColumnVTI {
    private static final String[] COLUMN_NAMES = new String[]{"getCatalogName", "getColumnClassName", "getColumnDisplaySize", "getColumnLabel", "getColumnName", "getColumnType", "getColumnTypeName", "getPrecision", "getScale", "getSchemaName", "getTableName", "isAutoIncrement", "isCaseSensitive", "isCurrency", "isDefinitelyWritable", "isNullable", "isReadOnly", "isSearchable", "isSigned", "isWritable"};
    private static final int[] COLUMN_TYPES = new int[]{12, 12, 4, 12, 12, 4, 12, 4, 4, 12, 12, 16, 16, 16, 16, 4, 16, 16, 16, 16};
    private Method[] _methods;
    private ResultSetMetaData _rsmd;
    private int _rowCount;
    private int _currentRow;
    private Integer _currentRowNumber;

    public static ResultSet getResultSetMetaData(String query) throws Exception {
        return new RSMDWrapper(DriverManager.getConnection("jdbc:default:connection"), query);
    }

    public RSMDWrapper(Connection conn, String query) throws Exception {
        super(COLUMN_NAMES);
        this.loadMethods();
        PreparedStatement ps = conn.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        this._rsmd = rs.getMetaData();
        this._rowCount = this._rsmd.getColumnCount();
        this._currentRow = 0;
        rs.close();
        ps.close();
    }

    private void loadMethods() throws Exception {
        int count = COLUMN_NAMES.length;
        this._methods = new Method[count];
        for (int i = 0; i < count; ++i) {
            this._methods[i] = ResultSetMetaData.class.getMethod(COLUMN_NAMES[i], Integer.TYPE);
        }
    }

    public boolean next() throws SQLException {
        if (this._currentRow >= this._rowCount) {
            return false;
        }
        ++this._currentRow;
        this._currentRowNumber = this._currentRow;
        return true;
    }

    public void close() {
        this._rsmd = null;
    }

    public ResultSetMetaData getMetaData() {
        return null;
    }

    protected String getRawColumn(int columnNumber) throws SQLException {
        int zeroIdx = columnNumber - 1;
        Method method = this._methods[zeroIdx];
        Object result = null;
        try {
            result = method.invoke((Object)this._rsmd, this._currentRowNumber);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException("Could not invoke method '" + method + "'");
        }
        int columnType = COLUMN_TYPES[zeroIdx];
        switch (columnType) {
            case 12: {
                return (String)result;
            }
            case 4: {
                return ((Integer)result).toString();
            }
            case 16: {
                return ((Boolean)result).toString();
            }
        }
        throw new SQLException("Unknown data type: " + columnType);
    }
}

