/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.BigDecimalHandler;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UpdatableResultSetTest
extends BaseJDBCTestCase {
    private static String[] allUpdateXXXNames = new String[]{"updateShort", "updateInt", "updateLong", "updateBigDecimal", "updateFloat", "updateDouble", "updateString", "updateAsciiStream", "updateCharacterStream", "updateByte", "updateBytes", "updateBinaryStream", "updateClob", "updateDate", "updateTime", "updateTimestamp", "updateBlob", "updateBoolean", "updateNull", "updateArray", "updateRef"};
    private static String[] allSQLTypes = new String[]{"SMALLINT", "INTEGER", "BIGINT", "DECIMAL(10,5)", "REAL", "DOUBLE", "CHAR(60)", "VARCHAR(60)", "LONG VARCHAR", "CHAR(2) FOR BIT DATA", "VARCHAR(2) FOR BIT DATA", "LONG VARCHAR FOR BIT DATA", "CLOB(1k)", "DATE", "TIME", "TIMESTAMP", "BLOB(1k)"};
    private static String[] ColumnNames = new String[]{"SMALLINTCOL", "INTEGERCOL", "BIGINTCOL", "DECIMALCOL", "REALCOL", "DOUBLECOL", "CHARCOL", "VARCHARCOL", "LONGVARCHARCOL", "CHARFORBITCOL", "VARCHARFORBITCOL", "LVARCHARFORBITCOL", "CLOBCOL", "DATECOL", "TIMECOL", "TIMESTAMPCOL", "BLOBCOL"};
    private static String[][] SQLData = new String[][]{{"11", "22"}, {"111", "1111"}, {"22", "222"}, {"3.3", "3.33"}, {"4.4", "4.44"}, {"5.5", "5.55"}, {"'1992-01-06'", "'1992'"}, {"'1992-01-07'", "'1992'"}, {"'1992-01-08'", "'1992'"}, {"X'10'", "X'10aa'"}, {"X'10'", "X'10bb'"}, {"X'10'", "X'10cc'"}, {"'13'", "'14'"}, {"'2000-01-01'", "'2000-01-01'"}, {"'15:30:20'", "'15:30:20'"}, {"'2000-01-01 15:30:20'", "'2000-01-01 15:30:20'"}, {"X'1020'", "X'10203040'"}};
    public static final String[][] updateXXXRulesTableForEmbedded = new String[][]{{"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22005", "22005", "PASS", "XCL12", "22005", "22005", "XCL12", "XCL12", "XCL12", "22005", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22005", "22005", "PASS", "XCL12", "22005", "22005", "XCL12", "XCL12", "XCL12", "22005", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22005", "22005", "PASS", "XCL12", "22005", "22005", "XCL12", "XCL12", "XCL12", "22005", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22005", "22005", "PASS", "XCL12", "22005", "22005", "XCL12", "XCL12", "XCL12", "22005", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22005", "22005", "PASS", "XCL12", "22005", "22005", "XCL12", "XCL12", "XCL12", "22005", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22005", "22005", "PASS", "XCL12", "22005", "22005", "XCL12", "XCL12", "XCL12", "22005", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22005", "22005", "PASS", "PASS", "PASS", "22005", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22005", "22005", "PASS", "PASS", "PASS", "22005", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22005", "22005", "PASS", "PASS", "PASS", "22005", "PASS", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "22005", "22005", "XCL12", "PASS", "PASS", "22005", "XCL12", "XCL12", "XCL12", "22005", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "22005", "22005", "XCL12", "PASS", "PASS", "22005", "XCL12", "XCL12", "XCL12", "22005", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "22005", "22005", "XCL12", "PASS", "PASS", "22005", "XCL12", "XCL12", "XCL12", "22005", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "PASS", "XCL12", "XCL12", "22005", "PASS", "XCL12", "XCL12", "XCL12", "22005", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "22007", "22005", "22005", "XCL12", "XCL12", "22005", "22005", "PASS", "XCL12", "PASS", "22005", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "22007", "22005", "22005", "XCL12", "XCL12", "22005", "22005", "XCL12", "PASS", "PASS", "22005", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "22007", "22005", "22005", "XCL12", "XCL12", "22005", "22005", "PASS", "XCL12", "PASS", "22005", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "22005", "22005", "XCL12", "PASS", "PASS", "22005", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "PASS", "0A000", "0A000"}};
    public static final String[][] updateXXXRulesTableForNetworkClient = new String[][]{{"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22018", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22018", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22018", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22018", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "PASS", "XCL12", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "PASS", "XCL12", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "PASS", "XCL12", "PASS", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "PASS", "XCL12", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "PASS", "XCL12", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "PASS", "0A000", "0A000"}};
    public static final String[][] updateObjectRulesTableForNetworkClient = new String[][]{{"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22018", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22018", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22018", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22018", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "PASS", "XCL12", "PASS", "PASS", "XCL12", "XCL12"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "PASS", "XCL12", "PASS", "PASS", "XCL12", "XCL12"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "PASS", "XCL12", "PASS", "PASS", "XCL12", "XCL12"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "XCL12"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "XCL12"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "XCL12"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "XCL12"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "PASS", "XCL12", "XCL12", "PASS", "XCL12", "XCL12"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12", "PASS", "XCL12", "XCL12"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "PASS", "XCL12", "XCL12", "PASS", "XCL12", "XCL12"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "PASS", "XCL12", "XCL12"}};

    public UpdatableResultSetTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("UpdatableResultSetTest");
        BaseTestSuite embeddedSuite = UpdatableResultSetTest.baseSuite("UpdatableResultSetTest:embedded");
        BaseTestSuite clientSuite = UpdatableResultSetTest.baseSuite("UpdatableResultSetTest:client");
        if (JDBC.vmSupportsJDBC3()) {
            embeddedSuite.addTest((Test)new UpdatableResultSetTest("xTestInsertRowAfterCommit"));
            clientSuite.addTest((Test)new UpdatableResultSetTest("xTestInsertRowAfterCommit"));
        }
        suite.addTest((Test)new CleanDatabaseTestSetup((Test)embeddedSuite));
        suite.addTest(TestConfiguration.clientServerDecorator((Test)new CleanDatabaseTestSetup((Test)clientSuite)));
        return suite;
    }

    private static BaseTestSuite baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        suite.addTestSuite(UpdatableResultSetTest.class);
        return suite;
    }

    protected void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
    }

    public void testScrollSensitiveResultSet() throws SQLException {
        this.getConnection().clearWarnings();
        Statement stmt = this.createStatement(1005, 1008);
        String sqlState = UpdatableResultSetTest.usingEmbedded() ? "01J02" : "01J10";
        UpdatableResultSetTest.assertEquals((String)"FAIL - Should get warning on Downgrade", (String)sqlState, (String)this.getConnection().getWarnings().getSQLState());
        UpdatableResultSetTest.assertEquals((String)"FAIL - Result set type should be scroll insensitive", (int)1004, (int)stmt.getResultSetType());
        UpdatableResultSetTest.assertEquals((String)"FAIL - Result set concurrency should be updatable", (int)1008, (int)stmt.getResultSetConcurrency());
    }

    public void testUpdateDeleteRowOnReadOnlyResultSet() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select * from t1");
        UpdatableResultSetTest.assertEquals((String)"FAIL - Result set concurrency should be read only", (int)1007, (int)rs.getConcurrency());
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        try {
            rs.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have failed because this is a read only resultset");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("XJ083", e);
        }
        try {
            rs.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - updateRow should have failed because this is a read only resultset");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("XJ083", e);
        }
        rs.close();
        Object[][] expected = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM t1"), expected, true);
        stmt.close();
    }

    public void testUpdateDeleteRowOnReadOnlyResultSetWithForUpdate() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select * from t1 FOR UPDATE");
        UpdatableResultSetTest.assertEquals((String)"FAIL - Result set concurrency should be read only", (int)1007, (int)rs.getConcurrency());
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        try {
            rs.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have failed because this is a read only resultset");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("XJ083", e);
        }
        try {
            rs.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - updateRow should have failed because this is a read only resultset");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("XJ083", e);
        }
        rs.close();
        Object[][] expected = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM t1"), expected, true);
        stmt.close();
    }

    public void testUpdateDeleteRowOnReadOnlyResultSetWithoutForUpdate() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1007);
        ResultSet rs = stmt.executeQuery("select * from t1");
        UpdatableResultSetTest.assertEquals((String)"FAIL - Result set concurrency should be read only", (int)1007, (int)rs.getConcurrency());
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        try {
            rs.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have failed because this is a read only resultset");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("XJ083", e);
        }
        try {
            rs.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - updateRow should have failed because this is a read only resultset");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("XJ083", e);
        }
        rs.close();
        Object[][] expected = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM t1"), expected, true);
        stmt.close();
    }

    public void testUpdateDeleteRowOnUpdatableResultSetWithForReadOnly() throws SQLException {
        this.createTableT1();
        this.getConnection().clearWarnings();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("select * from t1 FOR READ ONLY");
        UpdatableResultSetTest.assertEquals((String)"FAIL - Result set concurrency should be read only", (int)1007, (int)rs.getConcurrency());
        UpdatableResultSetTest.assertEquals((String)"FAIL - FAIL - Should get warning on Downgrade", (String)"01J06", (String)rs.getWarnings().getSQLState());
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        try {
            rs.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have failed because this is a read only resultset");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("XJ083", e);
        }
        try {
            rs.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - updateRow should have failed because this is a read only resultset");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("XJ083", e);
        }
        rs.close();
        Object[][] expected = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM t1"), expected, true);
        stmt.close();
    }

    public void testUpdateDeleteRowNotOnRow() throws SQLException {
        String sqlState;
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1");
        UpdatableResultSetTest.assertEquals((String)"FAIL - Result set concurrency should be updatable", (int)1008, (int)rs.getConcurrency());
        try {
            rs.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have failed, not on a row");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("24000", e);
        }
        try {
            rs.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - updateRow should have failed, not on a row");
        }
        catch (SQLException e) {
            sqlState = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        while (rs.next()) {
        }
        try {
            rs.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have failed, positioned after last row");
        }
        catch (SQLException e) {
            sqlState = UpdatableResultSetTest.usingEmbedded() ? "24000" : "42X30";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        try {
            rs.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - updateRow should have failed, positioned after last row");
        }
        catch (SQLException e) {
            sqlState = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        rs.close();
        Object[][] expected = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM t1"), expected, true);
        stmt.close();
    }

    public void testUpdateDeleteRowOnClosedResultSet() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertEquals((String)"FAIL - Result set concurrency should be updatable", (int)1008, (int)rs.getConcurrency());
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.close();
        try {
            rs.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have failed because this result set is closed");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("XCL16", e);
            UpdatableResultSetTest.assertTrue((e.getMessage().indexOf("deleteRow") > 0 ? 1 : 0) != 0);
        }
        try {
            rs.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - updateRow should have failed because this result set is closed");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("XCL16", e);
            UpdatableResultSetTest.assertTrue((e.getMessage().indexOf("updateRow") > 0 ? 1 : 0) != 0);
        }
        rs.close();
        Object[][] expected = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM t1"), expected, true);
        stmt.close();
    }

    public void testUpdatableResultSetOnSysTable() throws SQLException {
        try {
            ResultSet rs = this.createStatement().executeQuery("SELECT * FROM sys.systables FOR UPDATE");
            UpdatableResultSetTest.fail((String)"FAIL - trying to open an updatable resultset on a system table should have failed because system tables can't be updated by a user");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("42Y90", e);
        }
    }

    public void testUpdatableResultSetOnView() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create view v1 as select * from t1");
        try {
            ResultSet rs = stmt.executeQuery("SELECT * FROM v1 FOR UPDATE");
            UpdatableResultSetTest.fail((String)"FAIL - trying to open an updatable resultset on a view should have failed because Derby does not support updates to views yet");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("42Y90", e);
        }
        stmt.executeUpdate("drop view v1");
        stmt.close();
    }

    public void testUpdatableResultSetOnJoin() throws SQLException {
        this.createTableT1();
        this.createTableT2();
        Statement stmt = this.createStatement(1003, 1008);
        try {
            ResultSet rs = stmt.executeQuery("SELECT c1 FROM t1,t2 where t1.c1 = t2.c21 FOR UPDATE");
            UpdatableResultSetTest.fail((String)"FAIL - trying to open an updatable resultset should have failed because updatable resultset donot support join in the select query");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("42Y90", e);
        }
    }

    public void testDropTableWithUpatableResultSet() throws SQLException {
        String sqlState;
        this.getConnection().setAutoCommit(true);
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT c1 FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.updateInt(1, 123);
        Statement stmt1 = this.createStatement();
        try {
            stmt1.executeUpdate("drop table t1");
            UpdatableResultSetTest.fail((String)"FAIL - drop table should have failed because the updatable resultset is still open");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("X0X95", e);
        }
        stmt1.close();
        try {
            rs.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - resultset should have been closed at this point and updateRow should have failed");
        }
        catch (SQLException e) {
            sqlState = UpdatableResultSetTest.usingEmbedded() ? "XCL16" : "24000";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        try {
            rs.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - resultset should have been closed at this point and deleteRow should have failed");
        }
        catch (SQLException e) {
            sqlState = UpdatableResultSetTest.usingEmbedded() ? "XCL16" : "24000";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        Object[][] expected = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM t1"), expected, true);
        stmt.executeUpdate("DROP TABLE T1");
        stmt.close();
    }

    public void testForeignKeyConstraintFailureOnDeleteRow() throws SQLException {
        this.getConnection().setAutoCommit(true);
        this.createTableWithPrimaryKey();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM tableWithPrimaryKey FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        try {
            rs.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have failed because it will cause foreign key constraint failure");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("23503", e);
        }
        try {
            rs.next();
            if (UpdatableResultSetTest.usingEmbedded()) {
                UpdatableResultSetTest.fail((String)"FAIL - next should have failed because foreign key constraint failure resulted in a runtime rollback");
            }
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertFalse((String)"FAIL - Network client should not fail due to DERBY-160", (!UpdatableResultSetTest.usingEmbedded() ? 1 : 0) != 0);
            UpdatableResultSetTest.assertSQLState("XCL16", e);
        }
        Object[][] expected = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}};
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM tableWithPrimaryKey"), expected, true);
        stmt.executeUpdate("DROP TABLE tableWithConstraint");
        stmt.executeUpdate("DROP TABLE tableWithPrimaryKey");
        stmt.close();
    }

    public void testForeignKeyConstraintFailureOnUpdateRow() throws SQLException {
        this.getConnection().setAutoCommit(true);
        this.createTableWithPrimaryKey();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT c1, c2 FROM tableWithPrimaryKey FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.updateInt(1, 11);
        rs.updateInt(2, 22);
        try {
            rs.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - updateRow should have failed because it will cause foreign key constraint failure");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("23503", e);
        }
        try {
            rs.next();
            if (UpdatableResultSetTest.usingEmbedded()) {
                UpdatableResultSetTest.fail((String)"FAIL - next should have failed because foreign key constraint failure resulted in a runtime rollback");
            }
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertFalse((String)"FAIL - Network client should not fail due to DERBY-160", (!UpdatableResultSetTest.usingEmbedded() ? 1 : 0) != 0);
            UpdatableResultSetTest.assertSQLState("XCL16", e);
        }
        Object[][] expected = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}};
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM tableWithPrimaryKey"), expected, true);
        stmt.executeUpdate("DROP TABLE tableWithConstraint");
        stmt.executeUpdate("DROP TABLE tableWithPrimaryKey");
        stmt.close();
    }

    public void testUpdateXXXOnColumnNotFromTable() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT 1, 2 FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        try {
            rs.updateInt(1, 22);
            UpdatableResultSetTest.fail((String)"FAIL - updateInt should have failed because it is trying to update a column that does not correspond to column in base table");
        }
        catch (SQLException e) {
            String sqlState = UpdatableResultSetTest.usingEmbedded() ? "XJ084" : "XJ124";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        rs.close();
        stmt.close();
    }

    public void testUpdateXXXOnOutOfRangeColumn() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT c1, c2 FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        try {
            UpdatableResultSetTest.println("There are only 2 columns in the select list and we are trying to send updateXXX on column position 3");
            rs.updateInt(3, 22);
            UpdatableResultSetTest.fail((String)"FAIL - updateInt should have failed because there are only 2 columns in the select list");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("XCL14", e);
        }
        rs.close();
        stmt.close();
    }

    public void testResultSetNotPositionedAfterDeleteRow() throws SQLException {
        this.createTableT1();
        this.getConnection().clearWarnings();
        Statement stmt = this.createStatement(1003, 1008);
        JDBC.assertNoWarnings(this.getConnection().getWarnings());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong result set type", (int)1003, (int)stmt.getResultSetType());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong result set concurrency", (int)1008, (int)stmt.getResultSetConcurrency());
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        int c1Before = rs.getInt(1);
        String c2Before = rs.getString(2);
        rs.deleteRow();
        try {
            rs.getInt(1);
            UpdatableResultSetTest.fail((String)"FAIL - result set not positioned on a row, rs.getInt(1) should have failed");
        }
        catch (SQLException e) {
            String sqlState = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        try {
            rs.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have failed because ResultSet is not positioned on a row");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("24000", e);
        }
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.deleteRow();
        rs.close();
        Object[][] expected = new String[][]{{"3", "cc"}};
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM t1"), expected, true);
        stmt.close();
    }

    public void testResultSetNotPositionedAfterUpdateRow() throws SQLException {
        String sqlState;
        this.createTableT1();
        this.getConnection().clearWarnings();
        Statement stmt = this.createStatement(1003, 1008);
        JDBC.assertNoWarnings(this.getConnection().getWarnings());
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        int c1Before = rs.getInt(1);
        rs.updateInt(1, 234);
        UpdatableResultSetTest.assertEquals((String)"FAIL - column should have updated value", (int)234, (int)rs.getInt(1));
        UpdatableResultSetTest.assertEquals((String)"FAIL - value of column 2 should not have changed", (String)"aa", (String)rs.getString(2).trim());
        UpdatableResultSetTest.println("now updateRow on the row");
        rs.updateRow();
        try {
            rs.getInt(1);
            UpdatableResultSetTest.fail((String)"FAIL - result set not positioned on a row, rs.getInt(1) should have failed");
        }
        catch (SQLException e) {
            sqlState = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        try {
            rs.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - updateRow should have failed because ResultSet is not positioned on a row");
        }
        catch (SQLException e) {
            sqlState = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.updateString(2, "234");
        rs.updateRow();
        rs.close();
        Object[][] expected = new String[][]{{"234", "aa"}, {"2", "234"}, {"3", "cc"}};
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM t1"), expected, true);
        stmt.close();
    }

    public void testPositionedDeleteOnUpdatableResultSet() throws SQLException {
        this.createTableT1();
        this.getConnection().clearWarnings();
        Statement stmt = this.createStatement(1003, 1008);
        JDBC.assertNoWarnings(this.getConnection().getWarnings());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong result set type", (int)1003, (int)stmt.getResultSetType());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong result set concurrency", (int)1008, (int)stmt.getResultSetConcurrency());
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        int c1Before = rs.getInt(1);
        String c2Before = rs.getString(2);
        PreparedStatement pStmt = this.prepareStatement("DELETE FROM T1 WHERE CURRENT OF " + rs.getCursorName());
        pStmt.executeUpdate();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value on deleted row", (int)c1Before, (int)rs.getInt(1));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value on deleted row", (String)c2Before, (String)rs.getString(2));
        try {
            pStmt.executeUpdate();
            UpdatableResultSetTest.fail((String)"FAIL - positioned delete should have failed because ResultSet is not positioned on a row");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("24000", e);
        }
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        pStmt.executeUpdate();
        rs.close();
        pStmt.close();
        Object[][] expected = new String[][]{{"3", "cc"}};
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM t1"), expected, true);
        stmt.close();
    }

    public void testPositionedUpdateOnUpdatableResultSet() throws SQLException {
        this.createTableT1();
        this.getConnection().clearWarnings();
        Statement stmt = this.createStatement(1003, 1008);
        JDBC.assertNoWarnings(this.getConnection().getWarnings());
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        int c1Before = rs.getInt(1);
        String c2Before = rs.getString(2);
        PreparedStatement pStmt = this.prepareStatement("UPDATE T1 SET C1=?, C2=? WHERE CURRENT OF " + rs.getCursorName());
        int c1 = 2345;
        String c2 = "UUU";
        pStmt.setInt(1, 2345);
        pStmt.setString(2, "UUU");
        pStmt.executeUpdate();
        UpdatableResultSetTest.assertEquals((String)"FAIL - column 1 should have the original value", (int)c1Before, (int)rs.getInt(1));
        UpdatableResultSetTest.assertEquals((String)"FAIL - column 2 should have the original value", (String)c2Before, (String)rs.getString(2));
        try {
            rs.refreshRow();
            UpdatableResultSetTest.fail((String)"FAIL - refreshRow not implemented for this type of result set");
        }
        catch (SQLException e) {
            String sqlState = UpdatableResultSetTest.usingEmbedded() ? "0A000" : "XJ125";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        pStmt.setInt(1, 2345);
        pStmt.setString(2, "UUU");
        pStmt.executeUpdate();
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        pStmt.setInt(1, rs.getInt(1));
        pStmt.setString(2, "abc");
        pStmt.executeUpdate();
        rs.close();
        Object[][] expected = new String[][]{{"2345", "UUU"}, {"2", "abc"}, {"3", "cc"}};
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM t1"), expected, true);
        stmt.close();
        pStmt.close();
    }

    public void testUpdatableResultsetNoColumnInColumnList() throws SQLException {
        this.getConnection().setAutoCommit(true);
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("select count(*) from t1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - statement should return a row", (boolean)rs.next());
        int origCount = rs.getInt(1);
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)3, (int)origCount);
        rs = stmt.executeQuery("SELECT 1, 2 FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 1", (int)1, (int)rs.getInt(1));
        try {
            rs.deleteRow();
            UpdatableResultSetTest.assertTrue((String)"FAIL - should have failed in network server", (boolean)UpdatableResultSetTest.usingEmbedded());
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertTrue((String)"FAIL - should not fail on embedded", (!UpdatableResultSetTest.usingEmbedded() ? 1 : 0) != 0);
            UpdatableResultSetTest.assertSQLState("42X01", e);
        }
        rs.close();
        rs = stmt.executeQuery("select count(*) from t1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - statement should return a row", (boolean)rs.next());
        int count = rs.getInt(1);
        if (UpdatableResultSetTest.usingEmbedded()) {
            UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)(origCount - 1), (int)count);
        } else {
            UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)origCount, (int)count);
        }
        rs.close();
        stmt.execute("DROP TABLE T1");
        stmt.close();
    }

    public void testDeleteRowWithPreparedStatement() throws SQLException {
        String sqlState;
        this.createTableT1();
        PreparedStatement pStmt = this.prepareStatement("select * from t1 where c1 > ?", 1003, 1008);
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong result set type", (int)1003, (int)pStmt.getResultSetType());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong result set concurrency", (int)1008, (int)pStmt.getResultSetConcurrency());
        pStmt.setInt(1, 0);
        ResultSet rs = pStmt.executeQuery();
        UpdatableResultSetTest.assertTrue((String)"FAIL - statement should return a row", (boolean)rs.next());
        int c1Before = rs.getInt(1);
        rs.deleteRow();
        try {
            rs.getInt(1);
            UpdatableResultSetTest.fail((String)"FAIL - not on a row, can not get column");
        }
        catch (SQLException e) {
            sqlState = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        try {
            rs.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have failed because it can't be called more than once on the same row");
        }
        catch (SQLException e) {
            sqlState = "24000";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        UpdatableResultSetTest.assertTrue((String)"FAIL - statement should return a row", (boolean)rs.next());
        UpdatableResultSetTest.assertFalse((String)"FAIL - first column should not be 0", (rs.getInt(1) == 0 ? 1 : 0) != 0);
        rs.deleteRow();
        rs.close();
        pStmt.close();
        Object[][] expected = new String[][]{{"3", "cc"}};
        JDBC.assertFullResultSet(this.createStatement().executeQuery("SELECT * FROM t1"), expected, true);
    }

    public void testUpdateXXXWithPreparedStatement() throws SQLException {
        String sqlState;
        this.createTableT1();
        PreparedStatement pStmt = this.prepareStatement("select * from t1 where c1>? for update", 1003, 1008);
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong result set type", (int)1003, (int)pStmt.getResultSetType());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong result set concurrency", (int)1008, (int)pStmt.getResultSetConcurrency());
        pStmt.setInt(1, 0);
        ResultSet rs = pStmt.executeQuery();
        UpdatableResultSetTest.assertTrue((String)"FAIL - statement should return a row", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 1", (int)1, (int)rs.getInt(1));
        rs.updateInt(1, 5);
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 5", (int)5, (int)rs.getInt(1));
        rs.updateRow();
        try {
            rs.getInt(1);
            UpdatableResultSetTest.fail((String)"FAIL - not on a row, can not get column");
        }
        catch (SQLException e) {
            sqlState = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        try {
            rs.updateInt(1, 0);
            UpdatableResultSetTest.fail((String)"FAIL - updateXXX should have failed because resultset is not positioned on a row");
        }
        catch (SQLException e) {
            sqlState = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        try {
            rs.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - updateRow should have failed because resultset is not positioned on a row");
        }
        catch (SQLException e) {
            sqlState = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        try {
            rs.cancelRowUpdates();
            UpdatableResultSetTest.fail((String)"FAIL - cancelRowUpdates should have failed because the resultset is not positioned on a row");
        }
        catch (SQLException e) {
            sqlState = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        UpdatableResultSetTest.assertTrue((String)"FAIL - statement should return a row", (boolean)rs.next());
        rs.cancelRowUpdates();
        rs.close();
        pStmt.close();
        Object[][] expected = new String[][]{{"5", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(this.createStatement().executeQuery("SELECT * FROM t1"), expected, true);
    }

    public void testCallableStatementWithUpdatableResultSet() throws SQLException {
        String sqlState;
        this.createTableT1();
        CallableStatement callStmt = this.prepareCall("select * from t1", 1003, 1008);
        ResultSet rs = callStmt.executeQuery();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong result set type", (int)1003, (int)callStmt.getResultSetType());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong result set concurrency", (int)1008, (int)callStmt.getResultSetConcurrency());
        UpdatableResultSetTest.assertTrue((String)"FAIL - statement should return a row", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 1", (int)1, (int)rs.getInt(1));
        rs.deleteRow();
        try {
            rs.getInt(1);
            UpdatableResultSetTest.fail((String)"FAIL - not on row, can not get value");
        }
        catch (SQLException e) {
            sqlState = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        try {
            rs.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have failed because it can't be called more than once on the same row");
        }
        catch (SQLException e) {
            sqlState = "24000";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        UpdatableResultSetTest.assertTrue((String)"FAIL - statement should return a row", (boolean)rs.next());
        rs.deleteRow();
        rs.close();
        callStmt.close();
        Object[][] expected = new String[][]{{"3", "cc"}};
        JDBC.assertFullResultSet(this.createStatement().executeQuery("SELECT * FROM t1"), expected, true);
    }

    public void testUpdatableResultSetWithoutSelectingPrimaryKey() throws SQLException {
        this.createTableT3();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT c32 FROM t3");
        UpdatableResultSetTest.assertTrue((String)"FAIL - statement should return a row", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 1", (int)1, (int)rs.getInt(1));
        rs.deleteRow();
        UpdatableResultSetTest.assertTrue((String)"FAIL - statement should return a row", (boolean)rs.next());
        rs.updateLong(1, 123L);
        rs.updateRow();
        rs.close();
        Object[][] expected = new String[][]{{"2", "123"}, {"3", "3"}, {"4", "4"}};
        JDBC.assertFullResultSet(stmt.executeQuery("select * from t3"), expected, true);
        stmt.close();
    }

    public void testRowDeleted() throws SQLException {
        DatabaseMetaData dbmt = this.getConnection().getMetaData();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong values for ownDeletesAreVisible(ResultSet.TYPE_FORWARD_ONLY)", (boolean)false, (boolean)dbmt.ownDeletesAreVisible(1003));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong values for othersDeletesAreVisible(ResultSet.TYPE_FORWARD_ONLY)", (boolean)true, (boolean)dbmt.othersDeletesAreVisible(1003));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for deletesAreDetected(ResultSet.TYPE_FORWARD_ONLY)", (boolean)false, (boolean)dbmt.deletesAreDetected(1003));
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1 FOR UPDATE of c1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - statement should return a row", (boolean)rs.next());
        UpdatableResultSetTest.assertFalse((String)"FAIL - rs.rowDeleted() should always return false for this type of result set", (boolean)rs.rowDeleted());
        rs.deleteRow();
        rs.close();
        stmt.close();
    }

    public void testRowUpdated() throws SQLException {
        DatabaseMetaData dbmt = this.getConnection().getMetaData();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong values for ownUpdatesAreVisible(ResultSet.TYPE_FORWARD_ONLY)", (boolean)false, (boolean)dbmt.ownUpdatesAreVisible(1003));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong values for othersUpdatesAreVisible(ResultSet.TYPE_FORWARD_ONLY)", (boolean)true, (boolean)dbmt.othersUpdatesAreVisible(1003));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong values for updatesAreDetected(ResultSet.TYPE_FORWARD_ONLY)", (boolean)false, (boolean)dbmt.updatesAreDetected(1003));
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1 FOR UPDATE of c1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - statement should return a row", (boolean)rs.next());
        UpdatableResultSetTest.assertFalse((String)"FAIL - rs.rowUpdated() should always return false for this type of result set", (boolean)rs.rowUpdated());
        rs.updateLong(1, 123L);
        rs.updateRow();
        rs.close();
        stmt.close();
    }

    public void testDeleteRowOnTempTable() throws SQLException {
        Statement stmt = this.createStatement(1003, 1008);
        stmt.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit preserve rows not logged");
        stmt.executeUpdate("insert into SESSION.t2 values(21, 1)");
        stmt.executeUpdate("insert into SESSION.t2 values(22, 1)");
        UpdatableResultSetTest.println("following rows in temp table before deleteRow");
        ResultSet rs = stmt.executeQuery("select * from SESSION.t2");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c21", (int)21, (int)rs.getInt(1));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c21", (int)1, (int)rs.getInt(2));
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c21", (int)22, (int)rs.getInt(1));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c21", (int)1, (int)rs.getInt(2));
        rs.close();
        rs = stmt.executeQuery("select c21 from session.t2 for update");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.deleteRow();
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertFalse((String)"FAIL - Column c21 should not be 0", (rs.getInt(1) == 0 ? 1 : 0) != 0);
        rs.deleteRow();
        UpdatableResultSetTest.println("As expected, no rows in temp table after deleteRow");
        rs.close();
        rs = stmt.executeQuery("select * from SESSION.t2");
        UpdatableResultSetTest.assertFalse((String)"FAIL - all rows were deleted, rs.next() should return false", (boolean)rs.next());
        rs.close();
        stmt.executeUpdate("DROP TABLE SESSION.t2");
        stmt.close();
    }

    public void testUpdateRowOnTempTable() throws SQLException {
        Statement stmt = this.createStatement(1003, 1008);
        stmt.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t3(c31 int, c32 int) on commit preserve rows not logged");
        stmt.executeUpdate("insert into SESSION.t3 values(21, 1)");
        stmt.executeUpdate("insert into SESSION.t3 values(22, 1)");
        UpdatableResultSetTest.println("following rows in temp table before deleteRow");
        ResultSet rs = stmt.executeQuery("select * from SESSION.t3");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c21", (int)21, (int)rs.getInt(1));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c21", (int)1, (int)rs.getInt(2));
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c21", (int)22, (int)rs.getInt(1));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c21", (int)1, (int)rs.getInt(2));
        rs.close();
        rs = stmt.executeQuery("select c31 from session.t3");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.updateLong(1, 123L);
        rs.updateRow();
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.updateLong(1, 123L);
        rs.updateRow();
        rs.close();
        int countRows = 0;
        rs = stmt.executeQuery("select * from SESSION.t3");
        while (rs.next()) {
            ++countRows;
            UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c21", (int)123, (int)rs.getInt(1));
            UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c21", (int)1, (int)rs.getInt(2));
        }
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)2, (int)countRows);
        rs.close();
        stmt.executeUpdate("DROP TABLE SESSION.t3");
        stmt.close();
    }

    public void testDeleteRowWithSetCursorName() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        stmt.setCursorName("CURSORNOUPDATe");
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1 FOR UPDATE of c1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.deleteRow();
        try {
            stmt.setCursorName("CURSORNOUPDATE1");
            UpdatableResultSetTest.assertTrue((String)"FAIL - expected exception in network client", (boolean)UpdatableResultSetTest.usingEmbedded());
        }
        catch (SQLException e) {
            if (!UpdatableResultSetTest.usingEmbedded()) {
                UpdatableResultSetTest.assertSQLState("X0X95", e);
            }
            throw e;
        }
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.deleteRow();
        rs.close();
        Object[][] expected = new String[][]{{"3", "cc"}};
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM t1"), expected, true);
        stmt.close();
    }

    public void testUpdateRowWithSetCursorName() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        stmt.setCursorName("CURSORNOUPDATe");
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1 FOR UPDATE of c1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.updateLong(1, 123L);
        try {
            stmt.setCursorName("CURSORNOUPDATE1");
            UpdatableResultSetTest.assertTrue((String)"FAIL - expected exception in network client", (boolean)UpdatableResultSetTest.usingEmbedded());
        }
        catch (SQLException e) {
            if (!UpdatableResultSetTest.usingEmbedded()) {
                UpdatableResultSetTest.assertSQLState("X0X95", e);
            }
            throw e;
        }
        rs.updateRow();
        rs.close();
        Object[][] expected = new String[][]{{"123", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM t1"), expected, true);
        stmt.close();
    }

    public void testDeleteRowWithCorrelationForTableName() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1 abcde FOR UPDATE of c1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 1", (int)1, (int)rs.getInt(1));
        rs.deleteRow();
        rs.close();
        Object[][] expected = new String[][]{{"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM t1"), expected, true);
        stmt.close();
    }

    public void testDeleteRowWithCorrelationForColumnName() throws SQLException {
        ResultSet rs;
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        try {
            rs = stmt.executeQuery("SELECT c1 as col1, c2 as col2 FROM t1 abcde FOR UPDATE of c1");
            UpdatableResultSetTest.fail((String)"FAIL - executeQuery should have failed");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("42X42", e);
        }
        rs = stmt.executeQuery("SELECT c1, c2 as col2 FROM t1 abcde FOR UPDATE of c1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.updateInt(1, 11);
        rs.updateRow();
        rs.close();
        Object[][] expected = new String[][]{{"11", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM t1"), expected, true);
        stmt.close();
    }

    public void testUpdateXXXOnReadOnlyColumn() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT c1, c2 FROM t1 abcde FOR UPDATE of c1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        try {
            rs.updateString(2, "bbbb");
            UpdatableResultSetTest.fail((String)"FAIL - updateString on readonly column should have failed");
        }
        catch (SQLException e) {
            String sqlState = UpdatableResultSetTest.usingEmbedded() ? "42X31" : "XJ124";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        rs.close();
        Object[][] expected = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM t1"), expected, true);
        stmt.close();
    }

    public void testUpdateRowWithCorrelationOnTableAndColumn() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT c1, c2 as col2 FROM t1 abcde FOR UPDATE of c1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.updateInt(1, 11);
        rs.updateRow();
        rs.close();
        Object[][] expected = new String[][]{{"11", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM t1"), expected, true);
        stmt.close();
    }

    public void testUpdateXXXOnReadOnlyColumnWithCorrelationName() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT c1, c2 as col2 FROM t1 abcde FOR UPDATE of c1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        try {
            rs.updateString(2, "bbbb");
            UpdatableResultSetTest.fail((String)"FAIL - updateString on readonly column should have failed");
        }
        catch (SQLException e) {
            String sqlState = UpdatableResultSetTest.usingEmbedded() ? "42X31" : "XJ124";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        rs.close();
        Object[][] expected = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM t1"), expected, true);
        stmt.close();
    }

    public void testUpdateRowWithTableAndColumnAlias_d1773() throws SQLException {
        ResultSet rs;
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        try {
            rs = stmt.executeQuery("SELECT * from t1 as abcde(a1,a2) for update of c1");
            UpdatableResultSetTest.fail((String)"FAIL - executeQuery should have failed");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("42Y90", e);
        }
        try {
            rs = stmt.executeQuery("SELECT * from t1 as abcde(a1,a2) for update");
            UpdatableResultSetTest.fail((String)"FAIL - executeQuery should have failed");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("42Y90", e);
        }
        rs = stmt.executeQuery("select * from t1 as a(a1,a2)");
        rs.next();
        try {
            rs.updateString(2, "bbbb");
            UpdatableResultSetTest.fail((String)"FAIL - updateString should have failed");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("XJ083", e);
        }
        rs.close();
        rs = stmt.executeQuery("SELECT c1 as a1, c2 as a2 from t1 as abcde");
        rs.next();
        try {
            rs.updateString(2, "bbbb");
            UpdatableResultSetTest.fail((String)"FAIL - updateString should have failed");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState(UpdatableResultSetTest.usingDerbyNetClient() ? "XJ124" : "42X31", e);
        }
        rs.close();
        rs = stmt.executeQuery("SELECT c1 as a1, c2 from t1 as abcde for update of c2");
        rs.next();
        rs.updateString(2, "bbbb");
        try {
            rs.updateString(1, "aaaa");
            UpdatableResultSetTest.fail((String)"FAIL - updateString should have failed");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState(UpdatableResultSetTest.usingDerbyNetClient() ? "XJ124" : "42X31", e);
        }
        rs.close();
        rs = stmt.executeQuery("SELECT c1 as a1, c2 from t1 as abcde for update");
        rs.next();
        rs.updateString(2, "bbbb");
        try {
            rs.updateString(1, "aaaa");
            UpdatableResultSetTest.fail((String)"FAIL - updateString should have failed");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState(UpdatableResultSetTest.usingDerbyNetClient() ? "XJ124" : "42X31", e);
        }
        rs.close();
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM t1"), (Object[][])new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}}, true);
        stmt.close();
    }

    public void testTwoResultSetsDeletingSameRow() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        Statement stmt1 = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        ResultSet rs1 = stmt1.executeQuery("SELECT * FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs1.next());
        UpdatableResultSetTest.println("delete using first resultset");
        rs.deleteRow();
        try {
            rs1.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - delete using second resultset succedded? ");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("24000", e);
        }
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs1.next());
        rs1.deleteRow();
        rs.close();
        rs1.close();
        Object[][] expected = new String[][]{{"3", "cc"}};
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM t1"), expected, true);
        stmt.close();
        stmt1.close();
    }

    public void testSetFetchSizeOnUpdatableResultSet() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        stmt.executeUpdate("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        stmt.setFetchSize(200);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1 FOR UPDATE of c1");
        Statement stmt2 = this.createStatement();
        ResultSet rs2 = stmt2.executeQuery("values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        while (rs2.next()) {
            if (!rs2.getString(1).startsWith("Fetch Size")) continue;
            UpdatableResultSetTest.assertEquals((String)"FAIL - wrong fetch size", (String)"Fetch Size = 1", (String)rs2.getString(1));
        }
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong fetch size for updatable cursor", (int)200, (int)stmt.getFetchSize());
        rs.close();
        stmt.executeUpdate("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)");
        stmt.close();
    }

    public void testDeleteRowWithDeleteTrigger() throws SQLException {
        this.createTable0WithTrigger();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("select count(*) from deleteTriggerInsertIntoThisTable");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - table shoud contain no rows", (int)0, (int)rs.getInt(1));
        rs.close();
        rs = stmt.executeQuery("SELECT * FROM table0WithTriggers FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c1", (int)1, (int)rs.getInt(1));
        rs.deleteRow();
        rs.close();
        rs = stmt.executeQuery("select count(*) from deleteTriggerInsertIntoThisTable");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - table shoud contain one row", (int)1, (int)rs.getInt(1));
        rs.close();
        stmt.close();
    }

    public void testUpdateRowWithUpdateTrigger() throws SQLException {
        this.createTable0WithTrigger();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("select count(*) from updateTriggerInsertIntoThisTable");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - table shoud contain no rows", (int)0, (int)rs.getInt(1));
        rs.close();
        rs = stmt.executeQuery("SELECT * FROM table0WithTriggers");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c1", (int)1, (int)rs.getInt(1));
        rs.updateLong(1, 123L);
        rs.updateRow();
        rs.close();
        rs = stmt.executeQuery("select count(*) from updateTriggerInsertIntoThisTable");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - table shoud contain one row", (int)1, (int)rs.getInt(1));
        rs.close();
        stmt.close();
    }

    public void testDeleteRowWithTriggerChangingRS() throws SQLException {
        this.createTable1WithTrigger();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM table1WithTriggers FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c1", (int)1, (int)rs.getInt(1));
        rs.deleteRow();
        UpdatableResultSetTest.assertFalse((String)"FAIL - row not found", (boolean)rs.next());
        try {
            rs.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - there should have be no more rows in the resultset at this point because delete trigger deleted all the rows");
        }
        catch (SQLException e) {
            String sqlState = UpdatableResultSetTest.usingEmbedded() ? "24000" : "42X30";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        rs.close();
        rs = stmt.executeQuery("select count(*) from table1WithTriggers");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)0, (int)rs.getInt(1));
        rs.close();
        stmt.close();
    }

    public void testUpdateRowWithTriggerChangingRS() throws SQLException {
        this.createTable1WithTrigger();
        Statement stmt = this.createStatement(1003, 1008);
        Object[][] original = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}};
        JDBC.assertFullResultSet(stmt.executeQuery("select * from table2WithTriggers"), original, true);
        ResultSet rs = stmt.executeQuery("SELECT * FROM table2WithTriggers where c1>1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c1", (int)2, (int)rs.getInt(1));
        rs.updateLong(2, 2L);
        rs.updateRow();
        try {
            UpdatableResultSetTest.assertFalse((String)"FAIL - row not found", (boolean)rs.next());
            rs.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - there should have be no more rows in the resultset at this point because update trigger made all the rows not qualify for the resultset");
        }
        catch (SQLException e) {
            String sqlState = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        rs.close();
        rs = stmt.executeQuery("SELECT * FROM table2WithTriggers");
        Object[][] expected = new String[][]{{"1", "1"}, {"1", "2"}, {"1", "3"}, {"1", "4"}};
        JDBC.assertFullResultSet(rs, expected, true);
        stmt.close();
    }

    public void testDeleteRowSelfReferential() throws SQLException {
        this.createSelfReferencingTable();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("select * from selfReferencingT1");
        Object[][] expected = new String[][]{{"e1", null}, {"e2", "e1"}, {"e3", "e2"}, {"e4", "e3"}};
        JDBC.assertFullResultSet(rs, expected, true);
        rs.close();
        rs = stmt.executeQuery("SELECT * FROM selfReferencingT1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column1", (String)"e1", (String)rs.getString(1));
        rs.deleteRow();
        UpdatableResultSetTest.assertFalse((String)"FAIL - row not found", (boolean)rs.next());
        try {
            rs.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - there should have be no more rows in the resultset at this point because of the delete cascade");
        }
        catch (SQLException e) {
            String sqlState = UpdatableResultSetTest.usingEmbedded() ? "24000" : "42X30";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        rs.close();
        rs = stmt.executeQuery("select count(*) from selfReferencingT1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)0, (int)rs.getInt(1));
        rs.close();
        stmt.close();
    }

    public void testUpdateRowSelfReferential() throws SQLException {
        this.createSelfReferencingTable();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("select * from selfReferencingT2");
        Object[][] expected = new String[][]{{"e1", null}, {"e2", "e1"}, {"e3", "e2"}, {"e4", "e3"}};
        JDBC.assertFullResultSet(rs, expected, true);
        rs.close();
        rs = stmt.executeQuery("SELECT * FROM selfReferencingT2 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column1", (String)"e1", (String)rs.getString(1));
        rs.updateString(1, "e2");
        try {
            rs.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - this update should have caused violation of foreign key constraint");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("23503", e);
        }
        rs.close();
        stmt.close();
    }

    public void testDropTableWithUpdatableCursorOnIt() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        Statement stmt1 = this.createStatement();
        try {
            stmt1.executeUpdate("drop table t1");
            UpdatableResultSetTest.fail((String)"FAIL - drop table should have failed because the updatable resultset is still open");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("X0X95", e);
        }
        stmt1.close();
        rs.deleteRow();
        rs.close();
        rs = stmt.executeQuery("SELECT * FROM t1");
        Object[][] expected = new String[][]{{"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(rs, expected, true);
        rs.close();
        stmt.close();
    }

    public void testDeleteRowAndRollbackWithTriggers() throws SQLException {
        this.createTable0WithTrigger();
        this.commit();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("select count(*) from deleteTriggerInsertIntoThisTable");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)0, (int)rs.getInt(1));
        rs.close();
        rs = stmt.executeQuery("select count(*) from table0WithTriggers");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)4, (int)rs.getInt(1));
        rs.close();
        rs = stmt.executeQuery("SELECT * FROM table0WithTriggers FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 1", (int)1, (int)rs.getInt(1));
        UpdatableResultSetTest.println("now try to delete row and make sure that trigger got fired");
        rs.deleteRow();
        rs.close();
        rs = stmt.executeQuery("select count(*) from deleteTriggerInsertIntoThisTable");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)1, (int)rs.getInt(1));
        rs.close();
        rs = stmt.executeQuery("select count(*) from table0WithTriggers");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)3, (int)rs.getInt(1));
        rs.close();
        this.rollback();
        rs = stmt.executeQuery("select count(*) from deleteTriggerInsertIntoThisTable");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)0, (int)rs.getInt(1));
        rs.close();
        rs = stmt.executeQuery("select count(*) from table0WithTriggers");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)4, (int)rs.getInt(1));
        rs.close();
        stmt.executeUpdate("drop table table0WithTriggers");
        stmt.executeUpdate("drop table deleteTriggerInsertIntoThisTable");
        stmt.executeUpdate("drop table updateTriggerInsertIntoThisTable");
        stmt.close();
        this.commit();
    }

    public void testUpdateRowAndRollbackWithTriggers() throws SQLException {
        this.createTable0WithTrigger();
        this.commit();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("select count(*) from updateTriggerInsertIntoThisTable");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)0, (int)rs.getInt(1));
        rs.close();
        rs = stmt.executeQuery("SELECT * FROM table0WithTriggers");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 1", (int)1, (int)rs.getInt(1));
        UpdatableResultSetTest.println("now try to update row and make sure that trigger got fired");
        rs.updateLong(1, 123L);
        rs.updateRow();
        rs.close();
        rs = stmt.executeQuery("select count(*) from updateTriggerInsertIntoThisTable");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)1, (int)rs.getInt(1));
        rs.close();
        Object[][] expected = new String[][]{{"123", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}};
        rs = stmt.executeQuery("select * from table0WithTriggers");
        JDBC.assertFullResultSet(rs, expected, true);
        rs.close();
        this.rollback();
        rs = stmt.executeQuery("select count(*) from updateTriggerInsertIntoThisTable");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)0, (int)rs.getInt(1));
        rs.close();
        Object[][] original = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}};
        rs = stmt.executeQuery("select * from table0WithTriggers");
        JDBC.assertFullResultSet(rs, original, true);
        rs.close();
        stmt.executeUpdate("drop table table0WithTriggers");
        stmt.executeUpdate("drop table deleteTriggerInsertIntoThisTable");
        stmt.executeUpdate("drop table updateTriggerInsertIntoThisTable");
        stmt.close();
        this.commit();
    }

    public void testResultSetPositionedBeforeNextAfterDeleteRow() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.deleteRow();
        try {
            rs.getString(1);
            UpdatableResultSetTest.fail((String)"FAIL - getString should have failed, result set not positioned");
        }
        catch (SQLException e) {
            String sqlState = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        rs.close();
        stmt.close();
    }

    public void testCancelRowUpdatesOnReadOnlyRS() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1");
        try {
            rs.cancelRowUpdates();
            UpdatableResultSetTest.fail((String)"FAIL - should not have reached here because cancelRowUpdates is being called on a read-only resultset");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("XJ083", e);
        }
        rs.close();
        stmt.close();
    }

    public void testUpdateRowOnReadOnlyRS() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        try {
            rs.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - should not have reached here because updateRow is being called on a read-only resultset");
        }
        catch (SQLException e) {
            UpdatableResultSetTest.assertSQLState("XJ083", e);
        }
        rs.close();
        stmt.close();
    }

    public void testUpdateXXXOnReadOnlyRS() throws SQLException {
        this.createAllDatatypesTable();
        Statement stmt = this.createStatement();
        Statement stmt1 = this.createStatement();
        for (int updateXXXName = 1; updateXXXName <= allUpdateXXXNames.length; ++updateXXXName) {
            UpdatableResultSetTest.println("\nTest " + allUpdateXXXNames[updateXXXName - 1] + " on a readonly resultset");
            for (int indexOrName = 1; indexOrName <= 2; ++indexOrName) {
                ResultSet rs = stmt.executeQuery("SELECT * FROM AllDataTypesForTestingTable");
                rs.next();
                ResultSet rs1 = stmt1.executeQuery("SELECT * FROM AllDataTypesNewValuesData");
                rs1.next();
                if (indexOrName == 1) {
                    UpdatableResultSetTest.println("Using column position as first parameter to " + allUpdateXXXNames[updateXXXName - 1]);
                } else {
                    UpdatableResultSetTest.println("Using column name as first parameter to " + allUpdateXXXNames[updateXXXName - 1]);
                }
                try {
                    if (updateXXXName == 1) {
                        if (indexOrName == 1) {
                            rs.updateShort(1, rs1.getShort(updateXXXName));
                        } else {
                            rs.updateShort(ColumnNames[0], rs1.getShort(updateXXXName));
                        }
                    } else if (updateXXXName == 2) {
                        if (indexOrName == 1) {
                            rs.updateInt(1, rs1.getInt(updateXXXName));
                        } else {
                            rs.updateInt(ColumnNames[0], rs1.getInt(updateXXXName));
                        }
                    } else if (updateXXXName == 3) {
                        if (indexOrName == 1) {
                            rs.updateLong(1, rs1.getLong(updateXXXName));
                        } else {
                            rs.updateLong(ColumnNames[0], rs1.getLong(updateXXXName));
                        }
                    } else if (updateXXXName == 4) {
                        if (indexOrName == 1) {
                            BigDecimalHandler.updateBigDecimalString(rs, 1, BigDecimalHandler.getBigDecimalString(rs1, updateXXXName));
                        } else {
                            BigDecimalHandler.updateBigDecimalString(rs, ColumnNames[0], BigDecimalHandler.getBigDecimalString(rs1, updateXXXName));
                        }
                    } else if (updateXXXName == 5) {
                        if (indexOrName == 1) {
                            rs.updateFloat(1, rs1.getFloat(updateXXXName));
                        } else {
                            rs.updateFloat(ColumnNames[0], rs1.getFloat(updateXXXName));
                        }
                    } else if (updateXXXName == 6) {
                        if (indexOrName == 1) {
                            rs.updateDouble(1, rs1.getDouble(updateXXXName));
                        } else {
                            rs.updateDouble(ColumnNames[0], rs1.getDouble(updateXXXName));
                        }
                    } else if (updateXXXName == 7) {
                        if (indexOrName == 1) {
                            rs.updateString(1, rs1.getString(updateXXXName));
                        } else {
                            rs.updateString(ColumnNames[0], rs1.getString(updateXXXName));
                        }
                    } else if (updateXXXName == 8) {
                        if (indexOrName == 1) {
                            rs.updateAsciiStream(1, rs1.getAsciiStream(updateXXXName), 4);
                        } else {
                            rs.updateAsciiStream(ColumnNames[0], rs1.getAsciiStream(updateXXXName), 4);
                        }
                    } else if (updateXXXName == 9) {
                        if (indexOrName == 1) {
                            rs.updateCharacterStream(1, rs1.getCharacterStream(updateXXXName), 4);
                        } else {
                            rs.updateCharacterStream(ColumnNames[0], rs1.getCharacterStream(updateXXXName), 4);
                        }
                    } else if (updateXXXName == 10) {
                        if (indexOrName == 1) {
                            rs.updateByte(1, rs1.getByte(1));
                        } else {
                            rs.updateByte(ColumnNames[0], rs1.getByte(1));
                        }
                    } else if (updateXXXName == 11) {
                        if (indexOrName == 1) {
                            rs.updateBytes(1, rs1.getBytes(updateXXXName));
                        } else {
                            rs.updateBytes(ColumnNames[0], rs1.getBytes(updateXXXName));
                        }
                    } else if (updateXXXName == 12) {
                        if (indexOrName == 1) {
                            rs.updateBinaryStream(1, rs1.getBinaryStream(updateXXXName), 2);
                        } else {
                            rs.updateBinaryStream(ColumnNames[0], rs1.getBinaryStream(updateXXXName), 2);
                        }
                    } else if (updateXXXName == 13) {
                        if (!JDBC.vmSupportsJDBC3()) continue;
                        if (indexOrName == 1) {
                            rs.updateClob(1, rs1.getClob(updateXXXName));
                        } else {
                            rs.updateClob(ColumnNames[0], rs1.getClob(updateXXXName));
                        }
                    } else if (updateXXXName == 14) {
                        if (indexOrName == 1) {
                            rs.updateDate(1, rs1.getDate(updateXXXName));
                        } else {
                            rs.updateDate(ColumnNames[0], rs1.getDate(updateXXXName));
                        }
                    } else if (updateXXXName == 15) {
                        if (indexOrName == 1) {
                            rs.updateTime(1, rs1.getTime(updateXXXName));
                        } else {
                            rs.updateTime(ColumnNames[0], rs1.getTime(updateXXXName));
                        }
                    } else if (updateXXXName == 16) {
                        if (indexOrName == 1) {
                            rs.updateTimestamp(1, rs1.getTimestamp(updateXXXName));
                        } else {
                            rs.updateTimestamp(ColumnNames[0], rs1.getTimestamp(updateXXXName));
                        }
                    } else if (updateXXXName == 17) {
                        if (!JDBC.vmSupportsJDBC3()) continue;
                        if (indexOrName == 1) {
                            rs.updateBlob(1, rs1.getBlob(updateXXXName));
                        } else {
                            rs.updateBlob(ColumnNames[0], rs1.getBlob(updateXXXName));
                        }
                    } else if (updateXXXName == 18) {
                        if (indexOrName == 1) {
                            rs.updateBoolean(1, rs1.getBoolean(1));
                        } else {
                            rs.updateBoolean(ColumnNames[0], rs1.getBoolean(1));
                        }
                    } else if (updateXXXName == 19) {
                        if (indexOrName == 1) {
                            rs.updateNull(1);
                        } else {
                            rs.updateNull(ColumnNames[0]);
                        }
                    } else if (updateXXXName == 20) {
                        if (!JDBC.vmSupportsJDBC3()) continue;
                        if (indexOrName == 1) {
                            rs.updateArray(1, null);
                        } else {
                            rs.updateArray(ColumnNames[0], null);
                        }
                    } else if (updateXXXName == 21) {
                        if (!JDBC.vmSupportsJDBC3()) continue;
                        if (indexOrName == 1) {
                            rs.updateRef(1, null);
                        } else {
                            rs.updateRef(ColumnNames[0], null);
                        }
                    }
                    UpdatableResultSetTest.fail((String)"FAIL - should not have reached here because updateXXX is being called on a read-only resultset");
                    return;
                }
                catch (SQLException e) {
                    if (updateXXXName == 20 || updateXXXName == 21) {
                        UpdatableResultSetTest.assertSQLState("FAIL - unexpected exception on " + allUpdateXXXNames[updateXXXName - 1], "0A000", e);
                    }
                    rs.close();
                    rs1.close();
                }
            }
        }
        stmt.close();
        stmt1.close();
    }

    public void testUpdateXXXWithAllDatatypes() throws SQLException, IllegalArgumentException, UnsupportedEncodingException {
        this.createAllDatatypesTable();
        this.commit();
        PreparedStatement pstmt = this.prepareStatement("SELECT * FROM AllDataTypesForTestingTable FOR UPDATE", 1003, 1008);
        PreparedStatement pstmt1 = this.prepareStatement("SELECT * FROM AllDataTypesNewValuesData");
        for (int sqlType = 1; sqlType <= allSQLTypes.length; ++sqlType) {
            this.rollback();
            UpdatableResultSetTest.println("Next datatype to test is " + allSQLTypes[sqlType - 1]);
            for (int updateXXXName = 1; updateXXXName <= allUpdateXXXNames.length; ++updateXXXName) {
                if (JDBC.vmSupportsJSR169() && updateXXXName == 4) continue;
                UpdatableResultSetTest.println("Testing " + allUpdateXXXNames[updateXXXName - 1] + " on SQL type " + allSQLTypes[sqlType - 1]);
                this.runTestUpdateXXXWithAllDatatypes(pstmt, pstmt1, sqlType, updateXXXName);
            }
        }
        this.rollback();
        this.createStatement().executeUpdate("DROP TABLE AllDataTypesForTestingTable");
        this.createStatement().executeUpdate("DROP TABLE AllDataTypesNewValuesData");
        this.commit();
    }

    private void runTestUpdateXXXWithAllDatatypes(PreparedStatement pstmt, PreparedStatement pstmt1, int sqlType, int updateXXXName) throws SQLException, IllegalArgumentException, UnsupportedEncodingException {
        int checkAgainstColumn = updateXXXName;
        for (int indexOrName = 1; indexOrName <= 2; ++indexOrName) {
            if (indexOrName == 1) {
                UpdatableResultSetTest.println("Using column position as first parameter to " + allUpdateXXXNames[updateXXXName - 1]);
            } else {
                UpdatableResultSetTest.println("Using column name as first parameter to " + allUpdateXXXNames[updateXXXName - 1]);
            }
            ResultSet rs = pstmt.executeQuery();
            rs.next();
            ResultSet rs1 = pstmt1.executeQuery();
            rs1.next();
            try {
                if (updateXXXName == 1) {
                    if (indexOrName == 1) {
                        rs.updateShort(sqlType, rs1.getShort(updateXXXName));
                    } else {
                        rs.updateShort(ColumnNames[sqlType - 1], rs1.getShort(updateXXXName));
                    }
                } else if (updateXXXName == 2) {
                    if (indexOrName == 1) {
                        rs.updateInt(sqlType, rs1.getInt(updateXXXName));
                    } else {
                        rs.updateInt(ColumnNames[sqlType - 1], rs1.getInt(updateXXXName));
                    }
                } else if (updateXXXName == 3) {
                    if (indexOrName == 1) {
                        rs.updateLong(sqlType, rs1.getLong(updateXXXName));
                    } else {
                        rs.updateLong(ColumnNames[sqlType - 1], rs1.getLong(updateXXXName));
                    }
                } else if (updateXXXName == 4) {
                    if (!JDBC.vmSupportsJSR169()) {
                        if (indexOrName == 1) {
                            rs.updateBigDecimal(sqlType, rs1.getBigDecimal(updateXXXName));
                        } else {
                            rs.updateBigDecimal(ColumnNames[sqlType - 1], rs1.getBigDecimal(updateXXXName));
                        }
                    }
                } else if (updateXXXName == 5) {
                    if (indexOrName == 1) {
                        rs.updateFloat(sqlType, rs1.getFloat(updateXXXName));
                    } else {
                        rs.updateFloat(ColumnNames[sqlType - 1], rs1.getFloat(updateXXXName));
                    }
                } else if (updateXXXName == 6) {
                    if (indexOrName == 1) {
                        rs.updateDouble(sqlType, rs1.getDouble(updateXXXName));
                    } else {
                        rs.updateDouble(ColumnNames[sqlType - 1], rs1.getDouble(updateXXXName));
                    }
                } else if (updateXXXName == 7) {
                    if (indexOrName == 1) {
                        rs.updateString(sqlType, rs1.getString(updateXXXName));
                    } else {
                        rs.updateString(ColumnNames[sqlType - 1], rs1.getString(updateXXXName));
                    }
                } else if (updateXXXName == 8) {
                    if (indexOrName == 1) {
                        rs.updateAsciiStream(sqlType, rs1.getAsciiStream(updateXXXName), 4);
                    } else {
                        rs.updateAsciiStream(ColumnNames[sqlType - 1], rs1.getAsciiStream(updateXXXName), 4);
                    }
                } else if (updateXXXName == 9) {
                    if (indexOrName == 1) {
                        rs.updateCharacterStream(sqlType, rs1.getCharacterStream(updateXXXName), 4);
                    } else {
                        rs.updateCharacterStream(ColumnNames[sqlType - 1], rs1.getCharacterStream(updateXXXName), 4);
                    }
                } else if (updateXXXName == 10) {
                    checkAgainstColumn = 1;
                    if (indexOrName == 1) {
                        rs.updateByte(sqlType, rs1.getByte(checkAgainstColumn));
                    } else {
                        rs.updateByte(ColumnNames[sqlType - 1], rs1.getByte(checkAgainstColumn));
                    }
                } else if (updateXXXName == 11) {
                    if (indexOrName == 1) {
                        rs.updateBytes(sqlType, rs1.getBytes(updateXXXName));
                    } else {
                        rs.updateBytes(ColumnNames[sqlType - 1], rs1.getBytes(updateXXXName));
                    }
                } else if (updateXXXName == 12) {
                    if (indexOrName == 1) {
                        rs.updateBinaryStream(sqlType, rs1.getBinaryStream(updateXXXName), 2);
                    } else {
                        rs.updateBinaryStream(ColumnNames[sqlType - 1], rs1.getBinaryStream(updateXXXName), 2);
                    }
                } else if (updateXXXName == 13) {
                    if (!JDBC.vmSupportsJDBC3()) continue;
                    if (indexOrName == 1) {
                        rs.updateClob(sqlType, rs1.getClob(updateXXXName));
                    } else {
                        rs.updateClob(ColumnNames[sqlType - 1], rs1.getClob(updateXXXName));
                    }
                } else if (updateXXXName == 14) {
                    if (indexOrName == 1) {
                        rs.updateDate(sqlType, rs1.getDate(updateXXXName));
                    } else {
                        rs.updateDate(ColumnNames[sqlType - 1], rs1.getDate(updateXXXName));
                    }
                } else if (updateXXXName == 15) {
                    if (indexOrName == 1) {
                        rs.updateTime(sqlType, rs1.getTime(updateXXXName));
                    } else {
                        rs.updateTime(ColumnNames[sqlType - 1], rs1.getTime(updateXXXName));
                    }
                } else if (updateXXXName == 16) {
                    if (indexOrName == 1) {
                        rs.updateTimestamp(sqlType, rs1.getTimestamp(updateXXXName));
                    } else {
                        rs.updateTimestamp(ColumnNames[sqlType - 1], rs1.getTimestamp(updateXXXName));
                    }
                } else if (updateXXXName == 17) {
                    if (!JDBC.vmSupportsJDBC3()) continue;
                    if (indexOrName == 1) {
                        rs.updateBlob(sqlType, rs1.getBlob(updateXXXName));
                    } else {
                        rs.updateBlob(ColumnNames[sqlType - 1], rs1.getBlob(updateXXXName));
                    }
                } else if (updateXXXName == 18) {
                    if (indexOrName == 1) {
                        rs.updateBoolean(sqlType, rs1.getBoolean(1));
                    } else {
                        rs.updateBoolean(ColumnNames[sqlType - 1], rs1.getBoolean(1));
                    }
                } else if (updateXXXName == 19) {
                    if (indexOrName == 1) {
                        rs.updateNull(sqlType);
                    } else {
                        rs.updateNull(ColumnNames[sqlType - 1]);
                    }
                } else if (updateXXXName == 20) {
                    if (!JDBC.vmSupportsJDBC3()) continue;
                    if (indexOrName == 1) {
                        rs.updateArray(sqlType, null);
                    } else {
                        rs.updateArray(ColumnNames[sqlType - 1], null);
                    }
                } else if (updateXXXName == 21) {
                    if (!JDBC.vmSupportsJDBC3()) continue;
                    if (indexOrName == 1) {
                        rs.updateRef(sqlType, null);
                    } else {
                        rs.updateRef(ColumnNames[sqlType - 1], null);
                    }
                }
                rs.updateRow();
                if (UpdatableResultSetTest.usingDerbyNetClient() && !updateXXXRulesTableForNetworkClient[sqlType - 1][updateXXXName - 1].equals("PASS") || UpdatableResultSetTest.usingEmbedded() && !updateXXXRulesTableForEmbedded[sqlType - 1][updateXXXName - 1].equals("PASS")) {
                    UpdatableResultSetTest.fail((String)"FAILURE : We shouldn't reach here. The test should have failed earlier on updateXXX or updateRow call");
                    return;
                }
                this.verifyData(sqlType, checkAgainstColumn);
                this.resetData();
            }
            catch (SQLException e) {
                if (UpdatableResultSetTest.usingDerbyNetClient()) {
                    UpdatableResultSetTest.assertSQLState("Error using " + allUpdateXXXNames[updateXXXName - 1] + " on column type " + allSQLTypes[sqlType - 1], updateXXXRulesTableForNetworkClient[sqlType - 1][updateXXXName - 1], e);
                } else {
                    UpdatableResultSetTest.assertSQLState("Error using " + allUpdateXXXNames[updateXXXName - 1] + " on column type " + allSQLTypes[sqlType - 1], updateXXXRulesTableForEmbedded[sqlType - 1][updateXXXName - 1], e);
                }
            }
            catch (IllegalArgumentException ie) {
                if (sqlType == 14 || sqlType == 15 || sqlType == 16) {
                    UpdatableResultSetTest.assertEquals((String)"Should be updateString", (int)7, (int)checkAgainstColumn);
                }
                throw ie;
            }
            rs.close();
            rs1.close();
        }
    }

    public void testUpdateObjectWithAllDatatypes() throws SQLException, IllegalArgumentException, UnsupportedEncodingException {
        this.createAllDatatypesTable();
        this.commit();
        PreparedStatement pstmt = this.prepareStatement("SELECT * FROM AllDataTypesForTestingTable FOR UPDATE", 1003, 1008);
        PreparedStatement pstmt1 = this.prepareStatement("SELECT * FROM AllDataTypesNewValuesData");
        for (int sqlType = 1; sqlType <= allSQLTypes.length; ++sqlType) {
            this.rollback();
            UpdatableResultSetTest.println("Next datatype to test is " + allSQLTypes[sqlType - 1]);
            for (int updateXXXName = 1; updateXXXName <= allUpdateXXXNames.length; ++updateXXXName) {
                if (JDBC.vmSupportsJSR169() && updateXXXName == 4) continue;
                UpdatableResultSetTest.println("  Testing " + allUpdateXXXNames[updateXXXName - 1] + " on SQL type " + allSQLTypes[sqlType - 1]);
                this.runTestUpdateObjectWithAllDatatypes(pstmt, pstmt1, sqlType, updateXXXName);
            }
        }
        this.rollback();
        this.createStatement().executeUpdate("DROP TABLE AllDataTypesForTestingTable");
        this.createStatement().executeUpdate("DROP TABLE AllDataTypesNewValuesData");
        this.commit();
    }

    private void runTestUpdateObjectWithAllDatatypes(PreparedStatement pstmt, PreparedStatement pstmt1, int sqlType, int updateXXXName) throws SQLException, IllegalArgumentException, UnsupportedEncodingException {
        for (int indexOrName = 1; indexOrName <= 2; ++indexOrName) {
            String displayString = indexOrName == 1 ? "  updateObject with column position &" : "  updateObject with column name &";
            ResultSet rs = pstmt.executeQuery();
            rs.next();
            ResultSet rs1 = pstmt1.executeQuery();
            rs1.next();
            try {
                if (updateXXXName == 1) {
                    UpdatableResultSetTest.println(displayString + " Short object as parameters");
                    if (indexOrName == 1) {
                        rs.updateObject(sqlType, (Object)rs1.getShort(updateXXXName));
                    } else {
                        rs.updateObject(ColumnNames[sqlType - 1], (Object)rs1.getShort(updateXXXName));
                    }
                } else if (updateXXXName == 2) {
                    UpdatableResultSetTest.println(displayString + " Integer object as parameters");
                    if (indexOrName == 1) {
                        rs.updateObject(sqlType, (Object)rs1.getInt(updateXXXName));
                    } else {
                        rs.updateObject(ColumnNames[sqlType - 1], (Object)rs1.getInt(updateXXXName));
                    }
                } else if (updateXXXName == 3) {
                    UpdatableResultSetTest.println(displayString + " Long object as parameters");
                    if (indexOrName == 1) {
                        rs.updateObject(sqlType, (Object)rs1.getLong(updateXXXName));
                    } else {
                        rs.updateObject(ColumnNames[sqlType - 1], (Object)rs1.getLong(updateXXXName));
                    }
                } else if (updateXXXName == 4) {
                    if (!JDBC.vmSupportsJSR169()) {
                        UpdatableResultSetTest.println(displayString + " BigDecimal object as parameters");
                        if (indexOrName == 1) {
                            rs.updateObject(sqlType, (Object)rs1.getBigDecimal(updateXXXName));
                        } else {
                            rs.updateObject(ColumnNames[sqlType - 1], (Object)rs1.getBigDecimal(updateXXXName));
                        }
                    }
                } else if (updateXXXName == 5) {
                    UpdatableResultSetTest.println(displayString + " Float object as parameters");
                    if (indexOrName == 1) {
                        rs.updateObject(sqlType, (Object)Float.valueOf(rs1.getFloat(updateXXXName)));
                    } else {
                        rs.updateObject(ColumnNames[sqlType - 1], (Object)Float.valueOf(rs1.getFloat(updateXXXName)));
                    }
                } else if (updateXXXName == 6) {
                    UpdatableResultSetTest.println(displayString + " Double object as parameters");
                    if (indexOrName == 1) {
                        rs.updateObject(sqlType, (Object)rs1.getDouble(updateXXXName));
                    } else {
                        rs.updateObject(ColumnNames[sqlType - 1], (Object)rs1.getDouble(updateXXXName));
                    }
                } else if (updateXXXName == 7) {
                    UpdatableResultSetTest.println(displayString + " String object as parameters");
                    if (indexOrName == 1) {
                        rs.updateObject(sqlType, (Object)rs1.getString(updateXXXName));
                    } else {
                        rs.updateObject(ColumnNames[sqlType - 1], (Object)rs1.getString(updateXXXName));
                    }
                } else {
                    if (updateXXXName == 8 || updateXXXName == 12 || updateXXXName == 9 || updateXXXName == 10) continue;
                    if (updateXXXName == 11) {
                        UpdatableResultSetTest.println(displayString + " bytes[] array as parameters");
                        if (indexOrName == 1) {
                            rs.updateObject(sqlType, (Object)rs1.getBytes(updateXXXName));
                        } else {
                            rs.updateObject(ColumnNames[sqlType - 1], (Object)rs1.getBytes(updateXXXName));
                        }
                    } else if (updateXXXName == 13) {
                        if (!JDBC.vmSupportsJDBC3()) continue;
                        UpdatableResultSetTest.println(displayString + " Clob object as parameters");
                        if (indexOrName == 1) {
                            rs.updateObject(sqlType, (Object)rs1.getClob(updateXXXName));
                        } else {
                            rs.updateObject(ColumnNames[sqlType - 1], (Object)rs1.getClob(updateXXXName));
                        }
                    } else if (updateXXXName == 14) {
                        UpdatableResultSetTest.println(displayString + " Date object as parameters");
                        if (indexOrName == 1) {
                            rs.updateObject(sqlType, (Object)rs1.getDate(updateXXXName));
                        } else {
                            rs.updateObject(ColumnNames[sqlType - 1], (Object)rs1.getDate(updateXXXName));
                        }
                    } else if (updateXXXName == 15) {
                        UpdatableResultSetTest.println(displayString + " Time object as parameters");
                        if (indexOrName == 1) {
                            rs.updateObject(sqlType, (Object)rs1.getTime(updateXXXName));
                        } else {
                            rs.updateObject(ColumnNames[sqlType - 1], (Object)rs1.getTime(updateXXXName));
                        }
                    } else if (updateXXXName == 16) {
                        UpdatableResultSetTest.println(displayString + " TimeStamp object as parameters");
                        if (indexOrName == 1) {
                            rs.updateObject(sqlType, (Object)rs1.getTimestamp(updateXXXName));
                        } else {
                            rs.updateObject(ColumnNames[sqlType - 1], (Object)rs1.getTimestamp(updateXXXName));
                        }
                    } else if (updateXXXName == 17) {
                        if (!JDBC.vmSupportsJDBC3()) continue;
                        UpdatableResultSetTest.println(displayString + " Blob object as parameters");
                        if (indexOrName == 1) {
                            rs.updateObject(sqlType, (Object)rs1.getBlob(updateXXXName));
                        } else {
                            rs.updateObject(ColumnNames[sqlType - 1], (Object)rs1.getBlob(updateXXXName));
                        }
                    } else if (updateXXXName == 18) {
                        UpdatableResultSetTest.println(displayString + " Boolean object as parameters");
                        if (indexOrName == 1) {
                            rs.updateObject(sqlType, (Object)rs1.getBoolean(1));
                        } else {
                            rs.updateObject(ColumnNames[sqlType - 1], (Object)rs1.getBoolean(1));
                        }
                    } else if (updateXXXName == 19) {
                        UpdatableResultSetTest.println(displayString + " null as parameters");
                        if (indexOrName == 1) {
                            rs.updateObject(sqlType, null);
                        } else {
                            rs.updateObject(ColumnNames[sqlType - 1], null);
                        }
                    } else if (updateXXXName == 20 || updateXXXName == 21) continue;
                }
                rs.updateRow();
                if (UpdatableResultSetTest.usingDerbyNetClient() && !updateObjectRulesTableForNetworkClient[sqlType - 1][updateXXXName - 1].equals("PASS") || UpdatableResultSetTest.usingEmbedded() && !updateXXXRulesTableForEmbedded[sqlType - 1][updateXXXName - 1].equals("PASS")) {
                    UpdatableResultSetTest.fail((String)"FAIL - We shouldn't reach here. The test should have failed earlier on updateXXX or updateRow call.");
                }
                if (sqlType != 7 && sqlType != 8 && sqlType != 9 || updateXXXName != 13) {
                    this.verifyData(sqlType, updateXXXName);
                }
                this.resetData();
            }
            catch (SQLException e) {
                if (UpdatableResultSetTest.usingEmbedded()) {
                    UpdatableResultSetTest.assertSQLState(updateXXXRulesTableForEmbedded[sqlType - 1][updateXXXName - 1], e);
                } else {
                    UpdatableResultSetTest.assertSQLState(updateObjectRulesTableForNetworkClient[sqlType - 1][updateXXXName - 1], e);
                }
            }
            catch (IllegalArgumentException iae) {
                if (sqlType == 14 || sqlType == 15 || sqlType == 16) {
                    UpdatableResultSetTest.assertEquals((String)"FAIL - wrong updateXXX function", (int)7, (int)updateXXXName);
                }
                throw iae;
            }
            rs.close();
            rs1.close();
        }
    }

    public void testUpdateXXXWithCancelRowUpdates() throws SQLException {
        this.createAllDatatypesTable();
        Statement stmt = this.createStatement(1003, 1008);
        Statement stmt1 = this.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM AllDataTypesForTestingTable FOR UPDATE");
        rs.next();
        ResultSet rs1 = stmt1.executeQuery("SELECT * FROM AllDataTypesNewValuesData");
        rs1.next();
        short s = rs.getShort(1);
        rs.updateShort(1, rs1.getShort(1));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (short)rs1.getShort(1), (short)rs.getShort(1));
        rs.cancelRowUpdates();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (short)s, (short)rs.getShort(1));
        int i = rs.getInt(2);
        rs.updateInt(2, rs1.getInt(2));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (int)rs1.getInt(2), (int)rs.getInt(2));
        rs.cancelRowUpdates();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (int)i, (int)rs.getInt(2));
        long l = rs.getLong(3);
        rs.updateLong(3, rs1.getLong(3));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (long)rs1.getLong(3), (long)rs.getLong(3));
        rs.cancelRowUpdates();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (long)l, (long)rs.getLong(3));
        String bdString = BigDecimalHandler.getBigDecimalString(rs, 4);
        BigDecimalHandler.updateBigDecimalString(rs, 4, BigDecimalHandler.getBigDecimalString(rs1, 4));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (String)BigDecimalHandler.getBigDecimalString(rs1, 4), (String)BigDecimalHandler.getBigDecimalString(rs, 4));
        rs.cancelRowUpdates();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (String)bdString, (String)BigDecimalHandler.getBigDecimalString(rs, 4));
        float f = rs.getFloat(5);
        rs.updateFloat(5, rs1.getFloat(5));
        UpdatableResultSetTest.assertTrue((String)("FAIL - wrong value returned by getXXX method expected " + rs1.getFloat(5) + " but was " + rs.getFloat(5)), (rs1.getFloat(5) == rs.getFloat(5) ? 1 : 0) != 0);
        rs.cancelRowUpdates();
        UpdatableResultSetTest.assertTrue((String)("FAIL - wrong value returned by getXXX method expected " + f + " but was " + rs.getFloat(5)), (f == rs.getFloat(5) ? 1 : 0) != 0);
        UpdatableResultSetTest.println("  updateDouble and then cancelRowUpdates");
        double db = rs.getDouble(6);
        rs.updateDouble(6, rs1.getDouble(6));
        UpdatableResultSetTest.assertTrue((String)("FAIL - wrong value returned by getXXX method expected " + rs1.getDouble(6) + " but was " + rs.getDouble(6)), (rs1.getDouble(6) == rs.getDouble(6) ? 1 : 0) != 0);
        rs.cancelRowUpdates();
        UpdatableResultSetTest.assertTrue((String)("FAIL - wrong value returned by getXXX method expected " + db + " but was " + rs.getDouble(6)), (db == rs.getDouble(6) ? 1 : 0) != 0);
        String str = rs.getString(7);
        rs.updateString(7, rs1.getString(7));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (String)rs1.getString(7), (String)rs.getString(7));
        rs.cancelRowUpdates();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (String)str, (String)rs.getString(7));
        str = rs.getString(8);
        rs.updateAsciiStream(8, rs1.getAsciiStream(8), 4);
        UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (boolean)rs.getString(8).equals(rs1.getString(8)));
        rs.cancelRowUpdates();
        UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (boolean)rs.getString(8).equals(str));
        str = rs.getString(9);
        rs.updateCharacterStream(9, rs1.getCharacterStream(9), 4);
        UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (boolean)rs.getString(9).equals(rs1.getString(9)));
        rs.cancelRowUpdates();
        UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (boolean)rs.getString(9).equals(str));
        s = rs.getShort(1);
        rs.updateByte(1, rs1.getByte(1));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (short)rs1.getShort(1), (short)rs.getShort(1));
        rs.cancelRowUpdates();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (short)s, (short)rs.getShort(1));
        byte[] bts = rs.getBytes(11);
        rs.updateBytes(11, rs1.getBytes(11));
        UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (boolean)Arrays.equals(rs.getBytes(11), rs1.getBytes(11)));
        rs.cancelRowUpdates();
        UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (boolean)Arrays.equals(rs.getBytes(11), bts));
        bts = rs.getBytes(12);
        rs.updateBinaryStream(12, rs1.getBinaryStream(12), 2);
        UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (boolean)Arrays.equals(rs.getBytes(12), rs1.getBytes(12)));
        rs.cancelRowUpdates();
        UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (boolean)Arrays.equals(rs.getBytes(12), bts));
        Date date = rs.getDate(14);
        rs.updateDate(14, rs1.getDate(14));
        UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (rs.getDate(14).compareTo(rs1.getDate(14)) == 0 ? 1 : 0) != 0);
        rs.cancelRowUpdates();
        UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (rs.getDate(14).compareTo(date) == 0 ? 1 : 0) != 0);
        Time time = rs.getTime(15);
        rs.updateTime(15, rs1.getTime(15));
        UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (rs.getTime(15).compareTo(rs1.getTime(15)) == 0 ? 1 : 0) != 0);
        rs.cancelRowUpdates();
        UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (rs.getTime(15).compareTo(time) == 0 ? 1 : 0) != 0);
        Timestamp timeStamp = rs.getTimestamp(16);
        rs.updateTimestamp(16, rs1.getTimestamp(16));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (String)rs1.getTimestamp(16).toString(), (String)rs.getTimestamp(16).toString());
        rs.cancelRowUpdates();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (String)timeStamp.toString(), (String)rs.getTimestamp(16).toString());
        if (UpdatableResultSetTest.usingEmbedded() && JDBC.vmSupportsJDBC3()) {
            UpdatableResultSetTest.println("  updateClob and then cancelRowUpdates");
            String clb1 = rs.getString(13);
            String clb2 = rs1.getString(13);
            rs.updateClob(13, rs1.getClob(13));
            UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (String)clb2, (String)rs.getString(13));
            rs.cancelRowUpdates();
            UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (String)clb1, (String)rs.getString(13));
            UpdatableResultSetTest.println("  updateBlob and then cancelRowUpdates");
            bts = rs.getBytes(17);
            byte[] bts2 = rs1.getBytes(17);
            rs.updateBlob(17, rs1.getBlob(17));
            UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (boolean)Arrays.equals(rs.getBytes(17), bts2));
            rs.cancelRowUpdates();
            UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (boolean)Arrays.equals(rs.getBytes(17), bts));
        }
        rs.close();
        rs1.close();
        stmt.close();
        stmt1.close();
    }

    public void testCancelRowUpdatesAndDeleteRow() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 1 before updateInt", (int)1, (int)rs.getInt(1));
        rs.updateInt(1, 234);
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 1 before updateInt", (int)234, (int)rs.getInt(1));
        UpdatableResultSetTest.println("now cancelRowUpdates on the row");
        rs.cancelRowUpdates();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 1 after cancelRowUpdates", (int)1, (int)rs.getInt(1));
        rs.deleteRow();
        try {
            rs.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - updateRow should have failed because ResultSet is not positioned on a row");
        }
        catch (SQLException e) {
            String sqlState = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        UpdatableResultSetTest.println("Position the ResultSet with next()");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.println("Should be able to updateRow() on the current row now");
        rs.updateString(2, "234");
        rs.updateRow();
        rs.close();
        Object[][] expected = new String[][]{{"2", "234"}, {"3", "cc"}};
        rs = stmt.executeQuery("select * from t1");
        JDBC.assertFullResultSet(rs, expected, true);
        rs.close();
        stmt.close();
    }

    public void testCancelRowUpdatesWithoutUpdateXXX() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.cancelRowUpdates();
        rs.close();
        stmt.close();
    }

    public void testUpdateRowWithoutUpdateXXX() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.updateRow();
        rs.updateRow();
        rs.close();
        Object[][] original = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        rs = stmt.executeQuery("select * from t1");
        JDBC.assertFullResultSet(rs, original, true);
        rs.close();
        stmt.close();
    }

    public void testUpdateXXXAndDeleteRow() throws SQLException {
        String sqlState;
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.updateInt(1, 1234);
        rs.updateString(2, "aaaaa");
        rs.deleteRow();
        try {
            rs.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have moved the ResultSet to right before the next row");
        }
        catch (SQLException e) {
            sqlState = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        try {
            rs.updateInt(1, 2345);
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have moved the ResultSet to right before the next row");
        }
        catch (SQLException e) {
            sqlState = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        try {
            rs.getInt(1);
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have moved the ResultSet to right before the next row");
        }
        catch (SQLException e) {
            sqlState = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        rs.close();
        Object[][] expected = new String[][]{{"2", "bb"}, {"3", "cc"}};
        rs = stmt.executeQuery("select * from t1");
        JDBC.assertFullResultSet(rs, expected, true);
        rs.close();
        stmt.close();
    }

    public void testUpdateXXXAndMoveNext() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 1", (int)1, (int)rs.getInt(1));
        UpdatableResultSetTest.println("  Issue updateInt to change the column's value to 2345");
        rs.updateInt(1, 2345);
        rs.next();
        rs.close();
        Object[][] original = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        rs = stmt.executeQuery("select * from t1");
        JDBC.assertFullResultSet(rs, original, true);
        rs.close();
        stmt.close();
    }

    public void testMultipleUpdateXXXAndUpdateRow() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 1", (int)1, (int)rs.getInt(1));
        rs.updateInt(1, 2345);
        rs.updateInt(1, 9999);
        rs.updateString(2, "xxxxxxx");
        UpdatableResultSetTest.println("  Now issue updateRow");
        rs.updateRow();
        rs.close();
        Object[][] expected = new String[][]{{"9999", "xxxxxxx"}, {"2", "bb"}, {"3", "cc"}};
        rs = stmt.executeQuery("SELECT * FROM t1");
        JDBC.assertFullResultSet(rs, expected, true);
        rs.close();
        stmt.close();
    }

    public void testUpdateXXXOnTableColumn() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT 1, 2, c1, c2 FROM t1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.updateInt(3, 22);
        rs.updateRow();
        rs.close();
        Object[][] expected = new String[][]{{"22", "aa"}, {"2", "bb"}, {"3", "cc"}};
        rs = stmt.executeQuery("SELECT * FROM t1");
        JDBC.assertFullResultSet(rs, expected, true);
        rs.close();
        stmt.close();
    }

    public void testCaseSensitiveTableAndColumnName() throws SQLException {
        Statement stmt = this.createStatement(1003, 1008);
        stmt.executeUpdate("create table \"t1\" (\"c11\" int, c12 int)");
        stmt.executeUpdate("insert into \"t1\" values(1, 2), (2,3)");
        ResultSet rs = stmt.executeQuery("SELECT \"c11\", \"C12\" FROM \"t1\" FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.updateInt(1, 11);
        rs.updateInt(2, 22);
        rs.updateRow();
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.deleteRow();
        rs.close();
        rs = stmt.executeQuery("SELECT \"c11\", \"C12\" FROM \"t1\" FOR UPDATE");
        Object[][] expected = new String[][]{{"11", "22"}};
        JDBC.assertFullResultSet(rs, expected, true);
        rs.close();
        stmt.close();
    }

    public void testTableAndColumnNameWithSpaces() throws SQLException {
        Statement stmt = this.createStatement(1003, 1008);
        stmt.executeUpdate("create table \" t 11 \" (\" c 111 \" int, c112 int)");
        stmt.executeUpdate("insert into \" t 11 \" values(1, 2), (2,3)");
        ResultSet rs = stmt.executeQuery("SELECT \" c 111 \", \"C112\" FROM \" t 11 \" ");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.updateInt(1, 11);
        rs.updateInt(2, 22);
        rs.updateRow();
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.deleteRow();
        rs.close();
        rs = stmt.executeQuery("SELECT \" c 111 \", \"C112\" FROM \" t 11 \" ");
        Object[][] expected = new String[][]{{"11", "22"}};
        JDBC.assertFullResultSet(rs, expected, true);
        rs.close();
        stmt.close();
    }

    public void testUpdateXXXNotForUpdateColumns() throws SQLException {
        this.createTableT1();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT c1, c2 FROM t1 FOR UPDATE of c1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        try {
            rs.updateInt(2, 22);
            UpdatableResultSetTest.fail((String)"FAIL - updateXXX methods should fail when the column is not in the FOR UPDATE clause");
        }
        catch (SQLException e) {
            String sqlState = UpdatableResultSetTest.usingEmbedded() ? "42X31" : "XJ124";
            UpdatableResultSetTest.assertSQLState(sqlState, e);
        }
        rs.updateRow();
        rs.close();
        Object[][] expected = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        rs = stmt.executeQuery("SELECT * FROM t1");
        JDBC.assertFullResultSet(rs, expected, true);
        rs.close();
        stmt.close();
    }

    public void testUpdateTableDifferentSchema() throws SQLException {
        Statement stmt = this.createStatement(1003, 1008);
        this.createTableT1();
        stmt.executeUpdate("create schema s2");
        stmt.executeUpdate("create table s2.t1 (c1s2t1 int, c2s2t1 smallint, c3s2t2 double)");
        stmt.executeUpdate("insert into s2.t1 values(1,2,2.2),(1,3,3.3)");
        Object[][] expected_t1 = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1");
        JDBC.assertFullResultSet(rs, expected_t1, true);
        rs.close();
        Object[][] original_s2_t1 = new String[][]{{"1", "2", "2.2"}, {"1", "3", "3.3"}};
        rs = stmt.executeQuery("select * from s2.t1");
        JDBC.assertFullResultSet(rs, original_s2_t1, true);
        rs.close();
        rs = stmt.executeQuery("SELECT * FROM s2.t1 FOR UPDATE");
        rs.next();
        rs.updateInt(2, 1);
        rs.updateRow();
        rs.next();
        rs.updateInt(2, 1);
        rs.updateRow();
        rs.close();
        rs = stmt.executeQuery("SELECT * FROM t1");
        JDBC.assertFullResultSet(rs, expected_t1, true);
        rs.close();
        Object[][] expected_s2_t1 = new String[][]{{"1", "1", "2.2"}, {"1", "1", "3.3"}};
        rs = stmt.executeQuery("select * from s2.t1");
        JDBC.assertFullResultSet(rs, expected_s2_t1, true);
        rs.close();
        stmt.close();
    }

    public void testUpdateRowDeleteRowDoNotCommit() throws SQLException {
        int j;
        this.getConnection().setAutoCommit(true);
        this.createTableT1();
        this.commit();
        Object[][] expected = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.deleteRow();
        this.rollback();
        rs.close();
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM t1"), expected, true);
        rs = stmt.executeQuery("SELECT * FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.updateInt(1, -rs.getInt(1));
        rs.updateRow();
        this.rollback();
        rs.close();
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM t1"), expected, true);
        rs = stmt.executeQuery("SELECT COUNT(*) FROM t1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        int count = rs.getInt(1);
        rs.close();
        rs = stmt.executeQuery("SELECT * FROM t1 FOR UPDATE");
        for (j = 0; j < count; ++j) {
            UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        }
        rs.deleteRow();
        this.rollback();
        rs.close();
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM t1"), expected, true);
        rs = stmt.executeQuery("SELECT * FROM t1 FOR UPDATE");
        for (j = 0; j < count; ++j) {
            UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        }
        rs.updateInt(1, -rs.getInt(1));
        rs.updateRow();
        this.rollback();
        rs.close();
        JDBC.assertFullResultSet(stmt.executeQuery("SELECT * FROM t1"), expected, true);
        stmt.executeUpdate("DROP TABLE t1");
        stmt.close();
        this.commit();
    }

    public void testInsertRow() throws SQLException {
        this.createTableT4();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t4");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        int c41old = rs.getInt(1);
        int c42old = rs.getInt(2);
        rs.moveToInsertRow();
        rs.updateInt(1, 5);
        rs.updateInt(2, 5);
        rs.insertRow();
        int c41 = rs.getInt(1);
        int c42 = rs.getInt(2);
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c41", (int)5, (int)c41);
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c42", (int)5, (int)c42);
        rs.moveToCurrentRow();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c41", (int)c41old, (int)rs.getInt(1));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c42", (int)c42old, (int)rs.getInt(2));
        rs.moveToCurrentRow();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c41", (int)c41old, (int)rs.getInt(1));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c42", (int)c42old, (int)rs.getInt(2));
        rs.moveToInsertRow();
        rs.updateInt(1, 6);
        rs.updateInt(2, 4);
        c41 = rs.getInt(1);
        c42 = rs.getInt(2);
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c41", (int)6, (int)c41);
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c42", (int)4, (int)c42);
        rs.moveToInsertRow();
        c41 = rs.getInt(1);
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c41", (int)0, (int)c41);
        UpdatableResultSetTest.assertTrue((String)"FAIL - value should be undefined when moving to insertRow", (boolean)rs.wasNull());
        c42 = rs.getInt(2);
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c42", (int)0, (int)c42);
        UpdatableResultSetTest.assertTrue((String)"FAIL - value should be undefined when moving to insertRow", (boolean)rs.wasNull());
        rs.moveToInsertRow();
        rs.updateInt(2, 7);
        try {
            rs.insertRow();
            UpdatableResultSetTest.fail((String)"FAIL - should have failed can not insert NULL into not null column");
        }
        catch (SQLException se) {
            UpdatableResultSetTest.assertSQLState("23502", se);
        }
        rs.close();
        Object[][] expected = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}, {"5", "5"}};
        rs = stmt.executeQuery("SELECT * FROM t4");
        JDBC.assertFullResultSet(rs, expected, true);
        rs.close();
        stmt.close();
    }

    public void testUpdateRowDeleteRowFromInsertRow() throws SQLException {
        this.createTableT4();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t4");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.moveToInsertRow();
        rs.updateInt(1, 6);
        rs.updateInt(2, 6);
        try {
            rs.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - can not call updateRow from insertRow");
        }
        catch (SQLException se) {
            UpdatableResultSetTest.assertSQLState("24000", se);
        }
        try {
            rs.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - can not call deleteRow from insertRow");
        }
        catch (SQLException se) {
            UpdatableResultSetTest.assertSQLState("24000", se);
        }
        rs.close();
        Object[][] expected = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}};
        rs = stmt.executeQuery("SELECT * FROM t4");
        JDBC.assertFullResultSet(rs, expected, true);
        rs.close();
        stmt.close();
    }

    public void testInsertRowFromCurrentRow() throws SQLException {
        this.createTableT4();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t4");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.moveToCurrentRow();
        try {
            rs.insertRow();
            UpdatableResultSetTest.fail((String)"FAIL - insert row not allowed from current row");
        }
        catch (SQLException se) {
            UpdatableResultSetTest.assertSQLState("XJ086", se);
        }
        rs.close();
        stmt.close();
    }

    public void testInsertRowFromDifferentPositions() throws SQLException {
        this.createTableT4();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t4");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs = stmt.executeQuery("SELECT * FROM t4 WHERE c41 <= 5");
        rs.moveToInsertRow();
        rs.updateInt(1, 1000);
        rs.updateInt(2, 1000);
        rs.insertRow();
        while (rs.next()) {
            int c41 = rs.getInt(1);
            int c42 = rs.getInt(2);
            rs.moveToInsertRow();
            rs.updateInt(1, c41 + 100);
            rs.updateInt(2, c42 + 100);
            rs.insertRow();
        }
        rs.moveToInsertRow();
        rs.updateInt(1, 2000);
        rs.updateInt(2, 2000);
        rs.insertRow();
        rs.close();
        Object[][] expected = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}, {"1000", "1000"}, {"101", "101"}, {"102", "102"}, {"103", "103"}, {"104", "104"}, {"2000", "2000"}};
        rs = stmt.executeQuery("SELECT * FROM t4");
        JDBC.assertFullResultSet(rs, expected, true);
        rs.close();
        stmt.close();
    }

    public void testInsertRowWithNullColumn() throws SQLException {
        this.createTableT4();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t4");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.moveToInsertRow();
        rs.updateInt(1, 7);
        rs.insertRow();
        rs.close();
        Object[][] expected = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}, {"7", null}};
        rs = stmt.executeQuery("SELECT * FROM t4");
        JDBC.assertFullResultSet(rs, expected, true);
        rs.close();
        stmt.close();
    }

    public void xTestInsertRowAfterCommit() throws SQLException {
        this.createTableT4();
        this.getConnection().setHoldability(1);
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t4");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.moveToInsertRow();
        rs.updateInt(1, 8);
        rs.updateInt(2, 8);
        this.commit();
        rs.insertRow();
        rs.close();
        stmt.close();
        this.getConnection().setHoldability(2);
        stmt = this.createStatement(1003, 1008);
        rs = stmt.executeQuery("SELECT * FROM t4");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.moveToInsertRow();
        rs.updateInt(1, 82);
        rs.updateInt(2, 82);
        this.commit();
        try {
            rs.insertRow();
            UpdatableResultSetTest.fail((String)"FAIL - result set is not holdable and should be closed after commit");
        }
        catch (SQLException se) {
            UpdatableResultSetTest.assertSQLState("XCL16", se);
            UpdatableResultSetTest.assertTrue((se.getMessage().indexOf("insertRow") > 0 ? 1 : 0) != 0);
        }
        rs.close();
        Object[][] expected = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}, {"8", "8"}};
        rs = stmt.executeQuery("SELECT * FROM t4");
        JDBC.assertFullResultSet(rs, expected, true);
        rs.close();
        stmt.executeUpdate("DROP TABLE t4");
        stmt.close();
        this.commit();
    }

    public void testInsertRowAfterClose() throws SQLException {
        this.createTableT4();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t4");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.moveToInsertRow();
        rs.updateInt(1, 9);
        rs.updateInt(2, 9);
        rs.close();
        try {
            rs.insertRow();
            UpdatableResultSetTest.fail((String)"FAIL - insertRow can not be called on closed RS");
        }
        catch (SQLException se) {
            UpdatableResultSetTest.assertSQLState("XCL16", se);
        }
        try {
            rs.moveToCurrentRow();
            UpdatableResultSetTest.fail((String)"FAIL - moveToCurrentRow can not be called on closed RS");
        }
        catch (SQLException se) {
            UpdatableResultSetTest.assertSQLState("XCL16", se);
        }
        try {
            rs.moveToInsertRow();
            UpdatableResultSetTest.fail((String)"FAIL: moveToInsertRow can not be called on closed RS");
        }
        catch (SQLException se) {
            UpdatableResultSetTest.assertSQLState("XCL16", se);
        }
        Object[][] expected = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}};
        rs = stmt.executeQuery("SELECT * FROM t4");
        JDBC.assertFullResultSet(rs, expected, true);
        rs.close();
        stmt.close();
    }

    public void testInsertRowWithDefaultValue() throws SQLException {
        this.createTableT5();
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t5");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.moveToInsertRow();
        rs.insertRow();
        rs.close();
        Object[][] expected = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}, {"0", null}};
        rs = stmt.executeQuery("SELECT * FROM t5");
        JDBC.assertFullResultSet(rs, expected, true);
        rs.close();
        stmt.close();
    }

    public void testRollbackWithAutoCommit() throws SQLException {
        this.createTableT4();
        this.getConnection().setAutoCommit(true);
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t4");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        rs.moveToInsertRow();
        rs.updateInt(1, 4000);
        rs.updateInt(2, 4000);
        rs.insertRow();
        this.rollback();
        rs.close();
        Object[][] expected = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}};
        rs = stmt.executeQuery("SELECT * FROM t4");
        JDBC.assertFullResultSet(rs, expected, true);
        rs.close();
        stmt.executeUpdate("DROP TABLE t4");
        stmt.close();
        this.commit();
    }

    public void testInsertRowReadOnlyRS() throws SQLException {
        this.createTableT4();
        Statement stmt = this.createStatement(1003, 1007);
        ResultSet rs = stmt.executeQuery("SELECT * FROM t4");
        try {
            rs.moveToInsertRow();
            UpdatableResultSetTest.fail((String)"FAIL - moveToInsertRow can not be called on read-only RS");
        }
        catch (SQLException se) {
            UpdatableResultSetTest.assertSQLState("XJ083", se);
        }
        try {
            rs.updateInt(1, 5000);
            UpdatableResultSetTest.fail((String)"FAIL - updateXXX not allowed on read-only RS");
        }
        catch (SQLException se) {
            UpdatableResultSetTest.assertSQLState("XJ083", se);
        }
        try {
            rs.insertRow();
            UpdatableResultSetTest.fail((String)"FAIL - insertRow not allowed on read-only RS");
        }
        catch (SQLException se) {
            UpdatableResultSetTest.assertSQLState("XJ083", se);
        }
        try {
            rs.moveToCurrentRow();
            UpdatableResultSetTest.fail((String)"FAIL - moveToCurrentRow can not be called on read-only RS");
        }
        catch (SQLException se) {
            UpdatableResultSetTest.assertSQLState("XJ083", se);
        }
        rs.close();
        stmt.close();
    }

    public void testUpdateXXXAllDataTypesInsertRow() throws SQLException, UnsupportedEncodingException {
        this.createAllDatatypesTable();
        Statement stmt = this.createStatement();
        stmt.executeUpdate("DELETE FROM AllDataTypesForTestingTable");
        PreparedStatement pstmti = this.prepareStatement("SELECT * FROM AllDataTypesForTestingTable FOR UPDATE", 1003, 1008);
        PreparedStatement pstmt1i = this.prepareStatement("SELECT * FROM AllDataTypesNewValuesData");
        for (int sqlType = 1; sqlType <= allSQLTypes.length; ++sqlType) {
            UpdatableResultSetTest.println("Next datatype to test is " + allSQLTypes[sqlType - 1]);
            for (int updateXXXName = 1; updateXXXName <= allUpdateXXXNames.length; ++updateXXXName) {
                UpdatableResultSetTest.println("  Testing " + allUpdateXXXNames[updateXXXName - 1] + " on SQL type " + allSQLTypes[sqlType - 1]);
                this.runTestUpdateXXXAllDataTypesInsertRow(pstmti, pstmt1i, sqlType, updateXXXName);
            }
        }
    }

    private void runTestUpdateXXXAllDataTypesInsertRow(PreparedStatement pstmt, PreparedStatement pstmt1, int sqlType, int updateXXXName) throws SQLException, UnsupportedEncodingException {
        Statement s = this.createStatement();
        int checkAgainstColumn = updateXXXName;
        for (int indexOrName = 1; indexOrName <= 2; ++indexOrName) {
            if (indexOrName == 1) {
                UpdatableResultSetTest.println("Using column position as first parameter to " + allUpdateXXXNames[updateXXXName - 1]);
            } else {
                UpdatableResultSetTest.println("Using column name as first parameter to " + allUpdateXXXNames[updateXXXName - 1]);
            }
            ResultSet rs = pstmt.executeQuery();
            rs.moveToInsertRow();
            ResultSet rs1 = pstmt1.executeQuery();
            rs1.next();
            try {
                if (updateXXXName == 1) {
                    if (indexOrName == 1) {
                        rs.updateShort(sqlType, rs1.getShort(updateXXXName));
                    } else {
                        rs.updateShort(ColumnNames[sqlType - 1], rs1.getShort(updateXXXName));
                    }
                } else if (updateXXXName == 2) {
                    if (indexOrName == 1) {
                        rs.updateInt(sqlType, rs1.getInt(updateXXXName));
                    } else {
                        rs.updateInt(ColumnNames[sqlType - 1], rs1.getInt(updateXXXName));
                    }
                } else if (updateXXXName == 3) {
                    if (indexOrName == 1) {
                        rs.updateLong(sqlType, rs1.getLong(updateXXXName));
                    } else {
                        rs.updateLong(ColumnNames[sqlType - 1], rs1.getLong(updateXXXName));
                    }
                } else if (updateXXXName == 4) {
                    if (JDBC.vmSupportsJSR169()) continue;
                    if (indexOrName == 1) {
                        rs.updateBigDecimal(sqlType, rs1.getBigDecimal(updateXXXName));
                    } else {
                        rs.updateBigDecimal(ColumnNames[sqlType - 1], rs1.getBigDecimal(updateXXXName));
                    }
                } else if (updateXXXName == 5) {
                    if (indexOrName == 1) {
                        rs.updateFloat(sqlType, rs1.getFloat(updateXXXName));
                    } else {
                        rs.updateFloat(ColumnNames[sqlType - 1], rs1.getFloat(updateXXXName));
                    }
                } else if (updateXXXName == 6) {
                    if (indexOrName == 1) {
                        rs.updateDouble(sqlType, rs1.getDouble(updateXXXName));
                    } else {
                        rs.updateDouble(ColumnNames[sqlType - 1], rs1.getDouble(updateXXXName));
                    }
                } else if (updateXXXName == 7) {
                    if (indexOrName == 1) {
                        rs.updateString(sqlType, rs1.getString(updateXXXName));
                    } else {
                        rs.updateString(ColumnNames[sqlType - 1], rs1.getString(updateXXXName));
                    }
                } else if (updateXXXName == 8) {
                    if (indexOrName == 1) {
                        rs.updateAsciiStream(sqlType, rs1.getAsciiStream(updateXXXName), 4);
                    } else {
                        rs.updateAsciiStream(ColumnNames[sqlType - 1], rs1.getAsciiStream(updateXXXName), 4);
                    }
                } else if (updateXXXName == 9) {
                    if (indexOrName == 1) {
                        rs.updateCharacterStream(sqlType, rs1.getCharacterStream(updateXXXName), 4);
                    } else {
                        rs.updateCharacterStream(ColumnNames[sqlType - 1], rs1.getCharacterStream(updateXXXName), 4);
                    }
                } else if (updateXXXName == 10) {
                    checkAgainstColumn = 1;
                    if (indexOrName == 1) {
                        rs.updateByte(sqlType, rs1.getByte(checkAgainstColumn));
                    } else {
                        rs.updateByte(ColumnNames[sqlType - 1], rs1.getByte(checkAgainstColumn));
                    }
                } else if (updateXXXName == 11) {
                    if (indexOrName == 1) {
                        rs.updateBytes(sqlType, rs1.getBytes(updateXXXName));
                    } else {
                        rs.updateBytes(ColumnNames[sqlType - 1], rs1.getBytes(updateXXXName));
                    }
                } else if (updateXXXName == 12) {
                    if (indexOrName == 1) {
                        rs.updateBinaryStream(sqlType, rs1.getBinaryStream(updateXXXName), 2);
                    } else {
                        rs.updateBinaryStream(ColumnNames[sqlType - 1], rs1.getBinaryStream(updateXXXName), 2);
                    }
                } else if (updateXXXName == 13) {
                    if (!JDBC.vmSupportsJDBC3()) continue;
                    if (indexOrName == 1) {
                        rs.updateClob(sqlType, rs1.getClob(updateXXXName));
                    } else {
                        rs.updateClob(ColumnNames[sqlType - 1], rs1.getClob(updateXXXName));
                    }
                } else if (updateXXXName == 14) {
                    if (indexOrName == 1) {
                        rs.updateDate(sqlType, rs1.getDate(updateXXXName));
                    } else {
                        rs.updateDate(ColumnNames[sqlType - 1], rs1.getDate(updateXXXName));
                    }
                } else if (updateXXXName == 15) {
                    if (indexOrName == 1) {
                        rs.updateTime(sqlType, rs1.getTime(updateXXXName));
                    } else {
                        rs.updateTime(ColumnNames[sqlType - 1], rs1.getTime(updateXXXName));
                    }
                } else if (updateXXXName == 16) {
                    if (indexOrName == 1) {
                        rs.updateTimestamp(sqlType, rs1.getTimestamp(updateXXXName));
                    } else {
                        rs.updateTimestamp(ColumnNames[sqlType - 1], rs1.getTimestamp(updateXXXName));
                    }
                } else if (updateXXXName == 17) {
                    if (!JDBC.vmSupportsJDBC3()) continue;
                    if (indexOrName == 1) {
                        rs.updateBlob(sqlType, rs1.getBlob(updateXXXName));
                    } else {
                        rs.updateBlob(ColumnNames[sqlType - 1], rs1.getBlob(updateXXXName));
                    }
                } else if (updateXXXName == 18) {
                    if (indexOrName == 1) {
                        rs.updateBoolean(sqlType, rs1.getBoolean(1));
                    } else {
                        rs.updateBoolean(ColumnNames[sqlType - 1], rs1.getBoolean(1));
                    }
                } else if (updateXXXName == 19) {
                    if (indexOrName == 1) {
                        rs.updateNull(sqlType);
                    } else {
                        rs.updateNull(ColumnNames[sqlType - 1]);
                    }
                } else if (updateXXXName == 20) {
                    if (!JDBC.vmSupportsJDBC3()) continue;
                    if (indexOrName == 1) {
                        rs.updateArray(sqlType, null);
                    } else {
                        rs.updateArray(ColumnNames[sqlType - 1], null);
                    }
                } else if (updateXXXName == 21) {
                    if (!JDBC.vmSupportsJDBC3()) continue;
                    if (indexOrName == 1) {
                        rs.updateRef(sqlType, null);
                    } else {
                        rs.updateRef(ColumnNames[sqlType - 1], null);
                    }
                }
                rs.insertRow();
                if (UpdatableResultSetTest.usingDerbyNetClient() && !updateXXXRulesTableForNetworkClient[sqlType - 1][updateXXXName - 1].equals("PASS") || UpdatableResultSetTest.usingEmbedded() && !updateXXXRulesTableForEmbedded[sqlType - 1][updateXXXName - 1].equals("PASS")) {
                    UpdatableResultSetTest.fail((String)"FAIL - We shouldn't reach here. The test should have failed earlier on updateXXX or insertRow call");
                    return;
                }
                this.verifyData(sqlType, checkAgainstColumn);
                s.executeUpdate("DELETE FROM AllDataTypesForTestingTable");
            }
            catch (SQLException se) {
                if (UpdatableResultSetTest.usingEmbedded()) {
                    UpdatableResultSetTest.assertSQLState(updateXXXRulesTableForEmbedded[sqlType - 1][updateXXXName - 1], se);
                } else {
                    UpdatableResultSetTest.assertSQLState(updateXXXRulesTableForNetworkClient[sqlType - 1][updateXXXName - 1], se);
                }
            }
            catch (IllegalArgumentException iae) {
                if (sqlType == 14 || sqlType == 15 || sqlType == 16) {
                    UpdatableResultSetTest.assertEquals((String)"FAIL - exception expected for updateString", (int)7, (int)checkAgainstColumn);
                }
                throw iae;
            }
            rs.close();
            rs1.close();
        }
        this.closeStatement(s);
    }

    private void createTableT1() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table t1 (c1 int, c2 char(20))");
        stmt.executeUpdate("insert into t1 values (1,'aa'), (2,'bb'), (3,'cc')");
        stmt.close();
    }

    private void createTableT2() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table t2 (c21 int, c22 int)");
        stmt.executeUpdate("insert into t2 values (1,1), (2, 2), (3, 3), (4, 4)");
        stmt.close();
    }

    private void createTableT3() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table t3 (c31 int not null primary key, c32 smallint)");
        stmt.executeUpdate("insert into t3 values (1,1), (2, 2), (3, 3), (4, 4)");
        stmt.close();
    }

    private void createTableT4() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table t4 (c41 int not null primary key, c42 int)");
        stmt.executeUpdate("insert into t4 values (1,1), (2,2), (3,3), (4, 4)");
        stmt.close();
    }

    private void createTableT5() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table t5 (c51 int not null default 0, c52 int)");
        stmt.executeUpdate("insert into t5 values (1,1), (2,2), (3,3), (4, 4)");
        stmt.close();
    }

    private void createTableWithPrimaryKey() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table tableWithPrimaryKey (c1 int not null, c2 int not null, constraint pk primary key(c1,c2))");
        stmt.executeUpdate("create table tableWithConstraint (c1 int, c2 int, constraint fk foreign key(c1,c2) references tableWithPrimaryKey)");
        stmt.executeUpdate("insert into tableWithPrimaryKey values (1, 1), (2, 2), (3, 3), (4, 4)");
        stmt.executeUpdate("insert into tableWithConstraint values (1, 1), (2, 2), (3, 3), (4, 4)");
        stmt.close();
    }

    private void createTable0WithTrigger() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table table0WithTriggers (c1 int, c2 bigint)");
        stmt.executeUpdate("create table deleteTriggerInsertIntoThisTable (c1 int)");
        stmt.executeUpdate("create table updateTriggerInsertIntoThisTable (c1 int)");
        stmt.executeUpdate("create trigger tr1 after delete on table0WithTriggers for each statement insert into deleteTriggerInsertIntoThisTable values (1)");
        stmt.executeUpdate("create trigger tr2 after update on table0WithTriggers for each statement insert into updateTriggerInsertIntoThisTable values (1)");
        stmt.executeUpdate("insert into table0WithTriggers values (1, 1), (2, 2), (3, 3), (4, 4)");
        stmt.close();
    }

    private void createTable1WithTrigger() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table table1WithTriggers (c1 int, c2 bigint)");
        stmt.executeUpdate("create trigger tr3 after delete on table1WithTriggers referencing old as old for each row delete from table1WithTriggers where c1=old.c1+1 or c1=old.c1-1");
        stmt.executeUpdate("create table table2WithTriggers (c1 int, c2 bigint)");
        stmt.executeUpdate("create trigger tr4 after update of c2 on table2WithTriggers for each statement update table2WithTriggers set c1=1");
        stmt.executeUpdate("insert into table1WithTriggers values (1, 1), (2, 2), (3, 3), (4, 4)");
        stmt.executeUpdate("insert into table2WithTriggers values (1, 1), (2, 2), (3, 3), (4, 4)");
        stmt.close();
    }

    private void createSelfReferencingTable() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table selfReferencingT1 (c1 char(2) not null, c2 char(2), constraint selfReferencingT1 primary key(c1), constraint manages1 foreign key(c2) references selfReferencingT1(c1) on delete cascade)");
        stmt.executeUpdate("create table selfReferencingT2 (c1 char(2) not null, c2 char(2), constraint selfReferencingT2 primary key(c1), constraint manages2 foreign key(c2) references selfReferencingT2(c1) on update restrict)");
        stmt.executeUpdate("insert into selfReferencingT1 values ('e1', null), ('e2', 'e1'), ('e3', 'e2'), ('e4', 'e3')");
        stmt.executeUpdate("insert into selfReferencingT2 values ('e1', null), ('e2', 'e1'), ('e3', 'e2'), ('e4', 'e3')");
        stmt.close();
    }

    private void createAllDatatypesTable() throws SQLException {
        int type;
        Statement stmt = this.createStatement();
        StringBuffer createSQL = new StringBuffer("create table AllDataTypesForTestingTable (");
        StringBuffer createTestDataSQL = new StringBuffer("create table AllDataTypesNewValuesData (");
        for (type = 0; type < allSQLTypes.length - 1; ++type) {
            createSQL.append(ColumnNames[type] + " " + allSQLTypes[type] + ",");
            createTestDataSQL.append(ColumnNames[type] + " " + allSQLTypes[type] + ",");
        }
        createSQL.append(ColumnNames[allSQLTypes.length - 1] + " " + allSQLTypes[allSQLTypes.length - 1] + ")");
        createTestDataSQL.append(ColumnNames[allSQLTypes.length - 1] + " " + allSQLTypes[allSQLTypes.length - 1] + ")");
        stmt.executeUpdate(createSQL.toString());
        stmt.executeUpdate(createTestDataSQL.toString());
        createSQL = new StringBuffer("insert into AllDataTypesForTestingTable values(");
        createTestDataSQL = new StringBuffer("insert into AllDataTypesNewValuesData values(");
        for (type = 0; type < allSQLTypes.length - 1; ++type) {
            createSQL.append(SQLData[type][0] + ",");
            createTestDataSQL.append(SQLData[type][1] + ",");
        }
        createSQL.append("cast(" + SQLData[allSQLTypes.length - 1][0] + " as BLOB(1K)))");
        createTestDataSQL.append("cast(" + SQLData[allSQLTypes.length - 1][1] + " as BLOB(1K)))");
        stmt.executeUpdate(createSQL.toString());
        stmt.executeUpdate(createTestDataSQL.toString());
        stmt.close();
    }

    private void verifyData(int sqlType, int updateXXXName) throws SQLException, UnsupportedEncodingException {
        PreparedStatement pstmt1 = this.prepareStatement("select * from AllDataTypesNewValuesData");
        ResultSet rs1 = pstmt1.executeQuery();
        rs1.next();
        PreparedStatement pstmt = this.prepareStatement("select * from AllDataTypesForTestingTable");
        ResultSet rs = pstmt.executeQuery();
        rs.next();
        if (updateXXXName == 18) {
            UpdatableResultSetTest.assertEquals((String)("FAIL - wrong value on " + allSQLTypes[sqlType - 1] + " using " + allUpdateXXXNames[updateXXXName - 1]), (boolean)rs.getBoolean(sqlType), (boolean)rs1.getBoolean(1));
        } else if (updateXXXName == 19) {
            UpdatableResultSetTest.assertNull((String)("FAIL - wrong value on " + allSQLTypes[sqlType - 1] + " using " + allUpdateXXXNames[updateXXXName - 1]), (Object)rs.getObject(sqlType));
            UpdatableResultSetTest.assertTrue((String)("FAIL - wrong value on " + allSQLTypes[sqlType - 1] + " using " + allUpdateXXXNames[updateXXXName - 1]), (boolean)rs.wasNull());
        } else if (sqlType == 1) {
            UpdatableResultSetTest.assertEquals((String)("FAIL - wrong value on " + allSQLTypes[sqlType - 1] + " using " + allUpdateXXXNames[updateXXXName - 1]), (short)rs1.getShort(updateXXXName), (short)rs.getShort(sqlType));
        } else if (sqlType == 2) {
            UpdatableResultSetTest.assertEquals((String)("FAIL - wrong value on " + allSQLTypes[sqlType - 1] + " using " + allUpdateXXXNames[updateXXXName - 1]), (int)rs1.getInt(updateXXXName), (int)rs.getInt(sqlType));
        } else if (sqlType == 3) {
            UpdatableResultSetTest.assertEquals((String)("FAIL - wrong value on " + allSQLTypes[sqlType - 1] + " using " + allUpdateXXXNames[updateXXXName - 1]), (long)rs1.getLong(updateXXXName), (long)rs.getLong(sqlType));
        } else if (sqlType == 4) {
            if (!JDBC.vmSupportsJSR169()) {
                UpdatableResultSetTest.assertTrue((String)("FAIL - wrong value on " + allSQLTypes[sqlType - 1] + rs.getBigDecimal(sqlType)), (rs.getBigDecimal(sqlType).doubleValue() == rs1.getBigDecimal(updateXXXName).doubleValue() ? 1 : 0) != 0);
            }
        } else if (sqlType == 5) {
            UpdatableResultSetTest.assertTrue((String)("FAIL - wrong value on " + allSQLTypes[sqlType - 1] + " using " + allUpdateXXXNames[updateXXXName - 1]), (rs.getFloat(sqlType) == rs1.getFloat(updateXXXName) ? 1 : 0) != 0);
        } else if (sqlType == 6) {
            Double d1 = rs.getDouble(sqlType);
            Double d2 = rs1.getDouble(updateXXXName);
            if (updateXXXName == 5) {
                UpdatableResultSetTest.assertTrue((String)("FAIL - wrong value on " + allSQLTypes[sqlType - 1] + " using " + allUpdateXXXNames[updateXXXName - 1]), (d1.floatValue() == d2.floatValue() ? 1 : 0) != 0);
            } else {
                UpdatableResultSetTest.assertTrue((String)("FAIL - wrong value on " + allSQLTypes[sqlType - 1] + " using " + allUpdateXXXNames[updateXXXName - 1]), (d1.doubleValue() == d2.doubleValue() ? 1 : 0) != 0);
            }
        } else if (sqlType == 7 || sqlType == 8 || sqlType == 9) {
            if (updateXXXName == 11) {
                String expected = new String(rs1.getBytes(updateXXXName), "UTF-16BE").trim();
                UpdatableResultSetTest.assertEquals((String)("FAIL - wrong value on " + allSQLTypes[sqlType - 1] + " using " + allUpdateXXXNames[updateXXXName - 1]), (String)expected, (String)rs.getString(sqlType).trim());
            } else {
                UpdatableResultSetTest.assertEquals((String)("FAIL - wrong value on " + allSQLTypes[sqlType - 1] + " using " + allUpdateXXXNames[updateXXXName - 1]), (String)rs1.getString(updateXXXName).trim(), (String)rs.getString(sqlType).trim());
            }
        } else if (sqlType == 10 || sqlType == 11 || sqlType == 12) {
            UpdatableResultSetTest.assertTrue((String)("FAIL - wrong value on " + allSQLTypes[sqlType - 1] + " using " + allUpdateXXXNames[updateXXXName - 1]), (boolean)Arrays.equals(rs.getBytes(sqlType), rs1.getBytes(updateXXXName)));
        } else if (sqlType == 13 && JDBC.vmSupportsJDBC3()) {
            Clob clob = rs.getClob(sqlType);
            int len = (int)clob.length();
            UpdatableResultSetTest.assertEquals((String)("FAIL - wrong value on " + allSQLTypes[sqlType - 1] + " using " + allUpdateXXXNames[updateXXXName - 1]), (String)rs1.getString(updateXXXName).trim(), (String)clob.getSubString(1L, len).trim());
        } else if (sqlType == 14) {
            UpdatableResultSetTest.assertEquals((String)("FAIL - wrong value on " + allSQLTypes[sqlType - 1] + " using " + allUpdateXXXNames[updateXXXName - 1]), (Object)rs1.getDate(updateXXXName), (Object)rs.getDate(sqlType));
        } else if (sqlType == 15) {
            UpdatableResultSetTest.assertEquals("FAIL - wrong value on " + allSQLTypes[sqlType - 1] + " using " + allUpdateXXXNames[updateXXXName - 1], rs1.getTime(updateXXXName), rs.getTime(sqlType));
        } else if (sqlType == 16) {
            UpdatableResultSetTest.assertEquals((String)("FAIL - wrong value on " + allSQLTypes[sqlType - 1] + " using " + allUpdateXXXNames[updateXXXName - 1]), (Object)rs1.getTimestamp(updateXXXName), (Object)rs.getTimestamp(sqlType));
        } else if (sqlType == 17 && JDBC.vmSupportsJDBC3()) {
            Blob blob = rs.getBlob(sqlType);
            long len = blob.length();
            UpdatableResultSetTest.assertTrue((String)("FAIL - wrong value on " + allSQLTypes[sqlType - 1] + " using " + allUpdateXXXNames[updateXXXName - 1]), (boolean)Arrays.equals(blob.getBytes(1L, (int)len), rs1.getBytes(updateXXXName)));
        }
        rs.close();
        rs1.close();
        this.closeStatement(pstmt);
        this.closeStatement(pstmt1);
    }

    private void resetData() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("delete from AllDataTypesForTestingTable");
        StringBuffer insertSQL = new StringBuffer("insert into AllDataTypesForTestingTable values(");
        for (int type = 0; type < allSQLTypes.length - 1; ++type) {
            insertSQL.append(SQLData[type][0] + ",");
        }
        insertSQL.append("cast(" + SQLData[allSQLTypes.length - 1][0] + " as BLOB(1K)))");
        stmt.executeUpdate(insertSQL.toString());
        this.closeStatement(stmt);
    }
}

