/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.SubqueryNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public abstract class BinaryComparisonOperatorNode
extends BinaryOperatorNode {
    private boolean forQueryRewrite;
    private boolean betweenSelectivity;

    BinaryComparisonOperatorNode(ValueNode leftOperand, ValueNode rightOperand, String operator, String methodName, boolean forQueryRewrite, ContextManager cm) throws StandardException {
        super(leftOperand, rightOperand, operator, methodName, "org.apache.derby.iapi.types.DataValueDescriptor", "org.apache.derby.iapi.types.DataValueDescriptor", cm);
        this.forQueryRewrite = forQueryRewrite;
    }

    void setForQueryRewrite(boolean val) {
        this.forQueryRewrite = val;
    }

    boolean getForQueryRewrite() {
        return this.forQueryRewrite;
    }

    void setBetweenSelectivity() {
        this.betweenSelectivity = true;
    }

    boolean getBetweenSelectivity() {
        return this.betweenSelectivity;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        super.bindExpression(fromList, subqueryList, aggregates);
        TypeId leftTypeId = this.leftOperand.getTypeId();
        TypeId rightTypeId = this.rightOperand.getTypeId();
        if (!leftTypeId.isStringTypeId() && rightTypeId.isStringTypeId()) {
            DataTypeDescriptor rightTypeServices = this.rightOperand.getTypeServices();
            this.rightOperand = new CastNode(this.rightOperand, new DataTypeDescriptor(rightTypeId, true, rightTypeServices.getMaximumWidth()), this.getContextManager());
            ((CastNode)this.rightOperand).bindCastNodeOnly();
        } else if (!rightTypeId.isStringTypeId() && leftTypeId.isStringTypeId()) {
            DataTypeDescriptor leftTypeServices = this.leftOperand.getTypeServices();
            this.leftOperand = new CastNode(this.leftOperand, new DataTypeDescriptor(leftTypeId, true, leftTypeServices.getMaximumWidth()), this.getContextManager());
            ((CastNode)this.leftOperand).bindCastNodeOnly();
        }
        this.bindComparisonOperator();
        return this;
    }

    void bindComparisonOperator() throws StandardException {
        boolean forEquals = this.operator.equals("=") || this.operator.equals("<>");
        boolean cmp = this.leftOperand.getTypeServices().comparable(this.rightOperand.getTypeServices(), forEquals, this.getClassFactory());
        if (!cmp && !this.forQueryRewrite) {
            throw StandardException.newException("42818", this.leftOperand.getTypeServices().getSQLTypeNameWithCollation(), this.rightOperand.getTypeServices().getSQLTypeNameWithCollation());
        }
        boolean nullableResult = this.leftOperand.getTypeServices().isNullable() || this.rightOperand.getTypeServices().isNullable();
        this.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, nullableResult));
    }

    @Override
    ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        this.leftOperand = this.leftOperand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        if (this.rightOperand instanceof SubqueryNode && !((SubqueryNode)this.rightOperand).getPreprocessed()) {
            ((SubqueryNode)this.rightOperand).setParentComparisonOperator(this);
            return this.rightOperand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        }
        this.rightOperand = this.rightOperand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        return this;
    }

    @Override
    ValueNode eliminateNots(boolean underNotNode) throws StandardException {
        if (!underNotNode) {
            return this;
        }
        return this.getNegation(this.leftOperand, this.rightOperand);
    }

    abstract BinaryOperatorNode getNegation(ValueNode var1, ValueNode var2) throws StandardException;

    abstract BinaryOperatorNode getSwappedEquivalent() throws StandardException;

    @Override
    ValueNode changeToCNF(boolean underTopAndNode) throws StandardException {
        if (underTopAndNode && this.rightOperand instanceof SubqueryNode) {
            this.rightOperand = this.rightOperand.changeToCNF(underTopAndNode);
        }
        return this;
    }

    @Override
    ValueNode genSQLJavaSQLTree() throws StandardException {
        TypeId rightTypeId;
        TypeId leftTypeId = this.leftOperand.getTypeId();
        if (leftTypeId.userType()) {
            if (this.leftOperand.getTypeServices().comparable(this.leftOperand.getTypeServices(), false, this.getClassFactory())) {
                return this;
            }
            this.leftOperand = this.leftOperand.genSQLJavaSQLTree();
        }
        if ((rightTypeId = this.rightOperand.getTypeId()).userType()) {
            if (this.rightOperand.getTypeServices().comparable(this.rightOperand.getTypeServices(), false, this.getClassFactory())) {
                return this;
            }
            this.rightOperand = this.rightOperand.genSQLJavaSQLTree();
        }
        return this;
    }
}

