/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.lucene;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.optional.lucene.DerbyIndexInput;
import org.apache.derby.optional.lucene.DerbyIndexOutput;
import org.apache.derby.optional.utils.ToolUtilities;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;

class DerbyLuceneDir
extends Directory {
    private final StorageFactory _storageFactory;
    private final StorageFile _directory;
    private final String _schema;
    private final String _table;
    private final String _textcol;
    private HashMap<String, DerbyIndexOutput> _outputFiles = new HashMap();
    private LockFactory _lockFactory;
    private boolean _closed = false;
    private static HashMap<String, DerbyLuceneDir> _openDirectories = new HashMap();

    static synchronized DerbyLuceneDir getDirectory(StorageFactory storageFactory, String schema, String table, String textcol) throws SQLException {
        DerbyLuceneDir candidate = new DerbyLuceneDir(storageFactory, schema, table, textcol);
        String key = DerbyLuceneDir.getKey(candidate);
        DerbyLuceneDir result = _openDirectories.get(key);
        if (result == null) {
            result = candidate;
            result.setLockFactory((LockFactory)new SingleInstanceLockFactory());
            _openDirectories.put(key, result);
        }
        return result;
    }

    private static synchronized void removeDir(DerbyLuceneDir dir) {
        _openDirectories.remove(DerbyLuceneDir.getKey(dir));
    }

    private static String getKey(DerbyLuceneDir dir) {
        return dir._directory.getPath();
    }

    private DerbyLuceneDir(StorageFactory storageFactory, String schema, String table, String textcol) throws SQLException {
        this._storageFactory = storageFactory;
        this._schema = schema;
        this._table = table;
        this._textcol = textcol;
        this._directory = DerbyLuceneDir.createPath(this._storageFactory, this._schema, this._table, this._textcol);
    }

    StorageFile getFile(String fileName) {
        return this._storageFactory.newStorageFile(this._directory, fileName);
    }

    StorageFile getDirectory() {
        return this._directory;
    }

    public void setLockFactory(LockFactory lockFactory) {
        this._lockFactory = lockFactory;
    }

    public LockFactory getLockFactory() {
        return this._lockFactory;
    }

    public void clearLock(String name) throws IOException {
        this._lockFactory.clearLock(name);
    }

    public Lock makeLock(String name) {
        return this._lockFactory.makeLock(name);
    }

    public void close() throws IOException {
        for (String fileName : this._outputFiles.keySet()) {
            this._outputFiles.get(fileName).close();
        }
        this._outputFiles.clear();
        this._closed = true;
        DerbyLuceneDir.removeDir(this);
    }

    public DerbyIndexOutput createOutput(String name, IOContext context) throws IOException {
        StorageFile file;
        this.checkIfClosed();
        DerbyIndexOutput indexOutput = this._outputFiles.get(name);
        if (indexOutput != null) {
            indexOutput.close();
        }
        if ((file = this.getStorageFile(name)).exists()) {
            this.deleteFile(name);
        }
        indexOutput = new DerbyIndexOutput(file, this);
        this._outputFiles.put(name, indexOutput);
        return indexOutput;
    }

    public void deleteFile(String name) throws IOException {
        this.checkIfClosed();
        StorageFile file = this.getStorageFile(name);
        if (file.exists() && !file.delete()) {
            throw this.newIOException("XBM0R.D", file.getPath());
        }
    }

    public boolean fileExists(String name) throws IOException {
        this.checkIfClosed();
        return this.getStorageFile(name).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long fileLength(String name) throws IOException {
        this.checkIfClosed();
        try (DerbyIndexInput indexInput = this.openInput(name, null);){
            long l = indexInput.length();
            return l;
        }
    }

    public String[] listAll() throws IOException {
        this.checkIfClosed();
        return this._directory.list();
    }

    public DerbyIndexInput openInput(String name, IOContext context) throws IOException {
        this.checkIfClosed();
        StorageFile file = this.getStorageFile(name);
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        return this.getIndexInput(file);
    }

    public void sync(Collection<String> names) throws IOException {
        for (String name : names) {
            DerbyIndexOutput indexOutput = this._outputFiles.get(name);
            if (indexOutput == null) continue;
            indexOutput.flush();
        }
    }

    void removeIndexOutput(String name) {
        this._outputFiles.remove(name);
    }

    private DerbyIndexInput getIndexInput(String name) throws IOException {
        return this.getIndexInput(this.getStorageFile(name));
    }

    private DerbyIndexInput getIndexInput(StorageFile file) throws IOException {
        return new DerbyIndexInput(file);
    }

    private StorageFile getStorageFile(String name) {
        return this._storageFactory.newStorageFile(this._directory, name);
    }

    private IOException newIOException(String sqlState, Object ... args) {
        return new IOException(ToolUtilities.newSQLException(sqlState, args).getMessage());
    }

    private void checkIfClosed() throws IOException {
        if (this._closed) {
            throw this.newIOException("40XD0", new Object[0]);
        }
    }

    private static StorageFile createPath(StorageFactory storageFactory, String schema, String table, String textcol) throws SQLException {
        StorageFile luceneDir = DerbyLuceneDir.createPathLeg(storageFactory, null, "LUCENE");
        StorageFile schemaDir = DerbyLuceneDir.createPathLeg(storageFactory, luceneDir, schema);
        StorageFile tableDir = DerbyLuceneDir.createPathLeg(storageFactory, schemaDir, table);
        StorageFile indexDir = DerbyLuceneDir.createPathLeg(storageFactory, tableDir, textcol);
        return indexDir;
    }

    private static StorageFile createPathLeg(final StorageFactory storageFactory, final StorageFile parentDir, final String fileName) throws SQLException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<StorageFile>(){

                @Override
                public StorageFile run() throws SQLException {
                    StorageFile file;
                    String normalizedName = ToolUtilities.derbyIdentifier(fileName);
                    StorageFile storageFile = file = parentDir == null ? storageFactory.newStorageFile(normalizedName) : storageFactory.newStorageFile(parentDir, normalizedName);
                    if (!file.exists()) {
                        file.mkdir();
                    }
                    if (!file.exists()) {
                        throw ToolUtilities.newSQLException("XBM0H.D", normalizedName);
                    }
                    return file;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (SQLException)pae.getCause();
        }
    }
}

