/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class NullSQLTextTest
extends BaseJDBCTestCase {
    private static String SQLSTATE_SYNTAX_ERROR = "42X01";

    public NullSQLTextTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("NullSQLTextTest");
        suite.addTest(NullSQLTextTest.baseSuite("NullSQLTextTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(NullSQLTextTest.baseSuite("NullSQLTextTest:client")));
        return suite;
    }

    private static Test baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        suite.addTestSuite(NullSQLTextTest.class);
        return new CleanDatabaseTestSetup((Test)suite){

            @Override
            protected void decorateSQL(Statement stmt) throws SQLException {
                Connection conn = this.getConnection();
                stmt.execute("create table t1 (i int)");
                stmt.execute("insert into t1 values 1, 2, 3, 4, 5, 6, 7");
                stmt.execute("create procedure za() language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.NullSQLTextTest.zeroArg' parameter style java");
            }
        };
    }

    public void testNullStringPreparedStatement() throws SQLException {
        String nullString = null;
        try {
            PreparedStatement ps = this.prepareStatement(nullString);
            NullSQLTextTest.fail((String)"preparedStatement(nullString) should have failed.");
        }
        catch (SQLException e) {
            NullSQLTextTest.assertSQLState("XJ067", e);
        }
    }

    public void testNullStringExecuteStatement() throws SQLException {
        String nullString = null;
        try {
            Statement stmt = this.createStatement();
            stmt.execute(nullString);
            NullSQLTextTest.fail((String)"execute(nullString) should have failed.");
        }
        catch (SQLException e) {
            NullSQLTextTest.assertSQLState("XJ067", e);
        }
    }

    public void testNullStringExecuteQueryStatement() throws SQLException {
        String nullString = null;
        try {
            Statement stmt = this.createStatement();
            stmt.executeQuery(nullString);
            NullSQLTextTest.fail((String)"executeQuery(nullString) should have failed.");
        }
        catch (SQLException e) {
            NullSQLTextTest.assertSQLState("XJ067", e);
        }
    }

    public void testNullStringExecuteUpdateStatement() throws SQLException {
        String nullString = null;
        try {
            Statement stmt = this.createStatement();
            stmt.executeUpdate(nullString);
            NullSQLTextTest.fail((String)"executeUpdate(nullString) should have failed.");
        }
        catch (SQLException e) {
            NullSQLTextTest.assertSQLState("XJ067", e);
        }
    }

    public void testDerby522() throws SQLException {
        Statement stmt = this.createStatement();
        NullSQLTextTest.testCommentStmt(stmt, " --", true);
        NullSQLTextTest.testCommentStmt(stmt, " -- ", true);
        NullSQLTextTest.testCommentStmt(stmt, " -- This is a comment \n --", true);
        NullSQLTextTest.testCommentStmt(stmt, " -- This is a comment\n --And another\n -- Andonemore", true);
        NullSQLTextTest.testCommentStmt(stmt, " --\nvalues 2, 4, 8", false);
        ResultSet rs = stmt.getResultSet();
        String[][] expectedRows = new String[][]{{"2"}, {"4"}, {"8"}};
        JDBC.assertFullResultSet(rs, expectedRows);
        NullSQLTextTest.testCommentStmt(stmt, " -- This is \n -- \n --3 comments\nvalues 8", false);
        rs = stmt.getResultSet();
        expectedRows = new String[][]{{"8"}};
        JDBC.assertFullResultSet(rs, expectedRows);
        NullSQLTextTest.testCommentStmt(stmt, " -- This is a comment\n --And another\n -- Andonemore\nvalues (2,3)", false);
        rs = stmt.getResultSet();
        ResultSetMetaData rsmd = rs.getMetaData();
        expectedRows = new String[][]{{"2", "3"}};
        JDBC.assertFullResultSet(rs, expectedRows);
        NullSQLTextTest.testCommentStmt(stmt, " -- This is a comment\n select i from t1", false);
        rs = stmt.getResultSet();
        expectedRows = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}, {"7"}};
        JDBC.assertFullResultSet(rs, expectedRows);
        NullSQLTextTest.testCommentStmt(stmt, " --singleword\n insert into t1 values (8)", false);
        rs = stmt.getResultSet();
        NullSQLTextTest.assertNull((String)"Unexpected Not Null ResultSet", (Object)rs);
        NullSQLTextTest.testCommentStmt(stmt, " --singleword\ncall za()", false);
        NullSQLTextTest.assertNull((String)"Unexpected Not Null ResultSet", (Object)rs);
        NullSQLTextTest.testCommentStmt(stmt, " -- leading comment\n(\nvalues 4, 8)", false);
        rs = stmt.getResultSet();
        expectedRows = new String[][]{{"4"}, {"8"}};
        JDBC.assertFullResultSet(rs, expectedRows);
        NullSQLTextTest.testCommentStmt(stmt, " -- leading comment\n\n(\n\n\rvalues 4, 8)", false);
        rs = stmt.getResultSet();
        expectedRows = new String[][]{{"4"}, {"8"}};
        JDBC.assertFullResultSet(rs, expectedRows);
        NullSQLTextTest.testCommentStmt(stmt, "select i from t1 -- This is a comment", false);
        rs = stmt.getResultSet();
        expectedRows = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}, {"7"}, {"8"}};
        JDBC.assertFullResultSet(rs, expectedRows);
        NullSQLTextTest.testCommentStmt(stmt, "select i from t1\n -- This is a comment", false);
        rs = stmt.getResultSet();
        expectedRows = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}, {"7"}, {"8"}};
        JDBC.assertFullResultSet(rs, expectedRows);
        NullSQLTextTest.testCommentStmt(stmt, "values 8, 4, 2\n --", false);
        rs = stmt.getResultSet();
        expectedRows = new String[][]{{"8"}, {"4"}, {"2"}};
        JDBC.assertFullResultSet(rs, expectedRows);
        NullSQLTextTest.testCommentStmt(stmt, "values 8, 4,\n -- middle comment\n2\n -- end", false);
        rs = stmt.getResultSet();
        expectedRows = new String[][]{{"8"}, {"4"}, {"2"}};
        JDBC.assertFullResultSet(rs, expectedRows);
        NullSQLTextTest.testCommentStmt(stmt, "values 8, 4,\n -- middle comment\n2\n -- end\n", false);
        rs = stmt.getResultSet();
        expectedRows = new String[][]{{"8"}, {"4"}, {"2"}};
        JDBC.assertFullResultSet(rs, expectedRows);
    }

    private static void testCommentStmt(Statement st, String sql, boolean expectFailure) throws SQLException {
        try {
            st.execute(sql);
            if (expectFailure) {
                NullSQLTextTest.fail((String)"Unexpected Failure -- execute() should have failed.");
            }
        }
        catch (SQLException se) {
            NullSQLTextTest.assertSQLState("42X01", se);
        }
    }

    public static void zeroArg() {
    }

    public void testExecuteEmptyString() throws SQLException {
        try {
            this.createStatement().execute("");
            NullSQLTextTest.fail((String)"Statement expected to fail");
        }
        catch (SQLException sqle) {
            NullSQLTextTest.assertSQLState(SQLSTATE_SYNTAX_ERROR, sqle);
        }
    }

    public void testExecuteUpdateEmptyString() {
        try {
            this.createStatement().executeUpdate("");
            NullSQLTextTest.fail((String)"Statement expected to fail");
        }
        catch (SQLException sqle) {
            NullSQLTextTest.assertSQLState(SQLSTATE_SYNTAX_ERROR, sqle);
        }
    }

    public void testExecuteQueryEmptyString() {
        try {
            this.createStatement().executeQuery("");
            NullSQLTextTest.fail((String)"Statement expected to fail");
        }
        catch (SQLException sqle) {
            NullSQLTextTest.assertSQLState(SQLSTATE_SYNTAX_ERROR, sqle);
        }
    }

    public void testPrepareEmptyString() {
        try {
            this.prepareStatement("");
            NullSQLTextTest.fail((String)"Statement expected to fail");
        }
        catch (SQLException sqle) {
            NullSQLTextTest.assertSQLState(SQLSTATE_SYNTAX_ERROR, sqle);
        }
    }
}

