/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ScrollCursors2Test
extends BaseJDBCTestCase {
    private static boolean isDerbyNetClient = ScrollCursors2Test.usingDerbyNetClient();

    public ScrollCursors2Test(String name) {
        super(name);
    }

    public void setUp() throws SQLException {
        Statement s_i_r = this.createStatement(1004, 1007);
        s_i_r.execute("create table t (i int, c50 char(50))");
        s_i_r.execute("insert into t (i) values (2), (3), (4), (5), (6)");
        s_i_r.execute("update t set c50 = RTRIM(CAST (i AS CHAR(50)))");
        s_i_r.close();
        isDerbyNetClient = ScrollCursors2Test.usingDerbyNetClient();
    }

    @Override
    public void tearDown() throws SQLException, Exception {
        this.dropTable("T");
        this.commit();
        super.tearDown();
    }

    public void testForwardOnlyNegative() throws SQLException {
        Connection conn = this.getConnection();
        PreparedStatement ps_f_r = null;
        Statement s_f_r = null;
        s_f_r = this.createStatement(1003, 1007);
        JDBC.assertNoWarnings(conn.getWarnings());
        conn.clearWarnings();
        try {
            s_f_r.setMaxRows(-1);
            ScrollCursors2Test.fail((String)"setMaxRows(-1) expected to fail");
        }
        catch (SQLException sqle) {
            ScrollCursors2Test.assertEquals((String)"XJ063", (String)sqle.getSQLState());
        }
        ScrollCursors2Test.assertEquals((String)"getMaxRows() expected to return 0", (int)0, (int)s_f_r.getMaxRows());
        ResultSet rs = s_f_r.executeQuery("select * from t");
        ScrollCursors2Test.assertEquals((int)1003, (int)rs.getType());
        ScrollCursors2Test.assertEquals((int)1007, (int)rs.getConcurrency());
        try {
            rs.first();
            ScrollCursors2Test.fail((String)"first() expected to fail");
        }
        catch (SQLException sqle) {
            this.assertOnlyOnScrollableException(sqle);
        }
        try {
            rs.beforeFirst();
            ScrollCursors2Test.fail((String)"beforeFirst() expected to fail");
        }
        catch (SQLException sqle) {
            this.assertOnlyOnScrollableException(sqle);
        }
        try {
            rs.isBeforeFirst();
            ScrollCursors2Test.fail((String)"isBeforeFirst() expected to fail");
        }
        catch (SQLException sqle) {
            this.assertOnlyOnScrollableException(sqle);
        }
        try {
            rs.isAfterLast();
            ScrollCursors2Test.fail((String)"isAfterLast() expected to fail");
        }
        catch (SQLException sqle) {
            this.assertOnlyOnScrollableException(sqle);
        }
        try {
            rs.isFirst();
            ScrollCursors2Test.fail((String)"isFirst() expected to fail");
        }
        catch (SQLException sqle) {
            this.assertOnlyOnScrollableException(sqle);
        }
        try {
            rs.isLast();
            ScrollCursors2Test.fail((String)"isLast() expected to fail");
        }
        catch (SQLException sqle) {
            this.assertOnlyOnScrollableException(sqle);
        }
        try {
            rs.absolute(1);
            ScrollCursors2Test.fail((String)"absolute() expected to fail");
        }
        catch (SQLException sqle) {
            this.assertOnlyOnScrollableException(sqle);
        }
        try {
            rs.relative(1);
            ScrollCursors2Test.fail((String)"relative() expected to fail");
        }
        catch (SQLException sqle) {
            this.assertOnlyOnScrollableException(sqle);
        }
        try {
            rs.setFetchDirection(1000);
            ScrollCursors2Test.fail((String)"setFetchDirection() expected to fail");
        }
        catch (SQLException sqle) {
            this.assertOnlyOnScrollableException(sqle);
        }
        if (isDerbyNetClient) {
            ScrollCursors2Test.assertEquals((int)0, (int)rs.getFetchSize());
        } else {
            ScrollCursors2Test.assertEquals((int)1, (int)rs.getFetchSize());
        }
        rs.setFetchSize(5);
        ScrollCursors2Test.assertEquals((int)5, (int)rs.getFetchSize());
        ScrollCursors2Test.assertEquals((int)1000, (int)rs.getFetchDirection());
        rs.close();
        s_f_r.close();
        ps_f_r = this.prepareStatement("select * from t", 1003, 1007);
        JDBC.assertNoWarnings(conn.getWarnings());
        conn.clearWarnings();
        rs = ps_f_r.executeQuery();
        ScrollCursors2Test.assertEquals((int)1003, (int)rs.getType());
        ScrollCursors2Test.assertEquals((int)1007, (int)rs.getConcurrency());
        try {
            rs.first();
            ScrollCursors2Test.fail((String)"first() expected to fail");
        }
        catch (SQLException sqle) {
            this.assertOnlyOnScrollableException(sqle);
        }
        rs.close();
        ps_f_r.close();
    }

    public void testForwardOnlyPositive() throws SQLException {
        Connection conn = this.getConnection();
        Statement s_f_r = this.createStatement(1003, 1007);
        JDBC.assertNoWarnings(conn.getWarnings());
        conn.clearWarnings();
        s_f_r.setMaxRows(5);
        ScrollCursors2Test.assertEquals((int)5, (int)s_f_r.getMaxRows());
        ResultSet rs = s_f_r.executeQuery("values 1, 2, 3, 4, 5, 6");
        JDBC.assertDrainResults(rs, 5);
        s_f_r.close();
    }

    public void testScrollSensitive() throws SQLException {
        Connection conn = this.getConnection();
        Statement s_s_r = null;
        Statement s_s_u = null;
        s_s_r = this.createStatement(1005, 1007);
        SQLWarning warning = conn.getWarnings();
        ScrollCursors2Test.assertNotNull((Object)warning);
        conn.clearWarnings();
        ResultSet rs = s_s_r.executeQuery("select * from t");
        ScrollCursors2Test.assertEquals((int)1004, (int)rs.getType());
        ScrollCursors2Test.assertEquals((int)1007, (int)rs.getConcurrency());
        rs.close();
        s_s_r.close();
        s_s_u = this.createStatement(1005, 1008);
        warning = conn.getWarnings();
        ScrollCursors2Test.assertNotNull((Object)warning);
        conn.clearWarnings();
        rs = s_s_u.executeQuery("select * from t");
        ScrollCursors2Test.assertEquals((int)1004, (int)rs.getType());
        ScrollCursors2Test.assertEquals((int)1008, (int)rs.getConcurrency());
        rs.close();
    }

    public void testScrollInsensitivePositive() throws SQLException {
        int index;
        Connection conn = this.getConnection();
        Statement s_i_r = this.createStatement(1004, 1007);
        JDBC.assertNoWarnings(conn.getWarnings());
        conn.clearWarnings();
        ResultSet rs = s_i_r.executeQuery("select * from t");
        ScrollCursors2Test.assertEquals((int)1004, (int)rs.getType());
        ScrollCursors2Test.assertEquals((int)1007, (int)rs.getConcurrency());
        ScrollCursors2Test.assertTrue((boolean)rs.isBeforeFirst());
        ScrollCursors2Test.assertFalse((boolean)rs.absolute(0));
        ScrollCursors2Test.assertTrue((boolean)rs.isBeforeFirst());
        ScrollCursors2Test.assertTrue((boolean)rs.first());
        ScrollCursors2Test.assertEquals((int)rs.getInt(1), (int)2);
        ScrollCursors2Test.assertTrue((boolean)rs.isFirst());
        rs.beforeFirst();
        ScrollCursors2Test.assertTrue((boolean)rs.isBeforeFirst());
        ScrollCursors2Test.assertTrue((boolean)rs.last());
        ScrollCursors2Test.assertTrue((boolean)rs.isLast());
        ScrollCursors2Test.assertFalse((boolean)rs.isAfterLast());
        ScrollCursors2Test.assertEquals((int)6, (int)rs.getInt(1));
        ScrollCursors2Test.assertFalse((String)"not expecting to find another row", (boolean)rs.next());
        ScrollCursors2Test.assertTrue((boolean)rs.isAfterLast());
        ScrollCursors2Test.assertFalse((boolean)rs.isLast());
        ScrollCursors2Test.assertFalse((boolean)rs.isFirst());
        ScrollCursors2Test.assertFalse((boolean)rs.isBeforeFirst());
        ScrollCursors2Test.assertEquals((int)1000, (int)rs.getFetchDirection());
        rs.setFetchDirection(1002);
        ScrollCursors2Test.assertEquals((int)1002, (int)rs.getFetchDirection());
        if (isDerbyNetClient) {
            ScrollCursors2Test.assertEquals((int)64, (int)rs.getFetchSize());
        } else {
            ScrollCursors2Test.assertEquals((int)1, (int)rs.getFetchSize());
        }
        rs.setFetchSize(5);
        ScrollCursors2Test.assertEquals((int)5, (int)rs.getFetchSize());
        rs.setFetchSize(0);
        if (isDerbyNetClient) {
            ScrollCursors2Test.assertEquals((int)64, (int)rs.getFetchSize());
        } else {
            ScrollCursors2Test.assertEquals((int)5, (int)rs.getFetchSize());
        }
        rs.close();
        rs = s_i_r.executeQuery("select * from t where 1=0");
        rs.afterLast();
        ScrollCursors2Test.assertFalse((String)"afterLast() on empty RS should be no-op", (boolean)rs.isAfterLast());
        rs.beforeFirst();
        ScrollCursors2Test.assertFalse((String)"beforeFirst() on empty RS should be no-op", (boolean)rs.isBeforeFirst());
        rs.close();
        PreparedStatement ps_i_r = this.prepareStatement("select * from t", 1004, 1007);
        JDBC.assertNoWarnings(conn.getWarnings());
        rs = ps_i_r.executeQuery();
        rs.last();
        rs.close();
        ps_i_r.close();
        ScrollCursors2Test.assertEquals((int)0, (int)s_i_r.getMaxRows());
        s_i_r.setMaxRows(5);
        ScrollCursors2Test.assertEquals((int)5, (int)s_i_r.getMaxRows());
        rs = s_i_r.executeQuery("values 1, 2, 3, 4, 5, 6");
        ScrollCursors2Test.assertNotNull((Object)rs);
        for (index = 1; index < 6; ++index) {
            ScrollCursors2Test.assertTrue((boolean)rs.next());
        }
        ScrollCursors2Test.assertFalse((boolean)rs.next());
        rs.close();
        rs = s_i_r.executeQuery("values 1, 2, 3, 4, 5, 6");
        ScrollCursors2Test.assertNotNull((Object)rs);
        ScrollCursors2Test.assertTrue((boolean)rs.last());
        for (index = 1; index < 5; ++index) {
            ScrollCursors2Test.assertTrue((boolean)rs.previous());
        }
        ScrollCursors2Test.assertFalse((boolean)rs.previous());
        rs.close();
        rs = s_i_r.executeQuery("values 1, 2, 3, 4, 5, 6");
        ScrollCursors2Test.assertNotNull((Object)rs);
        rs.afterLast();
        for (index = 1; index < 6; ++index) {
            ScrollCursors2Test.assertTrue((boolean)rs.previous());
        }
        ScrollCursors2Test.assertFalse((boolean)rs.previous());
        rs.close();
        s_i_r.setMaxRows(0);
        rs = s_i_r.executeQuery("values 1, 2, 3, 4, 5, 6");
        ScrollCursors2Test.assertNotNull((Object)rs);
        for (index = 1; index < 7; ++index) {
            ScrollCursors2Test.assertTrue((boolean)rs.next());
        }
        ScrollCursors2Test.assertFalse((boolean)rs.next());
        rs.close();
    }

    public void testScrollInsensitiveNegative() throws SQLException {
        Connection conn = this.getConnection();
        Statement s_i_r = this.createStatement(1004, 1007);
        JDBC.assertNoWarnings(conn.getWarnings());
        conn.clearWarnings();
        try {
            s_i_r.setMaxRows(-1);
            ScrollCursors2Test.fail((String)"setMaxRows(-1) expected to fail");
        }
        catch (SQLException sqle) {
            ScrollCursors2Test.assertEquals((String)"XJ063", (String)sqle.getSQLState());
        }
        ScrollCursors2Test.assertEquals((int)0, (int)s_i_r.getMaxRows());
        ResultSet rs = s_i_r.executeQuery("select * from t where 1=0");
        ScrollCursors2Test.assertFalse((boolean)rs.isBeforeFirst());
        ScrollCursors2Test.assertFalse((boolean)rs.next());
        ScrollCursors2Test.assertFalse((boolean)rs.previous());
        ScrollCursors2Test.assertFalse((boolean)rs.isAfterLast());
        ScrollCursors2Test.assertFalse((boolean)rs.isFirst());
        ScrollCursors2Test.assertFalse((boolean)rs.isLast());
        ScrollCursors2Test.assertFalse((boolean)rs.relative(0));
        ScrollCursors2Test.assertFalse((boolean)rs.relative(1));
        ScrollCursors2Test.assertFalse((boolean)rs.relative(-1));
        ScrollCursors2Test.assertFalse((boolean)rs.absolute(0));
        ScrollCursors2Test.assertFalse((boolean)rs.absolute(1));
        ScrollCursors2Test.assertFalse((boolean)rs.absolute(-1));
        rs.close();
        rs = s_i_r.executeQuery("select * from t");
        try {
            rs.setFetchSize(-5);
            ScrollCursors2Test.fail((String)"setFetchSize(-5) expected to fail");
        }
        catch (SQLException sqle) {
            ScrollCursors2Test.assertEquals((String)"XJ062", (String)sqle.getSQLState());
        }
        rs.close();
        s_i_r.close();
    }

    public void testCallableStatements() throws SQLException {
        Connection conn = this.getConnection();
        CallableStatement cs_s_r = null;
        CallableStatement cs_s_u = null;
        CallableStatement cs_i_r = null;
        CallableStatement cs_f_r = null;
        cs_s_r = this.prepareCall("values cast (? as Integer)", 1005, 1007);
        SQLWarning warning = conn.getWarnings();
        ScrollCursors2Test.assertNotNull((Object)warning);
        if (!isDerbyNetClient) {
            ScrollCursors2Test.assertEquals((String)"01J02", (String)warning.getSQLState());
        } else {
            ScrollCursors2Test.assertEquals((String)"01J10", (String)warning.getSQLState());
        }
        JDBC.assertNoWarnings(warning.getNextWarning());
        conn.clearWarnings();
        cs_s_r.close();
        cs_s_u = this.prepareCall("values cast (? as Integer)", 1005, 1008);
        warning = conn.getWarnings();
        ScrollCursors2Test.assertNotNull((Object)warning);
        if (!isDerbyNetClient) {
            ScrollCursors2Test.assertEquals((String)"01J02", (String)warning.getSQLState());
        } else {
            ScrollCursors2Test.assertEquals((String)"01J10", (String)warning.getSQLState());
        }
        JDBC.assertNoWarnings(warning.getNextWarning());
        conn.clearWarnings();
        cs_s_u.close();
        cs_i_r = this.prepareCall("values cast (? as Integer)", 1004, 1007);
        JDBC.assertNoWarnings(conn.getWarnings());
        conn.clearWarnings();
        cs_i_r.close();
        cs_f_r = this.prepareCall("values cast (? as Integer)", 1003, 1007);
        JDBC.assertNoWarnings(conn.getWarnings());
        conn.clearWarnings();
        cs_f_r.close();
    }

    public void testGetMetaData() throws SQLException {
        PreparedStatement ps_f_r = null;
        ps_f_r = this.prepareStatement("select c50, i, 43 from t", 1003, 1007);
        ResultSetMetaData rsmd_ps = ps_f_r.getMetaData();
        ScrollCursors2Test.assertNotNull((Object)rsmd_ps);
        ResultSet rs = ps_f_r.executeQuery();
        ResultSetMetaData rsmd_rs = rs.getMetaData();
        ScrollCursors2Test.assertNotNull((Object)rsmd_rs);
        ScrollCursors2Test.assertEquals((int)rsmd_ps.getColumnCount(), (int)rsmd_rs.getColumnCount());
        ScrollCursors2Test.assertEquals((String)rsmd_ps.getColumnName(2), (String)rsmd_rs.getColumnName(2));
        ScrollCursors2Test.assertEquals((boolean)rsmd_ps.isReadOnly(2), (boolean)rsmd_rs.isReadOnly(2));
        rs.close();
        ps_f_r.close();
    }

    public void testScrollVerifyMaxRowWithFetchSize() throws SQLException {
        this.scrollVerifyMaxRowWithFetchSize(10, 10);
        this.scrollVerifyMaxRowWithFetchSize(10, 5);
        this.scrollVerifyMaxRowWithFetchSize(10, 0);
        this.scrollVerifyMaxRowWithFetchSize(0, 0);
        this.scrollVerifyMaxRowWithFetchSize(0, 5);
        this.scrollVerifyMaxRowWithFetchSize(0, 10);
        this.scrollVerifyMaxRowWithFetchSize(0, 15);
    }

    private void scrollVerifyMaxRowWithFetchSize(int maxRows, int fetchSize) throws SQLException {
        int index;
        Statement s_i_r = this.createStatement(1004, 1007);
        s_i_r.setMaxRows(maxRows);
        ResultSet rs = s_i_r.executeQuery("values 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15");
        rs.setFetchSize(fetchSize);
        s_i_r.setMaxRows(2);
        if (maxRows == 0) {
            maxRows = 15;
        }
        ScrollCursors2Test.assertNotNull((Object)rs);
        for (index = 1; index < maxRows + 1; ++index) {
            ScrollCursors2Test.assertTrue((String)("rs.next() failed, index = " + index), (boolean)rs.next());
            ScrollCursors2Test.assertEquals((int)index, (int)rs.getInt(1));
        }
        ScrollCursors2Test.assertFalse((boolean)rs.next());
        ScrollCursors2Test.assertTrue((boolean)rs.first());
        for (index = 1; index < maxRows; ++index) {
            ScrollCursors2Test.assertTrue((boolean)rs.next());
            ScrollCursors2Test.assertEquals((int)(index + 1), (int)rs.getInt(1));
        }
        ScrollCursors2Test.assertFalse((boolean)rs.next());
        rs.afterLast();
        for (index = 1; index < maxRows + 1; ++index) {
            ScrollCursors2Test.assertTrue((boolean)rs.previous());
            ScrollCursors2Test.assertEquals((int)(maxRows - index + 1), (int)rs.getInt(1));
        }
        ScrollCursors2Test.assertFalse((boolean)rs.previous());
        ScrollCursors2Test.assertTrue((boolean)rs.last());
        for (index = 1; index < maxRows; ++index) {
            ScrollCursors2Test.assertTrue((boolean)rs.previous());
            ScrollCursors2Test.assertEquals((int)(maxRows - index), (int)rs.getInt(1));
        }
        ScrollCursors2Test.assertFalse((boolean)rs.previous());
        rs.last();
        int rows = rs.getRow();
        rs.absolute(rows / 2);
        ScrollCursors2Test.assertFalse((boolean)rs.relative(-1 * rows));
        ScrollCursors2Test.assertTrue((boolean)rs.isBeforeFirst());
        rs.absolute(rows / 2);
        ScrollCursors2Test.assertFalse((boolean)rs.relative(rows));
        ScrollCursors2Test.assertTrue((boolean)rs.isAfterLast());
        rs.absolute(rows / 2);
        ScrollCursors2Test.assertFalse((String)("absolute(" + (rows + 1) + ") should return false, position outside of the resultSet"), (boolean)rs.absolute(rows + 1));
        rs.absolute(rows / 2);
        ScrollCursors2Test.assertFalse((boolean)rs.absolute(-1 * (rows + 1)));
        ScrollCursors2Test.assertTrue((boolean)rs.isBeforeFirst());
        rs.close();
    }

    private void assertOnlyOnScrollableException(SQLException sqle) {
        if (!isDerbyNetClient) {
            ScrollCursors2Test.assertEquals((String)"XJ061", (String)sqle.getSQLState());
        } else {
            ScrollCursors2Test.assertEquals((String)"XJ125", (String)sqle.getSQLState());
        }
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(ScrollCursors2Test.class);
    }
}

