/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.functionTests.tests.derbynet.DerbyNetAutoStartTest;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.ClassLoaderTestSetup;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SpawnedProcess;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SecureServerTest
extends BaseJDBCTestCase {
    private static final String BASIC = "functionTests/tests/derbynet/SecureServerTest.derby.properties";
    private static final String SST_USER_NAME = "MARY";
    private static final String SST_PASSWORD = "marypwd";
    private static final String HOSTW = "0.0.0.0";
    private static final String ALTW = "0.00.000.0";
    private static final String IPV6W = "::";
    private static final Outcome RUNNING_SECURITY_NOT_BOOTED = new Outcome(true, "");
    private static final Outcome RUNNING_SECURITY_BOOTED = new Outcome(true, SecureServerTest.serverBootedOK());
    private NetworkServerTestSetup nsTestSetup;
    private boolean _unsecureSet;
    private boolean _authenticationRequired;
    private String _customDerbyProperties;
    private String _wildCardHost;
    private Outcome _outcome;
    static final String POLICY6619 = "org/apache/derbyTesting/functionTests/tests/derbynet/SecureServerTest.policy";
    final String[] expected6619 = new String[]{"WARNING: cannot set the context class loader due to a security exception:", "This may lead to class loader leak"};

    public SecureServerTest(boolean bl, boolean bl2, String string, String string2, Outcome outcome) {
        super("testServerStartup");
        this._unsecureSet = bl;
        this._authenticationRequired = bl2;
        this._customDerbyProperties = string;
        this._wildCardHost = string2;
        this._outcome = outcome;
    }

    public SecureServerTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("SecureServerTest");
        if (!TestConfiguration.loadingFromJars()) {
            return baseTestSuite;
        }
        if (!Derby.hasServer()) {
            return baseTestSuite;
        }
        baseTestSuite.addTest(SecureServerTest.decorateTest(false, false, null, null, RUNNING_SECURITY_BOOTED));
        baseTestSuite.addTest(SecureServerTest.decorateTest(false, false, BASIC, null, RUNNING_SECURITY_BOOTED));
        baseTestSuite.addTest(SecureServerTest.decorateTest(false, true, null, null, RUNNING_SECURITY_BOOTED));
        baseTestSuite.addTest(SecureServerTest.decorateTest(false, true, null, HOSTW, RUNNING_SECURITY_BOOTED));
        baseTestSuite.addTest(SecureServerTest.decorateTest(false, true, null, ALTW, RUNNING_SECURITY_BOOTED));
        baseTestSuite.addTest(SecureServerTest.makeDerby6619Test());
        return baseTestSuite;
    }

    private static Test decorateTest(boolean bl, boolean bl2, String string, String string2, Outcome outcome) {
        NetworkServerTestSetup networkServerTestSetup;
        SecureServerTest secureServerTest = new SecureServerTest(bl, bl2, string, string2, outcome);
        String[] stringArray = SecureServerTest.getStartupProperties(bl2, string);
        String[] stringArray2 = SecureServerTest.getStartupArgs(bl, string2);
        secureServerTest.nsTestSetup = networkServerTestSetup = new NetworkServerTestSetup((Test)secureServerTest, stringArray, stringArray2, secureServerTest._outcome.serverShouldComeUp());
        Object object = SecurityManagerSetup.noSecurityManager((Test)networkServerTestSetup);
        if (string != null) {
            object = new SupportFilesSetup((Test)object, null, new String[]{BASIC}, null, new String[]{"derby.properties"});
        }
        Test test = TestConfiguration.defaultServerDecorator(object);
        test = TestConfiguration.changeUserDecorator(test, SST_USER_NAME, SST_PASSWORD);
        return test;
    }

    private static String[] getStartupArgs(boolean bl, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            arrayList.add("-noSecurityManager");
        }
        if (string != null) {
            arrayList.add("-h");
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String[] getStartupProperties(boolean bl, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            arrayList.add("derby.connection.requireAuthentication=true");
            arrayList.add("derby.authentication.provider=BUILTIN");
            arrayList.add("derby.user.MARY=marypwd");
        }
        if (string != null) {
            arrayList.add("derby.system.home=extinout");
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static Test makeDerby6619Test() {
        Object object = new SecureServerTest("test6619");
        object = TestConfiguration.clientServerDecorator((Test)object);
        object = new SecurityManagerSetup((Test)object, POLICY6619);
        object = new ClassLoaderTestSetup((Test)object);
        return object;
    }

    public void test6619() throws Exception {
        NetworkServerControl networkServerControl = NetworkServerTestSetup.getNetworkServerControl();
        NetworkServerTestSetup.waitForServerStart(networkServerControl);
        this.assertWarningDerby6619("derby.system.home", true);
    }

    public void testServerStartup() throws Exception {
        String string = this.toString();
        boolean bl = this.serverCameUp();
        String string2 = this.getServerOutput();
        boolean bl2 = string2.indexOf(this._outcome.expectedServerOutput()) >= 0;
        SecureServerTest.assertEquals((String)(string + ": serverCameUp = " + bl), (boolean)this._outcome.serverShouldComeUp(), (boolean)bl);
        this.assertWarningDerby6619("user.dir", false);
        if (!SecureServerTest.runsWithEmma() && !SecureServerTest.runsWithJaCoCo()) {
            SecureServerTest.assertTrue((String)(string + "\nExpected: " + this._outcome.expectedServerOutput() + "\nBut saw: " + string2), (boolean)bl2);
        }
        if (this._authenticationRequired && this._wildCardHost != null) {
            this.connectToServer();
        }
        this.runsysinfo();
        this.enableTracing();
        this.setTraceDirectory();
        this.disableTracing();
    }

    private void disableTracing() throws Exception {
        String string = this.runServerCommand(new String[]{"trace", "off"});
        SecureServerTest.println("Output for trace off command:\n\n" + string);
        if (string.indexOf("Trace turned off for all sessions.") < 0) {
            SecureServerTest.fail((String)("Failed to turn trace off:\n\n:" + string));
        }
    }

    private void setTraceDirectory() throws Exception {
        String string;
        String string2 = this.runServerCommand(new String[]{"tracedirectory", "trace"});
        SecureServerTest.println("Output for tracedirectory trace command:\n\n" + string2);
        if (string2.indexOf("Trace directory changed to trace.") < 0) {
            SecureServerTest.fail((String)("Unexpected output in setting trace directory:" + string2));
        }
        if ((string = this.runServerCommand(new String[]{"ping"})).indexOf("Connection obtained for host:") < 0) {
            SecureServerTest.fail((String)("Failed ping after changing trace directory: " + string));
        }
        SecureServerTest.assertTrue((String)"directory trace does not exist", (boolean)PrivilegedFileOpsForTests.exists(new File("trace")));
    }

    private void connectToServer() throws Exception {
        TestConfiguration testConfiguration = this.getTestConfiguration();
        String string = "jdbc:derby://localhost:" + testConfiguration.getPort() + "/wombat;create=true;user=" + testConfiguration.getUserName() + ";password=" + testConfiguration.getUserPassword();
        SecureServerTest.println("XXX in connectToServer(). url = " + string);
        Class.forName("org.apache.derby.jdbc.ClientDriver");
        Connection connection = DriverManager.getConnection(string);
        SecureServerTest.assertNotNull((String)"Connection should not be null...", (Object)connection);
        connection.close();
    }

    private void runsysinfo() throws Exception {
        String string = this.runServerCommand(new String[]{"sysinfo"});
        if (string.indexOf("Security Exception:") > -1) {
            SecureServerTest.fail((String)("Security exceptions in sysinfo output:\n\n:" + string));
        }
    }

    private void enableTracing() throws Exception {
        String string = this.runServerCommand(new String[]{"trace", "on"});
        SecureServerTest.println("Output for trace on command:\n\n" + string);
        if (string.indexOf("Trace turned on for all sessions.") < 0) {
            SecureServerTest.fail((String)("Security exceptions in output of trace enabling command:\n\n:" + string));
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SecureServerTest( ");
        stringBuilder.append("Opened = ");
        stringBuilder.append(this._unsecureSet);
        stringBuilder.append(", Authenticated= ");
        stringBuilder.append(this._authenticationRequired);
        stringBuilder.append(", CustomDerbyProperties= ");
        stringBuilder.append(this._customDerbyProperties);
        stringBuilder.append(", WildCardHost= ");
        stringBuilder.append(this._wildCardHost);
        stringBuilder.append(" )");
        return stringBuilder.toString();
    }

    private String runServerCommand(String[] stringArray) throws Exception {
        String string = Integer.toString(this.getTestConfiguration().getPort());
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-Demma.verbosity.level=silent");
        arrayList.add("org.apache.derby.drda.NetworkServerControl");
        arrayList.add("-p");
        arrayList.add(string);
        arrayList.addAll(Arrays.asList(stringArray));
        String[] stringArray2 = arrayList.toArray(stringArray);
        Process process = SecureServerTest.execJavaCmd(stringArray2);
        SpawnedProcess spawnedProcess = new SpawnedProcess(process, arrayList.toString());
        SecureServerTest.assertEquals((int)0, (int)spawnedProcess.complete());
        return spawnedProcess.getFullServerOutput();
    }

    private String getServerOutput() throws Exception {
        return this.nsTestSetup.getServerProcess().getNextServerOutput();
    }

    private static String serverBootedOK() {
        return "Security manager installed using the Basic server security policy.";
    }

    private boolean serverCameUp() throws Exception {
        return NetworkServerTestSetup.pingForServerUp(NetworkServerTestSetup.getNetworkServerControl(), this.nsTestSetup.getServerProcess().getProcess(), true);
    }

    private void assertWarningDerby6619(String string, boolean bl) throws IOException {
        String string2 = SecureServerTest.getSystemProperty(string) + File.separator + "derby.log";
        if (DerbyNetAutoStartTest.checkLog(string2, this.expected6619)) {
            if (!bl) {
                SecureServerTest.fail((String)"Expected no warning on derby.log cf DERBY-6619");
            }
        } else if (bl) {
            SecureServerTest.fail((String)"Expected warning on derby.log cf DERBY-6619");
        }
    }

    public static final class Outcome {
        private boolean _serverShouldComeUp;
        private String _expectedServerOutput;

        public Outcome(boolean bl, String string) {
            this._serverShouldComeUp = bl;
            this._expectedServerOutput = string;
        }

        public boolean serverShouldComeUp() {
            return this._serverShouldComeUp;
        }

        public String expectedServerOutput() {
            return this._expectedServerOutput;
        }
    }
}

