/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class InvalidLDAPServerAuthenticationTest
extends BaseJDBCTestCase {
    public InvalidLDAPServerAuthenticationTest(String string) {
        super(string);
    }

    @Override
    protected void initializeConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("InvalidLDAPServerAuthenticationTest - cannot run with JSR169 - missing functionality for org.apache.derby.iapi.jdbc.AuthenticationService");
        }
        BaseTestSuite baseTestSuite = new BaseTestSuite("InvalidLDAPServerAuthenticationTest");
        baseTestSuite.addTest(SecurityManagerSetup.noSecurityManager(InvalidLDAPServerAuthenticationTest.baseSuite("testInvalidLDAPServerConnectionError")));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(SecurityManagerSetup.noSecurityManager(InvalidLDAPServerAuthenticationTest.baseSuite("testInvalidLDAPServerConnectionError"))));
        return baseTestSuite;
    }

    public static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        InvalidLDAPServerAuthenticationTest invalidLDAPServerAuthenticationTest = new InvalidLDAPServerAuthenticationTest("testInvalidLDAPServerConnectionError");
        baseTestSuite.addTest((Test)invalidLDAPServerAuthenticationTest);
        return TestConfiguration.singleUseDatabaseDecoratorNoShutdown((Test)baseTestSuite);
    }

    protected void setDatabaseProperty(String string, String string2, Connection connection) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.execute();
        callableStatement.close();
    }

    public void testInvalidLDAPServerConnectionError() throws SQLException {
        Connection connection = this.getConnection();
        this.setDatabaseProperty("derby.connection.requireAuthentication", "true", connection);
        this.setDatabaseProperty("derby.authentication.provider", "LDAP", connection);
        this.setDatabaseProperty("derby.authentication.server", "noSuchServer.invalid", connection);
        this.setDatabaseProperty("derby.authentication.ldap.searchBase", "o=dnString", connection);
        this.setDatabaseProperty("derby.authentication.ldap.searchFilter", "(&(objectClass=inetOrgPerson)(uid=%USERNAME%))", connection);
        this.commit();
        connection.setAutoCommit(true);
        connection.close();
        TestConfiguration.getCurrent().shutdownDatabase();
        String string = TestConfiguration.getCurrent().getDefaultDatabaseName();
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        try {
            dataSource.getConnection();
            InvalidLDAPServerAuthenticationTest.fail((String)"expected java.net.UnknownHostException for datasource");
        }
        catch (SQLException sQLException) {
            if (JDBC.vmSupportsJNDI()) {
                InvalidLDAPServerAuthenticationTest.assertSQLState("08004", sQLException);
                InvalidLDAPServerAuthenticationTest.println("Saw SQLException with message = " + sQLException.getMessage());
                if (InvalidLDAPServerAuthenticationTest.usingEmbedded()) {
                    InvalidLDAPServerAuthenticationTest.assertTrue((sQLException.getMessage().indexOf("java.net.UnknownHostException") > 1 ? 1 : 0) != 0);
                }
            }
            InvalidLDAPServerAuthenticationTest.assertSQLState("XJ040", sQLException);
        }
        String string2 = TestConfiguration.getCurrent().getJDBCUrl(string);
        try {
            DriverManager.getConnection(string2, "user", "password").close();
            InvalidLDAPServerAuthenticationTest.fail((String)"expected java.net.UnknownHostException for driver");
        }
        catch (SQLException sQLException) {
            if (JDBC.vmSupportsJNDI()) {
                InvalidLDAPServerAuthenticationTest.assertSQLState("08004", sQLException);
                if (InvalidLDAPServerAuthenticationTest.usingEmbedded()) {
                    InvalidLDAPServerAuthenticationTest.assertTrue((sQLException.getMessage().indexOf("java.net.UnknownHostException") > 1 ? 1 : 0) != 0);
                }
            }
            InvalidLDAPServerAuthenticationTest.assertSQLState("XJ040", sQLException);
        }
        this.shutdownSystem();
    }

    protected void shutdownSystem() throws SQLException {
        DataSource dataSource;
        if (InvalidLDAPServerAuthenticationTest.usingEmbedded()) {
            dataSource = JDBCDataSource.getDataSource();
            JDBCDataSource.clearStringBeanProperty(dataSource, "databaseName");
        } else {
            dataSource = JDBCDataSource.getDataSource("");
        }
        JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "shutdown");
        try {
            dataSource.getConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

