/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class UpdateXXXTest
extends BaseJDBCTestCase {
    private static final String TABLE_NAME = "MultiTypeTable";
    private static final String SELECT_STMT = "SELECT * FROM MultiTypeTable";
    private static final int COLUMNS = 10;

    public UpdateXXXTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = UpdateXXXTest.baseSuite("UpdateXXXTest");
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator((Test)UpdateXXXTest.baseSuite("UpdateXXXTest:client")));
        return baseTestSuite;
    }

    private static BaseTestSuite baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(UpdateXXXTest.class);
        if (JDBC.vmSupportsJDBC3()) {
            baseTestSuite.addTest((Test)new UpdateXXXTest("jdbc2testUpdateBigDecimal"));
        }
        return baseTestSuite;
    }

    public void setUp() throws Exception {
        Connection connection = this.getConnection();
        try {
            connection.setAutoCommit(false);
            Statement statement = connection.createStatement();
            String string = "CREATE TABLE MultiTypeTable (F01 SMALLINT,F02 INTEGER,F03 BIGINT,F04 REAL,F05 FLOAT,F06 DOUBLE,F07 DECIMAL,F08 NUMERIC,F09 CHAR(100),F10 VARCHAR(256) )";
            UpdateXXXTest.println(string);
            statement.executeUpdate(string);
            PreparedStatement preparedStatement = connection.prepareStatement("insert into MultiTypeTable values(?,?,?,?,?,?,?,?,?,?)");
            preparedStatement.setShort(1, (short)1);
            preparedStatement.setInt(2, 1);
            preparedStatement.setLong(3, 1L);
            preparedStatement.setFloat(4, 1.0f);
            preparedStatement.setDouble(5, 1.0);
            preparedStatement.setDouble(6, 1.0);
            preparedStatement.setString(7, "1");
            preparedStatement.setString(8, "1");
            preparedStatement.setString(9, "1");
            preparedStatement.setString(10, "1");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            connection.rollback();
            throw sQLException;
        }
    }

    public void testUpdateString() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery(SELECT_STMT);
        resultSet.next();
        for (int i = 1; i <= 10; ++i) {
            resultSet.updateString(i, "2");
            UpdateXXXTest.assertEquals((String)("Expected rs.getDouble(" + i + ") to match updated value"), (int)2, (int)((int)resultSet.getDouble(i)));
        }
        resultSet.updateRow();
        resultSet.close();
        this.checkColumnsAreUpdated();
        statement.close();
    }

    public void testUpdateInt() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery(SELECT_STMT);
        resultSet.next();
        for (int i = 1; i <= 10; ++i) {
            resultSet.updateInt(i, 2);
            UpdateXXXTest.assertEquals((String)("Expected rs.getInt(" + i + ") to match updated value"), (int)2, (int)resultSet.getInt(i));
        }
        resultSet.updateRow();
        resultSet.close();
        this.checkColumnsAreUpdated();
        statement.close();
    }

    public void testUpdateLong() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery(SELECT_STMT);
        resultSet.next();
        for (int i = 1; i <= 10; ++i) {
            resultSet.updateLong(i, 2L);
            UpdateXXXTest.assertEquals((String)("Expected rs.getLong(" + i + ") to match updated value"), (long)2L, (long)resultSet.getLong(i));
        }
        resultSet.updateRow();
        resultSet.close();
        this.checkColumnsAreUpdated();
        statement.close();
    }

    public void testUpdateShort() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery(SELECT_STMT);
        resultSet.next();
        for (int i = 1; i <= 10; ++i) {
            resultSet.updateShort(i, (short)2);
            UpdateXXXTest.assertEquals((String)("Expected rs.getShort(" + i + ") to match updated value"), (int)2, (int)resultSet.getShort(i));
        }
        resultSet.updateRow();
        resultSet.close();
        this.checkColumnsAreUpdated();
        statement.close();
    }

    public void testUpdateFloat() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery(SELECT_STMT);
        resultSet.next();
        for (int i = 1; i <= 10; ++i) {
            resultSet.updateFloat(i, 2.0f);
            UpdateXXXTest.assertEquals((String)("Expected rs.getFloat(" + i + ") to match updated value"), (int)2, (int)((int)resultSet.getFloat(i)));
        }
        resultSet.updateRow();
        resultSet.close();
        this.checkColumnsAreUpdated();
        statement.close();
    }

    public void testUpdateDouble() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery(SELECT_STMT);
        resultSet.next();
        for (int i = 1; i <= 10; ++i) {
            resultSet.updateDouble(i, 2.0);
            UpdateXXXTest.assertEquals((String)("Expected rs.getDouble(" + i + ") to match updated value"), (int)2, (int)((int)resultSet.getDouble(i)));
        }
        resultSet.updateRow();
        resultSet.close();
        this.checkColumnsAreUpdated();
        statement.close();
    }

    public void jdbc2testUpdateBigDecimal() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery(SELECT_STMT);
        resultSet.next();
        for (int i = 1; i <= 10; ++i) {
            resultSet.updateBigDecimal(i, BigDecimal.valueOf(2L));
            UpdateXXXTest.assertEquals((String)("Expected rs.getBigDecimal(" + i + ") to match updated value"), (int)2, (int)resultSet.getBigDecimal(i).intValue());
        }
        resultSet.updateRow();
        resultSet.close();
        this.checkColumnsAreUpdated();
        statement.close();
    }

    public void testUpdateObjectWithNull() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery(SELECT_STMT);
        resultSet.next();
        Object var3_3 = null;
        for (int i = 1; i <= 10; ++i) {
            resultSet.updateObject(i, var3_3);
            UpdateXXXTest.assertNull((String)("Expected rs.getObject(" + i + ") to be null"), (Object)resultSet.getObject(i));
            UpdateXXXTest.assertTrue((String)"Expected rs.wasNull() to return true", (boolean)resultSet.wasNull());
        }
        resultSet.updateRow();
        resultSet.close();
        this.checkColumnsAreNull();
        statement.close();
    }

    public void testUpdateNull() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery(SELECT_STMT);
        resultSet.next();
        for (int i = 1; i <= 10; ++i) {
            resultSet.updateNull(i);
            UpdateXXXTest.assertNull((String)("Expected rs.getObject(" + i + ") to be null"), (Object)resultSet.getObject(i));
            UpdateXXXTest.assertTrue((String)"Expected rs.wasNull() to return true", (boolean)resultSet.wasNull());
        }
        resultSet.updateRow();
        resultSet.close();
        this.checkColumnsAreNull();
        statement.close();
    }

    private void checkColumnsAreNull() throws SQLException {
        Statement statement = this.createStatement(1003, 1007);
        ResultSet resultSet = statement.executeQuery(SELECT_STMT);
        resultSet.next();
        for (int i = 1; i <= 10; ++i) {
            UpdateXXXTest.assertNull((String)("Expected column " + i + " to be null"), (Object)resultSet.getObject(i));
            UpdateXXXTest.assertTrue((String)("Expected wasNull() after reading column " + i + " to be true when data is SQL Null on column"), (boolean)resultSet.wasNull());
        }
        statement.close();
    }

    private void checkColumnsAreUpdated() throws SQLException {
        Statement statement = this.createStatement(1003, 1007);
        ResultSet resultSet = statement.executeQuery(SELECT_STMT);
        resultSet.next();
        for (int i = 1; i <= 10; ++i) {
            int n = 2;
            int n2 = (int)resultSet.getDouble(i);
            UpdateXXXTest.assertEquals((String)("Unexpected value from rs.getDouble( + " + i + ")"), (int)n, (int)n2);
        }
        statement.close();
    }
}

