/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.File;
import java.sql.SQLException;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class HalfCreatedDatabaseTest
extends BaseJDBCTestCase {
    private static final String DB_NAME = "hcdt_db";
    private static final String DB_DIRECTORY = "system" + File.separator + "hcdt_db";
    private static final String SERVICE_PROPERTIES_FILE_NAME = DB_DIRECTORY + File.separator + "service.properties";
    private static final String RENAMED_FILE_NAME = DB_DIRECTORY + File.separator + "renamed.properties";

    public HalfCreatedDatabaseTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("HalfCreatedDatabaseTest");
        baseTestSuite.addTest(HalfCreatedDatabaseTest.decorateTest());
        return baseTestSuite;
    }

    private static Test decorateTest() {
        BaseTestSuite baseTestSuite = new BaseTestSuite(HalfCreatedDatabaseTest.class);
        baseTestSuite = TestConfiguration.singleUseDatabaseDecorator((Test)baseTestSuite, DB_NAME);
        baseTestSuite = SecurityManagerSetup.noSecurityManager((Test)baseTestSuite);
        return baseTestSuite;
    }

    public void test_4589() throws Exception {
        this.getConnection();
        this.getTestConfiguration().shutdownDatabase();
        File file = new File(SERVICE_PROPERTIES_FILE_NAME);
        File file2 = new File(RENAMED_FILE_NAME);
        file.renameTo(file2);
        try {
            this.getConnection();
            HalfCreatedDatabaseTest.fail((String)"Should not be able to get a connection.");
        }
        catch (SQLException sQLException) {
            SQLException sQLException2;
            boolean bl = false;
            while (sQLException2 != null) {
                String string = sQLException2.getSQLState();
                if ("XBM0A".equals(string)) {
                    bl = true;
                    break;
                }
                sQLException2 = sQLException2.getNextException();
            }
            HalfCreatedDatabaseTest.assertTrue((boolean)bl);
        }
        file2.renameTo(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_5526() throws SQLException {
        String string = BaseTestCase.getSystemProperty("derby.system.home") + File.separator + "mydatadir";
        File file = new File(string);
        HalfCreatedDatabaseTest.assertTrue((boolean)file.mkdir());
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        JDBCDataSource.setBeanProperty(dataSource, "createDatabase", "create");
        try {
            dataSource.getConnection();
            HalfCreatedDatabaseTest.fail((String)("Should not be able to create database on existing directory " + string));
        }
        catch (SQLException sQLException) {
            HalfCreatedDatabaseTest.assertSQLState("XJ041", sQLException);
            SQLException sQLException2 = sQLException.getNextException();
            HalfCreatedDatabaseTest.assertSQLState("XBM0J", sQLException2);
        }
        finally {
            BaseTestCase.removeDirectory(file);
        }
    }
}

