/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.File;
import java.security.AccessControlException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SecurityPolicyReloadingTest
extends BaseJDBCTestCase {
    private static final String RELOADABLE_INITIAL_SOURCE_POLICY = "functionTests/tests/lang/SecurityPolicyReloadingTest.initial.policy";
    private static final String RELOADABLE_MODIFIED_SOURCE_POLICY = "functionTests/tests/lang/SecurityPolicyReloadingTest.modified.policy";
    private static final String UNRELOADABLE_SOURCE_POLICY = "functionTests/tests/lang/SecurityPolicyReloadingTest.unreloadable.policy";
    private static final String TARGET_POLICY = "server.policy";
    private static final String NON_DBO_USER = "NON_DBO_USER";
    private static final String PASSWORD_TOKEN = "PASSWORD_TOKEN";

    public SecurityPolicyReloadingTest() {
        super("testPolicyReloading");
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("SecurityPolicyReloadingTest");
        if (!TestConfiguration.loadingFromJars()) {
            return baseTestSuite;
        }
        baseTestSuite.addTest(SecurityPolicyReloadingTest.decorateTest());
        return baseTestSuite;
    }

    private static Test decorateTest() {
        Object object = new SecurityPolicyReloadingTest();
        object = new SecurityManagerSetup((Test)object, SecurityPolicyReloadingTest.makeServerPolicyName());
        object = TestConfiguration.sqlAuthorizationDecorator((Test)object, new String[]{NON_DBO_USER}, PASSWORD_TOKEN);
        object = new SupportFilesSetup((Test)object, null, new String[]{SecurityPolicyReloadingTest.getSourcePolicy()}, null, new String[]{SecurityPolicyReloadingTest.makeTargetPolicyStub()});
        object = SecurityManagerSetup.noSecurityManager((Test)object);
        return object;
    }

    public void testPolicyReloading() throws Exception {
        this.doPolicyReloadingIsGranted();
        this.doPolicyReloadingIsNotGranted();
    }

    private void doPolicyReloadingIsGranted() throws Exception {
        this.dbaTest();
        this.nonDbaTest();
    }

    private void dbaTest() throws Exception {
        Connection connection = this.openUserConnection("TEST_DBO");
        SecurityPolicyReloadingTest.assertTrue((String)"Initially, should be able to read property.", (boolean)this.canReadProperty());
        this.changePolicyFile(connection, RELOADABLE_MODIFIED_SOURCE_POLICY, true, null);
        SecurityPolicyReloadingTest.assertFalse((String)"Policy file changed. Should not be able to read the property.", (boolean)this.canReadProperty());
        this.changePolicyFile(connection, RELOADABLE_INITIAL_SOURCE_POLICY, true, null);
        SecurityPolicyReloadingTest.assertTrue((String)"Reverted to initial policy. Should be able to read the property again.", (boolean)this.canReadProperty());
        connection.close();
    }

    private void nonDbaTest() throws Exception {
        String string = "42504";
        Connection connection = this.openUserConnection(NON_DBO_USER);
        SecurityPolicyReloadingTest.assertTrue((String)"Initially, should be able to read property.", (boolean)this.canReadProperty());
        this.changePolicyFile(connection, RELOADABLE_MODIFIED_SOURCE_POLICY, false, string);
        SecurityPolicyReloadingTest.assertTrue((String)"Policy file not changed. Should still be able to read the property.", (boolean)this.canReadProperty());
        this.changePolicyFile(connection, RELOADABLE_INITIAL_SOURCE_POLICY, false, string);
        SecurityPolicyReloadingTest.assertTrue((String)"Reverted to initial policy. Should still be able to read the property again.", (boolean)this.canReadProperty());
        connection.close();
    }

    private void doPolicyReloadingIsNotGranted() throws Exception {
        String string = "XK000";
        Connection connection = this.openUserConnection("TEST_DBO");
        this.changePolicyFile(connection, UNRELOADABLE_SOURCE_POLICY, true, null);
        this.changePolicyFile(connection, RELOADABLE_INITIAL_SOURCE_POLICY, false, string);
        connection.close();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SecurityPolicyReloadingTest( ");
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    private boolean canReadProperty() throws Exception {
        try {
            SecurityPolicyReloadingTest.getSystemProperty("SecurityPolicyReloadingTest.property");
            return true;
        }
        catch (AccessControlException accessControlException) {
            return false;
        }
    }

    private void changePolicyFile(Connection connection, String string, boolean bl, String string2) throws Exception {
        boolean bl2 = true;
        this.writePolicyFile(string);
        CallableStatement callableStatement = connection.prepareCall("call SYSCS_UTIL.SYSCS_RELOAD_SECURITY_POLICY()");
        try {
            callableStatement.execute();
        }
        catch (SQLException sQLException) {
            bl2 = false;
            SecurityPolicyReloadingTest.assertSQLState(string2, sQLException);
        }
        SecurityPolicyReloadingTest.assertEquals((boolean)bl, (boolean)bl2);
    }

    private void writePolicyFile(String string) throws Exception {
        SupportFilesSetup.privCopyFiles("extinout", new String[]{string}, new String[]{SecurityPolicyReloadingTest.makeTargetPolicyStub()});
    }

    private static String makeServerPolicyName() {
        try {
            String string = SecurityPolicyReloadingTest.getSystemProperty("user.dir");
            String string2 = string + File.separator + "extinout" + File.separator + SecurityPolicyReloadingTest.makeTargetPolicyStub();
            File file = new File(string2);
            return file.toURI().toURL().toExternalForm();
        }
        catch (Exception exception) {
            System.out.println("Unexpected exception caught by makeServerPolicyName(): " + exception);
            return null;
        }
    }

    private static String makeTargetPolicyStub() {
        return TARGET_POLICY;
    }

    private static String getSourcePolicy() {
        return RELOADABLE_INITIAL_SOURCE_POLICY;
    }
}

