/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.text.NumberFormat;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derbyTesting.functionTests.tests.lang.StringArrayVTI;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.JDBC;

public class TableFunctionTest
extends BaseJDBCTestCase {
    private static final String UTF8 = "UTF-8";
    private static final String BAD_ARG_JOIN = "42ZB7";
    private static final int MAX_VARIABLE_DATA_TYPE_LENGTH = 32700;
    private static final String[] FUNCTION_NAMES = new String[]{"SIMPLEFUNCTIONTABLE", "invert", "returnsACoupleRows", "getXXXrecord", "returnsAllLegalDatatypes", "missingConstructor", "zeroArgConstructorNotPublic", "constructorException", "goodVTICosting", "allStringTypesFunction", "coercionFunction"};
    private static final String[] TABLE_NAMES = new String[]{"allStringTypesTable", "fooTestTable"};
    private static final String[][] SIMPLE_ROWS = new String[][]{{"who", "put"}, {"the", "bop"}, {null, "in"}, {"the", null}};
    private static final String[][] SIMPLY_ROWS = new String[][]{{"the       ", null}, {"the       ", "bop       "}, {"who       ", "put       "}, {null, "in        "}};
    private static final String[][] DOUBLY_SIMPLE_ROWS = new String[][]{{"the       ", null}, {"the       ", "bop       "}, {"the       ", null}, {"the       ", "bop       "}, {"who       ", "put       "}, {"who       ", "put       "}, {null, "in        "}, {null, "in        "}};
    private static final String[][] BOOLEAN_ROWS = new String[][]{{"tRuE", "true"}, {"fAlSe", "false"}};
    private static final String[][] BULK_INSERT_ROWS = new String[][]{{"1", "red"}, {"2", "blue"}};
    private static final String[][] BULK_INSERT_SELF_JOIN_ROWS = new String[][]{{"2", "blue"}};
    private static final String[][] DOUBLY_INSERTED_ROWS = new String[][]{{"1", "red"}, {"1", "red"}, {"2", "blue"}, {"2", "blue"}};
    private static final String[][] WARNING_VTI_ROWS = new String[][]{{"1", "red"}, {"2", "blue"}};
    private static final String[][] ALL_TYPES_ROWS = new String[][]{{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null}};
    private static final String EXPECTED_GET_XXX_CALLS = "getLong getBlob getString getBytes getString getDate getBigDecimal getDouble getDouble getFloat getDouble getInt getString getBytes getBigDecimal getFloat getShort getTime getTimestamp getString getBytes getBoolean ";
    private static final String EXPECTED_GET_XXX_CALLS_JSR169 = "getLong getBlob getString getBytes getString getDate getString getDouble getDouble getFloat getDouble getInt getString getBytes getString getFloat getShort getTime getTimestamp getString getBytes getBoolean ";
    private static final String[] STRING_TYPES = new String[]{"CHAR( 20 )", "VARCHAR( 20 )"};
    private static final int[] STRING_JDBC_TYPES = new int[]{1, 12};
    private static final String[][] ALL_STRING_TYPES_ROWS = new String[][]{{"char col            ", "varchar col"}};
    private static final String SFT_RETURN_TYPE = "TABLE ( \"INTCOL\" INTEGER, \"VARCHARCOL\" VARCHAR(10) )";
    private static final String RADT_RETURN_TYPE = "TABLE ( \"COLUMN0\" BIGINT, \"COLUMN1\" BLOB(2147483647), \"COLUMN2\" CHAR(10), \"COLUMN3\" CHAR (10) FOR BIT DATA, \"COLUMN4\" CLOB(2147483647), \"COLUMN5\" DATE, \"COLUMN6\" DECIMAL(5,0), \"COLUMN7\" DOUBLE, \"COLUMN8\" DOUBLE, \"COLUMN9\" REAL, \"COLUMN10\" DOUBLE, \"COLUMN11\" INTEGER, \"COLUMN12\" LONG VARCHAR, \"COLUMN13\" LONG VARCHAR FOR BIT DATA, \"COLUMN14\" NUMERIC(5,0), \"COLUMN15\" REAL, \"COLUMN16\" SMALLINT, \"COLUMN17\" TIME, \"COLUMN18\" TIMESTAMP, \"COLUMN19\" VARCHAR(10), \"COLUMN20\" VARCHAR (10) FOR BIT DATA, \"COLUMN21\" BOOLEAN )";
    private static final Integer FUNCTION_COLUMN_IN = 1;
    private static final Integer FUNCTION_RETURN_VALUE = 4;
    private static final Integer FUNCTION_RESULT_COLUMN = 5;
    private static final Integer FUNCTION_RETURNS_TABLE = 2;
    private static final Integer JDBC_TYPE_OTHER = 1111;
    private static final Integer JDBC_TYPE_INT = 4;
    private static final Integer JDBC_TYPE_VARCHAR = 12;
    private static final Integer JDBC_TYPE_BIGINT = -5;
    private static final Integer JDBC_TYPE_BLOB = 2004;
    private static final Integer JDBC_TYPE_CHAR = 1;
    private static final Integer JDBC_TYPE_CLOB = 2005;
    private static final Integer JDBC_TYPE_DATE = 91;
    private static final Integer JDBC_TYPE_DECIMAL = 3;
    private static final Integer JDBC_TYPE_DOUBLE = 8;
    private static final Integer JDBC_TYPE_REAL = 7;
    private static final Integer JDBC_TYPE_NUMERIC = 2;
    private static final Integer JDBC_TYPE_SMALLINT = 5;
    private static final Integer JDBC_TYPE_TIME = 92;
    private static final Integer JDBC_TYPE_TIMESTAMP = 93;
    private static final Integer JDBC_TYPE_BINARY = -2;
    private static final Integer JDBC_TYPE_LONGVARBINARY = -4;
    private static final Integer JDBC_TYPE_LONGVARCHAR = -1;
    private static final Integer JDBC_TYPE_VARBINARY = -3;
    private static final Integer JDBC_TYPE_BOOLEAN = 16;
    private static final Integer PRECISION_NONE = 0;
    private static final Integer PRECISION_INTEGER = 10;
    private static final Integer PRECISION_BIGINT = 19;
    private static final Integer PRECISION_MAX = Integer.MAX_VALUE;
    private static final Integer LENGTH_UNDEFINED = -1;
    private static final Integer LENGTH_INTEGER = 4;
    private static final Integer LENGTH_BIGINT = 40;
    private static final Integer LENGTH_MAX = Integer.MAX_VALUE;
    private static final Integer SCALE_UNDEFINED = null;
    private static final Integer SCALE_INTEGER = 0;
    private static final Integer RADIX_UNDEFINED = null;
    private static final Integer RADIX_INTEGER = 10;
    private static final Object NO_CATALOG = null;
    private static final String RETURN_VALUE_NAME = "";
    private static final Integer ALLOWS_NULLS = 1;
    private static final Object EMPTY_REMARKS = null;
    private static final Object UNDEFINED_CHAR_OCTET_LENGTH = null;
    private static final String IS_NULLABLE = "YES";
    private static final Integer ROW_ORDER_RETURN_VALUE = -1;
    private static final Integer ROW_ORDER_1 = 0;
    private static final Integer ROW_ORDER_2 = 1;
    private static final Integer POSITION_RETURN_VALUE = 0;
    private static final Integer POSITION_ARG_1 = 1;
    private static final Integer POSITION_ARG_2 = 2;
    private static final Integer ARG_COUNT_0 = 0;
    private static final Integer ARG_COUNT_1 = 1;
    private static final Integer ARG_COUNT_2 = 2;
    private static final Integer ARG_COUNT_3 = 3;
    private static final JDBC.GeneratedId GENERIC_NAME = new JDBC.GeneratedId();
    private static final Object[][] GF_SFT = new Object[][]{{NO_CATALOG, "APP", "SIMPLEFUNCTIONTABLE", "com.scores.proc.Functions.weighQuestion", FUNCTION_RETURNS_TABLE, GENERIC_NAME}};
    private static final Object[][] GFC_SFT = new Object[][]{{NO_CATALOG, "APP", "SIMPLEFUNCTIONTABLE", "INTCOL", FUNCTION_RESULT_COLUMN, JDBC_TYPE_INT, "INTEGER", PRECISION_INTEGER, LENGTH_INTEGER, SCALE_INTEGER, RADIX_INTEGER, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 1, "YES", GENERIC_NAME, ARG_COUNT_0, ROW_ORDER_1}, {NO_CATALOG, "APP", "SIMPLEFUNCTIONTABLE", "VARCHARCOL", FUNCTION_RESULT_COLUMN, JDBC_TYPE_VARCHAR, "VARCHAR", 10, 20, SCALE_UNDEFINED, RADIX_UNDEFINED, ALLOWS_NULLS, EMPTY_REMARKS, 20, 2, "YES", GENERIC_NAME, ARG_COUNT_0, ROW_ORDER_2}};
    private static final Object[][] GF_RADT = new Object[][]{{NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "org.apache.derbyTesting.functionTests.tests.lang.TableFunctionTest.returnsAllLegalDatatypes", FUNCTION_RETURNS_TABLE, GENERIC_NAME}};
    private static final Object[][] GFC_RADT = new Object[][]{{NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "INTARGUMENT", FUNCTION_COLUMN_IN, JDBC_TYPE_INT, "INTEGER", PRECISION_INTEGER, LENGTH_INTEGER, SCALE_INTEGER, RADIX_INTEGER, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, POSITION_ARG_1, "YES", GENERIC_NAME, ARG_COUNT_2, ROW_ORDER_1}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "VARCHARARGUMENT", FUNCTION_COLUMN_IN, JDBC_TYPE_VARCHAR, "VARCHAR", 10, 20, SCALE_UNDEFINED, RADIX_UNDEFINED, ALLOWS_NULLS, EMPTY_REMARKS, 20, POSITION_ARG_2, "YES", GENERIC_NAME, ARG_COUNT_2, ROW_ORDER_2}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN0", FUNCTION_RESULT_COLUMN, JDBC_TYPE_BIGINT, "BIGINT", PRECISION_BIGINT, LENGTH_BIGINT, SCALE_INTEGER, RADIX_INTEGER, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 1, "YES", GENERIC_NAME, ARG_COUNT_2, 2}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN1", FUNCTION_RESULT_COLUMN, JDBC_TYPE_BLOB, "BLOB", PRECISION_MAX, LENGTH_MAX, SCALE_UNDEFINED, RADIX_UNDEFINED, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 2, "YES", GENERIC_NAME, ARG_COUNT_2, 3}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN2", FUNCTION_RESULT_COLUMN, JDBC_TYPE_CHAR, "CHAR", 10, 20, SCALE_UNDEFINED, RADIX_UNDEFINED, ALLOWS_NULLS, EMPTY_REMARKS, 20, 3, "YES", GENERIC_NAME, ARG_COUNT_2, 4}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN3", FUNCTION_RESULT_COLUMN, JDBC_TYPE_BINARY, "CHAR () FOR BIT DATA", 10, 10, SCALE_UNDEFINED, RADIX_UNDEFINED, ALLOWS_NULLS, EMPTY_REMARKS, 10, 4, "YES", GENERIC_NAME, ARG_COUNT_2, 5}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN4", FUNCTION_RESULT_COLUMN, JDBC_TYPE_CLOB, "CLOB", PRECISION_MAX, LENGTH_MAX, SCALE_UNDEFINED, RADIX_UNDEFINED, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 5, "YES", GENERIC_NAME, ARG_COUNT_2, 6}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN5", FUNCTION_RESULT_COLUMN, JDBC_TYPE_DATE, "DATE", 10, 6, 0, 10, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 6, "YES", GENERIC_NAME, ARG_COUNT_2, 7}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN6", FUNCTION_RESULT_COLUMN, JDBC_TYPE_DECIMAL, "DECIMAL", 5, 14, 0, 10, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 7, "YES", GENERIC_NAME, ARG_COUNT_2, 8}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN7", FUNCTION_RESULT_COLUMN, JDBC_TYPE_DOUBLE, "DOUBLE", 52, 8, SCALE_UNDEFINED, 2, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 8, "YES", GENERIC_NAME, ARG_COUNT_2, 9}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN8", FUNCTION_RESULT_COLUMN, JDBC_TYPE_DOUBLE, "DOUBLE", 52, 8, SCALE_UNDEFINED, 2, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 9, "YES", GENERIC_NAME, ARG_COUNT_2, 10}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN9", FUNCTION_RESULT_COLUMN, JDBC_TYPE_REAL, "REAL", 23, 4, SCALE_UNDEFINED, 2, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 10, "YES", GENERIC_NAME, ARG_COUNT_2, 11}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN10", FUNCTION_RESULT_COLUMN, JDBC_TYPE_DOUBLE, "DOUBLE", 52, 8, SCALE_UNDEFINED, 2, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 11, "YES", GENERIC_NAME, ARG_COUNT_2, 12}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN11", FUNCTION_RESULT_COLUMN, JDBC_TYPE_INT, "INTEGER", PRECISION_INTEGER, LENGTH_INTEGER, SCALE_INTEGER, RADIX_INTEGER, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 12, "YES", GENERIC_NAME, ARG_COUNT_2, 13}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN12", FUNCTION_RESULT_COLUMN, JDBC_TYPE_LONGVARCHAR, "LONG VARCHAR", 32700, 65400, SCALE_UNDEFINED, RADIX_UNDEFINED, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 13, "YES", GENERIC_NAME, ARG_COUNT_2, 14}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN13", FUNCTION_RESULT_COLUMN, JDBC_TYPE_LONGVARBINARY, "LONG VARCHAR FOR BIT DATA", 32700, 32700, SCALE_UNDEFINED, RADIX_UNDEFINED, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 14, "YES", GENERIC_NAME, ARG_COUNT_2, 15}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN14", FUNCTION_RESULT_COLUMN, JDBC_TYPE_NUMERIC, "NUMERIC", 5, 14, 0, 10, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 15, "YES", GENERIC_NAME, ARG_COUNT_2, 16}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN15", FUNCTION_RESULT_COLUMN, JDBC_TYPE_REAL, "REAL", 23, 4, SCALE_UNDEFINED, 2, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 16, "YES", GENERIC_NAME, ARG_COUNT_2, 17}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN16", FUNCTION_RESULT_COLUMN, JDBC_TYPE_SMALLINT, "SMALLINT", 5, 2, SCALE_INTEGER, RADIX_INTEGER, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 17, "YES", GENERIC_NAME, ARG_COUNT_2, 18}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN17", FUNCTION_RESULT_COLUMN, JDBC_TYPE_TIME, "TIME", 8, 6, SCALE_INTEGER, RADIX_INTEGER, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 18, "YES", GENERIC_NAME, ARG_COUNT_2, 19}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN18", FUNCTION_RESULT_COLUMN, JDBC_TYPE_TIMESTAMP, "TIMESTAMP", 29, 16, 9, RADIX_INTEGER, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 19, "YES", GENERIC_NAME, ARG_COUNT_2, 20}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN19", FUNCTION_RESULT_COLUMN, JDBC_TYPE_VARCHAR, "VARCHAR", 10, 20, SCALE_UNDEFINED, RADIX_UNDEFINED, ALLOWS_NULLS, EMPTY_REMARKS, 20, 20, "YES", GENERIC_NAME, ARG_COUNT_2, 21}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN20", FUNCTION_RESULT_COLUMN, JDBC_TYPE_VARBINARY, "VARCHAR () FOR BIT DATA", 10, 10, SCALE_UNDEFINED, RADIX_UNDEFINED, ALLOWS_NULLS, EMPTY_REMARKS, 10, 21, "YES", GENERIC_NAME, ARG_COUNT_2, 22}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN21", FUNCTION_RESULT_COLUMN, JDBC_TYPE_BOOLEAN, "BOOLEAN", 1, 1, SCALE_UNDEFINED, RADIX_UNDEFINED, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 22, "YES", GENERIC_NAME, ARG_COUNT_2, 23}};
    private static final String ESTIMATED_ROW_COUNT = "optimizer estimated row count:";
    private static final String ESTIMATED_COST = "optimizer estimated cost:";
    private boolean _usingLocaleSpecificCollation;
    private DatabaseMetaData _databaseMetaData;

    public TableFunctionTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("TableFunctionTest");
        baseTestSuite.addTest((Test)new TableFunctionTest("noSpecialCollation"));
        baseTestSuite.addTest(TableFunctionTest.collatedSuite("en", "specialCollation"));
        return baseTestSuite;
    }

    private static Test collatedSuite(String string, String string2) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("TableFunctionTest:territory=" + string);
        baseTestSuite.addTest((Test)new TableFunctionTest(string2));
        return Decorator.territoryCollatedDatabase((Test)baseTestSuite, string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._databaseMetaData = this.getConnection().getMetaData();
        this.dropSchema();
    }

    @Override
    protected void tearDown() throws Exception {
        this.dropSchema();
        this._databaseMetaData = null;
        super.tearDown();
    }

    public void noSpecialCollation() throws Exception {
        this._usingLocaleSpecificCollation = false;
        this.tableFunctionTest();
    }

    public void specialCollation() throws Exception {
        this._usingLocaleSpecificCollation = true;
        this.tableFunctionTest();
    }

    public void tableFunctionTest() throws Exception {
        this.badDDL();
        this.simpleDDL();
        this.notTableFunction();
        this.simpleVTIResults();
        this.allLegalDatatypesVTIResults();
        this.vtiCosting();
        this.collationTest();
        this.subqueryTest();
        this.coercionTest();
        this.bulkInsert();
        this.miscBugs();
        this.classpathError();
    }

    private void badDDL() throws Exception {
        this.expectError("42ZB1", "create function badParameterStyle()\nreturns varchar(10)\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name 'com.scores.proc.Functions.weighQuestion'\n");
        this.expectError("42ZB1", "create procedure badParameterStyle\n( in takingID int )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nmodifies sql data\nexternal name 'com.scores.proc.Procedures.ScoreTestTaking'\n");
        this.expectError("42ZB2", "create function badParameterStyleForTableFunction()\nreturns TABLE\n  (\n     intCol int,\n     varcharCol varchar( 10 )\n  )\nlanguage java\nparameter style java\nno sql\nexternal name 'com.scores.proc.Functions.weighQuestion'\n");
        this.expectError("42ZB3", "create function xmlForbiddenInReturnedColumns()\nreturns TABLE\n  (\n     intCol int,\n     xmlCol xml\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name 'com.scores.proc.Functions.weighQuestion'\n");
    }

    private void simpleDDL() throws Exception {
        this.goodStatement("create function simpleFunctionTable()\nreturns TABLE\n  (\n     intCol int,\n     varcharCol varchar( 10 )\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name 'com.scores.proc.Functions.weighQuestion'\n");
        this.verifyReturnType("SIMPLEFUNCTIONTABLE", "weighQuestion() RETURNS TABLE ( \"INTCOL\" INTEGER, \"VARCHARCOL\" VARCHAR(10) ) LANGUAGE JAVA PARAMETER STYLE DERBY_JDBC_RESULT_SET NO SQL CALLED ON NULL INPUT");
        this.assertFunctionDBMD("SIMPLEFUNCTIONTABLE", GF_SFT, GFC_SFT);
    }

    private void notTableFunction() throws Exception {
        this.goodStatement("create function invert( intValue int )\nreturns int\nlanguage java\nparameter style java\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".invert'\n");
        this.expectError("42ZB4", "select s.*\n    from TABLE( invert( 1 ) ) s\n");
    }

    private void classpathError() throws Exception {
        this.goodStatement("create function foo( a int )\nreturns int\nlanguage java\nparameter style java\nno sql\nexternal name 'Bop.doowop'\n");
        this.expectError("42X51", "values ( foo( 1 ) )");
        this.goodStatement("create function bar( a int )\nreturns int\nlanguage java\nparameter style java\nno sql\nexternal name 'java.lang.Integer.doowop'\n");
        this.expectError("42X50", "values ( bar( 1 ) )");
    }

    private void simpleVTIResults() throws Exception {
        this.goodStatement("create function returnsACoupleRows()\nreturns TABLE\n  (\n     column0 varchar( 10 ),\n     column1 varchar( 10 )\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".returnsACoupleRows'\n");
        this.assertResults("select s.*\n    from TABLE( returnsACoupleRows() ) s\n", SIMPLE_ROWS, new int[]{12, 12});
        this.goodStatement("create function returnsACoupleRowsAsCHAR()\nreturns TABLE\n  (\n     column0 char( 10 ),\n     column1 char( 10 )\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".returnsACoupleRows'\n");
        String[][] stringArray = new String[SIMPLE_ROWS.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = new String[SIMPLE_ROWS[i].length];
            for (int j = 0; j < stringArray[i].length; ++j) {
                String string = SIMPLE_ROWS[i][j];
                if (string == null || string.length() >= 10) continue;
                StringBuffer stringBuffer = new StringBuffer(string);
                for (int k = string.length(); k < 10; ++k) {
                    stringBuffer.append(' ');
                }
                stringArray[i][j] = stringBuffer.toString();
            }
        }
        this.assertResults("select s.*\n    from TABLE( returnsACoupleRowsAsCHAR() ) s\n", stringArray, new int[]{1, 1});
        this.goodStatement("create function returnsBooleans()\nreturns TABLE\n  (\n     column0 varchar( 10 ),\n     column1 boolean\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".returnsBooleans'\n");
        this.assertResults("select s.*\n    from TABLE( returnsBooleans() ) s\n", BOOLEAN_ROWS, new int[]{12, 16});
    }

    private void bulkInsert() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement("create table bulkInsertTable\n  (\n     column0 int,\n     column1 varchar( 10 )\n  )\n");
        this.goodStatement("create table biSourceTable\n  (\n     column0 int,\n     column1 varchar( 10 )\n  )\n");
        this.goodStatement("create function bulkInsertVTI()\nreturns TABLE\n  (\n     column0 int,\n     column1 varchar( 10 )\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".bulkInsertVTI'\n");
        this.goodStatement("create view bulkInsertView( column0, column1 ) as select column0, column1\nfrom table( bulkInsertVTI() ) s\n");
        this.goodStatement("insert into biSourceTable select * from bulkInsertView\n");
        this.goodStatement("create table bulkInsertSimpleTable\n  (\n     column0 varchar( 10 ),\n     column1 varchar( 10 )\n  )\n");
        this.vetBulkInsert(connection, "insert into bulkInsertTable select * from table( bulkInsertVTI() ) s", true);
        this.vetBulkInsert(connection, "insert into bulkInsertTable select * from bulkInsertView", true);
        this.vetBulkInsert(connection, "insert into bulkInsertTable select * from table( bulkInsertVTI() ) s union select * from table (bulkInsertVTI()) t", true);
        this.vetBulkInsert(connection, "insert into bulkInsertTable select * from table( bulkInsertVTI()) b where b.column0 in (select c.column0 from table( bulkInsertVTI()) c)", true);
        this.goodStatement("delete from bulkInsertTable");
        this.vetBulkInsert(connection, "insert into bulkInsertTable select * from bulkInsertView b where 1 = (select count(*) from bulkInsertView bc where b.column0 > bc.column0)", true, BULK_INSERT_SELF_JOIN_ROWS);
        this.vetBulkInsert(connection, "insert into bulkInsertTable select * from biSourceTable", false);
        this.vetBulkInsert(connection, "insert into bulkInsertTable select * from table( bulkInsertVTI() ) s", true);
        this.vetBulkInsertSimple(connection, "insert into bulkInsertSimpleTable select * from table(RETURNSACOUPLEROWSASCHAR()) r", true);
        this.vetBulkInsertSimple(connection, "insert into bulkInsertSimpleTable select * from table( RETURNSACOUPLEROWSASCHAR() ) s union select * from table ( RETURNSACOUPLEROWSASCHAR() ) t", true);
        this.vetBulkInsertSimple(connection, "insert into bulkInsertSimpleTable select c.column0, c.column1 from table( RETURNSACOUPLEROWSASCHAR() ) c left outer join (select * from table( RETURNSACOUPLEROWSASCHAR() ) d) e on c.column0 = e.column0 and c.column1 = e.column1", true);
    }

    private void vetBulkInsert(Connection connection, String string, boolean bl) throws Exception {
        this.goodStatement("delete from bulkInsertTable");
        this.vetBulkInsert(connection, string, bl, BULK_INSERT_ROWS);
        this.vetBulkInsert(connection, string, false, DOUBLY_INSERTED_ROWS);
    }

    private void vetBulkInsert(Connection connection, String string, boolean bl, String[][] stringArray) throws Exception {
        long l = this.getConglomerateID(connection, "BULKINSERTTABLE");
        this.goodStatement(string);
        long l2 = this.getConglomerateID(connection, "BULKINSERTTABLE");
        TableFunctionTest.assertEquals((boolean)bl, (l != l2 ? 1 : 0) != 0);
        this.assertResults("select * from bulkInsertTable order by column0", stringArray, new int[]{4, 12});
    }

    private void vetBulkInsertSimple(Connection connection, String string, boolean bl) throws Exception {
        this.goodStatement("delete from bulkInsertSimpleTable");
        this.vetBulkInsertSimple(connection, string, bl, SIMPLY_ROWS);
        this.vetBulkInsertSimple(connection, string, false, DOUBLY_SIMPLE_ROWS);
    }

    private void vetBulkInsertSimple(Connection connection, String string, boolean bl, String[][] stringArray) throws Exception {
        long l = this.getConglomerateID(connection, "BULKINSERTSIMPLETABLE");
        this.goodStatement(string);
        long l2 = this.getConglomerateID(connection, "BULKINSERTSIMPLETABLE");
        TableFunctionTest.assertEquals((boolean)bl, (l != l2 ? 1 : 0) != 0);
        this.assertResults("select * from bulkInsertSimpleTable order by column0", stringArray, new int[]{12, 12});
    }

    private void allLegalDatatypesVTIResults() throws Exception {
        this.goodStatement("create function getXXXrecord()\nreturns varchar( 1000 )\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.StringArrayVTI.getXXXrecord'\n");
        this.goodStatement("create function returnsAllLegalDatatypes( intArgument int, varcharArgument varchar( 10 ) )\nreturns TABLE\n  (\ncolumn0 BIGINT,\ncolumn1 BLOB,\ncolumn2 CHAR( 10 ),\ncolumn3 CHAR( 10 ) FOR BIT DATA,\ncolumn4 CLOB,\ncolumn5 DATE,\ncolumn6 DECIMAL,\ncolumn7 DOUBLE,\ncolumn8 DOUBLE PRECISION,\ncolumn9 FLOAT( 23 ),\ncolumn10 FLOAT( 24 ),\ncolumn11 INTEGER,\ncolumn12 LONG VARCHAR,\ncolumn13 LONG VARCHAR FOR BIT DATA,\ncolumn14 NUMERIC,\ncolumn15 REAL,\ncolumn16 SMALLINT,\ncolumn17 TIME,\ncolumn18 TIMESTAMP,\ncolumn19 VARCHAR( 10 ),\ncolumn20 VARCHAR( 10 ) FOR BIT DATA,\ncolumn21 BOOLEAN\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".returnsAllLegalDatatypes'\n");
        this.assertResults("select s.*\n    from TABLE( returnsAllLegalDatatypes( 1, 'one' ) ) s\n", ALL_TYPES_ROWS, new int[]{-5, 2004, 1, -2, 2005, 91, 3, 8, 8, 7, 8, 4, -1, -4, 2, 7, 5, 92, 93, 12, -3, 16});
        this.assertFunctionDBMD("RETURNSALLLEGALDATATYPES", GF_RADT, GFC_RADT);
        this.checkGetXXXCalls();
    }

    private void checkGetXXXCalls() throws Exception {
        Object object;
        int n = ALL_TYPES_ROWS[0].length;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select s.*\n");
        stringBuffer.append("    from TABLE( returnsAllLegalDatatypes( 1, 'one' ) ) s\n");
        stringBuffer.append("    where\n");
        for (int i = 0; i < n; ++i) {
            object = "s.column" + i;
            if (i > 0) {
                stringBuffer.append("   and ");
            }
            stringBuffer.append("( " + (String)object + " is null )\n");
        }
        this.assertResults(stringBuffer.toString(), ALL_TYPES_ROWS, new int[]{-5, 2004, 1, -2, 2005, 91, 3, 8, 8, 7, 8, 4, -1, -4, 2, 7, 5, 92, 93, 12, -3, 16});
        PreparedStatement preparedStatement = this.prepareStatement("values getXXXrecord()");
        object = preparedStatement.executeQuery();
        object.next();
        String string = object.getString(1);
        object.close();
        preparedStatement.close();
        TableFunctionTest.println(string);
        String string2 = JDBC.vmSupportsJSR169() ? EXPECTED_GET_XXX_CALLS_JSR169 : EXPECTED_GET_XXX_CALLS;
        TableFunctionTest.assertEquals((String)string2, (String)string);
    }

    private void vtiCosting() throws Exception {
        this.goodStatement("create function missingConstructor()\nreturns TABLE\n  (\n     varcharCol varchar( 10 )\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.StringArrayVTI$MissingConstructor.dummyVTI'\n");
        this.expectError("42ZB5", "select s.*\n    from TABLE( missingConstructor() ) s\n");
        this.goodStatement("create function zeroArgConstructorNotPublic()\nreturns TABLE\n  (\n     varcharCol varchar( 10 )\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.StringArrayVTI$ZeroArgConstructorNotPublic.dummyVTI'\n");
        this.expectError("42ZB5", "select s.*\n    from TABLE( missingConstructor() ) s\n");
        this.goodStatement("create function constructorException()\nreturns TABLE\n  (\n     varcharCol varchar( 10 )\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.StringArrayVTI$ConstructorException.dummyVTI'\n");
        this.expectError("38000", "select s.*\n    from TABLE( constructorException() ) s\n");
        this.goodStatement("create function goodVTICosting()\nreturns TABLE\n  (\n     varcharCol varchar( 10 )\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.StringArrayVTI$GoodVTICosting.dummyVTI'\n");
        String string = this.getOptimizerStats("select s.*\n    from TABLE( goodVTICosting() ) s\n");
        TableFunctionTest.assertEquals((double)13.0, (double)this.readDoubleTag(string, ESTIMATED_ROW_COUNT), (double)0.0);
        TableFunctionTest.assertEquals((double)3149.0, (double)this.readDoubleTag(string, ESTIMATED_COST), (double)0.0);
    }

    private void collationTest() throws Exception {
        Object object;
        String string;
        int n;
        TableFunctionTest.assertEquals((int)STRING_TYPES.length, (int)ALL_STRING_TYPES_ROWS[0].length);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = STRING_TYPES.length;
        stringBuffer.append("(\n");
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append('\t');
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("column" + i + " " + STRING_TYPES[i] + "\n");
        }
        stringBuffer.append(")\n");
        this.goodStatement("create table allStringTypesTable\n" + stringBuffer.toString());
        this.goodStatement("create function allStringTypesFunction()\nreturns TABLE\n" + stringBuffer.toString() + "language java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".allStringTypesFunction'\n");
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("insert into allStringTypesTable values\n");
        stringBuffer2.append("(\n");
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                stringBuffer2.append(", ");
            }
            stringBuffer2.append("?");
        }
        stringBuffer2.append(")\n");
        PreparedStatement preparedStatement = this.chattyPrepare(stringBuffer2.toString());
        int n3 = ALL_STRING_TYPES_ROWS.length;
        for (int i = 0; i < n3; ++i) {
            for (n = 0; n < n2; ++n) {
                preparedStatement.setString(n + 1, ALL_STRING_TYPES_ROWS[i][n]);
            }
            preparedStatement.execute();
        }
        preparedStatement.close();
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer3.append("select f.*\n    from TABLE( allStringTypesFunction() ) f,\n    allStringTypesTable t\nwhere\n");
        for (n = 0; n < n2; ++n) {
            string = "f.column" + n;
            object = "t.column" + n;
            if (n > 0) {
                stringBuffer3.append(" and ");
            }
            stringBuffer3.append(string + " = " + (String)object);
        }
        this.assertResults(stringBuffer3.toString(), ALL_STRING_TYPES_ROWS, STRING_JDBC_TYPES);
        stringBuffer3 = new StringBuffer();
        stringBuffer3.append("select f.*\n    from TABLE( allStringTypesFunction() ) f,\n    sys.systables t\nwhere\n");
        for (n = 0; n < n2; ++n) {
            string = "f.column" + n;
            object = "t.tablename";
            if (n > 0) {
                stringBuffer3.append(" and ");
            }
            stringBuffer3.append(string + " = " + (String)object);
        }
        if (this._usingLocaleSpecificCollation) {
            this.expectError("42818", stringBuffer3.toString());
        } else {
            this.assertResults(stringBuffer3.toString(), (String[][])new String[0][], STRING_JDBC_TYPES);
        }
    }

    private void subqueryTest() throws Exception {
        this.goodStatement("create table fooTestTable\n(\n    inputCol    varchar( 20 ),\n    outputCol   varchar( 30 )\n)\n");
        this.goodStatement("insert into fooTestTable\nvalues\n( 'succeed1', 'succeed1 foo' ),\n( 'fail1', 'ladeedah' ),\n( 'succeed2', 'succeed2 bar' ),\n( 'fail2', 'hoopla' )\n");
        this.goodStatement("create function appendFooAndBar( inputArg varchar( 20 ) )\nreturns TABLE\n  (\n     inputText varchar( 20 ),\n     outputText varchar( 30 )\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.TableFunctionTest.appendFooAndBar'\n");
        this.assertResults("select * from fooTestTable\nwhere outputCol in\n(\n    select f.outputText\n    from TABLE( appendFooAndBar( inputCol ) ) as f\n)\n", new String[]{"INPUTCOL", "OUTPUTCOL"}, (String[][])new String[][]{{"succeed1", "succeed1 foo"}, {"succeed2", "succeed2 bar"}}, new int[]{12, 12});
    }

    private void coercionTest() throws Exception {
        this.goodStatement("create function coercionFunction( )\nreturns TABLE\n  (\n     keyCol int,\n     charCol char( 5 ),\n     varcharCol varchar( 5 ),\n     charForBitDataCol char( 5 ) for bit data,\n     varcharForBitDataCol varchar( 5 ) for bit data,\n     decimalCol decimal( 5, 2 ),\n     longvarcharCol long varchar,\n     longvarcharForBitDataCol long varchar for bit data\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.TableFunctionTest.coercionFunction'\n");
        this.assertResults("select *\nfrom TABLE( coercionFunction( ) ) as f order by keyCol\n", new String[]{"KEYCOL", "CHARCOL", "VARCHARCOL", "CHARFORBITDATACOL", "VARCHARFORBITDATACOL", "DECIMALCOL", "LONGVARCHARCOL", "LONGVARCHARFORBITDATACOL"}, TableFunctionTest.makeCoercionOutputs(), new int[]{4, 1, 12, -2, -3, 3, -1, -4});
    }

    private void miscBugs() throws Exception {
        this.derby_4092();
        this.derby_5779();
        this.derby_6040();
        this.derby_6151();
    }

    private void derby_4092() throws Exception {
        this.goodStatement("create function derby_4092()\nreturns TABLE\n  (\n     column0 varchar( 10 ),\n     column1 varchar( 10 )\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".returnsACoupleRows'\n");
        this.expectError("42ZB6", "values( derby_4092() )");
        this.expectError("42ZB6", "select derby_4092(), tablename from sys.systables");
    }

    private void derby_5779() throws Exception {
        this.goodStatement("create function lowerCaseRow( contents varchar( 32672 ) )\nreturns table\n(\n    contents varchar( 32672 )\n)\nlanguage java parameter style DERBY_JDBC_RESULT_SET no sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".lowerCaseRow'\n");
        this.goodStatement("create table t_5779( a int )\n");
        this.assertResults("select contents column0 from table( lowerCaseRow( 'FOO' ) ) t\n", (String[][])new String[][]{{"foo"}}, new int[]{12});
        PreparedStatement preparedStatement = this.prepareStatement("select contents from table( lowerCaseRow( ? ) ) t\n");
        preparedStatement.setString(1, "FOO");
        ResultSet resultSet = preparedStatement.executeQuery();
        this.assertResults(new int[]{12}, new String[]{"CONTENTS"}, resultSet, new String[][]{{"foo"}});
        resultSet.close();
        preparedStatement.close();
        this.assertResults("select tablename column0\nfrom sys.systables t\nwhere lower( cast (tablename as varchar( 32672 )) ) in\n( select contents from table( lowerCaseRow( 'SYSCOLUMNS' ) ) s )\n", (String[][])new String[][]{{"SYSCOLUMNS"}}, new int[]{12});
        this.assertResults("select tablename column0\nfrom sys.systables t\nwhere lower( cast (tablename as varchar( 32672 )) ) in\n( select contents from table( lowerCaseRow( cast (t.tablename as varchar(32672)) ) ) s )\nand length( tablename ) = 16\n", (String[][])new String[][]{{"SYSCONGLOMERATES"}}, new int[]{12});
        this.assertResults("select t2.conglomeratename column0\n    from \n        sys.systables systabs,\n        table (syscs_diag.space_table(systabs.tablename)) as t2\n    where cast (systabs.tablename as varchar(10)) = 'T_5779'\n", (String[][])new String[][]{{"T_5779"}}, new int[]{12});
        this.assertResults("select contents column0\nfrom table( lowerCaseRow( 'FOO' ) ) s\nwhere exists ( select tableid from sys.systables t )\n", (String[][])new String[][]{{"foo"}}, new int[]{12});
        this.expectError(BAD_ARG_JOIN, "select tablename, contents\nfrom sys.systables t, table( lowerCaseRow( cast (t.tablename as varchar(32672)) ) ) s\n");
        this.expectError(BAD_ARG_JOIN, "select tt.* from table(syscs_diag.space_table(st.tablename)) tt join sys.systables st using(tableid)");
        this.expectError(BAD_ARG_JOIN, "select tt.* from sys.systables st join table(syscs_diag.space_table(st.tablename)) tt using(tableid)");
        this.expectError(BAD_ARG_JOIN, "select tt.* from table(syscs_diag.space_table(st.tablename)) tt right join sys.systables st using(tableid)");
        this.expectError(BAD_ARG_JOIN, "select tt.* from sys.systables st right join table(syscs_diag.space_table(st.tablename)) tt using(tableid)");
        this.expectError(BAD_ARG_JOIN, "select tt.* from table(syscs_diag.space_table(st.tablename)) tt left join sys.systables st using(tableid)");
        this.expectError(BAD_ARG_JOIN, "select tt.* from sys.systables st left join table(syscs_diag.space_table(st.tablename)) tt using(tableid)");
        this.expectError(BAD_ARG_JOIN, "select tt.* from table( lowerCaseRow(st.tablename)) tt join sys.systables st on tt.contents = st.tablename");
        this.expectError(BAD_ARG_JOIN, "select tt.* from sys.systables st join table( lowerCaseRow(st.tablename)) tt on tt.contents = st.tablename");
        this.expectError(BAD_ARG_JOIN, "select tt.* from table( lowerCaseRow(st.tablename)) tt right join sys.systables st on tt.contents = st.tablename");
        this.expectError(BAD_ARG_JOIN, "select tt.* from sys.systables st right join table( lowerCaseRow(st.tablename)) tt on tt.contents = st.tablename");
        this.expectError(BAD_ARG_JOIN, "select tt.* from table( lowerCaseRow(st.tablename)) tt left join sys.systables st on tt.contents = st.tablename");
        this.expectError(BAD_ARG_JOIN, "select tt.* from sys.systables st left join table( lowerCaseRow(st.tablename)) tt on tt.contents = st.tablename");
        this.expectError(BAD_ARG_JOIN, "select tt.* from ( table(syscs_diag.space_table('foo')) tt join sys.systables st using(tableid) ) join table(syscs_diag.space_table(st.tablename)) tr using(tableid)");
        this.expectError(BAD_ARG_JOIN, "select tt.* from ( table( lowerCaseRow('foo')) tt join sys.systables st on tt.contents = st.tablename ) join table( lowerCaseRow(st.tablename)) tr on tr.contents = st.tablename");
        this.expectError(BAD_ARG_JOIN, "select tt.* from table(syscs_diag.space_table(st.tablename)) tt cross join sys.systables st");
        this.expectError(BAD_ARG_JOIN, "select tt.* from table( lowerCaseRow(st.tablename)) tt cross join sys.systables st");
        this.expectError(BAD_ARG_JOIN, "select tt.* from ( table(syscs_diag.space_table('foo')) tt cross join sys.systables st ) cross join table(syscs_diag.space_table(st.tablename)) tr");
        this.expectError(BAD_ARG_JOIN, "select tt.* from ( table( lowerCaseRow('foo')) tt cross join sys.systables st ) cross join table( lowerCaseRow(st.tablename)) tr");
        this.expectError(BAD_ARG_JOIN, "select tt.*\n    from\n        sys.systables systabs,\n        ( select * from table (syscs_diag.space_table( systabs.tablename )) as t2 ) tt\n    where systabs.tabletype = 'T' and systabs.tableid = tt.tableid\n");
        this.expectError(BAD_ARG_JOIN, "select tt.*\n    from\n        sys.systables systabs,\n        ( select * from table (lowerCaseRow( systabs.tablename )) as t2 ) tt\n    where systabs.tabletype = 'T' and systabs.tablename = tt.contents\n");
        this.expectError(BAD_ARG_JOIN, "select tt.*\n    from\n        ( select tablename from table (syscs_diag.space_table( systabs.tablename )) as t2 ) tt,\n        sys.systables systabs\n    where systabs.tabletype = 'T' and systabs.tableid = tt.tableid\n");
        this.expectError(BAD_ARG_JOIN, "select tt.*\n    from\n        ( select * from table (lowerCaseRow( systabs.tablename )) as t2 ) tt,\n        sys.systables systabs\n    where systabs.tabletype = 'T' and systabs.tableid = tt.tableid\n");
        this.expectError(BAD_ARG_JOIN, "select tt.*\n    from\n        sys.systables systabs,\n        (\n            select columnname from sys.syscolumns\n            union\n            select tablename from table (syscs_diag.space_table( systabs.tablename )) as t2\n        ) tt\n    where systabs.tabletype = 'T' and systabs.tableid = tt.tableid\n");
        this.expectError(BAD_ARG_JOIN, "select tt.*\n    from\n        (\n            select columnname from sys.syscolumns\n            union\n            select tablename from table (syscs_diag.space_table( systabs.tablename )) as t2\n        ) tt,\n        sys.systables systabs\n    where systabs.tabletype = 'T' and systabs.tableid = tt.tableid\n");
        this.expectError(BAD_ARG_JOIN, "select tt.*\n    from\n        sys.systables systabs,\n        (\n            select columnname from sys.syscolumns\n            union\n            select contents from table (lowerCaseRow( systabs.tablename )) as t2\n        ) tt\n    where systabs.tabletype = 'T' and systabs.tableid = tt.tableid\n");
        this.expectError(BAD_ARG_JOIN, "select tt.*\n    from\n        (\n            select columnname from sys.syscolumns\n            union\n            select contents from table (lowerCaseRow( systabs.tablename )) as t\n        ) tt,\n        sys.systables systabs\n    where systabs.tabletype = 'T' and systabs.tableid = tt.tableid\n");
        this.expectError(BAD_ARG_JOIN, "select tt.*\n    from\n        sys.systables systabs,\n        (\n            select * from\n            sys.syscolumns col,\n            ( select tablename from table (syscs_diag.space_table( systabs.tablename )) as t2 ) ti\n            where col.columnname = ti.tablename\n        ) tt\n    where systabs.tabletype = 'T' and systabs.tableid = tt.tableid\n");
        this.expectError(BAD_ARG_JOIN, "select tt.*\n    from\n        sys.systables systabs,\n        (\n            select * from\n            sys.syscolumns col,\n            ( select contents from table (lowerCaseRow( systabs.tablename )) as t2 ) ti\n            where col.columnname = ti.contents\n        ) tt\n    where systabs.tabletype = 'T' and systabs.tableid = tt.tableid\n");
        this.expectError(BAD_ARG_JOIN, "select tt.*\n    from\n        (\n            select * from\n            sys.syscolumns col,\n            ( select tablename from table (syscs_diag.space_table( systabs.tablename )) as t2 ) ti\n            where col.columnname = ti.tablename\n        ) tt,\n        sys.systables systabs\n    where systabs.tabletype = 'T' and systabs.tableid = tt.tableid\n");
        this.expectError(BAD_ARG_JOIN, "select tt.*\n    from\n        (\n            select * from\n            sys.syscolumns col,\n            ( select contents from table (lowerCaseRow( systabs.tablename )) as t2 ) ti\n            where col.columnname = ti.contents\n        ) tt,\n        sys.systables systabs\n    where systabs.tabletype = 'T' and systabs.tableid = tt.tableid\n");
        this.expectError("42X04", "select contents\nfrom table( lowerCaseRow( cast( t.tablename as varchar(32672)) ) ) s\nwhere exists ( select tableid from sys.systables t )\n");
    }

    private void derby_6040() throws Exception {
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        this.goodStatement("create function leftTable\n(\n    columnNames varchar( 32672 ),\n    rowContents varchar( 32672 ) ...\n)\nreturns table\n(\n    a0   varchar( 5 ),\n    a1   varchar( 5 ),\n    a2   varchar( 5 ),\n    a3   varchar( 5 )\n)\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.stringArrayTable'\n");
        this.goodStatement("create function rightTable\n(\n    columnNames varchar( 32672 ),\n    rowContents varchar( 32672 ) ...\n)\nreturns table\n(\n    b1   varchar( 5 ),\n    b2   varchar( 5 ),\n    b3   varchar( 5 )\n)\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.stringArrayTable'\n");
        this.assertResults("select l.a2 column0, r.b3 column1\nfrom\n    table( leftTable\n            (\n            'A0 A1 A2 A3',\n            'X APP T Z',\n            'X APP S Z'\n            ) ) l,\n    table( rightTable\n           (\n           'B1 B2 B3',\n           'APP T A',\n           'APP T B',\n           'APP S A',\n           'APP S B'\n           ) ) r\nwhere r.b2 = l.a2\nand l.a3 = 'Z'\nand r.b1 = l.a1\norder by column0, column1\n", (String[][])new String[][]{{"S", "A"}, {"S", "B"}, {"T", "A"}, {"T", "B"}}, new int[]{12, 12});
    }

    private void derby_6151() throws Exception {
        this.goodStatement("create function warningVTI() returns table( a int, b varchar( 5 ) )\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".warningVTI'\n");
        ResultSet resultSet = this.getConnection().prepareStatement("select * from table( warningVTI() ) t").executeQuery();
        resultSet.next();
        TableFunctionTest.assertEquals((String)"Warning for row 1", (String)resultSet.getWarnings().getMessage());
        resultSet.clearWarnings();
        resultSet.next();
        TableFunctionTest.assertEquals((String)"Warning for row 2", (String)resultSet.getWarnings().getMessage());
        resultSet.close();
        this.goodStatement("drop function warningVTI");
    }

    private static String[][] makeCoercionInputs() {
        return new String[][]{{"1", "abc", "abc", "abc", "abc", "12.3", TableFunctionTest.makeString(5), TableFunctionTest.makeByteString(5)}, {"2", "abcdef", "abcdef", "abcdef", "abcdef", "12.345", TableFunctionTest.makeString(32701), TableFunctionTest.makeByteString(32701)}, {"3", "abcde", "abcde", "abcde", "abcde", "123.45", TableFunctionTest.makeString(5), TableFunctionTest.makeByteString(5)}};
    }

    private static String[][] makeCoercionOutputs() {
        return new String[][]{{"1", "abc  ", "abc", "abc  ", "abc", "12.30", TableFunctionTest.makeString(5), TableFunctionTest.makeByteString(5)}, {"2", "abcde", "abcde", "abcde", "abcde", "12.34", TableFunctionTest.makeString(32700), TableFunctionTest.makeByteString(32700)}, {"3", "abcde", "abcde", "abcde", "abcde", "123.45", TableFunctionTest.makeString(5), TableFunctionTest.makeByteString(5)}};
    }

    private static String makeString(int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, 'a');
        return new String(cArray);
    }

    private static String makeByteString(int n) {
        try {
            byte[] byArray = new byte[n];
            byte by = 1;
            Arrays.fill(byArray, by);
            return new String(byArray, UTF8);
        }
        catch (Throwable throwable) {
            TableFunctionTest.println(throwable.getMessage());
            return null;
        }
    }

    public static int invert(int n) {
        return -n;
    }

    public static ResultSet returnsBooleans() {
        return TableFunctionTest.makeVTI(BOOLEAN_ROWS);
    }

    public static ResultSet returnsACoupleRows() {
        return TableFunctionTest.makeVTI(SIMPLE_ROWS);
    }

    public static ResultSet bulkInsertVTI() {
        return TableFunctionTest.makeVTI(BULK_INSERT_ROWS);
    }

    public static ResultSet returnsAllLegalDatatypes(int n, String string) {
        return TableFunctionTest.makeVTI(ALL_TYPES_ROWS);
    }

    public static ResultSet allStringTypesFunction() {
        return TableFunctionTest.makeVTI(ALL_STRING_TYPES_ROWS);
    }

    public static ResultSet appendFooAndBar(String string) {
        String[][] stringArray = new String[][]{{string, string + " foo"}, {string, string + " bar"}};
        return TableFunctionTest.makeVTI(stringArray);
    }

    public static ResultSet coercionFunction() {
        return TableFunctionTest.makeVTI(TableFunctionTest.makeCoercionInputs());
    }

    public static ResultSet lowerCaseRow(String string) {
        return TableFunctionTest.makeVTI(new String[][]{{string.toLowerCase()}});
    }

    public void assertResults(String string, String[][] stringArray, int[] nArray) throws Exception {
        String[] stringArray2 = TableFunctionTest.makeColumnNames(nArray.length, "COLUMN");
        this.assertResults(string, stringArray2, stringArray, nArray);
    }

    public void assertResults(String string, String[] stringArray, String[][] stringArray2, int[] nArray) throws Exception {
        TableFunctionTest.println("\nExpecting good results from " + string);
        PreparedStatement preparedStatement = this.prepareStatement(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        this.assertResults(nArray, stringArray, resultSet, stringArray2);
        resultSet.close();
        preparedStatement.close();
    }

    private void expectError(String string, String string2) {
        TableFunctionTest.println("\nExpecting " + string + " when preparing:\n\t" + string2);
        this.assertCompileError(string, string2);
    }

    private void goodStatement(String string) throws SQLException {
        PreparedStatement preparedStatement = this.chattyPrepare(string);
        preparedStatement.execute();
        preparedStatement.close();
    }

    private PreparedStatement chattyPrepare(String string) throws SQLException {
        TableFunctionTest.println("Preparing statement:\n\t" + string);
        return this.prepareStatement(string);
    }

    private void verifyReturnType(String string, String string2) throws SQLException {
        TableFunctionTest.println(string + " should have return type = " + string2);
        String string3 = "select aliasinfo from sys.sysaliases where alias=?";
        PreparedStatement preparedStatement = this.prepareStatement(string3);
        preparedStatement.setString(1, string);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), string2);
    }

    public void assertFunctionDBMD(String string, Object[][] objectArray, Object[][] objectArray2) throws Exception {
        TableFunctionTest.println("\nExpecting correct function metadata from " + string);
        ResultSet resultSet = this._databaseMetaData.getFunctions(null, "APP", string);
        JDBC.assertFullResultSet(resultSet, objectArray, false);
        resultSet.close();
        TableFunctionTest.println("\nExpecting correct function column metadata from " + string);
        resultSet = this._databaseMetaData.getFunctionColumns(null, "APP", string, "%");
        JDBC.assertFullResultSet(resultSet, objectArray2, false);
        resultSet.close();
    }

    private void dropSchema() throws Exception {
        int n;
        int n2 = FUNCTION_NAMES.length;
        for (n = 0; n < n2; ++n) {
            this.dropFunction(FUNCTION_NAMES[n]);
        }
        n = TABLE_NAMES.length;
        for (int i = 0; i < n; ++i) {
            this.dropTable(TABLE_NAMES[i]);
        }
    }

    private void dropFunction(String string) throws Exception {
        try {
            PreparedStatement preparedStatement = this.prepareStatement("drop function " + string);
            preparedStatement.execute();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void assertResults(int[] nArray, String[] stringArray, ResultSet resultSet, String[][] stringArray2) throws Exception {
        int n = stringArray2.length;
        int[] nArray2 = this.getJdbcColumnTypes(resultSet);
        this.compareJdbcTypes(nArray, nArray2);
        this.compareColumnNames(stringArray, resultSet);
        for (int i = 0; i < n; ++i) {
            String[] stringArray3 = stringArray2[i];
            int n2 = stringArray3.length;
            TableFunctionTest.assertTrue((boolean)resultSet.next());
            for (int j = 0; j < n2; ++j) {
                String string = stringArray[j];
                String string2 = stringArray3[j];
                String string3 = null;
                String string4 = null;
                int n3 = j + 1;
                int n4 = nArray2[j];
                switch (n4) {
                    case 16: {
                        string3 = Boolean.toString(resultSet.getBoolean(n3));
                        string4 = Boolean.toString(resultSet.getBoolean(string));
                        if (!resultSet.wasNull()) break;
                        string4 = null;
                        string3 = null;
                        break;
                    }
                    case -5: {
                        string3 = Long.toString(resultSet.getLong(n3));
                        string4 = Long.toString(resultSet.getLong(string)).toString();
                        if (!resultSet.wasNull()) break;
                        string4 = null;
                        string3 = null;
                        break;
                    }
                    case 4: {
                        string3 = Integer.toString(resultSet.getInt(n3));
                        string4 = Integer.toString(resultSet.getInt(string));
                        if (!resultSet.wasNull()) break;
                        string4 = null;
                        string3 = null;
                        break;
                    }
                    case 5: {
                        string3 = Short.toString(resultSet.getShort(n3));
                        string4 = Short.toString(resultSet.getShort(string));
                        if (!resultSet.wasNull()) break;
                        string4 = null;
                        string3 = null;
                        break;
                    }
                    case -6: {
                        string3 = Byte.toString(resultSet.getByte(n3));
                        string4 = Byte.toString(resultSet.getByte(string));
                        if (!resultSet.wasNull()) break;
                        string4 = null;
                        string3 = null;
                        break;
                    }
                    case 8: {
                        string3 = Double.toString(resultSet.getDouble(n3));
                        string4 = Double.toString(resultSet.getDouble(string));
                        if (!resultSet.wasNull()) break;
                        string4 = null;
                        string3 = null;
                        break;
                    }
                    case 6: 
                    case 7: {
                        string3 = Float.toString(resultSet.getFloat(n3));
                        string4 = Float.toString(resultSet.getFloat(string));
                        if (!resultSet.wasNull()) break;
                        string4 = null;
                        string3 = null;
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (JDBC.vmSupportsJDBC3()) {
                            string3 = this.squeezeString(resultSet.getBigDecimal(n3));
                            string4 = this.squeezeString(resultSet.getBigDecimal(string));
                            break;
                        }
                        string3 = this.squeezeString(resultSet.getString(n3));
                        string4 = this.squeezeString(resultSet.getString(string));
                        break;
                    }
                    case 91: {
                        string3 = this.squeezeString(resultSet.getDate(n3));
                        string4 = this.squeezeString(resultSet.getDate(string));
                        break;
                    }
                    case 92: {
                        string3 = this.squeezeString(resultSet.getTime(n3));
                        string4 = this.squeezeString(resultSet.getTime(string));
                        break;
                    }
                    case 93: {
                        string3 = this.squeezeString(resultSet.getTimestamp(n3));
                        string4 = this.squeezeString(resultSet.getTimestamp(string));
                        break;
                    }
                    case 2004: {
                        Blob blob = resultSet.getBlob(n3);
                        string3 = this.squeezeString(blob);
                        string4 = this.squeezeString(blob);
                        break;
                    }
                    case 2005: {
                        Clob clob = resultSet.getClob(n3);
                        string3 = this.squeezeString(clob);
                        string4 = this.squeezeString(clob);
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        byte[] byArray = resultSet.getBytes(n3);
                        string3 = this.squeezeString(byArray);
                        string4 = this.squeezeString(resultSet.getBytes(string));
                        break;
                    }
                    case 2000: {
                        string3 = this.squeezeString(resultSet.getObject(n3));
                        string4 = this.squeezeString(resultSet.getObject(string));
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        string3 = resultSet.getString(n3);
                        string4 = resultSet.getString(string);
                        break;
                    }
                    default: {
                        TableFunctionTest.fail((String)("Can't handle jdbc type " + n4));
                    }
                }
                if (string3 == null) {
                    TableFunctionTest.assertNull(string4);
                } else {
                    TableFunctionTest.assertTrue((boolean)string3.equals(string4));
                }
                TableFunctionTest.assertEquals((string2 == null ? 1 : 0) != 0, (boolean)resultSet.wasNull());
                if (string2 == null) {
                    TableFunctionTest.assertNull((Object)string3);
                    continue;
                }
                TableFunctionTest.assertEquals((String)string2, (String)string3);
            }
        }
        TableFunctionTest.assertFalse((boolean)resultSet.next());
    }

    private void compareJdbcTypes(int[] nArray, int[] nArray2) throws Exception {
        int n = nArray.length;
        TableFunctionTest.assertEquals((int)n, (int)nArray2.length);
        for (int i = 0; i < n; ++i) {
            TableFunctionTest.assertEquals((String)("Type at position " + i), (int)nArray[i], (int)nArray2[i]);
        }
    }

    private void compareColumnNames(String[] stringArray, ResultSet resultSet) throws Exception {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        TableFunctionTest.println("Expecting " + stringArray.length + " columns.");
        TableFunctionTest.assertEquals((int)stringArray.length, (int)n);
        for (int i = 0; i < n; ++i) {
            TableFunctionTest.assertEquals((String)stringArray[i], (String)resultSetMetaData.getColumnName(i + 1));
        }
    }

    private int[] getJdbcColumnTypes(ResultSet resultSet) throws Exception {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = resultSetMetaData.getColumnType(i + 1);
        }
        return nArray;
    }

    private String squeezeString(Object object) throws Exception {
        if (object == null) {
            return null;
        }
        if (object instanceof Blob) {
            Blob blob = (Blob)object;
            return new String(blob.getBytes(0L, (int)blob.length()), UTF8);
        }
        if (object instanceof Clob) {
            Clob clob = (Clob)object;
            return clob.getSubString(0L, (int)clob.length());
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return new String(byArray, UTF8);
        }
        return object.toString();
    }

    private static StringArrayVTI makeVTI(String[][] stringArray) {
        int n = stringArray[0].length;
        return new StringArrayVTI(TableFunctionTest.makeColumnNames(n, "mycol"), stringArray);
    }

    private static String[] makeColumnNames(int n, String string) {
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = string + i;
        }
        return stringArray;
    }

    public static void prettyPrint(Connection connection, ResultSet resultSet) throws SQLException {
        JDBCDisplayUtil.DisplayResults((PrintStream)System.out, (ResultSet)resultSet, (Connection)connection);
    }

    private String getOptimizerStats(String string) throws Exception {
        this.goodStatement("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        this.goodStatement("CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(1)");
        this.goodStatement(string);
        PreparedStatement preparedStatement = this.prepareStatement("values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        String string2 = resultSet.getString(1);
        resultSet.close();
        preparedStatement.close();
        this.goodStatement("CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(0)");
        this.goodStatement("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)");
        return string2;
    }

    private double readDoubleTag(String string, String string2) throws Exception {
        String string3;
        StringReader stringReader = new StringReader(string);
        LineNumberReader lineNumberReader = new LineNumberReader(stringReader);
        while ((string3 = lineNumberReader.readLine()) != null) {
            int n = string3.indexOf(string2);
            if (n < 0) continue;
            String string4 = string3.substring(n + string2.length()).trim();
            Number number = NumberFormat.getInstance().parse(string4);
            TableFunctionTest.println("Read " + number + " from optimizer output.");
            return number.doubleValue();
        }
        return 0.0;
    }

    private long getConglomerateID(Connection connection, String string) throws Exception {
        PreparedStatement preparedStatement = connection.prepareStatement("select c.conglomeratenumber\nfrom sys.sysconglomerates c, sys.systables t\nwhere t.tablename = ? and t.tableid = c.tableid");
        preparedStatement.setString(1, string);
        long l = this.getScalarLong(preparedStatement);
        preparedStatement.close();
        return l;
    }

    private long getScalarLong(PreparedStatement preparedStatement) throws Exception {
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        long l = resultSet.getLong(1);
        resultSet.close();
        preparedStatement.close();
        return l;
    }

    public static WarningVTI warningVTI() {
        return new WarningVTI();
    }

    public static final class WarningVTI
    extends StringArrayVTI {
        private int _count;

        public WarningVTI() {
            super(TableFunctionTest.makeColumnNames(2, "mycol"), WARNING_VTI_ROWS);
        }

        @Override
        public boolean next() throws SQLException {
            boolean bl = super.next();
            if (bl) {
                ++this._count;
            }
            return bl;
        }

        public SQLWarning getWarnings() {
            return new SQLWarning("Warning for row " + this._count);
        }
    }
}

