/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class ReplicationRun_Local_StateTest_part1_1
extends ReplicationRun {
    static final String REPLICATION_DB_NOT_BOOTED = "XRE11";
    static final String REPLICATION_NOT_IN_SLAVE_MODE = "XRE40";
    static final String SLAVE_OPERATION_DENIED_WHILE_CONNECTED = "XRE41";
    static final String REPLICATION_SLAVE_SHUTDOWN_OK = "XRE42";

    public ReplicationRun_Local_StateTest_part1_1(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ReplicationRun_Local_StateTest_part1_1 Suite");
        baseTestSuite.addTestSuite(ReplicationRun_Local_StateTest_part1_1.class);
        return SecurityManagerSetup.noSecurityManager((Test)baseTestSuite);
    }

    public void testReplication_Local_StateTest_part1_1() throws Exception {
        this.cleanAllTestHosts();
        this.initEnvironment();
        this.initMaster(masterServerHost, replicatedDb);
        this.startServer(masterJvmVersion, derbyMasterVersion, masterServerHost, "0.0.0.0", masterServerPort, masterDbSubPath);
        this.startServer(slaveJvmVersion, derbySlaveVersion, slaveServerHost, "0.0.0.0", slaveServerPort, slaveDbSubPath);
        this.startServerMonitor(slaveServerHost);
        this.bootMasterDatabase(jvmVersion, masterDatabasePath + FS + masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, null);
        this.initSlave(slaveServerHost, jvmVersion, replicatedDb);
        this.startSlave(jvmVersion, replicatedDb, slaveServerHost, slaveServerPort, slaveServerHost, slaveReplPort, testClientHost);
        this.startMaster(jvmVersion, replicatedDb, masterServerHost, masterServerPort, masterServerHost, slaveServerPort, slaveServerHost, slaveReplPort);
        this._testPostStartedMasterAndSlave_StopSlave();
        this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
    }

    private void _testPostStartedMasterAndSlave_StopSlave() throws Exception {
        this.util.DEBUG("1. testPostStartedMasterAndSlave_StopSlave");
        this.assertException(this.stopSlave(slaveServerHost, slaveServerPort, slaveDatabasePath, replicatedDb, true), SLAVE_OPERATION_DENIED_WHILE_CONNECTED);
        this.util.DEBUG("2. testPostStartedMasterAndSlave_StopSlave");
        this.assertException(this.stopSlave(masterServerHost, masterServerPort, masterDatabasePath, masterDbSubPath, replicatedDb, true), REPLICATION_NOT_IN_SLAVE_MODE);
        this.killMaster(masterServerHost, masterServerPort);
        this.util.DEBUG("3. testPostStartedMasterAndSlave_StopSlave");
        this.stopSlave(slaveServerHost, slaveServerPort, slaveDatabasePath, replicatedDb, false);
        String string = slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb;
        String string2 = "jdbc:derby://" + slaveServerHost + ":" + slaveServerPort + "/" + string;
        this.util.DEBUG("4. testPostStartedMasterAndSlave_StopSlave: " + string2);
        this.waitForConnect(100L, 10, string, slaveServerHost, slaveServerPort);
    }
}

