/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ServicePropertiesFileTest
extends BaseJDBCTestCase {
    private static final String SPF_ENCODING = "ISO-8859-1";
    private static final String LOG_A_MODE = "derby.storage.logArchiveMode";
    private static final String END_TOKEN = "#--- last line, don't put anything after this line ---";
    private static final String DB_NAME = "spfTestDb";
    private static File databasesDir;
    private static File pristineDb;
    private static boolean dbInitialized;
    private File dbToDelete;
    private File spf;
    private File spfOld;

    public ServicePropertiesFileTest(String string) {
        super(string);
    }

    public void setUp() throws SQLException {
        if (!dbInitialized) {
            DataSource dataSource = JDBCDataSource.getDataSourceLogical(DB_NAME);
            JDBCDataSource.setBeanProperty(dataSource, "createDatabase", "create");
            dataSource.getConnection();
            JDBCDataSource.shutdownDatabase(dataSource);
            File file = new File(ServicePropertiesFileTest.getSystemProperty("derby.system.home"));
            databasesDir = new File(file, "singleUse");
            pristineDb = new File(file, TestConfiguration.getCurrent().getPhysicalDatabaseName(DB_NAME));
            dbInitialized = true;
        }
    }

    @Override
    public void tearDown() throws Exception {
        if (this.dbToDelete != null) {
            ServicePropertiesFileTest.assertDirectoryDeleted(this.dbToDelete);
        }
        super.tearDown();
    }

    public void testMissingServicePropertiesFileNoBackup() throws IOException, SQLException {
        String string = "spfTestMissingSPFNB";
        this.copyDbAs(string);
        PrivilegedFileOpsForTests.delete(this.spf);
        this.assertPresence(false, false);
        try {
            this.connectThenShutdown(string);
            ServicePropertiesFileTest.fail((String)"booted database without a service.properties file");
        }
        catch (SQLException sQLException) {
            ServicePropertiesFileTest.assertSQLState("error message has changed", "XJ004", sQLException);
        }
    }

    public void testMissingServicePropertiesFileWithBackup() throws IOException, SQLException {
        String string = "spfTestMissingSPFWB";
        this.copyDbAs(string);
        this.createSPFBackup(false);
        this.assertPresence(false, true);
        this.connectThenShutdown(string);
        this.assertNormalPresence();
    }

    public void testSevicePropertiesFileWithBackup() throws IOException, SQLException {
        String string = "spfTestSPFWB";
        this.copyDbAs(string);
        this.createSPFBackup(true);
        this.assertPresence(true, true);
        this.connectThenShutdown(string);
        this.assertNormalPresence();
        this.assertEOFToken(this.spf, SPF_ENCODING);
    }

    public void testSevicePropertiesFileCorruptedWithBackup() throws IOException, SQLException {
        String string = "spfTestSPFCWB";
        this.copyDbAs(string);
        this.createSPFBackup(true);
        this.removeEOFToken(this.spf, SPF_ENCODING);
        this.assertPresence(true, true);
        this.connectThenShutdown(string);
        this.assertNormalPresence();
        this.assertEOFToken(this.spf, SPF_ENCODING);
    }

    public void testBackupWithBackupExisting() throws IOException, SQLException {
        String string = "spfTestBWBE";
        this.copyDbAs(string);
        this.assertPresence(true, false);
        ServicePropertiesFileTest.assertEquals((int)0, (int)this.grepForToken(LOG_A_MODE, this.spf));
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "databaseName", "singleUse/" + string);
        Connection connection = dataSource.getConnection();
        this.createSPFBackup(true);
        Statement statement = connection.createStatement();
        statement.execute("CALL SYSCS_UTIL.SYSCS_DISABLE_LOG_ARCHIVE_MODE(0)");
        connection.close();
        JDBCDataSource.shutdownDatabase(dataSource);
        this.assertNormalPresence();
        ServicePropertiesFileTest.assertEquals((int)1, (int)this.grepForToken("derby.storage.logArchiveMode=false", this.spf));
    }

    private void assertNormalPresence() {
        this.assertPresence(true, false);
    }

    private void assertPresence(boolean bl, boolean bl2) {
        ServicePropertiesFileTest.assertEquals((String)("incorrect '" + this.spf.getAbsolutePath() + "' presence,"), (boolean)bl, (boolean)PrivilegedFileOpsForTests.exists(this.spf));
        ServicePropertiesFileTest.assertEquals((String)("incorrect '" + this.spfOld.getPath() + "' presence,"), (boolean)bl2, (boolean)PrivilegedFileOpsForTests.exists(this.spfOld));
    }

    private void assertEOFToken(File file, String string) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)PrivilegedFileOpsForTests.getFileInputStream(file), string));
        String string3 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            string3 = string2;
        }
        bufferedReader.close();
        ServicePropertiesFileTest.assertNotNull((String)"last line is null - empty file?", (Object)string3);
        ServicePropertiesFileTest.assertTrue((String)("prev:" + string3 + ": does not equal #--- last line, don't put anything after this line ---"), (boolean)string3.startsWith(END_TOKEN));
    }

    private void removeEOFToken(File file, String string) throws IOException {
        String string2;
        File file2 = new File(file.getAbsolutePath() + "-renamed");
        PrivilegedFileOpsForTests.copy(file, file2);
        PrivilegedFileOpsForTests.delete(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)PrivilegedFileOpsForTests.getFileInputStream(file2), string));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)PrivilegedFileOpsForTests.getFileOutputStream(file), string));
        String string3 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string3 != null) {
                bufferedWriter.write(string3);
                bufferedWriter.newLine();
            }
            string3 = string2;
        }
        ServicePropertiesFileTest.assertEquals((String)END_TOKEN, string3);
        bufferedReader.close();
        bufferedWriter.close();
        PrivilegedFileOpsForTests.delete(file2);
    }

    private int grepForToken(String string, File file) throws IOException {
        String string2;
        int n = 0;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)PrivilegedFileOpsForTests.getFileInputStream(file), SPF_ENCODING));
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.indexOf(string) == -1) continue;
            ++n;
        }
        bufferedReader.close();
        return n;
    }

    private void copyDbAs(String string) throws IOException {
        File file;
        this.dbToDelete = file = new File(databasesDir, string);
        PrivilegedFileOpsForTests.copy(pristineDb, file);
        this.spf = new File(file, "service.properties");
        this.spfOld = new File(file, "service.propertiesold");
    }

    private void createSPFBackup(boolean bl) throws IOException {
        PrivilegedFileOpsForTests.copy(this.spf, this.spfOld);
        if (!bl) {
            PrivilegedFileOpsForTests.delete(this.spf);
        }
    }

    private void connectThenShutdown(String string) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "databaseName", "singleUse/" + string);
        dataSource.getConnection().close();
        JDBCDataSource.shutdownDatabase(dataSource);
    }

    public static Test suite() {
        return TestConfiguration.additionalDatabaseDecoratorNoShutdown(TestConfiguration.embeddedSuite(ServicePropertiesFileTest.class), DB_NAME);
    }
}

