/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.Formatters;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.functionTests.util.TestUtil;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class StreamingColumnTest
extends BaseJDBCTestCase {
    public static final int DB2_LONGVARCHAR_MAXWIDTH = 32700;
    public static final int DB2_VARCHAR_MAXWIDTH = 32672;
    static String[] fileName;
    static long[] fileLength;
    private static final int LONGVARCHAR = 1;
    private static final int CLOB = 2;
    private static final int VARCHAR = 3;

    public StreamingColumnTest(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStream1() throws Exception {
        Object object;
        Statement statement = this.createStatement();
        for (int i = 0; i < fileName.length; ++i) {
            File file = new File(fileName[i]);
            StreamingColumnTest.fileLength[i] = PrivilegedFileOpsForTests.length(file);
            object = PrivilegedFileOpsForTests.getFileInputStream(file);
            StreamingColumnTest.println("===>  testing " + fileName[i] + " with length = " + fileLength[i]);
            PreparedStatement preparedStatement = this.prepareStatement("insert into testLongVarChar1 values(?, ?)");
            preparedStatement.setInt(1, 100 + i);
            preparedStatement.setAsciiStream(2, (InputStream)object, (int)fileLength[i]);
            try {
                preparedStatement.executeUpdate();
                if (32700L < fileLength[i]) {
                    StreamingColumnTest.fail((String)"Attempting to insert data longer than 32700 should have thrownan exception.");
                }
                StreamingColumnTest.println("No truncation and hence no error");
                continue;
            }
            catch (SQLException sQLException) {
                if (fileLength[i] > 32700L) {
                    if (i == 2 && StreamingColumnTest.usingDerbyNetClient()) {
                        StreamingColumnTest.assertSQLState("XJ001", sQLException);
                    } else {
                        StreamingColumnTest.assertSQLState("22001", sQLException);
                    }
                    StreamingColumnTest.println("expected exception for data > 32700 in length");
                    continue;
                }
                throw sQLException;
            }
            finally {
                ((InputStream)object).close();
            }
        }
        ResultSet resultSet = statement.executeQuery("select a, b from testLongVarChar1");
        byte[] byArray = new byte[128];
        while (resultSet.next()) {
            int n;
            int n2 = resultSet.getInt("a");
            object = resultSet.getAsciiStream(2);
            int n3 = 0;
            while ((n = ((InputStream)object).read(byArray)) != -1) {
                n3 += n;
            }
            this.verifyLength(n2, n3, fileLength);
        }
        resultSet = statement.executeQuery("select a, b from testLongVarChar1 order by a");
        resultSet.getMetaData();
        while (resultSet.next()) {
            int n;
            int n4 = resultSet.getInt("a");
            object = resultSet.getAsciiStream(2);
            int n5 = 0;
            while ((n = ((InputStream)object).read(byArray)) != -1) {
                n5 += n;
            }
            this.verifyLength(n4, n5, fileLength);
        }
        resultSet = statement.executeQuery("select a, b from testLongVarChar1");
        while (resultSet.next()) {
            int n = resultSet.getInt("a");
            object = resultSet.getString(2);
            this.verifyLength(n, ((String)object).length(), fileLength);
        }
        resultSet = statement.executeQuery("select a, b from testLongVarChar1 order by a");
        while (resultSet.next()) {
            int n = resultSet.getInt("a");
            object = resultSet.getString(2);
            this.verifyLength(n, ((String)object).length(), fileLength);
        }
        resultSet = statement.executeQuery("select a, b from testLongVarChar1 where b like 'test data: a string column inserted as an object'");
        while (resultSet.next()) {
            int n = resultSet.getInt("a");
            object = resultSet.getString(2);
            this.verifyLength(n, ((String)object).length(), fileLength);
        }
        this.insertLongString(10, "ssssssssss", false, "foo1");
        this.insertLongString(0, "", false, "foo1");
        this.insertLongString(1, "1", false, "foo1");
        this.insertLongString(-1, null, false, "foo1");
        this.insertLongString(20, "XXXXXXXXXXXXXXXXXXXX", false, "foo1");
        resultSet = statement.executeQuery("select a, b from foo1");
        StreamingColumnTest.println("Expect to get null string back");
        while (resultSet.next()) {
            int n = resultSet.getInt("a");
            object = resultSet.getString(2);
            StreamingColumnTest.assertEquals((String)("FAIL - failed to get string back, expect " + n + " got " + (String)(object == null ? "null resultString" : "" + ((String)object).length())), (int)n, (int)(object == null ? -1 : ((String)object).length()));
        }
        this.updateLongString(1, 3000, "foo1");
        this.updateLongString(0, 800, "foo1");
        this.updateLongString(3000, 0, "foo1");
        this.updateLongString(0, 51, "foo1");
        this.updateLongString(20, 0, "foo1");
        resultSet = statement.executeQuery("select a, b from foo1");
        while (resultSet.next()) {
            int n = resultSet.getInt("a");
            object = resultSet.getString(2);
            StreamingColumnTest.assertEquals((String)("FAIL - failed to get string back, expect " + n + " got " + (String)(object == null ? "null resultString" : "" + ((String)object).length())), (int)n, (int)(object == null ? -1 : ((String)object).length()));
        }
        resultSet.close();
        statement.close();
    }

    public void testStream2_1500() throws Exception {
        long l = 1500L;
        this.streamTest2(l, "foo2_1500");
    }

    public void testStream2_5000() throws Exception {
        long l = 5000L;
        this.streamTest2(l, "foo2_5000");
    }

    public void testStream2_10000() throws Exception {
        long l = 10000L;
        this.streamTest2(l, "foo2_10000");
    }

    private void streamTest2(long l, String string) throws Exception {
        Statement statement = this.createStatement();
        this.insertLongString(1, StreamingColumnTest.pad("Broadway", l), false, string);
        this.insertLongString(2, StreamingColumnTest.pad("Franklin", l), false, string);
        this.insertLongString(3, StreamingColumnTest.pad("Webster", l), false, string);
        statement.executeUpdate("insert into " + string + " select a+100, b from " + string);
        this.verifyExistence(1, "Broadway", l, string);
        this.verifyExistence(2, "Franklin", l, string);
        this.verifyExistence(3, "Webster", l, string);
        this.verifyExistence(101, "Broadway", l, string);
        this.verifyExistence(102, "Franklin", l, string);
        this.verifyExistence(103, "Webster", l, string);
    }

    public void testStream3_0() throws Exception {
        this.streamTest3(0L, "foo3_0");
    }

    public void testStream3_1500() throws Exception {
        this.streamTest3(1500L, "foo3_1500");
    }

    public void testStream3_5000() throws Exception {
        this.streamTest3(5000L, "foo3_5000");
    }

    public void testStream3_10000() throws Exception {
        this.streamTest3(10000L, "foo3_10000");
    }

    private void streamTest3(long l, String string) throws Exception {
        this.insertLongString(1, StreamingColumnTest.pad("Broadway", l), false, string);
        this.insertLongString(2, StreamingColumnTest.pad("Franklin", l), false, string);
        this.insertLongString(3, StreamingColumnTest.pad("Webster", l), false, string);
        PreparedStatement preparedStatement = this.prepareStatement("update " + string + " set a=a+1000, b=? where a<99 and a in (select a from " + string + ")");
        File file = new File("extin/short.data");
        FileInputStream fileInputStream = PrivilegedFileOpsForTests.getFileInputStream(file);
        preparedStatement.setAsciiStream(1, (InputStream)fileInputStream, (int)PrivilegedFileOpsForTests.length(file));
        preparedStatement.executeUpdate();
        ((InputStream)fileInputStream).close();
        preparedStatement = this.prepareStatement("update " + string + " set a=a+1000, b=? where a<99 and a in (select a from " + string + ")");
        file = new File("extin/shortbanner");
        fileInputStream = PrivilegedFileOpsForTests.getFileInputStream(file);
        preparedStatement.setAsciiStream(1, (InputStream)fileInputStream, (int)PrivilegedFileOpsForTests.length(file));
        preparedStatement.executeUpdate();
        ((InputStream)fileInputStream).close();
    }

    public void testStream4() throws Exception {
        int n;
        Object object;
        Statement statement = this.createStatement();
        statement.execute("insert into testLongVarBinary4 values(1, CAST (" + TestUtil.stringToHexLiteral("") + "AS BLOB(1G)))");
        statement.execute("insert into testLongVarBinary4 values(2,CAST (" + TestUtil.stringToHexLiteral("test data: a string column inserted as an object") + "AS BLOB(1G)))");
        for (int i = 0; i < fileName.length; ++i) {
            File file = new File(fileName[i]);
            StreamingColumnTest.fileLength[i] = PrivilegedFileOpsForTests.length(file);
            object = PrivilegedFileOpsForTests.getFileInputStream(file);
            StreamingColumnTest.println("Testing with " + fileName[i] + " length = " + fileLength[i]);
            PreparedStatement preparedStatement = this.prepareStatement("insert into testLongVarBinary4 values(?, ?)");
            preparedStatement.setInt(1, 100 + i);
            preparedStatement.setBinaryStream(2, (InputStream)object, (int)fileLength[i]);
            preparedStatement.executeUpdate();
            ((InputStream)object).close();
        }
        ResultSet resultSet = statement.executeQuery("select a, b from testLongVarBinary4");
        resultSet.getMetaData();
        byte[] byArray = new byte[128];
        while (resultSet.next()) {
            int n2 = resultSet.getInt("a");
            object = resultSet.getBinaryStream(2);
            int n3 = 0;
            while ((n = ((InputStream)object).read(byArray, 0, 100)) != -1) {
                n3 += n;
            }
            this.verifyLength(n2, n3, fileLength);
        }
        resultSet = statement.executeQuery("select a, b from testLongVarBinary4 order by a");
        resultSet.getMetaData();
        while (resultSet.next()) {
            int n4 = resultSet.getInt("a");
            object = resultSet.getBinaryStream(2);
            int n5 = 0;
            while ((n = ((InputStream)object).read(byArray)) != -1) {
                n5 += n;
            }
            this.verifyLength(n4, n5, fileLength);
        }
        resultSet = statement.executeQuery("select a, b from testLongVarBinary4");
        while (resultSet.next()) {
            int n6 = resultSet.getInt("a");
            object = resultSet.getString(2);
            this.verifyLength(n6, ((String)object).length() / 2, fileLength);
        }
        resultSet = statement.executeQuery("select a, b from testLongVarBinary4 order by a");
        while (resultSet.next()) {
            int n7 = resultSet.getInt("a");
            object = resultSet.getString(2);
            StreamingColumnTest.println((String)object);
            this.verifyLength(n7, ((String)object).length() / 2, fileLength);
        }
        resultSet.close();
        statement.close();
    }

    public void testStream5_0() throws Exception {
        this.streamTest5(0L, "foo5_0");
    }

    public void testStream5_1500() throws Exception {
        this.streamTest5(1500L, "foo5_1500");
    }

    public void testStream5_5000() throws Exception {
        this.streamTest5(5000L, "foo5_5000");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamTest5(long l, String string) throws Exception {
        try (InputStream inputStream = null;){
            this.insertLongString(1, StreamingColumnTest.pad("Broadway", l), true, string);
            this.insertLongString(2, StreamingColumnTest.pad("Franklin", l), true, string);
            this.insertLongString(3, StreamingColumnTest.pad("Webster", l), true, string);
            this.insertLongString(4, StreamingColumnTest.pad("Broadway", l), true, string);
            this.insertLongString(5, StreamingColumnTest.pad("Franklin", l), true, string);
            this.insertLongString(6, StreamingColumnTest.pad("Webster", l), true, string);
            PreparedStatement preparedStatement = this.prepareStatement("update " + string + " set a=a+1000, b=? where a<99 and a in (select a from " + string + ")");
            File file = new File("extin/short.data");
            inputStream = PrivilegedFileOpsForTests.getFileInputStream(file);
            preparedStatement.setBinaryStream(1, inputStream, (int)PrivilegedFileOpsForTests.length(file));
            preparedStatement.executeUpdate();
            inputStream.close();
            preparedStatement = this.prepareStatement("update " + string + " set a=a+1000, b=? where a<99 and a in (select a from " + string + ")");
            file = new File("extin/shortbanner");
            inputStream = PrivilegedFileOpsForTests.getFileInputStream(file);
            preparedStatement.setBinaryStream(1, inputStream, (int)PrivilegedFileOpsForTests.length(file));
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
    }

    public void testStream6() throws Exception {
        Statement statement = this.createStatement();
        this.insertLongString(1, StreamingColumnTest.pad("Broadway", 5000L), false, "foo_6");
        this.insertLongString(2, StreamingColumnTest.pad("Franklin", 5000L), false, "foo_6");
        this.insertLongString(3, StreamingColumnTest.pad("Webster", 5000L), false, "foo_6");
        PreparedStatement preparedStatement = this.prepareStatement("update foo_6 set a=a+1000, b=? where a<99 and a in (select a from foo_6)");
        StreamingColumnTest.streamInLongCol(preparedStatement, StreamingColumnTest.pad("Grand", 5000L));
        preparedStatement.close();
        statement.close();
    }

    public void testStream7() throws Exception {
        Object object;
        this.setAutoCommit(false);
        StreamingColumnTest.println("streamTest7");
        PreparedStatement preparedStatement = this.prepareStatement("insert into testlvc7 values (?, 'filler for column b on null column', null, 'filler for column d')");
        PreparedStatement preparedStatement2 = this.prepareStatement("insert into testlvc7 values (?, 'filler for column b on empty string column', ?, 'filler2 for column d')");
        for (int i = 0; i < 100; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.executeUpdate();
            object = new ByteArrayInputStream(new byte[0]);
            preparedStatement2.setInt(1, i);
            preparedStatement2.setAsciiStream(2, (InputStream)object, 0);
            preparedStatement2.executeUpdate();
        }
        preparedStatement.close();
        preparedStatement2.close();
        this.commit();
        PreparedStatement preparedStatement3 = this.prepareStatement("update testlvc7 set lvc = ? where a = ?");
        object = "this is a relatively long string, hopefully the row will be split or otherwise become long ???  I don't think it will become long but maybe if it rolls back it will become strange";
        for (int i = 0; i < 100; ++i) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((String)object).getBytes("US-ASCII"));
            preparedStatement3.setAsciiStream(1, (InputStream)byteArrayInputStream, ((String)object).length());
            preparedStatement3.setInt(2, i);
            preparedStatement3.executeUpdate();
            if (i % 2 == 0) {
                this.rollback();
            } else {
                this.commit();
            }
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(new byte[0]);
            preparedStatement3.setAsciiStream(1, (InputStream)byteArrayInputStream2, 0);
            preparedStatement3.executeUpdate();
            if (i % 3 == 0) {
                this.rollback();
                continue;
            }
            this.commit();
        }
        preparedStatement3.close();
    }

    public void testStream8_10_2500() throws Exception {
        int n = 10;
        int n2 = 2500;
        String string = "t8_10_2500";
        StreamingColumnTest.println("Starting testStream8_10_2500(" + n + ", " + n2 + ")");
        this.streamTest8(n, n2, string);
        StreamingColumnTest.println("Finishing testStream8_10_2500(" + n + ", " + n2 + ")");
    }

    public void testStream8_2500_10() throws Exception {
        int n = 2500;
        int n2 = 10;
        String string = "t8_2500_10";
        StreamingColumnTest.println("Starting streamTest8_2500_10(" + n + ", " + n2 + ")");
        this.streamTest8(n, n2, string);
        StreamingColumnTest.println("Finishing streamTest8_2500_10(" + n + ", " + n2 + ")");
    }

    private void streamTest8(int n, int n2, String string) throws Exception {
        Object object;
        int n3;
        StreamingColumnTest.println("Starting streamTest8(" + n + ", " + n2 + ")");
        String string2 = new String("insert into " + string + " values (?, ?, ?) ");
        int n4 = 10;
        byte[][] byArrayArray = new byte[n4][];
        byte[][] byArrayArray2 = new byte[n4][];
        for (int i = 0; i < n4; ++i) {
            byArrayArray[i] = new byte[n];
            for (n3 = 0; n3 < n; ++n3) {
                byArrayArray[i][n3] = (byte)(97 + i);
            }
            byArrayArray2[i] = new byte[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                byArrayArray2[i][n3] = (byte)(65 + i);
            }
        }
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement(string2);
        for (n3 = 0; n3 < n4; ++n3) {
            preparedStatement.setInt(1, n3);
            preparedStatement.setAsciiStream(2, (InputStream)new ByteArrayInputStream(byArrayArray[n3]), n);
            preparedStatement.setAsciiStream(3, (InputStream)new ByteArrayInputStream(byArrayArray2[n3]), n2);
            preparedStatement.executeUpdate();
            object = "insert into " + string + " select * from " + string + " where a = -6363";
            statement.execute((String)object);
        }
        preparedStatement.close();
        this.commit();
        ResultSet resultSet = statement.executeQuery("select a, b, c from " + string);
        while (resultSet.next()) {
            n3 = resultSet.getInt("a");
            object = resultSet.getString(2);
            String string3 = new String(byArrayArray[n3], "US-ASCII");
            StreamingColumnTest.assertEquals((String)("FAIL -- bad result string:canon: " + string3 + "resultString: " + (String)object), (int)0, (int)string3.compareTo((String)object));
            object = resultSet.getString(3);
            string3 = new String(byArrayArray2[n3], "US-ASCII");
            StreamingColumnTest.assertEquals((String)("FAIL -- bad result string:canon: " + string3 + "resultString: " + (String)object), (int)0, (int)string3.compareTo((String)object));
        }
        resultSet.close();
        statement.execute("insert into " + string + " select * from " + string + " ");
        statement.close();
        this.commit();
        StreamingColumnTest.println("Finishing streamTest8(" + n + ", " + n2 + ")");
    }

    public void testStream9_10_2500() throws Exception {
        int n = 10;
        int n2 = 2500;
        String string = "t9_10_2500";
        StreamingColumnTest.println("Starting testStream9_10_2500(" + n + ", " + n2 + ")");
        this.streamTest9(n, n2, string);
        StreamingColumnTest.println("Finishing testStream_10_2500(" + n + ", " + n2 + ")");
    }

    public void testStream9_2500_10() throws Exception {
        int n = 2500;
        int n2 = 10;
        String string = "t9_2500_10";
        StreamingColumnTest.println("Starting streamTest9_2500_10(" + n + ", " + n2 + ")");
        this.streamTest9(n, n2, string);
        StreamingColumnTest.println("Finishing testStream9_2500_10(" + n + ", " + n2 + ")");
    }

    private void streamTest9(int n, int n2, String string) throws SQLException {
        Object object;
        int n3;
        String string2 = new String("insert into " + string + " values (?, ?, ?) ");
        int n4 = 10;
        byte[][] byArrayArray = new byte[n4][];
        byte[][] byArrayArray2 = new byte[n4][];
        for (int i = 0; i < n4; ++i) {
            byArrayArray[i] = new byte[n];
            for (n3 = 0; n3 < n; ++n3) {
                byArrayArray[i][n3] = (byte)(97 + i);
            }
            byArrayArray2[i] = new byte[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                byArrayArray2[i][n3] = (byte)(65 + i);
            }
        }
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement(string2);
        for (n3 = 0; n3 < n4; ++n3) {
            preparedStatement.setInt(1, n3);
            preparedStatement.setBinaryStream(2, (InputStream)new ByteArrayInputStream(byArrayArray[n3]), n);
            preparedStatement.setBinaryStream(3, (InputStream)new ByteArrayInputStream(byArrayArray2[n3]), n2);
            preparedStatement.executeUpdate();
            object = "insert into " + string + " select * from " + string + " where a = -6363";
            statement.execute((String)object);
        }
        preparedStatement.close();
        this.commit();
        ResultSet resultSet = statement.executeQuery("select a, b, c from " + string);
        while (resultSet.next()) {
            n3 = resultSet.getInt("a");
            object = resultSet.getBytes(2);
            byte[] byArray = byArrayArray[n3];
            StreamingColumnTest.assertTrue((String)("FAIL -- bad result byte array 1:canon: " + byArray + "resultString: " + object), (boolean)Arrays.equals(byArray, object));
            object = resultSet.getBytes(3);
            byArray = byArrayArray2[n3];
            StreamingColumnTest.assertTrue((String)("FAIL -- bad result byte array 2:canon: " + byArray + "resultString: " + object), (boolean)Arrays.equals(byArray, object));
        }
        resultSet.close();
        statement.execute("insert into " + string + " select * from " + string);
        statement.close();
        this.commit();
        StreamingColumnTest.println("Finishing streamTest9(" + n + ", " + n2 + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStream10() throws Exception {
        StreamingColumnTest.println("Test 10 starts from here");
        Statement statement = this.createStatement();
        for (int i = 0; i < fileName.length; ++i) {
            StreamingColumnTest.println("i:" + i + " fileName:" + fileName[i]);
            File file = new File(fileName[i]);
            StreamingColumnTest.fileLength[i] = PrivilegedFileOpsForTests.length(file);
            FileInputStream fileInputStream = PrivilegedFileOpsForTests.getFileInputStream(file);
            StreamingColumnTest.println("===> testing " + fileName[i] + " length = " + fileLength[i]);
            PreparedStatement preparedStatement = this.prepareStatement("insert into tab10 values(?, ?, ?)");
            preparedStatement.setInt(1, 100 + i);
            preparedStatement.setInt(2, 100 + i);
            preparedStatement.setAsciiStream(3, (InputStream)fileInputStream, (int)fileLength[i]);
            try {
                StreamingColumnTest.println(preparedStatement.toString());
                preparedStatement.executeUpdate();
                if (i == 2) {
                    StreamingColumnTest.fail((String)"Length 414000 should have thrown a truncation error!");
                }
                StreamingColumnTest.println("No truncation and hence no error");
                continue;
            }
            catch (SQLException sQLException) {
                StreamingColumnTest.println(i + " " + fileName[i]);
                if (fileLength[i] > 32700L) {
                    if (StreamingColumnTest.usingDerbyNetClient() && i == 2) {
                        StreamingColumnTest.assertSQLState("XJ001", sQLException);
                    } else {
                        StreamingColumnTest.assertSQLState("22001", sQLException);
                    }
                    StreamingColumnTest.println("expected exception for data > 32700 in length");
                    continue;
                }
                throw sQLException;
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        CallableStatement callableStatement = this.prepareCall("CALL SYSCS_UTIL.SYSCS_COMPRESS_TABLE(?, ?, ?)");
        callableStatement.setString(1, "APP");
        callableStatement.setString(2, "TESTLONGVARCHAR1");
        callableStatement.setInt(3, 0);
        callableStatement.execute();
        statement.execute("CREATE FUNCTION ConsistencyChecker() RETURNS VARCHAR(128) EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.T_ConsistencyChecker.runConsistencyChecker' LANGUAGE JAVA PARAMETER STYLE JAVA");
        statement.execute("VALUES ConsistencyChecker()");
        statement.close();
        StreamingColumnTest.println("Test 10 ends here");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStream11() throws Exception {
        StreamingColumnTest.println("Test 11 - Can't pass negative length as the stream length for various setXXXStream methods");
        File file = new File("extin/short.data");
        FileInputStream fileInputStream = PrivilegedFileOpsForTests.getFileInputStream(file);
        PreparedStatement preparedStatement = this.prepareStatement("insert into testLongVarCharInvalidStreamLength11 values(?, ?, ?)");
        preparedStatement.setInt(1, 100);
        try {
            StreamingColumnTest.println("===> testing using setAsciiStream with -2 as length");
            preparedStatement.setAsciiStream(2, (InputStream)fileInputStream, -2);
            StreamingColumnTest.fail((String)"FAIL -- should have gotten exception for -2 param value to setAsciiStream");
        }
        catch (SQLException sQLException) {
            StreamingColumnTest.assertSQLState("XJ025", sQLException);
            StreamingColumnTest.println("Expected exception:" + sQLException.toString());
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "US-ASCII");
        try {
            StreamingColumnTest.println("===> testing using setCharacterStream with -1 as length");
            preparedStatement.setCharacterStream(2, (Reader)inputStreamReader, -1);
            StreamingColumnTest.fail((String)"FAIL -- should have gotten exception for -1 param value to setCharacterStream");
        }
        catch (SQLException sQLException) {
            StreamingColumnTest.assertSQLState("XJ025", sQLException);
            StreamingColumnTest.println("PASS -- expected exception:" + sQLException.toString());
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        try {
            StreamingColumnTest.println("===> testing using setBinaryStream with -1 as length");
            preparedStatement.setBinaryStream(3, (InputStream)fileInputStream, -1);
            StreamingColumnTest.fail((String)"FAIL -- should have gotten exception for -1 param value to setBinaryStream");
        }
        catch (SQLException sQLException) {
            StreamingColumnTest.assertSQLState("XJ025", sQLException);
            StreamingColumnTest.println("Expected exception:" + sQLException.toString());
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        StreamingColumnTest.println("Test 11 - negative stream length tests end in here");
    }

    public void testStream12() throws Exception {
        String string = "extin/char32675trailingblanks.data";
        String string2 = "extin/char32675.data";
        StreamingColumnTest.println("Test 12 - varchar truncation tests start from here");
        Statement statement = this.createStatement();
        String string3 = new String(Formatters.repeatChar("a", 16350));
        String string4 = new String(Formatters.repeatChar("a", 16336));
        PreparedStatement preparedStatement = this.prepareStatement("insert into testConcatenation12 values (?, ?, ?, ?)");
        preparedStatement.setString(1, string3);
        preparedStatement.setString(2, string3);
        preparedStatement.setString(3, string4);
        preparedStatement.setString(4, string4);
        preparedStatement.executeUpdate();
        preparedStatement = this.prepareStatement("insert into testVarChar12 values(?, ?)");
        StreamingColumnTest.insertDataUsingAsciiStream(preparedStatement, 1, string, 32672, 12);
        StreamingColumnTest.insertDataUsingCharacterStream(preparedStatement, 2, string, 32672, 12);
        StreamingColumnTest.insertDataUsingStringOrObject(preparedStatement, 3, 32672, true, true, 12);
        StreamingColumnTest.insertDataUsingStringOrObject(preparedStatement, 4, 32672, true, false, 12);
        StreamingColumnTest.println("===> testing trailing blanks using concatenation");
        StreamingColumnTest.insertDataUsingConcat(statement, 5, 32672, true, 3, "testConcatenation12");
        StreamingColumnTest.insertDataUsingAsciiStream(preparedStatement, 6, string2, 32672, 12);
        StreamingColumnTest.insertDataUsingCharacterStream(preparedStatement, 7, string2, 32672, 12);
        StreamingColumnTest.insertDataUsingStringOrObject(preparedStatement, 8, 32672, false, true, 12);
        StreamingColumnTest.insertDataUsingStringOrObject(preparedStatement, 9, 32672, false, false, 12);
        StreamingColumnTest.println("===> testing trailing non-blank characters using concatenation");
        StreamingColumnTest.insertDataUsingConcat(statement, 10, 32672, false, 3, "testConcatenation12");
        ResultSet resultSet = statement.executeQuery("select a, b from testVarChar12");
        StreamingColumnTest.streamTestDataVerification(resultSet, 32672);
        StreamingColumnTest.println("Test 12 - varchar truncation tests end in here");
    }

    public void testStream13() throws Exception {
        String string = "extin/char32703trailingblanks.data";
        String string2 = "extin/char32703.data";
        StreamingColumnTest.println("testStream13 - long varchar truncation tests start from here");
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("insert into testLongVarChars13 values(?, ?)");
        StreamingColumnTest.insertDataUsingAsciiStream(preparedStatement, 1, string, 32700, 13);
        StreamingColumnTest.insertDataUsingCharacterStream(preparedStatement, 2, string, 32700, 13);
        StreamingColumnTest.insertDataUsingStringOrObject(preparedStatement, 3, 32700, true, true, 13);
        StreamingColumnTest.insertDataUsingStringOrObject(preparedStatement, 4, 32700, true, false, 13);
        StreamingColumnTest.insertDataUsingAsciiStream(preparedStatement, 6, string2, 32700, 13);
        StreamingColumnTest.insertDataUsingCharacterStream(preparedStatement, 7, string2, 32700, 13);
        StreamingColumnTest.insertDataUsingStringOrObject(preparedStatement, 7, 32700, false, true, 13);
        StreamingColumnTest.insertDataUsingStringOrObject(preparedStatement, 9, 32700, false, false, 13);
        ResultSet resultSet = statement.executeQuery("select a, b from testLongVarChars13");
        StreamingColumnTest.streamTestDataVerification(resultSet, 32700);
        StreamingColumnTest.println("Test 13 - long varchar truncation tests end in here");
    }

    public void testStream14() throws Exception {
        String string = "extin/char32675trailingblanks.data";
        String string2 = "extin/char32675.data";
        StreamingColumnTest.println("testStream 14 - clob truncation tests start from here");
        Statement statement = this.createStatement();
        String string3 = new String(Formatters.repeatChar("a", 16350));
        String string4 = new String(Formatters.repeatChar("a", 16336));
        PreparedStatement preparedStatement = this.prepareStatement("insert into testConcatenation14 values (?, ?, ?, ?)");
        preparedStatement.setString(1, string3);
        preparedStatement.setString(2, string3);
        preparedStatement.setString(3, string4);
        preparedStatement.setString(4, string4);
        preparedStatement.executeUpdate();
        preparedStatement = this.prepareStatement("insert into testClob14 values(?, ?)");
        StreamingColumnTest.insertDataUsingAsciiStream(preparedStatement, 1, string, 32672, 14);
        StreamingColumnTest.insertDataUsingCharacterStream(preparedStatement, 2, string, 32672, 14);
        StreamingColumnTest.insertDataUsingStringOrObject(preparedStatement, 3, 32672, true, true, 14);
        StreamingColumnTest.insertDataUsingStringOrObject(preparedStatement, 4, 32672, true, false, 14);
        StreamingColumnTest.println("testStream14 - Testing trailing blanks using concatenation");
        StreamingColumnTest.insertDataUsingConcat(statement, 5, 32672, true, 2, "testConcatenation14");
        StreamingColumnTest.insertDataUsingAsciiStream(preparedStatement, 6, string2, 32672, 14);
        StreamingColumnTest.insertDataUsingCharacterStream(preparedStatement, 7, string2, 32672, 14);
        StreamingColumnTest.insertDataUsingStringOrObject(preparedStatement, 8, 32672, false, true, 14);
        StreamingColumnTest.insertDataUsingStringOrObject(preparedStatement, 9, 32672, false, false, 14);
        StreamingColumnTest.println("testStream14 - Testing trailing non-blank characters using concatenation");
        StreamingColumnTest.insertDataUsingConcat(statement, 10, 32672, false, 2, "testConcatenation14");
        ResultSet resultSet = statement.executeQuery("select a, b from testVarChar12");
        StreamingColumnTest.streamTestDataVerification(resultSet, 32672);
        StreamingColumnTest.println("Test 14 - clob truncation tests end in here");
    }

    public void testDerby500() throws Exception {
        int n;
        StreamingColumnTest.println("======================================");
        StreamingColumnTest.println("START  DERBY-500 TEST ");
        Statement statement = this.createStatement();
        this.setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("insert into test500 values (?,?,?,?,?)");
        int n2 = 0;
        int n3 = 10000;
        byte[] byArray = new byte[n3];
        char[] cArray = new char[n3];
        int n4 = 99;
        for (n = 0; n < n3; ++n) {
            byArray[n] = (byte)n4;
            cArray[n] = n4;
        }
        n = 9998;
        byArray[n] = 101;
        cArray[n] = 101;
        StreamingColumnTest.println("Inserting rows ");
        for (int i = 0; i < 10; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setString(2, "mname" + i);
            preparedStatement.setInt(3, 0);
            preparedStatement.setBinaryStream(4, (InputStream)new ByteArrayInputStream(byArray), n3);
            preparedStatement.setAsciiStream(5, (InputStream)new ByteArrayInputStream(byArray), n3);
            n2 += preparedStatement.executeUpdate();
        }
        this.commit();
        StreamingColumnTest.println("Rows inserted =" + n2);
        PreparedStatement preparedStatement2 = this.prepareStatement(" select chardata,bytedata from test500 where id = ?");
        this.verifyDerby500Test(preparedStatement2, byArray, cArray, 0, 10, true);
        PreparedStatement preparedStatement3 = this.prepareStatement("update test500 set bytedata = ? , chardata = ? where mvalue = ?  ");
        byArray[n + 1] = 117;
        cArray[n + 1] = 117;
        n2 = 0;
        StreamingColumnTest.println("Update qualifies many rows + streams");
        try {
            preparedStatement3.setBinaryStream(1, (InputStream)new ByteArrayInputStream(byArray), n3);
            preparedStatement3.setCharacterStream(2, (Reader)new CharArrayReader(cArray), n3);
            preparedStatement3.setInt(3, 0);
            StreamingColumnTest.println("DERBY500 #1 Rows updated  =" + (n2 += preparedStatement3.executeUpdate()));
            StreamingColumnTest.fail((String)"Attempting to reuse stream should have thrown an exception!");
        }
        catch (SQLException sQLException) {
            StreamingColumnTest.assertSQLState("XJ001", sQLException);
            StreamingColumnTest.println("EXPECTED EXCEPTION - streams cannot be re-used");
            this.rollback();
        }
        byArray[n + 1] = (byte)n4;
        cArray[n + 1] = n4;
        this.verifyDerby500Test(preparedStatement2, byArray, cArray, 0, 10, true);
        PreparedStatement preparedStatement4 = this.prepareStatement("update test500 set bytedata = ? , chardata = ? where id = ?  ");
        byArray[n + 1] = 117;
        cArray[n + 1] = 117;
        n2 = 0;
        preparedStatement4.setBinaryStream(1, (InputStream)new ByteArrayInputStream(byArray), n3);
        preparedStatement4.setAsciiStream(2, (InputStream)new ByteArrayInputStream(byArray), n3);
        preparedStatement4.setInt(3, 0);
        StreamingColumnTest.println("DERBY500 #2 Rows updated  =" + (n2 += preparedStatement4.executeUpdate()));
        this.commit();
        this.verifyDerby500Test(preparedStatement2, byArray, cArray, 0, 1, true);
        PreparedStatement preparedStatement5 = this.prepareStatement("delete from test500 where mvalue = ?");
        n2 = 0;
        preparedStatement5.setInt(1, 0);
        n2 += preparedStatement5.executeUpdate();
        StreamingColumnTest.println("DERBY500 #3 Rows deleted =" + (n2 += preparedStatement5.executeUpdate()));
        this.commit();
        this.verifyDerby500Test(preparedStatement2, byArray, cArray, 0, 10, true);
        PreparedStatement preparedStatement6 = this.prepareStatement("delete from test500 where id = ?");
        n2 = 0;
        preparedStatement6.setInt(1, 0);
        StreamingColumnTest.println("DERBY500 #4 Rows deleted  =" + (n2 += preparedStatement6.executeUpdate()));
        this.commit();
        this.verifyDerby500Test(preparedStatement2, byArray, cArray, 1, 2, true);
        try {
            preparedStatement.setInt(1, 11);
            n2 += preparedStatement.executeUpdate();
            StreamingColumnTest.fail((String)"Attempting to reuse stream should have thrown an exception!");
        }
        catch (SQLException sQLException) {
            if (StreamingColumnTest.usingDerbyNetClient()) {
                StreamingColumnTest.assertSQLState("XN017", sQLException);
            } else {
                StreamingColumnTest.assertSQLState("XJ001", sQLException);
                StreamingColumnTest.println("EXPECTED EXCEPTION - streams cannot be re-used");
            }
            this.rollback();
        }
        this.commit();
        statement.close();
        preparedStatement2.close();
        preparedStatement4.close();
        preparedStatement3.close();
        preparedStatement5.close();
        preparedStatement6.close();
        StreamingColumnTest.println("END  DERBY-500 TEST ");
        StreamingColumnTest.println("======================================");
    }

    public void testDerby500_verifyVarcharStreams() throws Exception {
        Object object;
        int n;
        StreamingColumnTest.println("======================================");
        StreamingColumnTest.println("START  DERBY-500 TEST for varchar ");
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("insert into test500_verify values (?,?,?,?,?)");
        int n2 = 0;
        int n3 = 10000;
        byte[] byArray = new byte[n3];
        char[] cArray = new char[n3];
        int n4 = 99;
        for (n = 0; n < n3; ++n) {
            byArray[n] = (byte)n4;
            cArray[n] = n4;
        }
        n = 9998;
        byArray[n] = 101;
        cArray[n] = 101;
        for (int i = 0; i < 10; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setString(2, "mname" + i);
            preparedStatement.setInt(3, 0);
            preparedStatement.setCharacterStream(4, (Reader)new CharArrayReader(cArray), n3);
            preparedStatement.setAsciiStream(5, (InputStream)new ByteArrayInputStream(byArray), n3);
            n2 += preparedStatement.executeUpdate();
        }
        this.commit();
        StreamingColumnTest.println("Rows inserted =" + n2);
        try {
            preparedStatement.setInt(1, 11);
            n2 += preparedStatement.executeUpdate();
            if (StreamingColumnTest.usingDerbyNetClient()) {
                StreamingColumnTest.fail((String)"Expected second executeUpdate with client driver to fail");
            }
        }
        catch (SQLException sQLException) {
            if (StreamingColumnTest.usingDerbyNetClient()) {
                object = "XN017";
                if (sQLException.getSQLState().equals("XN014")) {
                    object = "XN014";
                }
                StreamingColumnTest.assertSQLState((String)object, sQLException);
            }
            StreamingColumnTest.println("UNEXPECTED EXCEPTION - streams cannot be re-used but in case of varchar, stream is materialized the first time around. So multiple executions using streams should  work fine. ");
            throw sQLException;
        }
        PreparedStatement preparedStatement2 = this.prepareStatement(" select lvc,vc from test500_verify where id = ?");
        this.verifyDerby500Test(preparedStatement2, byArray, cArray, 0, 10, false);
        object = this.prepareStatement("update test500_verify set vc = ? , lvc = ? where mvalue = ?  ");
        byArray[n + 1] = 117;
        cArray[n + 1] = 117;
        n2 = 0;
        object.setAsciiStream(1, (InputStream)new ByteArrayInputStream(byArray), n3);
        object.setCharacterStream(2, (Reader)new CharArrayReader(cArray), n3);
        object.setInt(3, 0);
        StreamingColumnTest.println("DERBY500 for varchar #1 Rows updated  =" + (n2 += object.executeUpdate()));
        this.verifyDerby500Test(preparedStatement2, byArray, cArray, 0, 10, false);
        PreparedStatement preparedStatement3 = this.prepareStatement("update test500_verify set vc = ? , lvc = ? where id = ?  ");
        byArray[n + 1] = 104;
        cArray[n + 1] = 104;
        n2 = 0;
        preparedStatement3.setAsciiStream(1, (InputStream)new ByteArrayInputStream(byArray), n3);
        preparedStatement3.setAsciiStream(2, (InputStream)new ByteArrayInputStream(byArray), n3);
        preparedStatement3.setInt(3, 0);
        this.commit();
        StreamingColumnTest.println("DERBY500 for varchar #2 Rows updated  =" + (n2 += preparedStatement3.executeUpdate()));
        this.verifyDerby500Test(preparedStatement2, byArray, cArray, 0, 1, false);
        PreparedStatement preparedStatement4 = this.prepareStatement("delete from test500_verify where mvalue = ?");
        n2 = 0;
        preparedStatement4.setInt(1, 0);
        n2 += preparedStatement4.executeUpdate();
        StreamingColumnTest.println("DERBY500 for varchar #3 Rows deleted =" + (n2 += preparedStatement4.executeUpdate()));
        this.verifyDerby500Test(preparedStatement2, byArray, cArray, 0, 10, false);
        PreparedStatement preparedStatement5 = this.prepareStatement("delete from test500_verify where id = ?");
        n2 = 0;
        preparedStatement5.setInt(1, 0);
        this.commit();
        StreamingColumnTest.println("DERBY500 for varchar #4 Rows deleted  =" + (n2 += preparedStatement5.executeUpdate()));
        this.verifyDerby500Test(preparedStatement2, byArray, cArray, 1, 2, false);
        this.commit();
        statement.close();
        preparedStatement2.close();
        preparedStatement3.close();
        object.close();
        preparedStatement4.close();
        preparedStatement5.close();
        StreamingColumnTest.println("END  DERBY-500 TEST  for varchar");
        StreamingColumnTest.println("======================================");
    }

    private void verifyDerby500Test(PreparedStatement preparedStatement, byte[] byArray, char[] cArray, int n, int n2, boolean bl) throws Exception {
        int n3 = 0;
        ResultSet resultSet = null;
        for (int i = n; i < n2; ++i) {
            preparedStatement.setInt(1, i);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) continue;
            StreamingColumnTest.compareCharArray(resultSet.getCharacterStream(1), cArray, cArray.length);
            if (bl) {
                Arrays.equals(resultSet.getBytes(2), byArray);
            } else {
                StreamingColumnTest.compareCharArray(resultSet.getCharacterStream(2), cArray, cArray.length);
            }
            ++n3;
        }
        StreamingColumnTest.println("Rows selected =" + n3);
        resultSet.close();
    }

    private static void compareCharArray(Reader reader, char[] cArray, int n) throws Exception {
        int n2 = 0;
        int n3 = 0;
        do {
            n2 = reader.read();
            StreamingColumnTest.assertEquals((String)("MISMATCH in data stored versus data retrieved at " + (n3 - 1)), (int)n2, (int)cArray[n3++]);
        } while (n2 != -1 && --n > 0);
    }

    private static void streamTestDataVerification(ResultSet resultSet, int n) throws Exception {
        resultSet.getMetaData();
        byte[] byArray = new byte[128];
        while (resultSet.next()) {
            int n2;
            int n3 = resultSet.getInt("a");
            InputStream inputStream = resultSet.getAsciiStream(2);
            int n4 = 0;
            while ((n2 = inputStream.read(byArray)) != -1) {
                n4 += n2;
            }
            if (n3 >= 1 && n3 <= 5 && n4 == n) {
                StreamingColumnTest.println("===> verified length " + n);
                continue;
            }
            StreamingColumnTest.println("test failed, columnSize should be " + n + " but it is" + n4);
        }
    }

    private static void insertDataUsingConcat(Statement statement, int n, int n2, boolean bl, int n3, String string) throws Exception {
        Object object;
        boolean bl2 = false;
        switch (n3) {
            case 1: {
                object = "insert into testLongVarChars13 select " + n + ", a||b||";
                break;
            }
            case 2: {
                object = "insert into testClob14 select " + n + ", c||d||";
                bl2 = true;
                break;
            }
            default: {
                object = "insert into testVarChar12 select " + n + ", c||d||";
                bl2 = true;
            }
        }
        object = bl ? ((String)object).concat("'   ' from " + string) : ((String)object).concat("'123' from " + string);
        try {
            statement.execute((String)object);
            if (bl2 && !bl) {
                StreamingColumnTest.fail((String)"Truncation sould have thrown an exception!");
            }
            StreamingColumnTest.println("No truncation and hence no error.");
        }
        catch (SQLException sQLException) {
            StreamingColumnTest.assertSQLState("22001", sQLException);
            StreamingColumnTest.println("expected exception for data > " + n2 + " in length");
        }
    }

    private static void insertDataUsingStringOrObject(PreparedStatement preparedStatement, int n, int n2, boolean bl, boolean bl2, int n3) throws Exception {
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append('q');
        }
        String string = new String(stringBuffer);
        if (bl) {
            string = string.concat("   ");
            StreamingColumnTest.println("===> testing trailing blanks(using ");
        } else {
            string = string.concat("123");
            StreamingColumnTest.println("===> testing trailing non-blanks(using ");
        }
        preparedStatement.setInt(1, n);
        if (bl2) {
            StreamingColumnTest.println("setString) length = " + string.length());
            preparedStatement.setString(2, string);
        } else {
            StreamingColumnTest.println("setObject) length = " + string.length());
            preparedStatement.setObject(2, string);
        }
        try {
            preparedStatement.executeUpdate();
            if (!bl) {
                StreamingColumnTest.fail((String)"Should have thrown a truncation error");
            }
            StreamingColumnTest.println("No truncation and hence no error");
        }
        catch (SQLException sQLException) {
            if (string.length() > n2) {
                if (!bl && StreamingColumnTest.usingDerbyNetClient()) {
                    StreamingColumnTest.assertSQLState("XJ001", sQLException);
                } else if (n3 == 13 && StreamingColumnTest.usingDerbyNetClient()) {
                    StreamingColumnTest.assertSQLState("XJ001", sQLException);
                } else {
                    StreamingColumnTest.assertSQLState("22001", sQLException);
                }
                StreamingColumnTest.println("expected exception for data > " + n2 + " in length");
            }
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertDataUsingCharacterStream(PreparedStatement preparedStatement, int n, String string, int n2, int n3) throws Exception {
        block15: {
            File file = new File(string);
            FileInputStream fileInputStream = PrivilegedFileOpsForTests.getFileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "US-ASCII");
            StreamingColumnTest.println("===> testing(using setCharacterStream) " + string + " length = " + PrivilegedFileOpsForTests.length(file));
            preparedStatement.setInt(1, n);
            preparedStatement.setCharacterStream(2, (Reader)inputStreamReader, (int)PrivilegedFileOpsForTests.length(file));
            try {
                preparedStatement.executeUpdate();
                if ("extin/char32675.data".equals(string)) {
                    StreamingColumnTest.fail((String)"Should have thrown a truncation error");
                }
                StreamingColumnTest.println("No truncation and hence no error");
            }
            catch (SQLException sQLException) {
                if (PrivilegedFileOpsForTests.length(file) > (long)n2) {
                    if (n3 == 12) {
                        if (StreamingColumnTest.usingDerbyNetClient() && "extin/char32675.data".equals(string)) {
                            StreamingColumnTest.assertSQLState("XJ001", sQLException);
                        } else {
                            StreamingColumnTest.assertSQLState("22001", sQLException);
                        }
                    } else if (n3 == 13) {
                        if (StreamingColumnTest.usingDerbyNetClient()) {
                            StreamingColumnTest.assertSQLState("XJ001", sQLException);
                        } else {
                            StreamingColumnTest.assertSQLState("22001", sQLException);
                        }
                    } else {
                        StreamingColumnTest.assertSQLState("XJ001", sQLException);
                    }
                    StreamingColumnTest.println("expected exception for data > " + n2 + " in length");
                    break block15;
                }
                throw sQLException;
            }
            finally {
                ((Reader)inputStreamReader).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertDataUsingAsciiStream(PreparedStatement preparedStatement, int n, String string, int n2, int n3) throws Exception {
        block18: {
            File file = new File(string);
            FileInputStream fileInputStream = PrivilegedFileOpsForTests.getFileInputStream(file);
            StreamingColumnTest.println("===> testing(using setAsciiStream) " + string + " length = " + PrivilegedFileOpsForTests.length(file));
            preparedStatement.setInt(1, n);
            preparedStatement.setAsciiStream(2, (InputStream)fileInputStream, (int)PrivilegedFileOpsForTests.length(file));
            try {
                preparedStatement.executeUpdate();
                if ("extin/char32675.data".equals(string)) {
                    StreamingColumnTest.fail((String)"Should have thrown a truncation error");
                }
                StreamingColumnTest.println("No truncation and hence no error");
            }
            catch (SQLException sQLException) {
                if (PrivilegedFileOpsForTests.length(file) > (long)n2) {
                    if (n3 == 12) {
                        if (StreamingColumnTest.usingDerbyNetClient() && "extin/char32675.data".equals(string)) {
                            StreamingColumnTest.assertSQLState("XJ001", sQLException);
                        } else {
                            StreamingColumnTest.assertSQLState("22001", sQLException);
                        }
                    } else if (n3 == 13) {
                        if (StreamingColumnTest.usingDerbyNetClient()) {
                            StreamingColumnTest.assertSQLState("XJ001", sQLException);
                        } else {
                            StreamingColumnTest.assertSQLState("22001", sQLException);
                        }
                    } else if (n3 == 14) {
                        if ("extin/char32675.data".equals(string)) {
                            StreamingColumnTest.assertSQLState("XJ001", sQLException);
                        } else {
                            StreamingColumnTest.assertSQLState("22001", sQLException);
                        }
                    }
                    StreamingColumnTest.println("expected exception for data > " + n2 + " in length");
                    break block18;
                }
                throw sQLException;
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    private void verifyLength(int n, int n2, long[] lArray) {
        for (int i = 0; i < lArray.length; ++i) {
            if (n != 100 + i && n != 10000 + i) continue;
            StreamingColumnTest.assertEquals((String)("ColumnSize should be " + lArray[i] + ", but it is " + n2 + ", i = " + i), (long)lArray[i], (long)n2);
        }
    }

    private void verifyExistence(int n, String string, long l, String string2) throws Exception {
        StreamingColumnTest.assertEquals((String)("failed to find value " + string + "... at key " + n), (String)StreamingColumnTest.pad(string, l), (String)this.getLongString(n, string2));
    }

    private String getLongString(int n, String string) throws Exception {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select b from " + string + " where a = " + n);
        StreamingColumnTest.assertTrue((String)("There weren't any rows for key = " + n), (boolean)resultSet.next());
        String string2 = resultSet.getString(1);
        StreamingColumnTest.assertFalse((String)("There were multiple rows for key = " + n), (boolean)resultSet.next());
        resultSet.close();
        statement.close();
        return string2;
    }

    static String pad(String string, long l) {
        StringBuffer stringBuffer = new StringBuffer(string);
        long l2 = 1L;
        while ((long)stringBuffer.length() < l) {
            stringBuffer.append(" " + l2);
            ++l2;
        }
        return stringBuffer.toString();
    }

    private int insertLongString(int n, String string, boolean bl, String string2) throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("insert into " + string2 + " values(" + n + ", ?)");
        return this.streamInStringCol(preparedStatement, string, bl);
    }

    private int updateLongString(int n, int n2, String string) throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("update " + string + " set a = ?, b = ? where a = " + n);
        String string2 = StreamingColumnTest.pad("", n2);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes("US-ASCII"));
        preparedStatement.setInt(1, n2);
        preparedStatement.setAsciiStream(2, (InputStream)byteArrayInputStream, string2.length());
        int n3 = preparedStatement.executeUpdate();
        preparedStatement.close();
        return n3;
    }

    private int streamInStringCol(PreparedStatement preparedStatement, String string, boolean bl) throws Exception {
        int n = 0;
        if (string == null) {
            preparedStatement.setAsciiStream(1, (InputStream)null, 0);
            n = preparedStatement.executeUpdate();
        } else {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("US-ASCII"));
            if (bl) {
                preparedStatement.setBinaryStream(1, (InputStream)byteArrayInputStream, string.length());
            } else {
                preparedStatement.setAsciiStream(1, (InputStream)byteArrayInputStream, string.length());
            }
            n = preparedStatement.executeUpdate();
            byteArrayInputStream.close();
        }
        return n;
    }

    private static int streamInLongCol(PreparedStatement preparedStatement, Object object) throws Exception {
        String string = (String)object;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("US-ASCII"));
        preparedStatement.setAsciiStream(1, (InputStream)byteArrayInputStream, string.length());
        int n = preparedStatement.executeUpdate();
        byteArrayInputStream.close();
        return n;
    }

    public static Test suite() {
        Properties properties = new Properties();
        properties.setProperty("derby.storage.sortBufferMax", "5");
        properties.setProperty("derby.debug.true", "testSort");
        BaseTestSuite baseTestSuite = new BaseTestSuite("StreamingColumnTest");
        baseTestSuite.addTest(StreamingColumnTest.baseSuite("StreamingColumnTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(StreamingColumnTest.baseSuite("StreamingColumnTest:client")));
        return new SystemPropertyTestSetup((Test)baseTestSuite, properties);
    }

    protected static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(StreamingColumnTest.class);
        SupportFilesSetup supportFilesSetup = new SupportFilesSetup((Test)baseTestSuite, new String[]{"functionTests/tests/store/short.data", "functionTests/tests/store/shortbanner", "functionTests/tests/store/derby.banner", "functionTests/tests/store/empty.data", "functionTests/tests/store/char32703trailingblanks.data", "functionTests/tests/store/char32703.data", "functionTests/tests/store/char32675trailingblanks.data", "functionTests/tests/store/char32675.data"});
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts((Test)supportFilesSetup, 2, 4)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create table testLongVarChar1 (a int, b long varchar)");
                statement.execute("insert into testLongVarChar1 values(1, '')");
                statement.execute("insert into testLongVarChar1 values(2, 'test data: a string column inserted as an object')");
                statement.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '1024')");
                statement.execute("create table foo1 (a int not null, b long varchar, primary key (a))");
                statement.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
                statement.execute("create table foo2_1500 (a int not null, b long varchar, primary key (a))");
                statement.execute("create table foo2_5000 (a int not null, b long varchar, primary key (a))");
                statement.execute("create table foo2_10000 (a int not null, b long varchar, primary key (a))");
                statement.execute("create table foo3_0 (a int not null constraint pk3_0 primary key, b long varchar)");
                statement.execute("create table foo3_1500 (a int not null constraint pk3_1500 primary key, b long varchar)");
                statement.execute("create table foo3_5000 (a int not null constraint pk3_5000 primary key, b long varchar)");
                statement.execute("create table foo3_10000 (a int not null constraint pk3_10000 primary key, b long varchar)");
                statement.execute("create table testLongVarBinary4 (a int, b BLOB(1G))");
                long l = 0L;
                String string = l > 32700L ? "BLOB(1G)" : "long varchar for bit data";
                statement.execute("create table foo5_0 (a int not null constraint pk5_0 primary key, b " + string + " )");
                l = 1500L;
                string = l > 32700L ? "BLOB(1G)" : "long varchar for bit data";
                statement.execute("create table foo5_1500 (a int not null constraint pk5_1500 primary key, b " + string + " )");
                l = 5000L;
                string = l > 32700L ? "BLOB(1G)" : "long varchar for bit data";
                statement.executeUpdate("create table foo5_5000 (a int not null constraint pk5_5000 primary key, b " + string + " )");
                l = 100000L;
                string = l > 32700L ? "BLOB(1G)" : "long varchar for bit data";
                statement.executeUpdate("create table foo5_100000 (a int not null constraint pk5_100000 primary key, b " + string + " )");
                statement.executeUpdate("create table foo_6 (a int not null constraint pk6 primary key, b long varchar)");
                statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '1024')");
                statement.execute("create table testlvc7 (a int, b char(100), lvc long varchar, d char(100))");
                statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
                statement.execute("create table t8_10_2500(a int, b long varchar, c long varchar)");
                statement.execute("create table t8_2500_10(a int, b long varchar, c long varchar)");
                statement.execute("create table t9_10_2500(a int, b long varchar for bit data, c long varchar for bit data)");
                statement.execute("create table t9_2500_10(a int, b long varchar for bit data, c long varchar for bit data)");
                statement.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '1024')");
                statement.execute("create table tab10 (a int, b int, c long   varchar)");
                statement.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
                statement.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
                statement.execute("create index i_a on tab10 (a)");
                statement.execute("create index i_ab on tab10 (a, b)");
                statement.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
                statement.execute("insert into tab10 values(1, 1, '')");
                statement.execute("insert into tab10 values(2, 2, 'test data: a string column inserted as an object')");
                statement.execute("create table testLongVarCharInvalidStreamLength11 (a int, b long varchar, c long varchar for bit data)");
                statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
                statement.execute("create table testVarChar12 (a int, b varchar(32672))");
                statement.execute("create table testConcatenation12 (a varchar(16350), b varchar(16350), c varchar(16336), d varchar(16336))");
                statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
                statement.execute("create table testLongVarChars13 (a int, b long varchar)");
                statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
                statement.execute("create table testClob14 (a int, b clob(32672))");
                statement.execute("create table testConcatenation14 (a clob(16350), b clob(16350), c clob(16336), d clob(16336))");
                statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
                statement.execute("CREATE TABLE test500 (id INTEGER NOT NULL,mname VARCHAR( 254 ) NOT NULL,mvalue INT NOT NULL,bytedata BLOB NOT NULL,chardata CLOB NOT NULL,PRIMARY KEY ( id ))");
                statement.execute("CREATE TABLE test500_verify (id INTEGER NOT NULL,mname VARCHAR( 254 ) NOT NULL,mvalue INT NOT NULL,vc varchar(32500),lvc long varchar NOT NULL,PRIMARY KEY ( id ))");
            }
        };
    }

    static {
        int n = 4;
        fileName = new String[n];
        fileLength = new long[n];
        StreamingColumnTest.fileName[0] = "extin/short.data";
        StreamingColumnTest.fileName[1] = "extin/shortbanner";
        StreamingColumnTest.fileName[2] = "extin/derby.banner";
        StreamingColumnTest.fileName[3] = "extin/empty.data";
    }
}

