/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import junit.framework.Assert;

public class SecurityCheck {
    private static final String[] EMBEDDED_PUBLIC_API = new String[]{"org.apache.derby.jdbc.EmbeddedDriver", "org.apache.derby.jdbc.EmbeddedDataSource", "org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource", "org.apache.derby.jdbc.EmbeddedXADataSource", "org.apache.derby.authentication.UserAuthenticator"};
    private static final SortedMap<String, String> allInspectedClasses = new TreeMap<String, String>();

    private static boolean isPublicApi(Class clazz) {
        for (int i = 0; i < EMBEDDED_PUBLIC_API.length; ++i) {
            if (!EMBEDDED_PUBLIC_API[i].equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    public static void checkEmbeddedPublicApi() throws ClassNotFoundException {
        System.out.println("SecurityCheck: embedded public api classes");
        allInspectedClasses.clear();
        for (int i = 0; i < EMBEDDED_PUBLIC_API.length; ++i) {
            SecurityCheck.inspectClass(EMBEDDED_PUBLIC_API[i]);
        }
        SecurityCheck.report(true);
    }

    public static void report() {
        SecurityCheck.report(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void report(boolean bl) {
        SortedMap<String, String> sortedMap = allInspectedClasses;
        synchronized (sortedMap) {
            for (Map.Entry<String, String> entry : allInspectedClasses.entrySet()) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                if (string2 == null) {
                    if (!bl) continue;
                    System.out.println("CLEAR: " + string);
                    continue;
                }
                System.out.print(string2);
            }
        }
    }

    public static void inspectClass(String string) throws ClassNotFoundException {
        SecurityCheck.inspectClass(Class.forName(string), null);
    }

    public static void assertSourceSecurity(Object object, String string) {
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)SecurityCheck.inspectClass(object.getClass(), string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean inspectClass(Class clazz, String string) {
        if (!clazz.getName().startsWith("org.apache.derby.")) {
            return false;
        }
        if (clazz.getName().startsWith("org.apache.derby.client.")) {
            return false;
        }
        SortedMap<String, String> sortedMap = allInspectedClasses;
        synchronized (sortedMap) {
            Class<?> clazz2;
            boolean bl;
            if (allInspectedClasses.containsKey(clazz.getName())) {
                return true;
            }
            allInspectedClasses.put(clazz.getName(), null);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Class ");
            stringBuffer.append(clazz.getName());
            stringBuffer.append('\n');
            if (string != null) {
                allInspectedClasses.put(string, "Checked class declared as: " + string + "\n");
            }
            boolean bl2 = SecurityCheck.isPublicApi(clazz);
            boolean bl3 = false;
            boolean bl4 = clazz.getPackage().isSealed();
            boolean bl5 = Modifier.isFinal(clazz.getModifiers());
            boolean bl6 = Modifier.isPublic(clazz.getModifiers());
            boolean bl7 = Modifier.isAbstract(clazz.getModifiers());
            Constructor<?>[] constructorArray = clazz.getConstructors();
            boolean bl8 = bl = constructorArray.length != 0;
            if (bl && !bl6) {
                bl3 = true;
                stringBuffer.append("..public constructors in non-public class\n");
                if (!bl5 && !bl4) {
                    stringBuffer.append("..public constructors in non-final class and non-sealed package\n");
                }
            }
            if (bl && bl6) {
                if (!bl2) {
                    // empty if block
                }
                if (!bl5) {
                    // empty if block
                }
            }
            for (int i = 0; i < constructorArray.length; ++i) {
                if (!bl3) continue;
                stringBuffer.append("..public constructor: ");
                stringBuffer.append(constructorArray[i].toString());
                stringBuffer.append('\n');
            }
            Field[] fieldArray = clazz.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                boolean bl9 = Modifier.isStatic(field.getModifiers());
                clazz2 = field.getType();
                SecurityCheck.inspectClass(clazz2, null);
                if (Modifier.isFinal(field.getModifiers())) continue;
                bl3 = true;
                stringBuffer.append("..public non-final field: ");
                stringBuffer.append(field.toString());
                stringBuffer.append('\n');
            }
            Method[] methodArray = clazz.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                clazz2 = method.getReturnType();
                if (SecurityCheck.inspectClass(clazz2, null) && !SecurityCheck.isPublicApi(clazz2)) continue;
            }
            if (bl3) {
                allInspectedClasses.put(clazz.getName(), stringBuffer.toString());
            }
        }
        return true;
    }
}

