/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BaseTestSuite
extends TestSuite {
    private static final Comparator<TestCase> TEST_ORDERER = new Comparator<TestCase>(){

        @Override
        public int compare(TestCase testCase, TestCase testCase2) {
            return testCase.getName().compareTo(testCase2.getName());
        }
    };

    public BaseTestSuite() {
    }

    public BaseTestSuite(String string) {
        super(string);
    }

    public BaseTestSuite(Class clazz, String string) {
        super(string);
        this.orderedSuite(clazz);
    }

    public BaseTestSuite(Class clazz) {
        super(TestConfiguration.suiteName(clazz));
        this.orderedSuite(clazz);
    }

    public void addTestSuite(Class clazz) {
        this.orderedSuite(clazz);
    }

    private void orderedSuite(Class<?> clazz) {
        ArrayList<TestCase> arrayList = new ArrayList<TestCase>();
        Enumeration enumeration = new TestSuite(clazz).tests();
        while (enumeration.hasMoreElements()) {
            arrayList.add((TestCase)enumeration.nextElement());
        }
        Collections.sort(arrayList, TEST_ORDERER);
        for (TestCase testCase : arrayList) {
            this.addTest((Test)testCase);
        }
    }
}

