/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import org.apache.derbyTesting.junit.Utilities;
import org.apache.derbyTesting.junit.Version;

public class DerbyVersion
implements Comparable {
    public static final DerbyVersion _10_0 = new DerbyVersion(10, 0, 0, 0);
    public static final DerbyVersion _10_1 = new DerbyVersion(10, 1, 0, 0);
    public static final DerbyVersion _10_2 = new DerbyVersion(10, 2, 0, 0);
    public static final DerbyVersion _10_3 = new DerbyVersion(10, 3, 0, 0);
    public static final DerbyVersion _10_4 = new DerbyVersion(10, 4, 0, 0);
    public static final DerbyVersion _10_5 = new DerbyVersion(10, 5, 0, 0);
    public static final DerbyVersion _10_6 = new DerbyVersion(10, 6, 0, 0);
    public static final DerbyVersion _10_7 = new DerbyVersion(10, 7, 0, 0);
    public static final DerbyVersion _10_8 = new DerbyVersion(10, 8, 0, 0);
    public static final DerbyVersion _10_9 = new DerbyVersion(10, 9, 0, 0);
    public static final DerbyVersion _10_10 = new DerbyVersion(10, 10, 0, 0);
    public static final DerbyVersion _10_0_2_1 = new DerbyVersion(10, 0, 2, 1);
    public static final DerbyVersion _10_1_1_0 = new DerbyVersion(10, 1, 1, 0);
    public static final DerbyVersion _10_1_2_1 = new DerbyVersion(10, 1, 2, 1);
    public static final DerbyVersion _10_1_3_1 = new DerbyVersion(10, 1, 3, 1);
    public static final DerbyVersion _10_2_1_6 = new DerbyVersion(10, 2, 1, 6);
    public static final DerbyVersion _10_2_2_0 = new DerbyVersion(10, 2, 2, 0);
    public static final DerbyVersion _10_3_1_4 = new DerbyVersion(10, 3, 1, 4);
    public static final DerbyVersion _10_3_3_0 = new DerbyVersion(10, 3, 3, 0);
    public static final DerbyVersion _10_4_1_3 = new DerbyVersion(10, 4, 1, 3);
    public static final DerbyVersion _10_4_2_0 = new DerbyVersion(10, 4, 2, 0);
    public static final DerbyVersion _10_5_1_1 = new DerbyVersion(10, 5, 1, 1);
    public static final DerbyVersion _10_5_3_0 = new DerbyVersion(10, 5, 3, 0);
    public static final DerbyVersion _10_6_1_0 = new DerbyVersion(10, 6, 1, 0);
    public static final DerbyVersion _10_6_2_1 = new DerbyVersion(10, 6, 2, 1);
    public static final DerbyVersion _10_7_1_1 = new DerbyVersion(10, 7, 1, 1);
    public static final DerbyVersion _10_8_1_2 = new DerbyVersion(10, 8, 1, 2);
    public static final DerbyVersion _10_8_2_2 = new DerbyVersion(10, 8, 2, 2);
    public static final DerbyVersion _10_8_3_0 = new DerbyVersion(10, 8, 3, 0);
    public static final DerbyVersion _10_9_1_0 = new DerbyVersion(10, 9, 1, 0);
    public static final DerbyVersion FIRST_JIGSAW_VERSION = new DerbyVersion(10, 15, 0, 0);
    private final int major;
    private final int minor;
    private final int fixpack;
    private final int point;
    private final Version simpleVersion;

    public static DerbyVersion parseVersionString(String string) throws IllegalArgumentException {
        String[] stringArray = Utilities.split(string.trim(), ' ');
        if ((stringArray = Utilities.split(stringArray[0], '.')).length != 4) {
            throw new IllegalArgumentException("invalid number of version components, got " + stringArray.length + " expected 4: " + string);
        }
        return new DerbyVersion(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
    }

    public DerbyVersion(int n, int n2, int n3, int n4) {
        this.major = n;
        this.minor = n2;
        this.fixpack = n3;
        this.point = n4;
        this.simpleVersion = new Version(n, n2);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getFixpack() {
        return this.fixpack;
    }

    public int getPoint() {
        return this.point;
    }

    public boolean lessThan(DerbyVersion derbyVersion) {
        return this.compareTo(derbyVersion) < 0;
    }

    public boolean greaterThan(DerbyVersion derbyVersion) {
        return this.compareTo(derbyVersion) > 0;
    }

    public boolean greaterMinorThan(DerbyVersion derbyVersion) {
        if (!this.sameMajorAs(derbyVersion)) {
            throw new IllegalArgumentException("major versions must be equal");
        }
        return this.minor > derbyVersion.minor;
    }

    public boolean atLeast(DerbyVersion derbyVersion) {
        return this.compareTo(derbyVersion) >= 0;
    }

    public boolean atMost(DerbyVersion derbyVersion) {
        return this.compareTo(derbyVersion) <= 0;
    }

    public boolean atMajorMinor(int n, int n2) {
        return this.major == n && this.minor == n2;
    }

    public boolean atMajorMinorOf(DerbyVersion derbyVersion) {
        return this.major == derbyVersion.major && this.minor == derbyVersion.minor;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.fixpack + "." + this.point;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DerbyVersion derbyVersion = (DerbyVersion)object;
        if (this.major != derbyVersion.major) {
            return false;
        }
        if (this.minor != derbyVersion.minor) {
            return false;
        }
        if (this.fixpack != derbyVersion.fixpack) {
            return false;
        }
        return this.point == derbyVersion.point;
    }

    public int hashCode() {
        int n = 3;
        n = 23 * n + this.major;
        n = 23 * n + this.minor;
        n = 23 * n + this.fixpack;
        n = 23 * n + this.point;
        return n;
    }

    public int compareTo(Object object) {
        return this.compareTo((DerbyVersion)object);
    }

    public int compareTo(DerbyVersion derbyVersion) {
        if (this.major < derbyVersion.major) {
            return -1;
        }
        if (this.major > derbyVersion.major) {
            return 1;
        }
        if (this.minor < derbyVersion.minor) {
            return -1;
        }
        if (this.minor > derbyVersion.minor) {
            return 1;
        }
        if (this.fixpack < derbyVersion.fixpack) {
            return -1;
        }
        if (this.fixpack > derbyVersion.fixpack) {
            return 1;
        }
        if (this.point < derbyVersion.point) {
            return -1;
        }
        if (this.point > derbyVersion.point) {
            return 1;
        }
        return 0;
    }

    public Version asSimpleVersion() {
        return this.simpleVersion;
    }

    private boolean sameMajorAs(DerbyVersion derbyVersion) {
        return this.major == derbyVersion.major;
    }
}

