/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import org.apache.derbyTesting.junit.BaseJDBCTestCase;

public class JDBCPerfTestCase
extends BaseJDBCTestCase {
    private long startTime;
    private long endTime;
    private int iterations = 1;
    private int repeats = 1;
    private int testRunNum = 0;
    private long[] runs;

    public JDBCPerfTestCase(String string) {
        super(string);
        this.runs = new long[this.repeats];
    }

    public JDBCPerfTestCase(String string, int n, int n2) {
        super(string);
        this.iterations = n;
        this.repeats = n2;
        this.runs = new long[n2];
    }

    @Override
    protected void runBareOverridable() throws Throwable {
        for (int i = 0; i < this.repeats; ++i) {
            JDBCPerfTestCase.println("Repeat =" + i);
            super.runBareOverridable();
            ++this.testRunNum;
        }
        if (this.repeats == 1 && this.iterations == 1) {
            return;
        }
        long l = 0L;
        if (this.repeats > 1) {
            for (int i = 1; i < this.repeats; ++i) {
                l += this.runs[i];
            }
        } else {
            l = this.runs[0];
        }
        System.out.println("Test-" + this.getName() + ": framework:" + this.getTestConfiguration().getJDBCClient().getName() + ":iterations: " + this.iterations + " : Avg elapsedTime(ms): " + l / (this.repeats > 1 ? (long)(this.repeats - 1) : (long)this.repeats));
    }

    protected void runTest() throws Throwable {
        this.startTime = System.currentTimeMillis();
        for (int i = 0; i < this.iterations; ++i) {
            super.runTest();
        }
        this.endTime = System.currentTimeMillis();
        this.runs[this.testRunNum] = this.endTime - this.startTime;
        System.out.println("Test-" + this.getName() + ": framework:" + this.getTestConfiguration().getJDBCClient().getName() + ": run#" + this.testRunNum + " iterations: " + this.iterations + " : elapsedTime(ms): " + (this.endTime - this.startTime));
    }
}

