/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.clients;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derbyTesting.perf.clients.Client;
import org.apache.derbyTesting.perf.clients.Runner;

public class GroupByClient
implements Client {
    private static final int MAX_GROUPING_COLS = 25;
    private Connection conn;
    private PreparedStatement ps;
    private int numGroupingCols;
    private int[] numGroups = new int[26];
    private String[] groupingExpr = new String[26];
    private int totalExpectedGroups;
    private int tableSize = 0;
    private String sql;

    public GroupByClient() {
        this.numGroupingCols = Runner.getLoadOpt("numGroupingCols", -1);
        if (this.numGroupingCols > 0) {
            this.totalExpectedGroups = 1;
            for (int i = 1; i < this.numGroups.length; ++i) {
                this.numGroups[i] = Runner.getLoadOpt("numGroups" + i, 1);
                this.totalExpectedGroups *= this.numGroups[i];
                this.getGroupingExpr(i);
            }
        } else {
            this.numGroupingCols = 1;
            this.numGroups[1] = 10;
            this.totalExpectedGroups = 10;
            this.getGroupingExpr(1);
        }
        this.sql = this.buildStatement();
    }

    @Override
    public void init(Connection connection) throws SQLException {
        this.conn = connection;
        this.getTableSize();
        System.out.println("We'll run '" + this.sql + "'");
        if (this.numGroupingCols == 1) {
            System.out.println("... which should produce " + this.totalExpectedGroups + " total groups, each containing " + this.tableSize / this.totalExpectedGroups + " rows.");
        }
        this.ps = connection.prepareStatement(this.sql);
        connection.setAutoCommit(false);
    }

    private void getGroupingExpr(int n) {
        this.groupingExpr[n] = this.numGroups[n] == 1 ? null : (this.numGroups[n] == 10 ? "TEN" : (this.numGroups[n] == 100 ? "ONEPERCENT" : "MOD(UNIQUE1," + this.numGroups[n] + ")"));
    }

    private String buildStatement() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        this.appendGroups(stringBuffer);
        stringBuffer.append(", COUNT(*) FROM TENKTUP1 GROUP BY ");
        this.appendGroups(stringBuffer);
        return stringBuffer.toString();
    }

    private void appendGroups(StringBuffer stringBuffer) {
        for (int i = 1; i < this.numGroups.length && this.numGroups[i] > 1; ++i) {
            if (i > 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.groupingExpr[i]);
        }
    }

    private void dumpTables() throws SQLException {
        ResultSet resultSet = this.conn.getMetaData().getTables(null, null, "%", null);
        while (resultSet.next()) {
            System.out.println("Schem=" + resultSet.getString("TABLE_SCHEM") + " name=" + resultSet.getString("TABLE_NAME"));
        }
        resultSet.close();
        this.conn.commit();
    }

    private void getTableSize() throws SQLException {
        Statement statement = this.conn.createStatement();
        ResultSet resultSet = statement.executeQuery("select count(*) from tenktup1");
        if (!resultSet.next()) {
            throw new RuntimeException("Unable to find size of tenktup1");
        }
        this.tableSize = resultSet.getInt(1);
        resultSet.close();
        statement.close();
        this.conn.commit();
    }

    @Override
    public void doWork() throws SQLException {
        ResultSet resultSet = this.ps.executeQuery();
        int n = this.tableSize / this.totalExpectedGroups;
        int n2 = 0;
        while (resultSet.next()) {
            ++n2;
            int n3 = resultSet.getInt(1);
            int n4 = resultSet.getInt(2);
            if (this.numGroupingCols != 1 || n4 == n) continue;
            System.out.println("group=" + n3 + ", count=" + n4 + ",expectedCount=" + n);
        }
        if (this.numGroupingCols == 1 && n2 != this.totalExpectedGroups) {
            System.out.println("Total rows from GROUP BY was " + n2 + ", expected total rows to be " + this.totalExpectedGroups);
        }
        resultSet.close();
        this.conn.commit();
    }

    @Override
    public void printReport(PrintStream printStream) {
    }
}

