/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.optimizer;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.derbyTesting.system.optimizer.StaticValues;
import org.apache.derbyTesting.system.optimizer.query.GenericQuery;
import org.apache.derbyTesting.system.optimizer.query.QueryList;
import org.apache.derbyTesting.system.optimizer.utils.DataUtils;
import org.apache.derbyTesting.system.optimizer.utils.TestViews;

public class RunOptimizerTest {
    public static void main(String[] stringArray) {
        Connection connection = null;
        String string = StaticValues.embedClass;
        String string2 = StaticValues.embedURL;
        boolean bl = false;
        boolean bl2 = false;
        try {
            int n;
            File file;
            String string3 = System.getProperty("derby.optimizertest.mode");
            if (string3 != null) {
                if (string3.equalsIgnoreCase("client")) {
                    string = StaticValues.clientClass;
                    string2 = StaticValues.clientURL;
                } else {
                    string = StaticValues.embedClass;
                    string2 = StaticValues.embedURL;
                }
            }
            if (!(file = new File("testdb")).exists()) {
                bl = true;
            }
            System.out.println("Running test with url " + string2);
            if (stringArray.length > 0) {
                for (n = 0; n < stringArray.length; ++n) {
                    if (stringArray[n].equalsIgnoreCase("-reset")) {
                        bl = true;
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("-qlist")) {
                        QueryList.queryListOnly = true;
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("-verbose")) {
                        bl2 = true;
                        continue;
                    }
                    RunOptimizerTest.printUsage();
                    return;
                }
            }
            Class.forName(string);
            if (bl) {
                System.out.println("Initializing db ...");
                connection = DriverManager.getConnection(string2);
                TestViews.init();
                DataUtils.dropObjects(connection, bl2);
                DataUtils.createObjects(connection, bl2);
            } else {
                System.out.println("Use existing db ...");
                connection = DriverManager.getConnection(string2);
            }
            DataUtils.insertData(connection, bl2);
            QueryList.init(connection);
            if (bl2) {
                System.out.println(" List of query scenarios to run: " + QueryList.getQList().size());
            }
            System.out.println("Starting tests ...");
            for (n = 0; n < QueryList.getQList().size(); ++n) {
                if (bl2) {
                    System.out.println("\n______________________________________________________________________\n");
                }
                GenericQuery genericQuery = QueryList.getQList().get(n);
                if (bl2) {
                    System.out.println("*** Running query: " + genericQuery.getDescription() + " ***");
                }
                connection = null;
                connection = DriverManager.getConnection(string2);
                genericQuery.setConnection(connection);
                genericQuery.executeQueries(false, bl2);
                connection.close();
                connection = null;
                connection = DriverManager.getConnection(string2);
                genericQuery.setConnection(connection);
                genericQuery.executeQueries(true, bl2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Class not found Exception: " + classNotFoundException.getMessage());
        }
        catch (SQLException sQLException) {
            System.out.println("SQL Exception :" + sQLException);
            sQLException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println("Unexpected Exception " + exception);
            exception.printStackTrace();
        }
        RunOptimizerTest.printResults();
    }

    private static void printUsage() {
        System.out.println("Usage:");
        System.out.println("\njava org.apache.derbyTesting.system.optimizer.RunOptimizerTest -reset|-qlist\n");
        System.out.println("-reset = Reset the database and begin run");
        System.out.println("-qlist = Run only test queries from the 'query.list' file provided");
        System.out.println("\nNo arguments will run all the default test queries available in this test case.\n");
    }

    private static void printResults() {
        System.out.println("\n\n========================= R E S U L T S =========================\n");
        for (int i = 0; i < QueryList.getQList().size(); ++i) {
            System.out.println("\n________________________________________________________________________________________________");
            GenericQuery genericQuery = QueryList.getQList().get(i);
            if (genericQuery.getPrepStmtRunResults().size() == 0) {
                System.out.println("Queries didn't run");
                System.exit(0);
                continue;
            }
            System.out.println("Timings for Query type: " + genericQuery.getDescription() + "\n");
            System.out.println("QueryName\tUsing PreparedStatment\tUsing Statement\tRows Expected");
            System.out.println("------------------------------------------------------------------------------");
            System.out.println("Query size: " + genericQuery.getQueries().size());
            for (int j = 0; j < genericQuery.getQueries().size(); ++j) {
                String string = "QUERY # " + (j + 1);
                String[] stringArray = genericQuery.getPrepStmtRunResults().get(j);
                String[] stringArray2 = genericQuery.getStmtRunResults().get(j);
                for (int k = 0; k < StaticValues.ITER; ++k) {
                    System.out.println(string + "\t" + stringArray[k] + "\t\t" + stringArray2[k] + "\t" + genericQuery.getRowsExpected(j));
                }
                System.out.println("*************************************************************************");
            }
            System.out.println("\n________________________________________________________________________________________________");
        }
    }
}

