/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.shared.common.stream.HeaderPrintWriter;

public class MsgTrace
implements Runnable {
    public static final String DELAY_PARAM_NAME = "derby.memoryTrace.bombDelay";
    public static final String RING_BUFFER_SIZE_PARAM_NAME = "derby.memoryTrace.ringBufferSize";
    private static MsgTrace singleton = null;
    long bombDelay;
    int ringBufferSize;
    HeaderPrintWriter output = MsgTrace.getMonitor().getSystemStreams().stream();

    private MsgTrace() {
        this.bombDelay = PropertyUtil.getSystemInt((String)DELAY_PARAM_NAME, (int)1800);
        this.bombDelay *= 1000L;
        this.ringBufferSize = PropertyUtil.getSystemInt((String)RING_BUFFER_SIZE_PARAM_NAME, (int)99);
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    public static void traceString(String string) {
        if (singleton == null) {
            singleton = new MsgTrace();
        }
        singleton.trace(string);
    }

    private void trace(String string) {
    }

    @Override
    public void run() {
        try {
            Thread.sleep(this.bombDelay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(1);
    }

    private static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }
}

