/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby3650Test
extends BaseJDBCTestCase {
    private static final boolean runDerby3749tests = false;

    public Derby3650Test(String name) {
        super(name);
    }

    public void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
    }

    private void runQueryCasesClob(String query) throws SQLException, IOException {
        this.runQueryClob(query, true, false);
        this.runQueryClob(query, false, false);
    }

    private void runQueryClob(String query, boolean freelob, boolean commitAfterLobVerify) throws SQLException, IOException {
        int length;
        int id;
        PreparedStatement ps = this.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            id = rs.getInt(1);
            length = rs.getInt(2);
            Clob clob = rs.getClob(3);
            this.verifyClob(clob.getCharacterStream(), length, new LoopingAlphabetReader(length));
            if (freelob) {
                clob.free();
            }
            if (!commitAfterLobVerify) continue;
            this.commit();
        }
        rs.close();
        this.commit();
        rs = ps.executeQuery();
        while (rs.next()) {
            id = rs.getInt(1);
            length = rs.getInt(2);
            this.verifyClob(rs.getCharacterStream(3), length, new LoopingAlphabetReader(length));
            if (!commitAfterLobVerify) continue;
            this.commit();
        }
        rs.close();
        this.commit();
        ps.close();
    }

    private void runQueryCasesBlob(String query) throws SQLException, IOException {
        this.runQueryBlob(query, true, false);
        this.runQueryBlob(query, false, false);
    }

    private void runQueryBlob(String query, boolean freelob, boolean commitAfterLobVerify) throws SQLException, IOException {
        PreparedStatement ps = this.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Blob blob = rs.getBlob(3);
            this.verifyBlob(blob.getBinaryStream(), rs.getInt(2), rs.getInt(1));
            if (freelob) {
                blob.free();
            }
            if (!commitAfterLobVerify) continue;
            this.commit();
        }
        rs.close();
        this.rollback();
        rs = ps.executeQuery();
        while (rs.next()) {
            int id = rs.getInt(1);
            int length = rs.getInt(2);
            InputStream stream = rs.getBinaryStream(3);
            this.verifyBlob(stream, length, id);
            if (!commitAfterLobVerify) continue;
            this.commit();
        }
        rs.close();
        this.commit();
        ps.close();
    }

    private void verifyClob(Reader input, int length, Reader expected) throws SQLException, IOException {
        int input_char;
        int charcount = 0;
        do {
            input_char = input.read();
            int expect_char = expected.read();
            if (input_char == -1) continue;
            ++charcount;
            if ((char)input_char == expect_char) continue;
            Derby3650Test.fail((String)("Unexpected Character " + (char)input_char + " expected " + (char)expect_char));
        } while (input_char != -1);
        if (charcount != length) {
            Derby3650Test.fail((String)("Unexpected character count " + charcount + "expected: " + length));
        }
    }

    private void verifyBlob(InputStream is, int length, int id) throws SQLException, IOException {
        int b;
        int bytecount = 0;
        do {
            if ((b = is.read()) == -1) continue;
            ++bytecount;
            if ((byte)b == id) continue;
            Derby3650Test.fail((String)("Unexpected byte value " + (byte)b + " expected: " + id));
        } while (b != -1);
        if (bytecount != length) {
            Derby3650Test.fail((String)("Unexpected byte count, got " + bytecount + "  expected " + length));
        }
    }

    public void test1ToManyJoinClob() throws SQLException, IOException {
        this.runQueryCasesClob("select testClob.id, length, c from testClob join jointab on jointab.id = testClob.id");
    }

    public void test1ToManyJoinBlob() throws SQLException, IOException {
        this.runQueryCasesBlob("select testBlob.id, length, c from testBlob join jointab on jointab.id = testBlob.id");
    }

    public void test1ToManyHashJoinClob() throws SQLException, IOException {
        this.runQueryCasesClob("select testClob.id, length, c from --DERBY-PROPERTIES joinOrder=FIXED \ntestClob --DERBY-PROPERTIES joinStrategy=HASH \njoin jointab on jointab.id = testClob.id");
        this.runQueryCasesClob("select jointab.id, length, c from --DERBY-PROPERTIES joinOrder=FIXED \njointab --DERBY-PROPERTIES joinStrategy=HASH \njoin testClob on jointab.id = testClob.id");
    }

    public void test1ToManyHashJoinBlob() throws SQLException, IOException {
        this.runQueryCasesBlob("select testBlob.id, length, c from --DERBY-PROPERTIES joinOrder=FIXED \ntestBlob --DERBY-PROPERTIES joinStrategy=HASH \njoin jointab on jointab.id = testBlob.id");
        this.runQueryCasesBlob("select testBlob.id, length, c from --DERBY-PROPERTIES joinOrder=FIXED \njointab --DERBY-PROPERTIES joinStrategy=HASH \njoin testBlob on jointab.id = testBlob.id");
    }

    public void test1ToManyleftOuterJoinClob() throws SQLException, IOException {
        this.runQueryCasesClob("select testClob.id, length, c from testClob left outer join jointab on jointab.id = testClob.id");
        this.runQueryCasesClob("select jointab.id, length, c from jointab left outer join testClob on jointab.id = testClob.id");
    }

    public void test1ToManyleftOuterJoinBlob() throws SQLException, IOException {
        this.runQueryCasesBlob("select testBlob.id, length, c from testBlob left outer join jointab on jointab.id = testBlob.id");
        this.runQueryCasesBlob("select jointab.id, length, c from jointab left outer join testBlob on jointab.id = testBlob.id");
    }

    public void testClobSelect() throws SQLException, IOException {
        this.runQueryCasesClob("select id, length, c from testMultipleClob");
    }

    public void testBlobSelect() throws SQLException, IOException {
        this.runQueryCasesBlob("select id, length, c from testMultipleBlob");
    }

    private static void initializeClobTables(Statement stmt) throws SQLException, IOException {
        stmt.executeUpdate("CREATE TABLE testClob (id int, length int, c CLOB(2M))");
        Connection conn = stmt.getConnection();
        PreparedStatement ps = conn.prepareStatement("INSERT INTO TestClob VALUES(?,?,?)");
        ps.setInt(1, 1);
        ps.setInt(2, 40000);
        ps.setCharacterStream(3, new LoopingAlphabetReader(40000L));
        ps.executeUpdate();
        ps.setInt(1, 1);
        ps.setInt(2, 40001);
        ps.setCharacterStream(3, new LoopingAlphabetReader(40001L));
        ps.executeUpdate();
        ps.setInt(1, 2);
        ps.setInt(2, 40002);
        ps.setCharacterStream(3, new LoopingAlphabetReader(40002L));
        ps.executeUpdate();
        ps.setInt(1, 2);
        ps.setInt(2, 40003);
        ps.setCharacterStream(3, new LoopingAlphabetReader(40003L));
        ps.executeUpdate();
        ps.close();
        stmt.executeUpdate("CREATE TABLE testMultipleClob (id int, length int, c CLOB(2M))");
        ps = conn.prepareStatement("INSERT INTO testMultipleClob VALUES(?,?,?)");
        for (int i = 0; i < 100; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, 40000 + i);
            ps.setCharacterStream(3, new LoopingAlphabetReader(40000 + i));
            ps.executeUpdate();
        }
        ps.close();
        conn.commit();
    }

    private static void initializeBlobTables(Statement stmt) throws SQLException, IOException {
        stmt.executeUpdate("CREATE TABLE testBlob (id int, length int, c BLOB(2M))");
        Connection conn = stmt.getConnection();
        PreparedStatement ps = conn.prepareStatement("INSERT INTO TestBlob VALUES(?,?,?)");
        byte[] mybytes = new byte[40000];
        Arrays.fill(mybytes, (byte)1);
        ps.setInt(1, 1);
        ps.setInt(2, 40000);
        ps.setBytes(3, mybytes);
        ps.executeUpdate();
        mybytes = new byte[40001];
        Arrays.fill(mybytes, (byte)1);
        ps.setInt(1, 1);
        ps.setInt(2, 40001);
        ps.setBytes(3, mybytes);
        ps.executeUpdate();
        mybytes = new byte[40002];
        Arrays.fill(mybytes, (byte)2);
        ps.setInt(1, 2);
        ps.setInt(2, 40002);
        ps.setBytes(3, mybytes);
        ps.executeUpdate();
        mybytes = new byte[40003];
        Arrays.fill(mybytes, (byte)2);
        ps.setInt(1, 2);
        ps.setInt(2, 40003);
        ps.setBytes(3, mybytes);
        ps.executeUpdate();
        ps.close();
        stmt.executeUpdate("CREATE TABLE jointab (id int)");
        stmt.executeUpdate("INSERT INTO jointab values(1)");
        stmt.executeUpdate("INSERT INTO jointab values(1)");
        stmt.executeUpdate("INSERT INTO jointab values(2)");
        stmt.executeUpdate("INSERT INTO jointab values(2)");
        stmt.executeUpdate("CREATE TABLE testMultipleBlob (id int, length int, c BLOB(2M))");
        ps = conn.prepareStatement("INSERT INTO testMultipleBlob VALUES(?,?,?)");
        for (int i = 0; i < 100; ++i) {
            mybytes = new byte[40000 + i];
            Arrays.fill(mybytes, (byte)i);
            ps.setInt(1, i);
            ps.setInt(2, 40000 + i);
            ps.setBytes(3, mybytes);
            ps.executeUpdate();
        }
        ps.close();
        conn.commit();
    }

    protected static Test baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        suite.addTestSuite(Derby3650Test.class);
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts((Test)suite, 2, 4)){

            @Override
            protected void decorateSQL(Statement stmt) throws SQLException {
                try {
                    Derby3650Test.initializeClobTables(stmt);
                    Derby3650Test.initializeBlobTables(stmt);
                }
                catch (IOException ioe) {
                    1.fail((String)("Unexpected I/O exception during setup: " + ioe));
                }
            }
        };
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("Derby3650Test");
        suite.addTest(Derby3650Test.baseSuite("Derby3650Test:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(Derby3650Test.baseSuite("Derby3650Test:client")));
        return suite;
    }
}

