/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClosedObjectTest
extends BaseJDBCTestCase {
    private final Method method_;
    private final ObjectDecorator decorator_;
    private String name_;

    public ClosedObjectTest(Method method, ObjectDecorator decorator) {
        super("testClosedObjects");
        this.method_ = method;
        this.decorator_ = decorator;
        this.name_ = method.getDeclaringClass().getName() + "." + method.getName();
    }

    public String getName() {
        return this.name_;
    }

    public void testClosedObjects() throws Throwable {
        try {
            Object object = this.decorator_.getClosedObject();
            String implClassName = object.getClass().getName();
            this.name_ = implClassName + "." + this.method_.getName();
            if (JDBC.vmSupportsJDBC4() && !this.isImplemented()) {
                ClosedObjectTest.println("Skipping testing of " + this.method_ + " on " + implClassName + " because it is not implemented");
                this.name_ = this.name_ + "_SKIPPED";
                return;
            }
            this.method_.invoke(object, ClosedObjectTest.getNullArguments(this.method_.getParameterTypes()));
            ClosedObjectTest.assertFalse((String)("No exception was thrown for method " + this.method_), (boolean)this.decorator_.expectsException(this.method_));
        }
        catch (InvocationTargetException ite) {
            try {
                throw ite.getCause();
            }
            catch (SQLException sqle) {
                this.decorator_.checkException(this.method_, sqle);
            }
        }
    }

    private boolean isImplemented() throws NoSuchMethodException {
        for (Class<?> c = this.decorator_.getClosedObject().getClass(); c != null; c = c.getSuperclass()) {
            if (!c.getName().startsWith("org.apache.derby.")) continue;
            try {
                Method m = c.getDeclaredMethod(this.method_.getName(), this.method_.getParameterTypes());
                if (m.isSynthetic()) continue;
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return false;
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("ClosedObjectTest suite");
        suite.addTest(ClosedObjectTest.baseSuite(false));
        suite.addTest(ClosedObjectTest.baseSuite(true));
        return suite;
    }

    private static Test baseSuite(boolean network) {
        BaseTestSuite topSuite = new BaseTestSuite("ClosedObjectTest:" + (network ? "client" : "embedded"));
        BaseTestSuite dsSuite = new BaseTestSuite("ClosedObjectTest DataSource");
        DataSourceDecorator dsDecorator = new DataSourceDecorator((Test)dsSuite);
        topSuite.addTest((Test)dsDecorator);
        ClosedObjectTest.fillDataSourceSuite(dsSuite, dsDecorator);
        if (JDBC.vmSupportsJDBC3()) {
            topSuite.addTest(ClosedObjectTest.poolSuite(Collections.emptyMap()));
            if (network) {
                topSuite.addTest(ClosedObjectTest.poolSuite(Collections.singletonMap("maxStatements", 5)));
            }
            BaseTestSuite xaSuite = new BaseTestSuite("ClosedObjectTest XA");
            XADataSourceDecorator xaDecorator = new XADataSourceDecorator((Test)xaSuite);
            topSuite.addTest((Test)xaDecorator);
            ClosedObjectTest.fillDataSourceSuite(xaSuite, xaDecorator);
        }
        return network ? TestConfiguration.clientServerDecorator((Test)topSuite) : topSuite;
    }

    private static Test poolSuite(Map dsProps) {
        BaseTestSuite poolSuite = new BaseTestSuite("ClosedObjectTest ConnectionPoolDataSource");
        PoolDataSourceDecorator poolDecorator = new PoolDataSourceDecorator((Test)poolSuite, dsProps);
        ClosedObjectTest.fillDataSourceSuite(poolSuite, poolDecorator);
        return poolDecorator;
    }

    private static void fillDataSourceSuite(BaseTestSuite suite, DataSourceDecorator dsDecorator) {
        BaseTestSuite rsSuite = new BaseTestSuite("Closed ResultSet");
        ResultSetObjectDecorator rsDecorator = new ResultSetObjectDecorator((Test)rsSuite, dsDecorator);
        suite.addTest((Test)rsDecorator);
        ClosedObjectTest.fillObjectSuite(rsSuite, rsDecorator, ResultSet.class);
        BaseTestSuite stmtSuite = new BaseTestSuite("Closed Statement");
        StatementObjectDecorator stmtDecorator = new StatementObjectDecorator((Test)stmtSuite, dsDecorator);
        suite.addTest((Test)stmtDecorator);
        ClosedObjectTest.fillObjectSuite(stmtSuite, stmtDecorator, Statement.class);
        BaseTestSuite psSuite = new BaseTestSuite("Closed PreparedStatement");
        PreparedStatementObjectDecorator psDecorator = new PreparedStatementObjectDecorator((Test)psSuite, dsDecorator);
        suite.addTest((Test)psDecorator);
        ClosedObjectTest.fillObjectSuite(psSuite, psDecorator, PreparedStatement.class);
        BaseTestSuite csSuite = new BaseTestSuite("Closed CallableStatement");
        CallableStatementObjectDecorator csDecorator = new CallableStatementObjectDecorator((Test)csSuite, dsDecorator);
        suite.addTest((Test)csDecorator);
        ClosedObjectTest.fillObjectSuite(csSuite, csDecorator, CallableStatement.class);
        BaseTestSuite connSuite = new BaseTestSuite("Closed Connection");
        ConnectionObjectDecorator connDecorator = new ConnectionObjectDecorator((Test)connSuite, dsDecorator);
        suite.addTest((Test)connDecorator);
        ClosedObjectTest.fillObjectSuite(connSuite, connDecorator, Connection.class);
    }

    private static void fillObjectSuite(BaseTestSuite suite, ObjectDecorator decorator, Class iface) {
        Method[] methods = iface.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            ClosedObjectTest cot = new ClosedObjectTest(methods[i], decorator);
            suite.addTest((Test)cot);
        }
    }

    private static Object[] getNullArguments(Class[] params) {
        Object[] args = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            args[i] = ClosedObjectTest.getNullValueForType(params[i]);
        }
        return args;
    }

    private static Object getNullValueForType(Class type) {
        if (!type.isPrimitive()) {
            return null;
        }
        if (type == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (type == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (type == Byte.TYPE) {
            return (byte)0;
        }
        if (type == Short.TYPE) {
            return (short)0;
        }
        if (type == Integer.TYPE) {
            return 0;
        }
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Double.TYPE) {
            return 0.0;
        }
        ClosedObjectTest.fail((String)("Don't know how to handle type " + type));
        return null;
    }

    private static abstract class ObjectDecorator
    extends TestSetup {
        private final DataSourceDecorator decorator_;
        protected Object object_;

        public ObjectDecorator(Test test, DataSourceDecorator decorator) {
            super(test);
            this.decorator_ = decorator;
        }

        protected void tearDown() throws Exception {
            this.object_ = null;
        }

        public Object getClosedObject() {
            return this.object_;
        }

        public boolean expectsException(Method method) {
            String name = method.getName();
            return !name.equals("close") && !name.equals("isClosed") && !name.equals("isValid") && !name.equals("abort");
        }

        public final void checkException(Method method, SQLException sqle) throws SQLException {
            if (!this.expectsException(method)) {
                throw sqle;
            }
            if (sqle.getSQLState().startsWith("0A")) {
                return;
            }
            this.checkSQLState(method, sqle);
        }

        protected abstract void checkSQLState(Method var1, SQLException var2) throws SQLException;

        protected Connection createConnection() throws SQLException {
            return this.decorator_.newConnection();
        }

        protected Statement createStatement() throws SQLException {
            return this.decorator_.getConnection().createStatement();
        }

        protected PreparedStatement prepareStatement(String sql) throws SQLException {
            return this.decorator_.getConnection().prepareStatement(sql);
        }

        protected CallableStatement prepareCall(String call) throws SQLException {
            return this.decorator_.getConnection().prepareCall(call);
        }
    }

    private static class DataSourceDecorator
    extends TestSetup {
        private Connection connection_;

        public DataSourceDecorator(Test test) {
            super(test);
        }

        public final void setUp() throws SQLException {
            this.connection_ = this.newConnection();
        }

        public final Connection getConnection() {
            return this.connection_;
        }

        public final Connection newConnection() throws SQLException {
            Connection conn = this.newConnection_();
            conn.setAutoCommit(false);
            return conn;
        }

        public final void tearDown() throws SQLException {
            this.connection_.rollback();
            this.connection_.close();
            this.connection_ = null;
        }

        protected Connection newConnection_() throws SQLException {
            DataSource ds = JDBCDataSource.getDataSource();
            JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "create=true");
            return ds.getConnection();
        }
    }

    private static class XADataSourceDecorator
    extends DataSourceDecorator {
        public XADataSourceDecorator(Test test) {
            super(test);
        }

        @Override
        protected Connection newConnection_() throws SQLException {
            XADataSource ds = J2EEDataSource.getXADataSource();
            XAConnection xac = ds.getXAConnection();
            return xac.getConnection();
        }
    }

    private static class PoolDataSourceDecorator
    extends DataSourceDecorator {
        private final Map dsProps;

        public PoolDataSourceDecorator(Test test, Map dsProps) {
            super(test);
            this.dsProps = dsProps;
        }

        @Override
        protected Connection newConnection_() throws SQLException {
            ConnectionPoolDataSource ds = J2EEDataSource.getConnectionPoolDataSource();
            for (Map.Entry e : this.dsProps.entrySet()) {
                J2EEDataSource.setBeanProperty(ds, (String)e.getKey(), e.getValue());
            }
            PooledConnection pc = ds.getPooledConnection();
            return pc.getConnection();
        }
    }

    private static class ResultSetObjectDecorator
    extends ObjectDecorator {
        private Statement stmt_;

        public ResultSetObjectDecorator(Test test, DataSourceDecorator decorator) {
            super(test, decorator);
        }

        public void setUp() throws SQLException {
            this.stmt_ = this.createStatement();
            ResultSet rs = this.stmt_.executeQuery("VALUES(1)");
            rs.close();
            this.object_ = rs;
        }

        @Override
        public void tearDown() throws Exception {
            this.stmt_.close();
            this.stmt_ = null;
            super.tearDown();
        }

        @Override
        protected void checkSQLState(Method method, SQLException sqle) throws SQLException {
            String methodString;
            if (sqle.getSQLState().equals("XCL16")) {
                methodString = method.getName();
                if (methodString.indexOf("(") > 1) {
                    methodString = methodString.substring(0, methodString.length() - 2);
                }
            } else {
                throw sqle;
            }
            ResultSetObjectDecorator.assertTrue((String)("method = " + method.toString() + ", but message: " + sqle.getMessage()), (sqle.getMessage().indexOf(methodString) > 0 ? 1 : 0) != 0);
        }
    }

    private static class StatementObjectDecorator
    extends ObjectDecorator {
        public StatementObjectDecorator(Test test, DataSourceDecorator decorator) {
            super(test, decorator);
        }

        public void setUp() throws SQLException {
            Statement stmt = this.createStatement();
            stmt.close();
            this.object_ = stmt;
        }

        @Override
        protected void checkSQLState(Method method, SQLException sqle) throws SQLException {
            String sqlState = sqle.getSQLState();
            if (!sqlState.equals("XJ012")) {
                throw sqle;
            }
        }
    }

    private static class PreparedStatementObjectDecorator
    extends StatementObjectDecorator {
        public PreparedStatementObjectDecorator(Test test, DataSourceDecorator decorator) {
            super(test, decorator);
        }

        @Override
        public void setUp() throws SQLException {
            PreparedStatement ps = this.prepareStatement("VALUES(1)");
            ps.close();
            this.object_ = ps;
        }

        @Override
        protected void checkSQLState(Method method, SQLException sqle) throws SQLException {
            if (method.getDeclaringClass() != Statement.class || !sqle.getSQLState().equals("XJ016")) {
                super.checkSQLState(method, sqle);
            }
        }
    }

    private static class CallableStatementObjectDecorator
    extends PreparedStatementObjectDecorator {
        public CallableStatementObjectDecorator(Test test, DataSourceDecorator decorator) {
            super(test, decorator);
        }

        @Override
        public void setUp() throws SQLException {
            CallableStatement cs = this.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
            cs.close();
            this.object_ = cs;
        }
    }

    private static class ConnectionObjectDecorator
    extends ObjectDecorator {
        public ConnectionObjectDecorator(Test test, DataSourceDecorator decorator) {
            super(test, decorator);
        }

        public void setUp() throws SQLException {
            Connection conn = this.createConnection();
            conn.rollback();
            conn.close();
            this.object_ = conn;
        }

        @Override
        protected void checkSQLState(Method method, SQLException sqle) throws SQLException {
            if (method.getName().equals("setClientInfo") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Properties.class) {
                if (!sqle.getClass().getName().equals("java.sql.SQLClientInfoException")) {
                    throw sqle;
                }
            } else if (!sqle.getSQLState().equals("08003")) {
                throw sqle;
            }
        }
    }
}

