/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.TriggerInfo;
import org.apache.derby.impl.sql.execute.WriteCursorConstantAction;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.util.ArrayUtil;

public class UpdateConstantAction
extends WriteCursorConstantAction {
    int[] changedColumnIds;
    private boolean positionedUpdate;
    int numColumns;
    private String schemaName;
    private String tableName;
    private String[] columnNames;
    String identitySequenceUUIDString;
    RowLocation[] autoincRowLocation;
    private long[] autoincIncrement;

    public UpdateConstantAction() {
    }

    UpdateConstantAction(TableDescriptor targetTableDesc, StaticCompiledOpenConglomInfo heapSCOCI, IndexRowGenerator[] irgs, long[] indexCIDS, StaticCompiledOpenConglomInfo[] indexSCOCIs, String[] indexNames, boolean deferred, UUID targetUUID, int lockMode, int[] changedColumnIds, FKInfo[] fkInfo, TriggerInfo triggerInfo, FormatableBitSet baseRowReadList, int[] baseRowReadMap, int[] streamStorableHeapColIds, int numColumns, boolean positionedUpdate, boolean singleRowSource, RowLocation[] autoincRowLocation, boolean underMerge, String identitySequenceUUIDString) throws StandardException {
        super(targetTableDesc.getHeapConglomerateId(), heapSCOCI, irgs, indexCIDS, indexSCOCIs, indexNames, deferred, null, targetUUID, lockMode, fkInfo, triggerInfo, baseRowReadList, baseRowReadMap, streamStorableHeapColIds, singleRowSource, underMerge);
        this.changedColumnIds = changedColumnIds;
        this.positionedUpdate = positionedUpdate;
        this.numColumns = numColumns;
        this.schemaName = targetTableDesc.getSchemaName();
        this.tableName = targetTableDesc.getName();
        this.columnNames = targetTableDesc.getColumnNamesArray();
        this.autoincIncrement = targetTableDesc.getAutoincIncrementArray();
        this.identitySequenceUUIDString = identitySequenceUUIDString;
        this.autoincRowLocation = autoincRowLocation;
    }

    public boolean hasAutoincrement() {
        return this.autoincRowLocation != null;
    }

    RowLocation[] getAutoincRowLocation() {
        return this.autoincRowLocation;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.changedColumnIds = ArrayUtil.readIntArray(in);
        this.positionedUpdate = in.readBoolean();
        this.numColumns = in.readInt();
        this.autoincIncrement = ArrayUtil.readLongArray(in);
        this.identitySequenceUUIDString = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        ArrayUtil.writeIntArray(out, this.changedColumnIds);
        out.writeBoolean(this.positionedUpdate);
        out.writeInt(this.numColumns);
        ArrayUtil.writeLongArray(out, this.autoincIncrement);
        out.writeObject(this.identitySequenceUUIDString);
    }

    @Override
    public int getTypeFormatId() {
        return 39;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName(int i) {
        return this.columnNames[i];
    }

    String[] getColumnNames() {
        return this.columnNames;
    }

    public long getAutoincIncrement(int i) {
        return this.autoincIncrement[i];
    }
}

