/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class JoinDeadlockTest
extends BaseJDBCTestCase {
    public JoinDeadlockTest(String name) {
        super(name);
    }

    public static Test suite() {
        Properties systemProperties = new Properties();
        systemProperties.setProperty("derby.locks.waitTimeout", "7");
        systemProperties.setProperty("derby.locks.deadlockTimeout", "5");
        return new SystemPropertyTestSetup(TestConfiguration.defaultSuite(JoinDeadlockTest.class), systemProperties, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJoinDeadlock() throws Exception {
        Statement st = this.createStatement();
        try {
            Connection c2 = this.openDefaultConnection();
            this.setAutoCommit(false);
            c2.setAutoCommit(false);
            st.executeUpdate("create table outer1(c1 int)");
            st.executeUpdate("create index o1_i1 on outer1(c1)");
            st.executeUpdate("insert into outer1 (c1) values 1, 2");
            this.commit();
            st.executeUpdate("create table inner1(c1 int, c2 char(254))");
            st.executeUpdate("create index i1_i1 on inner1(c1)");
            st.executeUpdate("insert into inner1 (c1) values 1, 2");
            this.commit();
            st.executeUpdate("create table inner2(c1 int, c2 char(254))");
            st.executeUpdate("create index i2_i1 on inner2(c1)");
            st.executeUpdate("insert into inner2 (c1) values 1, 2");
            this.commit();
            ResultSet c1_rs = st.executeQuery("select * from outer1 where c1 <= (select count(*) from inner1, inner2 where outer1.c1 = outer1.c1)");
            c1_rs.next();
            JoinDeadlockTest.assertEquals((String)c1_rs.getString(1), (String)"1");
            Statement c2_st = c2.createStatement();
            c2_st.executeUpdate("update inner1 set c1 = c1 where c1 = 1");
            try {
                c1_rs.next();
            }
            catch (SQLException e) {
                JoinDeadlockTest.assertSQLState("40XL1", e);
            }
            c2.rollback();
            c2.close();
        }
        finally {
            this.dontThrow(st, "drop table outer1");
            this.dontThrow(st, "drop table inner1");
            this.dontThrow(st, "drop table inner2");
            this.commit();
        }
    }

    private void dontThrow(Statement st, String stm) {
        try {
            st.executeUpdate(stm);
        }
        catch (SQLException e) {
            JoinDeadlockTest.println("\"" + stm + "\" failed");
        }
    }
}

