/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memorydb;

import java.util.Arrays;
import java.util.Random;

public class SampMog {
    public Random rng;
    public static final int max_n = 6;
    int n = 3;
    final double[] weight = new double[6];
    final double[] mean = new double[6];
    final double[] var = new double[6];
    final double[] cumulative = new double[6];
    final double[] stdv = new double[6];

    public SampMog() {
        this.rng = new Random(System.currentTimeMillis());
    }

    public SampMog(Random rng) {
        this.rng = rng;
    }

    public void generate(int ns, double[] sample) {
        int i;
        for (i = 0; i < ns; ++i) {
            double r;
            sample[i] = r = this.rng.nextGaussian();
        }
        for (i = 0; i < ns; ++i) {
            double x;
            double w = this.rng.nextDouble();
            int idx = Arrays.binarySearch(this.cumulative, w);
            if (idx < 0) {
                idx = -(idx + 1);
            }
            if (idx >= this.n) {
                idx = this.n - 1;
            }
            double m = this.mean[idx];
            double s = this.stdv[idx];
            double r = sample[i];
            sample[i] = x = m + s * r;
        }
    }

    public static int getMaxNumber() {
        return 6;
    }

    public int getNumber() {
        return this.n;
    }

    public void set(int n, double[] wts, double[] mm, double[] vv) {
        this.setNumber(n);
        this.setWeights(wts);
        this.setMeans(mm);
        this.setVars(vv);
    }

    public void setNumber(int n) {
        if (1 > n || n > 6) {
            String msg = "Number of Gaussian components (" + n + ") not in [1, 6].";
            throw new IllegalArgumentException(msg);
        }
        this.n = n;
    }

    public void setWeights(double[] wts) {
        int i;
        int i2;
        System.arraycopy(wts, 0, this.weight, 0, this.n);
        IllegalArgumentException ex = null;
        double sum = 0.0;
        for (i2 = 0; i2 < this.n; ++i2) {
            double wt = this.weight[i2];
            if (wt > 0.0) {
                sum += wt;
                continue;
            }
            if (ex != null) continue;
            String msg = "Invalid weight (" + wt + ").";
            ex = new IllegalArgumentException(msg);
        }
        if (sum > 0.0) {
            i2 = 0;
            while (i2 < this.n) {
                int n = i2++;
                this.weight[n] = this.weight[n] / sum;
            }
        } else if (ex == null) {
            String msg = "Invalid total weight (" + sum + ").";
            ex = new IllegalArgumentException(msg);
        }
        if (ex != null) {
            throw ex;
        }
        this.cumulative[0] = this.weight[0];
        for (i = 1; i < this.n; ++i) {
            this.cumulative[i] = Math.min(this.cumulative[i - 1] + this.weight[i], 1.0);
        }
        for (i = this.n; i < 6; ++i) {
            this.cumulative[i] = 1.0;
        }
    }

    public void setMeans(double[] mm) {
        System.arraycopy(mm, 0, this.mean, 0, this.n);
    }

    public void setVars(double[] vv) {
        for (int i = 0; i < this.n; ++i) {
            double v;
            this.var[i] = v = Math.abs(vv[i]);
            this.stdv[i] = Math.sqrt(v);
        }
    }
}

