/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ConnectWrongSubprotocolTest
extends BaseJDBCTestCase {
    public ConnectWrongSubprotocolTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("empty: no support for Driver.sql.Manager with jsr 169");
        }
        if (!Derby.hasTools()) {
            return new BaseTestSuite("empty: no tools support");
        }
        Properties props = new Properties();
        props.setProperty("ij.connection.wrongSubprotocol", "jdbc:noone:fruitfly;create=true");
        Test test = TestConfiguration.embeddedSuite(ConnectWrongSubprotocolTest.class);
        return new SystemPropertyTestSetup(test, props);
    }

    public void testConnectWrongSubprotocolWithSystemProperty() throws UnsupportedEncodingException, SQLException {
        String emptyIjScript = "";
        boolean useSystemProperties = true;
        this.checkConnectWrongSubprotocol(emptyIjScript, useSystemProperties);
    }

    public void testConnectWrongSubprotoctestolWithoutSystemProperty() throws UnsupportedEncodingException, SQLException {
        String ijScriptConnectWrongSubprotocol = "connect 'jdbc:noone:fruitfly;create=true';";
        boolean useSystemProperties = false;
        this.checkConnectWrongSubprotocol(ijScriptConnectWrongSubprotocol, useSystemProperties);
    }

    private void checkConnectWrongSubprotocol(String ijScript, boolean useSystemProperties) throws UnsupportedEncodingException, SQLException {
        String ijResult = this.runIjScript(ijScript, useSystemProperties);
        ConnectWrongSubprotocolTest.assertTrue((ijResult.indexOf("08001") > -1 ? 1 : 0) != 0);
        ConnectWrongSubprotocolTest.assertTrue((ijResult.indexOf("No suitable driver") > -1 ? 1 : 0) != 0);
    }

    private String runIjScript(String ijScript, boolean useSystemProperties) throws UnsupportedEncodingException, SQLException {
        ByteArrayInputStream bais = new ByteArrayInputStream(ijScript.getBytes("US-ASCII"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(10240);
        Connection conn = this.getConnection();
        ij.runScript((Connection)conn, (InputStream)bais, (String)"US-ASCII", (OutputStream)baos, (String)"US-ASCII", (boolean)useSystemProperties);
        if (!conn.isClosed() && !conn.getAutoCommit()) {
            conn.commit();
        }
        return new String(baos.toByteArray(), "US-ASCII");
    }
}

