/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.lang.ref.WeakReference;
import java.util.Hashtable;
import java.util.Stack;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientResultSet;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;

public class SectionManager {
    private Agent agent_;
    private final Stack<Section> freeSectionsNonHold_;
    private final Stack<Section> freeSectionsHold_;
    private int nextAvailableSectionNumber_ = 1;
    byte[] holdPKGNAMCBytes = null;
    byte[] noHoldPKGNAMCBytes = null;
    private static final String packageNameWithHold__ = "SYSLH000";
    private static final String packageNameWithNoHold__ = "SYSLN000";
    private static final String cursorNamePrefixWithHold__ = "SQL_CURLH000C";
    private static final String cursorNamePrefixWithNoHold__ = "SQL_CURLN000C";
    private final Hashtable<String, Section> positionedUpdateCursorNameToQuerySection_ = new Hashtable();
    private final Hashtable<String, WeakReference<ClientResultSet>> positionedUpdateCursorNameToResultSet_ = new Hashtable();
    private final int maxNumSections_ = 32768;

    public SectionManager(Agent agent) {
        this.agent_ = agent;
        this.freeSectionsNonHold_ = new Stack();
        this.freeSectionsHold_ = new Stack();
    }

    void setPKGNAMCBytes(byte[] b, int resultSetHoldability) {
        if (resultSetHoldability == 1) {
            this.agent_.sectionManager_.holdPKGNAMCBytes = b;
        } else if (resultSetHoldability == 2) {
            this.agent_.sectionManager_.noHoldPKGNAMCBytes = b;
        }
    }

    Section getDynamicSection(int resultSetHoldability) throws SqlException {
        if (resultSetHoldability == 1) {
            return this.getSection(this.freeSectionsHold_, packageNameWithHold__, cursorNamePrefixWithHold__, resultSetHoldability);
        }
        if (resultSetHoldability == 2) {
            return this.getSection(this.freeSectionsNonHold_, packageNameWithNoHold__, cursorNamePrefixWithNoHold__, resultSetHoldability);
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.3"), resultSetHoldability);
    }

    private Section getSection(Stack freeSections, String packageName, String cursorNamePrefix, int resultSetHoldability) throws SqlException {
        if (!freeSections.empty()) {
            return (Section)freeSections.pop();
        }
        if (this.nextAvailableSectionNumber_ < Short.MAX_VALUE) {
            String cursorName = cursorNamePrefix + this.nextAvailableSectionNumber_;
            Section section = new Section(this.agent_, packageName, this.nextAvailableSectionNumber_, cursorName, resultSetHoldability);
            ++this.nextAvailableSectionNumber_;
            return section;
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ200.S"), "32000");
    }

    void freeSection(Section section, int resultSetHoldability) {
        if (resultSetHoldability == 1) {
            this.freeSectionsHold_.push(section);
        } else if (resultSetHoldability == 2) {
            this.freeSectionsNonHold_.push(section);
        }
    }

    Section getPositionedUpdateSection(Section querySection) throws SqlException {
        ClientConnection connection = this.agent_.connection_;
        return this.getDynamicSection(connection.holdability());
    }

    Section getPositionedUpdateSection(String cursorName, boolean useExecuteImmediateSection) throws SqlException {
        Section querySection = this.positionedUpdateCursorNameToQuerySection_.get(cursorName);
        if (querySection != null) {
            Section section = this.getPositionedUpdateSection(querySection);
            section.setClientCursorName(querySection.getClientCursorName());
            section.serverCursorNameForPositionedUpdate_ = querySection.getServerCursorName();
            return section;
        }
        return null;
    }

    void mapCursorNameToQuerySection(String cursorName, Section section) {
        this.positionedUpdateCursorNameToQuerySection_.put(cursorName, section);
    }

    void mapCursorNameToResultSet(String cursorName, ClientResultSet resultSet) {
        this.positionedUpdateCursorNameToResultSet_.put(cursorName, new WeakReference<ClientResultSet>(resultSet));
    }

    ClientResultSet getPositionedUpdateResultSet(String cursorName) throws SqlException {
        ClientResultSet rs = (ClientResultSet)this.positionedUpdateCursorNameToResultSet_.get(cursorName).get();
        if (rs == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL16.S"), "update");
        }
        return rs.resultSetType_ == 1003 ? null : rs;
    }

    void removeCursorNameToResultSetMapping(String clientCursorName, String serverCursorName) {
        if (clientCursorName != null) {
            this.positionedUpdateCursorNameToResultSet_.remove(clientCursorName);
        }
        if (serverCursorName != null) {
            this.positionedUpdateCursorNameToResultSet_.remove(serverCursorName);
        }
    }

    void removeCursorNameToQuerySectionMapping(String clientCursorName, String serverCursorName) {
        if (clientCursorName != null) {
            this.positionedUpdateCursorNameToQuerySection_.remove(clientCursorName);
        }
        if (serverCursorName != null) {
            this.positionedUpdateCursorNameToQuerySection_.remove(serverCursorName);
        }
    }
}

