/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.qname;

import org.apache.commons.lang3.StringUtils;
import org.apache.torque.generator.qname.Namespace;

public final class QualifiedName {
    public static final char SEPARATOR = '.';
    private String name;
    private Namespace namespace;

    public QualifiedName(String qualifiedName) {
        this(qualifiedName, (Namespace)null);
    }

    public QualifiedName(String nameOrQualifiedName, String defaultNamespace) {
        this(nameOrQualifiedName, defaultNamespace != null ? new Namespace(defaultNamespace) : null);
    }

    public QualifiedName(String nameOrQualifiedName, Namespace defaultNamespace) {
        if (nameOrQualifiedName == null) {
            throw new NullPointerException("nameOrQualifiedName must not be null");
        }
        int dotIndex = nameOrQualifiedName.lastIndexOf(46);
        if (dotIndex == -1) {
            if (defaultNamespace == null) {
                defaultNamespace = Namespace.ROOT_NAMESPACE;
            }
            this.setName(nameOrQualifiedName);
            this.namespace = defaultNamespace;
        } else {
            this.setName(nameOrQualifiedName.substring(dotIndex + 1).trim());
            String namespacePart = nameOrQualifiedName.substring(0, dotIndex).trim();
            this.setNamespace(namespacePart);
        }
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        if (name.indexOf(46) != -1) {
            throw new IllegalArgumentException("name \"" + name + "\" must not contain " + '.');
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name must not be blank");
        }
        this.name = name;
    }

    private void setNamespace(String namespace) {
        this.namespace = new Namespace(namespace);
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public boolean isVisibleFrom(Namespace otherNamespace) {
        return this.namespace.isVisibleFrom(otherNamespace);
    }

    public Namespace getParentNamespace() {
        return this.namespace.getParent();
    }

    public boolean isInRootNamespace() {
        return this.namespace.isRoot();
    }

    public String toString() {
        if (this.isInRootNamespace()) {
            return this.name;
        }
        return this.namespace.toString() + '.' + this.name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof QualifiedName)) {
            return false;
        }
        QualifiedName qualifiedName = (QualifiedName)o;
        if (!qualifiedName.name.equals(this.name)) {
            return false;
        }
        return qualifiedName.namespace.equals(this.namespace);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

