/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.file;

import java.io.File;
import java.io.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;

public class WildcardFilter
implements FileFilter {
    private final String expression;
    private final boolean acceptDir;
    private final boolean acceptFile;

    public WildcardFilter(String expression, boolean acceptDir, boolean acceptFile) {
        this.expression = expression;
        this.acceptDir = acceptDir;
        this.acceptFile = acceptFile;
    }

    @Override
    public boolean accept(File file) {
        if (!this.acceptDir && file.isDirectory() || !this.acceptFile && file.isFile()) {
            return false;
        }
        return FilenameUtils.wildcardMatch((String)file.getName(), (String)this.expression, (IOCase)IOCase.SENSITIVE);
    }
}

