/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.template.velocity;

import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceException;
import org.apache.torque.generator.template.velocity.VelocityOutlet;
import org.apache.torque.generator.variable.Variable;

public class TorqueGenVelocity {
    private final ControllerState controllerState;
    private final VelocityOutlet outlet;
    private static AtomicInteger counter = new AtomicInteger(1);

    public TorqueGenVelocity(VelocityOutlet outlet, ControllerState controllerState) {
        if (controllerState == null) {
            throw new NullPointerException("controllerState may not be null");
        }
        if (outlet == null) {
            throw new NullPointerException("outlet may not be null");
        }
        this.controllerState = controllerState;
        this.outlet = outlet;
    }

    public String mergepoint(String mergepointName) throws GeneratorException {
        return this.outlet.mergepoint(mergepointName, this.controllerState);
    }

    public ControllerState getControllerState() {
        return this.controllerState;
    }

    public Object getModel() {
        return this.controllerState.getModel();
    }

    public SourceElement getSourceElement() throws SourceException {
        Object model = this.controllerState.getModel();
        if (model instanceof SourceElement) {
            return (SourceElement)model;
        }
        throw new SourceException("model is no SourceElement but is of class " + model.getClass().getName());
    }

    public List<SourceElement> getChildren() throws SourceException {
        return this.getSourceElement().getChildren();
    }

    public List<SourceElement> getChildren(String name) throws SourceException {
        return this.getSourceElement().getChildren(name);
    }

    public SourceElement getChild(String name) throws SourceException {
        return this.getSourceElement().getChild(name);
    }

    public SourceElement getParent() throws SourceException {
        return this.getSourceElement().getParent();
    }

    public Object option(String key) {
        Object result = this.controllerState.getOption(key);
        return result;
    }

    public boolean booleanOption(String key) {
        boolean result = this.controllerState.getBooleanOption(key);
        return result;
    }

    public int intOption(String key) {
        Object optionValue = this.controllerState.getOption(key);
        if (optionValue == null) {
            return 0;
        }
        String optionString = optionValue.toString();
        if (StringUtils.isBlank((CharSequence)optionString)) {
            return 0;
        }
        return Integer.parseInt(optionString);
    }

    public Object getVariable(String key) {
        return this.outlet.getVariable(key, this.controllerState);
    }

    public void setVariable(String key, Object value) {
        this.outlet.setVariable(key, value, this.controllerState);
    }

    public void setVariable(String key, Object value, String scope) {
        Variable.Scope scopeValue = Variable.Scope.valueOf(scope);
        this.outlet.setVariable(key, value, scopeValue, this.controllerState);
    }

    public File getSourceFile() {
        return this.controllerState.getSourceFile();
    }

    public Date now() {
        return new Date();
    }

    public static int getCounter() {
        return counter.incrementAndGet();
    }

    public static void resetCounter() {
        counter.set(1);
    }
}

