/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidSearchFilterException;
import org.apache.directory.api.ldap.model.filter.BranchNormalizedVisitor;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.FilterParser;
import org.apache.directory.api.ldap.model.message.AbstractAbandonableRequest;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.message.ReferralsPolicyEnum;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchResultDoneImpl;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;

public class SearchRequestImpl
extends AbstractAbandonableRequest
implements SearchRequest {
    static final long serialVersionUID = -5655881944020886218L;
    private Dn baseDn;
    private ExprNode filterNode;
    private SearchScope scope;
    private boolean typesOnly;
    private long sizeLimit;
    private int timeLimit;
    private AliasDerefMode aliasDerefMode = AliasDerefMode.DEREF_ALWAYS;
    private List<String> attributes = new ArrayList<String>();
    private SearchResultDone response;
    private ReferralsPolicyEnum referralHandling = ReferralsPolicyEnum.THROW;

    public SearchRequestImpl() {
        super(-1, MessageTypeEnum.SEARCH_REQUEST);
    }

    @Override
    public List<String> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    @Override
    public Dn getBase() {
        return this.baseDn;
    }

    @Override
    public SearchRequest setBase(Dn base) {
        this.baseDn = base;
        return this;
    }

    @Override
    public AliasDerefMode getDerefAliases() {
        return this.aliasDerefMode;
    }

    @Override
    public SearchRequest setDerefAliases(AliasDerefMode aliasDerefAliases) {
        this.aliasDerefMode = aliasDerefAliases;
        return this;
    }

    @Override
    public ExprNode getFilter() {
        return this.filterNode;
    }

    @Override
    public SearchRequest setFilter(ExprNode filter) {
        this.filterNode = filter;
        return this;
    }

    @Override
    public SearchRequest setFilter(String filter) throws LdapException {
        try {
            this.filterNode = FilterParser.parse(filter);
        }
        catch (ParseException pe) {
            throw new LdapInvalidSearchFilterException(I18n.err(I18n.ERR_13508_INVALID_FILTER, filter, pe.getMessage()));
        }
        return this;
    }

    @Override
    public MessageTypeEnum[] getResponseTypes() {
        return RESPONSE_TYPES;
    }

    @Override
    public SearchScope getScope() {
        return this.scope;
    }

    @Override
    public SearchRequest setScope(SearchScope scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public long getSizeLimit() {
        return this.sizeLimit;
    }

    @Override
    public SearchRequest setSizeLimit(long entriesMax) {
        this.sizeLimit = entriesMax;
        return this;
    }

    @Override
    public int getTimeLimit() {
        return this.timeLimit;
    }

    @Override
    public SearchRequest setTimeLimit(int secondsMax) {
        this.timeLimit = secondsMax;
        return this;
    }

    @Override
    public boolean getTypesOnly() {
        return this.typesOnly;
    }

    @Override
    public SearchRequest setTypesOnly(boolean typesOnly) {
        this.typesOnly = typesOnly;
        return this;
    }

    @Override
    public SearchRequest addAttributes(String ... attributesToAdd) {
        this.attributes.addAll(Arrays.asList(attributesToAdd));
        return this;
    }

    @Override
    public SearchRequest removeAttribute(String attribute) {
        this.attributes.remove(attribute);
        return this;
    }

    @Override
    public SearchResultDone getResultResponse() {
        if (this.response == null) {
            this.response = new SearchResultDoneImpl(this.getMessageId());
        }
        return this.response;
    }

    @Override
    public SearchRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public SearchRequest addControl(Control control) {
        return (SearchRequest)super.addControl(control);
    }

    @Override
    public SearchRequest addAllControls(Control[] controls) {
        return (SearchRequest)super.addAllControls(controls);
    }

    @Override
    public SearchRequest removeControl(Control control) {
        return (SearchRequest)super.removeControl(control);
    }

    @Override
    public int hashCode() {
        int hash = 37;
        if (this.baseDn != null) {
            hash = hash * 17 + this.baseDn.hashCode();
        }
        hash = hash * 17 + this.aliasDerefMode.hashCode();
        hash = hash * 17 + this.scope.hashCode();
        hash = hash * 17 + Long.valueOf(this.sizeLimit).hashCode();
        hash = hash * 17 + this.timeLimit;
        hash = hash * 17 + (this.typesOnly ? 0 : 1);
        if (this.attributes != null) {
            hash = hash * 17 + this.attributes.size();
            for (String attr : this.attributes) {
                if (attr == null) continue;
                hash += attr.hashCode();
            }
        }
        BranchNormalizedVisitor visitor = new BranchNormalizedVisitor();
        this.filterNode.accept(visitor);
        hash = hash * 17 + this.filterNode.toString().hashCode();
        hash = hash * 17 + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SearchRequest req = (SearchRequest)obj;
        if (!req.getBase().equals(this.baseDn)) {
            return false;
        }
        if (req.getDerefAliases() != this.aliasDerefMode) {
            return false;
        }
        if (req.getScope() != this.scope) {
            return false;
        }
        if (req.getSizeLimit() != this.sizeLimit) {
            return false;
        }
        if (req.getTimeLimit() != this.timeLimit) {
            return false;
        }
        if (req.getTypesOnly() != this.typesOnly) {
            return false;
        }
        if (req.getAttributes() == null && this.attributes != null && !this.attributes.isEmpty()) {
            return false;
        }
        if (req.getAttributes() != null && this.attributes == null && !req.getAttributes().isEmpty()) {
            return false;
        }
        if (req.getAttributes() != null && this.attributes != null) {
            if (req.getAttributes().size() != this.attributes.size()) {
                return false;
            }
            for (String attribute : this.attributes) {
                if (req.getAttributes().contains(attribute)) continue;
                return false;
            }
        }
        BranchNormalizedVisitor visitor = new BranchNormalizedVisitor();
        req.getFilter().accept(visitor);
        this.filterNode.accept(visitor);
        String myFilterString = this.filterNode.toString();
        String reqFilterString = req.getFilter().toString();
        return myFilterString.equals(reqFilterString);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    SearchRequest\n");
        sb.append("        baseDn : '").append(this.baseDn).append("'\n");
        if (this.filterNode != null) {
            sb.append("        filter : '");
            sb.append(this.filterNode.toString());
            sb.append("'\n");
        }
        sb.append("        scope : ");
        switch (this.scope) {
            case OBJECT: {
                sb.append("base object");
                break;
            }
            case ONELEVEL: {
                sb.append("single level");
                break;
            }
            case SUBTREE: {
                sb.append("whole subtree");
                break;
            }
            default: {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_13509_UNEXPECTED_SCOPE, new Object[]{this.scope}));
            }
        }
        sb.append('\n');
        sb.append("        typesOnly : ").append(this.typesOnly).append('\n');
        sb.append("        Size Limit : ");
        if (this.sizeLimit == 0L) {
            sb.append("no limit");
        } else {
            sb.append(this.sizeLimit);
        }
        sb.append('\n');
        sb.append("        Time Limit : ");
        if (this.timeLimit == 0) {
            sb.append("no limit");
        } else {
            sb.append(this.timeLimit);
        }
        sb.append('\n');
        sb.append("        Deref Aliases : ");
        switch (this.aliasDerefMode) {
            case NEVER_DEREF_ALIASES: {
                sb.append("never Deref Aliases");
                break;
            }
            case DEREF_IN_SEARCHING: {
                sb.append("deref In Searching");
                break;
            }
            case DEREF_FINDING_BASE_OBJ: {
                sb.append("deref Finding Base Obj");
                break;
            }
            case DEREF_ALWAYS: {
                sb.append("deref Always");
                break;
            }
            default: {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_13517_UNEXPECTED_ALIAS_DEREF_MODE, new Object[]{this.aliasDerefMode}));
            }
        }
        sb.append('\n');
        sb.append("        attributes : ");
        boolean isFirst = true;
        if (this.attributes != null) {
            for (String attribute : this.attributes) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append('\'').append(attribute).append('\'');
            }
        }
        sb.append('\n');
        sb.append(super.toString());
        return super.toString(sb.toString());
    }

    @Override
    public boolean isFollowReferrals() {
        return this.referralHandling == ReferralsPolicyEnum.FOLLOW;
    }

    @Override
    public SearchRequest followReferrals() {
        this.referralHandling = ReferralsPolicyEnum.FOLLOW;
        return this;
    }

    @Override
    public boolean isIgnoreReferrals() {
        return this.referralHandling == ReferralsPolicyEnum.IGNORE;
    }

    @Override
    public SearchRequest ignoreReferrals() {
        this.referralHandling = ReferralsPolicyEnum.IGNORE;
        return this;
    }
}

