/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.directory.api.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LdapClientTrustStoreManager
implements X509TrustManager,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CLS_NM = LdapClientTrustStoreManager.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(CLS_NM);
    private boolean isExamineValidityDates;
    private char[] trustStorePw;
    private String trustStoreFile;
    private String trustStoreFormat;
    private X509TrustManager[] x509TrustManagers;

    public LdapClientTrustStoreManager(String trustStoreFile, char[] trustStorePw, String trustStoreFormat, boolean isExamineValidity) {
        if (trustStoreFile == null) {
            throw new RuntimeException(I18n.err(I18n.ERR_04174_INPUT_FILE_NAME_NULL, new Object[0]));
        }
        this.trustStoreFile = trustStoreFile;
        this.trustStorePw = (char[])trustStorePw.clone();
        this.isExamineValidityDates = isExamineValidity;
        this.trustStoreFormat = trustStoreFormat == null ? KeyStore.getDefaultType() : trustStoreFormat;
    }

    @Override
    public synchronized void checkClientTrusted(X509Certificate[] x509Chain, String authNType) throws CertificateException {
        for (X509TrustManager trustMgr : this.getTrustManagers(x509Chain)) {
            trustMgr.checkClientTrusted(x509Chain, authNType);
        }
    }

    @Override
    public synchronized void checkServerTrusted(X509Certificate[] x509Chain, String authNType) throws CertificateException {
        for (X509TrustManager trustManager : this.getTrustManagers(x509Chain)) {
            trustManager.checkServerTrusted(x509Chain, authNType);
        }
    }

    @Override
    public synchronized X509Certificate[] getAcceptedIssuers() {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        for (X509TrustManager trustManager : this.x509TrustManagers) {
            for (X509Certificate certificate : trustManager.getAcceptedIssuers()) {
                certificates.add(certificate);
            }
        }
        return certificates.toArray(new X509Certificate[0]);
    }

    private synchronized X509TrustManager[] getTrustManagers(X509Certificate[] x509Chain) throws CertificateException {
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_04176_TRUST_MANAGER_ON_CLASSPATH, CLS_NM));
        }
        return this.getTrustManagersOnClasspath(x509Chain);
    }

    private synchronized X509TrustManager[] getTrustManagersOnClasspath(X509Certificate[] x509Chain) throws CertificateException {
        InputStream trustStoreInputStream;
        if (this.isExamineValidityDates) {
            Date currentDate = new Date();
            for (X509Certificate x509Cert : x509Chain) {
                x509Cert.checkValidity(currentDate);
            }
        }
        if (this.trustStoreFile != null) {
            try {
                trustStoreInputStream = new FileInputStream(this.trustStoreFile);
            }
            catch (IOException ioe) {
                throw new CertificateException(I18n.err(I18n.ERR_04175_TRUST_STORE_FILE_NULL, new Object[0]));
            }
        } else {
            trustStoreInputStream = this.getTrustStoreInputStream();
        }
        if (trustStoreInputStream == null) {
            throw new CertificateException(I18n.err(I18n.ERR_04176_TRUST_MANAGER_NOT_FOUND, new Object[0]));
        }
        try {
            trustStoreInputStream.close();
        }
        catch (IOException e) {
            LOG.warn(I18n.msg(I18n.MSG_04175_TRUST_MANAGER_IO_EXCEPTION, e.getMessage()));
        }
        return this.loadTrustManagers(this.getTrustStore());
    }

    private X509TrustManager[] loadTrustManagers(KeyStore trustStore) throws CertificateException {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            this.x509TrustManagers = new X509TrustManager[trustManagers.length];
            for (int i = 0; i < trustManagers.length; ++i) {
                this.x509TrustManagers[i] = (X509TrustManager)trustManagers[i];
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertificateException(I18n.err(I18n.ERR_04177_NO_SUCH_ALGORITHM, new Object[0]), e);
        }
        catch (KeyStoreException e) {
            throw new CertificateException(I18n.err(I18n.ERR_04178_CANT_LOAD_KEY_STORE, new Object[0]), e);
        }
        return this.x509TrustManagers;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private KeyStore getTrustStore() throws CertificateException {
        KeyStore trustStore;
        try {
            trustStore = KeyStore.getInstance(this.trustStoreFormat);
        }
        catch (KeyStoreException e) {
            throw new CertificateException(I18n.err(I18n.ERR_04178_CANT_LOAD_KEY_STORE, new Object[0]), e);
        }
        InputStream trustStoreInputStream = null;
        try {
            trustStoreInputStream = this.trustStoreFile != null ? new FileInputStream(this.trustStoreFile) : this.getTrustStoreInputStream();
            trustStore.load(trustStoreInputStream, this.trustStorePw);
            if (trustStoreInputStream == null) return trustStore;
        }
        catch (NoSuchAlgorithmException e) {
            try {
                throw new CertificateException(I18n.err(I18n.ERR_04177_NO_SUCH_ALGORITHM, new Object[0]), e);
                catch (IOException e2) {
                    throw new CertificateException(I18n.err(I18n.ERR_04178_CANT_LOAD_KEY_STORE, new Object[0]), e2);
                }
            }
            catch (Throwable throwable) {
                if (trustStoreInputStream == null) throw throwable;
                try {
                    trustStoreInputStream.close();
                    throw throwable;
                }
                catch (IOException e3) {
                    LOG.warn(I18n.err(I18n.ERR_04179_TRUST_STORE_CANT_BE_READ, e3.getMessage()));
                }
                throw throwable;
            }
        }
        try {
            trustStoreInputStream.close();
            return trustStore;
        }
        catch (IOException e) {
            LOG.warn(I18n.err(I18n.ERR_04179_TRUST_STORE_CANT_BE_READ, e.getMessage()));
            return trustStore;
        }
    }

    private InputStream getTrustStoreInputStream() throws CertificateException {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        InputStream result = classloader.getResourceAsStream(this.trustStoreFile);
        if (null == result) {
            throw new CertificateException(I18n.err(I18n.ERR_04180_FILE_DOES_NOT_EXIST_ON_CLASSPATH, new Object[0]));
        }
        return result;
    }
}

