/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfSchemaDocument;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.element.style.StyleStyleElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.OdfStylePropertySet;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.type.StyleNameRef;
import org.w3c.dom.DOMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OdfStylableElement
extends OdfElement
implements OdfStylePropertySet {
    private static final long serialVersionUID = -7828513537641758879L;
    private OdfStyle mAutomaticStyle;
    protected OdfStyleFamily mFamily;
    protected OdfName mStyleNameAttrib;
    private OdfSchemaDocument mOdfSchemaDocument;

    public OdfStylableElement(OdfFileDom ownerDocument, OdfName name, OdfStyleFamily family, OdfName styleNameAttrib) throws DOMException {
        super(ownerDocument, name.getUri(), name.getQName());
        this.mFamily = family;
        this.mStyleNameAttrib = styleNameAttrib;
        this.mOdfSchemaDocument = (OdfSchemaDocument)ownerDocument.getDocument();
    }

    public StyleStyleElement getOrCreateUnqiueAutomaticStyle() {
        OdfOfficeAutomaticStyles automatic_styles;
        if ((this.mAutomaticStyle == null || this.mAutomaticStyle.getStyleUserCount() > 1) && (automatic_styles = this.getAutomaticStyles()) != null) {
            StyleNameRef sParentStyleName = null;
            if (this.mAutomaticStyle == null) {
                this.mAutomaticStyle = automatic_styles.newStyle(this.getStyleFamily());
                sParentStyleName = new StyleNameRef(this.getStyleName());
            } else {
                String nameAttr = this.mAutomaticStyle.getStyleParentStyleNameAttribute();
                sParentStyleName = new StyleNameRef(nameAttr == null ? "" : nameAttr);
                this.mAutomaticStyle.removeStyleUser(this);
                this.mAutomaticStyle = automatic_styles.makeStyleUnique(this.mAutomaticStyle);
            }
            this.mAutomaticStyle.addStyleUser(this);
            if (sParentStyleName != null && sParentStyleName.toString().length() != 0) {
                this.mAutomaticStyle.setStyleParentStyleNameAttribute(sParentStyleName.toString());
            }
            this.setStyleName(this.mAutomaticStyle.getStyleNameAttribute());
        }
        return this.mAutomaticStyle;
    }

    public OdfOfficeAutomaticStyles getAutomaticStyles() {
        OdfFileDom fileDom = (OdfFileDom)this.ownerDocument;
        if (fileDom != null) {
            if (fileDom instanceof OdfContentDom) {
                return ((OdfContentDom)fileDom).getAutomaticStyles();
            }
            if (fileDom instanceof OdfStylesDom) {
                return ((OdfStylesDom)fileDom).getAutomaticStyles();
            }
            return null;
        }
        return null;
    }

    public void setAttributeNS(String uri, String qname, String value) {
        super.setAttributeNS(uri, qname, value);
        if (this.mStyleNameAttrib.equals(uri, qname)) {
            OdfStyle autoStyle = null;
            if (this.mAutomaticStyle == null || !this.mAutomaticStyle.getStyleNameAttribute().equals(value)) {
                OdfOfficeAutomaticStyles automatic_styles = this.getAutomaticStyles();
                if (automatic_styles != null) {
                    autoStyle = automatic_styles.getStyle(value, this.getStyleFamily());
                }
                if (this.mAutomaticStyle != null) {
                    this.mAutomaticStyle.removeStyleUser(this);
                }
                this.mAutomaticStyle = autoStyle;
                if (this.mAutomaticStyle != null) {
                    this.mAutomaticStyle.addStyleUser(this);
                }
            }
        }
    }

    public String getStyleName() {
        return this.getAttributeNS(this.mStyleNameAttrib.getUri(), this.mStyleNameAttrib.getLocalName());
    }

    public void setStyleName(String name) {
        this.setAttributeNS(this.mStyleNameAttrib.getUri(), this.mStyleNameAttrib.getQName(), name);
    }

    public OdfStyle getAutomaticStyle() {
        return this.mAutomaticStyle;
    }

    public boolean hasAutomaticStyle() {
        return this.mAutomaticStyle != null;
    }

    public OdfStyle reuseDocumentStyle(String styleName) {
        OdfStyle style = null;
        if (styleName != null && (style = this.mOdfSchemaDocument.getDocumentStyles().getStyle(styleName, this.getStyleFamily())) != null) {
            this.setDocumentStyle(style);
        }
        return style;
    }

    public void setDocumentStyle(OdfStyle style) {
        if (this.mAutomaticStyle != null) {
            this.mAutomaticStyle.setStyleParentStyleNameAttribute(style.getStyleNameAttribute());
        } else {
            this.setStyleName(style.getStyleNameAttribute());
        }
    }

    public OdfStyle getDocumentStyle() {
        String styleName = this.mAutomaticStyle != null ? this.mAutomaticStyle.getStyleParentStyleNameAttribute() : this.getStyleName();
        return this.mOdfSchemaDocument.getDocumentStyles().getStyle(styleName, this.getStyleFamily());
    }

    public boolean hasDocumentStyle() {
        return this.getDocumentStyle() != null;
    }

    public OdfStyleFamily getStyleFamily() {
        return this.mFamily;
    }

    @Override
    public String getProperty(OdfStyleProperty property) {
        OdfStyle style = this.mAutomaticStyle;
        if (style == null) {
            style = this.getOfficeStyle();
        }
        if (style != null) {
            return style.getProperty(property);
        }
        return null;
    }

    @Override
    public Map<OdfStyleProperty, String> getProperties(Set<OdfStyleProperty> properties) {
        HashMap<OdfStyleProperty, String> map = new HashMap<OdfStyleProperty, String>();
        for (OdfStyleProperty property : properties) {
            map.put(property, this.getProperty(property));
        }
        return map;
    }

    @Override
    public Set<OdfStyleProperty> getStrictProperties() {
        return this.getStyleFamily().getProperties();
    }

    @Override
    public boolean hasProperty(OdfStyleProperty property) {
        return this.mAutomaticStyle != null && this.mAutomaticStyle.hasProperty(property);
    }

    @Override
    public void removeProperty(OdfStyleProperty property) {
        if (this.mAutomaticStyle != null) {
            this.mAutomaticStyle.removeProperty(property);
        }
    }

    @Override
    public void setProperties(Map<OdfStyleProperty, String> properties) {
        for (Map.Entry<OdfStyleProperty, String> entry : properties.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setProperty(OdfStyleProperty property, String value) {
        this.getOrCreateUnqiueAutomaticStyle().setProperty(property, value);
    }

    @Override
    protected void onInsertNode() {
        super.onInsertNode();
        String stylename = this.getStyleName();
        if (stylename.length() != 0) {
            OdfOfficeAutomaticStyles automatic_styles;
            if (this.mAutomaticStyle != null) {
                if (this.mAutomaticStyle.getStyleNameAttribute().equals(stylename)) {
                    return;
                }
                this.mAutomaticStyle.removeStyleUser(this);
                this.mAutomaticStyle = null;
            }
            if ((automatic_styles = this.getAutomaticStyles()) != null) {
                this.mAutomaticStyle = automatic_styles.getStyle(stylename, this.getStyleFamily());
                if (this.mAutomaticStyle != null) {
                    this.mAutomaticStyle.addStyleUser(this);
                }
            }
        }
    }

    @Override
    protected void onRemoveNode() {
        super.onInsertNode();
        if (this.mAutomaticStyle != null) {
            this.mAutomaticStyle.removeStyleUser(this);
            this.mAutomaticStyle = null;
        }
    }

    private OdfStyle getOfficeStyle() {
        OdfOfficeStyles styles = this.mOdfSchemaDocument.getDocumentStyles();
        if (styles != null) {
            return styles.getStyle(this.getStyleName(), this.getStyleFamily());
        }
        return null;
    }
}

