/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.studio.test.integration.ui.bots;


import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;


public class NewSchemaProjectWizardBot extends WizardBot
{

    public NewSchemaProjectWizardBot()
    {
        super( "" );
    }


    public void typeProjectName( String projectName )
    {
        activate();
        SWTBotText text = bot.textWithLabel( "Project name:" );
        text.setText( projectName );
    }


    public void selectOfflineSchema()
    {
        activate();
        bot.radio( "Offline Schema" ).click();
    }


    public void selectOnlineSchema()
    {
        activate();
        bot.radio( "Online Schema from a Directory Server" ).click();
    }


    public void selectApacheDS()
    {
        activate();
        bot.radio( "ApacheDS" ).click();
    }


    public void selectOpenLDAP()
    {
        activate();
        bot.radio( "OpenLDAP" ).click();
    }


    public void selectAllSchemas()
    {
        activate();
        clickButton( "Select All" );
    }


    public void selectConnection( String connectionName )
    {
        activate();
        bot.tree().select( connectionName );
    }

}
