/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package org.apache.flex.swc;

/**
 * Version information of a SWC file. Since Flex 3, Flex version is decoupled
 * with SWC library version.
 */
public interface ISWCVersion
{
    /**
     * Get the SWC file version.
     * @return SWC version
     */
    String getSWCVersion();
    void setSWCVersion(String value);

    String getFlexVersion();
    void setFlexVersion(String value);
    
    String getFlexBuild();
    void setFlexBuild(String value);
    
    String getFlexMinSupportedVersion();
    void setFlexMinSupportedVersion(String value);
    
    /**
     * Get the flex min supported version as an integer. The bits 24-31 are the
     * flex major version number, bits 16-23 are the flex minor version number,
     * and bits 0-15 are the flex revision number.
     * <p>
     * For example, "4.6.1" becomes (4<<24) | (6<<16) | 1.
     * @return the flex min supported version as an integer
     */
    int getFlexMinSupportedVersionInt();

    /**
     * The name of the compiler that created the SWC.
     * @return name of the compiler.
     */
    String getCompilerName();
    
    /**
     * Set the name of the compiler that created the SWC.
     * 
     * @param value name of the compiler.
     */
    void setCompilerName(String value);
    
    /**
     * The version of the compiler that created the SWC.
     * Set the version of the compiler that created the SWC. The version of the
     * compiler has three components: 1) a major version, 2) a minor version,
     * and 3) a nano verison. The components are separated by dots, for example
     * "4.7.0".
     * 
     * @return version of the compiler.
     */
    String getCompilerVersion();

    /**
     * Set the version of the compiler that created the SWC. The version of the
     * compiler has three components: 1) a major version, 2) a minor version,
     * and 3) a nano verison. The components are separated by dots, for example
     * "4.7.0".
     * 
     * @param value version of the compiler, not validated.
     */
    void setCompilerVersion(String value);

    /**
     * The build number of the compiler that created the SWC. The build number
     * is an integer generated by the source control system used for the
     * compiler's development, "777".
     * 
     * @return build number of the compiler.
     */
    String getCompilerBuild();

    /**
     * Set the build number of the compiler that created the SWC. The build
     * number is an integer generated by the source control system used for the
     * compiler's development, "777".
     * 
     * @param value build number of the compiler, not validated.
     */
    void setCompilerBuild(String value);
}
