/*
 * Decompiled with CFR 0.152.
 */
package flash.localization;

import flash.localization.ILocalizedText;
import flash.localization.ILocalizer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LocalizationManager {
    private Locale locale = Locale.getDefault();
    private List<ILocalizer> localizers = new LinkedList<ILocalizer>();

    public void addLocalizer(ILocalizer iLocalizer) {
        this.localizers.add(iLocalizer);
    }

    private ILocalizedText getLocalizedTextInner(Locale locale, String string) {
        for (ILocalizer iLocalizer : this.localizers) {
            ILocalizedText iLocalizedText = iLocalizer.getLocalizedText(locale, string);
            if (iLocalizedText == null) continue;
            return iLocalizedText;
        }
        return null;
    }

    private ILocalizedText getLocalizedText(Locale locale, String string) {
        ILocalizedText iLocalizedText = this.getLocalizedTextInner(locale, string);
        if (iLocalizedText == null && locale.getCountry().length() > 0 && locale.getVariant().length() > 0) {
            iLocalizedText = this.getLocalizedTextInner(new Locale(locale.getLanguage(), locale.getCountry()), string);
        }
        if (iLocalizedText == null && locale.getCountry().length() > 0) {
            iLocalizedText = this.getLocalizedTextInner(new Locale(locale.getLanguage()), string);
        }
        return iLocalizedText;
    }

    protected static String replaceInlineReferences(String string, Map map) {
        int n;
        if (map == null) {
            return string;
        }
        int n2 = 100;
        while (n2-- > 0 && (n = string.indexOf("${")) != -1 && (n < 1 || string.charAt(n - 1) != '$' || (n = string.indexOf("${", n + 2)) != -1)) {
            int n3 = string.indexOf("}", n);
            if (n3 == -1) {
                return null;
            }
            String string2 = string.substring(n + 2, n3);
            String string3 = null;
            if (map.containsKey(string2) && map.get(string2) != null) {
                string3 = map.get(string2).toString();
            }
            if (string3 == null) {
                string3 = "";
            }
            string = string.substring(0, n) + string3 + string.substring(n3 + 1);
        }
        return string.replaceAll("[$][$][{]", "\\${");
    }

    public String getLocalizedTextString(String string) {
        return this.getLocalizedTextString(string, Collections.EMPTY_MAP);
    }

    public String getLocalizedTextString(String string, Map map) {
        return this.getLocalizedTextString(this.locale, string, map);
    }

    public String getLocalizedTextString(Locale locale, String string, Map map) {
        ILocalizedText iLocalizedText = this.getLocalizedText(locale, string);
        if (iLocalizedText == null && !locale.equals(locale)) {
            iLocalizedText = this.getLocalizedText(locale, string);
        }
        if (iLocalizedText == null && !locale.getLanguage().equals("en")) {
            iLocalizedText = this.getLocalizedText(new Locale("en"), string);
        }
        return iLocalizedText == null ? null : iLocalizedText.format(map);
    }

    public String getLocalizedTextString(Object object) {
        String string = this.getLocalizedTextString(this.locale, object);
        return string;
    }

    public String getLocalizedTextString(Locale locale, Object object) {
        String string;
        Object object2;
        Object object3;
        String string2 = object.getClass().getName().replaceAll("\\$", ".");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            object3 = clazz.getDeclaredFields();
            for (int i = 0; i < ((Field[])object3).length; ++i) {
                object2 = object3[i];
                if (!Modifier.isPublic(((Field)object2).getModifiers()) || Modifier.isStatic(((Field)object2).getModifiers())) continue;
                try {
                    hashMap.put(((Field)object2).getName(), ((Field)object2).get(object));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        object3 = null;
        if (hashMap.containsKey("id") && hashMap.get("id") != null && (string = hashMap.get("id").toString()).length() > 0) {
            object3 = this.getLocalizedTextString(locale, string2 + "." + string, hashMap);
        }
        if (object3 == null) {
            object3 = this.getLocalizedTextString(locale, string2, hashMap);
        }
        if (object3 == null) {
            object3 = string2;
            if (hashMap != null) {
                object3 = (String)object3 + "[";
                Iterator iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    object2 = iterator.next();
                    object3 = (String)object3 + object2.getKey();
                    if (object2.getValue() != null) {
                        object3 = (String)object3 + "='" + object2.getValue() + "'";
                    }
                    if (!iterator.hasNext()) continue;
                    object3 = (String)object3 + ", ";
                }
                object3 = (String)object3 + "]";
            }
            return object3;
        }
        return object3;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

